/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.codeInspection.InspectionProfileLoaderBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfileManager;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaToolRegistrar;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaInspectionProfileLoader;", "Lcom/intellij/codeInspection/InspectionProfileLoaderBase;", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "loadProfileByName", "profileName", "", "loadProfileByPath", "profilePath", "intellij.qodana"})
public final class QodanaInspectionProfileLoader
extends InspectionProfileLoaderBase<QodanaInspectionProfile> {
    public QodanaInspectionProfileLoader(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Nullable
    public QodanaInspectionProfile loadProfileByName(@NotNull String profileName) {
        Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
        return QodanaInspectionProfileManager.Companion.getInstance(this.getProject()).getQodanaProfile(profileName);
    }

    @Nullable
    public QodanaInspectionProfile loadProfileByPath(@NotNull String profilePath) {
        InspectionProfileImpl profileFromYaml;
        Intrinsics.checkNotNullParameter((Object)profilePath, (String)"profilePath");
        QodanaInspectionProfileManager profileManager = QodanaInspectionProfileManager.Companion.getInstance(this.getProject());
        InspectionProfileImpl inspectionProfileImpl = profileFromYaml = this.tryLoadProfileFromYaml(profilePath, QodanaToolRegistrar.Companion.getInstance(this.getProject()), profileManager);
        if (inspectionProfileImpl != null) {
            String string = profileFromYaml.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return QodanaInspectionProfile.Companion.clone(inspectionProfileImpl, string, profileManager);
        }
        Path file = Paths.get(profilePath, new String[0]);
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return null;
        }
        Element element = JDOMUtil.load((Path)file);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Element element2 = element;
        return QodanaInspectionProfile.Companion.newFromXml(element2, null, profileManager);
    }
}

