/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.abbreviation.internal;

import com.vladsch.flexmark.ext.abbreviation.AbbreviationBlock;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationRepository;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbbreviationBlockParser
extends AbstractBlockParser {
    static Pattern ABBREVIATION_BLOCK = Pattern.compile("^\\*\\[\\s*.*\\s*\\]:");
    final AbbreviationBlock block = new AbbreviationBlock();

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        return BlockContinue.none();
    }

    @Override
    public void addLine(ParserState state, BasedSequence line) {
        throw new IllegalStateException("Abbreviation Blocks hold a single line");
    }

    @Override
    public void closeBlock(ParserState state) {
        AbbreviationRepository abbreviationMap = AbbreviationExtension.ABBREVIATIONS.get(state.getProperties());
        abbreviationMap.put(abbreviationMap.normalizeKey(this.block.getText()), this.block);
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        BlockFactory(DataHolder options) {
            super(options);
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int nextNonSpace;
            if (state.getIndent() >= 4) {
                return BlockStart.none();
            }
            BasedSequence line = state.getLine();
            BasedSequence trySequence = line.subSequence(nextNonSpace = state.getNextNonSpaceIndex(), line.length());
            Matcher matcher = ABBREVIATION_BLOCK.matcher(trySequence);
            if (matcher.find()) {
                int openingStart = nextNonSpace + matcher.start();
                int openingEnd = nextNonSpace + matcher.end();
                BasedSequence openingMarker = trySequence.subSequence(openingStart, openingStart + 2);
                BasedSequence text2 = (BasedSequence)trySequence.subSequence(openingStart + 2, openingEnd - 2).trim();
                BasedSequence closingMarker = trySequence.subSequence(openingEnd - 2, openingEnd);
                AbbreviationBlockParser abbreviationBlock = new AbbreviationBlockParser();
                abbreviationBlock.block.setOpeningMarker(openingMarker);
                abbreviationBlock.block.setText(text2);
                abbreviationBlock.block.setClosingMarker(closingMarker);
                abbreviationBlock.block.setAbbreviation((BasedSequence)((BasedSequence)trySequence.subSequence(matcher.end())).trim());
                abbreviationBlock.block.setCharsFromContent();
                return BlockStart.of(abbreviationBlock).atIndex(line.length());
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        @NotNull
        public BlockParserFactory apply(@NotNull DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

