/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.CGAlgorithmsDD;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.math.MathUtil;

public class CGAlgorithms {
    public static final int CLOCKWISE = -1;
    public static final int RIGHT = -1;
    public static final int COUNTERCLOCKWISE = 1;
    public static final int LEFT = 1;
    public static final int COLLINEAR = 0;
    public static final int STRAIGHT = 0;

    public static int orientationIndex(Coordinate p1, Coordinate p2, Coordinate q) {
        return CGAlgorithmsDD.orientationIndex(p1, p2, q);
    }

    public static boolean isPointInRing(Coordinate p2, Coordinate[] ring) {
        return CGAlgorithms.locatePointInRing(p2, ring) != 2;
    }

    public static int locatePointInRing(Coordinate p2, Coordinate[] ring) {
        return RayCrossingCounter.locatePointInRing(p2, ring);
    }

    public static boolean isOnLine(Coordinate p2, Coordinate[] pt) {
        RobustLineIntersector lineIntersector = new RobustLineIntersector();
        for (int i2 = 1; i2 < pt.length; ++i2) {
            Coordinate p0 = pt[i2 - 1];
            Coordinate p1 = pt[i2];
            ((LineIntersector)lineIntersector).computeIntersection(p2, p0, p1);
            if (!lineIntersector.hasIntersection()) continue;
            return true;
        }
        return false;
    }

    public static boolean isCCW(Coordinate[] ring) {
        int nPts = ring.length - 1;
        if (nPts < 3) {
            throw new IllegalArgumentException("Ring has fewer than 4 points, so orientation cannot be determined");
        }
        Coordinate hiPt = ring[0];
        int hiIndex = 0;
        for (int i2 = 1; i2 <= nPts; ++i2) {
            Coordinate p2 = ring[i2];
            if (!(p2.y > hiPt.y)) continue;
            hiPt = p2;
            hiIndex = i2;
        }
        int iPrev = hiIndex;
        do {
            if (--iPrev >= 0) continue;
            iPrev = nPts;
        } while (ring[iPrev].equals2D(hiPt) && iPrev != hiIndex);
        int iNext = hiIndex;
        while (ring[iNext = (iNext + 1) % nPts].equals2D(hiPt) && iNext != hiIndex) {
        }
        Coordinate prev2 = ring[iPrev];
        Coordinate next = ring[iNext];
        if (prev2.equals2D(hiPt) || next.equals2D(hiPt) || prev2.equals2D(next)) {
            return false;
        }
        int disc = CGAlgorithms.computeOrientation(prev2, hiPt, next);
        boolean isCCW = disc == 0 ? prev2.x > next.x : disc > 0;
        return isCCW;
    }

    public static int computeOrientation(Coordinate p1, Coordinate p2, Coordinate q) {
        return CGAlgorithms.orientationIndex(p1, p2, q);
    }

    public static double distancePointLine(Coordinate p2, Coordinate A, Coordinate B) {
        if (A.x == B.x && A.y == B.y) {
            return p2.distance(A);
        }
        double len2 = (B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y);
        double r = ((p2.x - A.x) * (B.x - A.x) + (p2.y - A.y) * (B.y - A.y)) / len2;
        if (r <= 0.0) {
            return p2.distance(A);
        }
        if (r >= 1.0) {
            return p2.distance(B);
        }
        double s = ((A.y - p2.y) * (B.x - A.x) - (A.x - p2.x) * (B.y - A.y)) / len2;
        return Math.abs(s) * Math.sqrt(len2);
    }

    public static double distancePointLinePerpendicular(Coordinate p2, Coordinate A, Coordinate B) {
        double len2 = (B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y);
        double s = ((A.y - p2.y) * (B.x - A.x) - (A.x - p2.x) * (B.y - A.y)) / len2;
        return Math.abs(s) * Math.sqrt(len2);
    }

    public static double distancePointLine(Coordinate p2, Coordinate[] line) {
        if (line.length == 0) {
            throw new IllegalArgumentException("Line array must contain at least one vertex");
        }
        double minDistance = p2.distance(line[0]);
        for (int i2 = 0; i2 < line.length - 1; ++i2) {
            double dist = CGAlgorithms.distancePointLine(p2, line[i2], line[i2 + 1]);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
        }
        return minDistance;
    }

    public static double distanceLineLine(Coordinate A, Coordinate B, Coordinate C, Coordinate D) {
        if (A.equals(B)) {
            return CGAlgorithms.distancePointLine(A, C, D);
        }
        if (C.equals(D)) {
            return CGAlgorithms.distancePointLine(D, A, B);
        }
        boolean noIntersection = false;
        if (!Envelope.intersects(A, B, C, D)) {
            noIntersection = true;
        } else {
            double denom = (B.x - A.x) * (D.y - C.y) - (B.y - A.y) * (D.x - C.x);
            if (denom == 0.0) {
                noIntersection = true;
            } else {
                double r_num = (A.y - C.y) * (D.x - C.x) - (A.x - C.x) * (D.y - C.y);
                double s_num = (A.y - C.y) * (B.x - A.x) - (A.x - C.x) * (B.y - A.y);
                double s = s_num / denom;
                double r = r_num / denom;
                if (r < 0.0 || r > 1.0 || s < 0.0 || s > 1.0) {
                    noIntersection = true;
                }
            }
        }
        if (noIntersection) {
            return MathUtil.min(CGAlgorithms.distancePointLine(A, C, D), CGAlgorithms.distancePointLine(B, C, D), CGAlgorithms.distancePointLine(C, A, B), CGAlgorithms.distancePointLine(D, A, B));
        }
        return 0.0;
    }

    public static double signedArea(Coordinate[] ring) {
        if (ring.length < 3) {
            return 0.0;
        }
        double sum = 0.0;
        double x0 = ring[0].x;
        for (int i2 = 1; i2 < ring.length - 1; ++i2) {
            double x = ring[i2].x - x0;
            double y1 = ring[i2 + 1].y;
            double y2 = ring[i2 - 1].y;
            sum += x * (y2 - y1);
        }
        return sum / 2.0;
    }

    public static double signedArea(CoordinateSequence ring) {
        int n = ring.size();
        if (n < 3) {
            return 0.0;
        }
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        Coordinate p2 = new Coordinate();
        ring.getCoordinate(0, p1);
        ring.getCoordinate(1, p2);
        double x0 = p1.x;
        p2.x -= x0;
        double sum = 0.0;
        for (int i2 = 1; i2 < n - 1; ++i2) {
            p0.y = p1.y;
            p1.x = p2.x;
            p1.y = p2.y;
            ring.getCoordinate(i2 + 1, p2);
            p2.x -= x0;
            sum += p1.x * (p0.y - p2.y);
        }
        return sum / 2.0;
    }

    public static double length(CoordinateSequence pts) {
        int n = pts.size();
        if (n <= 1) {
            return 0.0;
        }
        double len = 0.0;
        Coordinate p2 = new Coordinate();
        pts.getCoordinate(0, p2);
        double x0 = p2.x;
        double y0 = p2.y;
        for (int i2 = 1; i2 < n; ++i2) {
            pts.getCoordinate(i2, p2);
            double x1 = p2.x;
            double y1 = p2.y;
            double dx = x1 - x0;
            double dy = y1 - y0;
            len += Math.sqrt(dx * dx + dy * dy);
            x0 = x1;
            y0 = y1;
        }
        return len;
    }
}

