/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectName;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.intentions.SqlQualificationIntentionBase;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlQualifyIdentifierIntention
extends SqlQualificationIntentionBase
implements PriorityAction {
    private final boolean myIsPreview;

    public SqlQualifyIdentifierIntention(boolean preview) {
        this.myIsPreview = preview;
    }

    public SqlQualifyIdentifierIntention() {
        this(false);
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = PriorityAction.Priority.TOP;
        if (priority == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(0);
        }
        return priority;
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.qualify.identifier", (Object[])new Object[0]);
        if (string == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static boolean canBeQualified(@NotNull SqlIdentifier identifier) {
        if (identifier == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(2);
        }
        return SqlQualifyIdentifierIntention.getParentObjectNames(identifier).isNotEmpty() && SqlImplUtil.getSqlDialectSafe((PsiElement)identifier).canBeQualified(identifier);
    }

    @NotNull
    private static JBIterable<ObjectName> getParentObjectNames(@NotNull SqlIdentifier identifier) {
        if (identifier == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(3);
        }
        JBIterable jBIterable = JBIterable.from(SqlQualifyIdentifierIntention.getParentObjects(identifier)).filterMap(o -> SqlQualifyIdentifierIntention.getName(o));
        if (jBIterable == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @Nullable
    private static PsiElement getQualifierElement(@NotNull ResolveResult result2) {
        PsiElement immediateQualifier;
        if (result2 == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(5);
        }
        if ((immediateQualifier = SqlImplUtil.getImmediateQualifier(result2)) != null && !(immediateQualifier instanceof SqlJoinExpression)) {
            return immediateQualifier;
        }
        SqlColumnSymbol columnSymbol = (SqlColumnSymbol)((Object)ObjectUtils.tryCast((Object)SqlImplUtil.getImmediateTarget(result2), SqlColumnSymbol.class));
        PsiElement qualifier = columnSymbol != null ? columnSymbol.getQualifier() : null;
        return qualifier != null ? qualifier : SqlImplUtil.getQualifier(result2);
    }

    @NotNull
    private static Object adjustQualifier(@NotNull PsiElement qualifier, @Nullable PsiElement targetElement) {
        if (qualifier == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(6);
        }
        if (targetElement == null) {
            PsiElement psiElement = qualifier;
            if (psiElement == null) {
                SqlQualifyIdentifierIntention.$$$reportNull$$$0(7);
            }
            return psiElement;
        }
        if (!(qualifier instanceof SqlQueryExpression)) {
            PsiElement psiElement = qualifier;
            if (psiElement == null) {
                SqlQualifyIdentifierIntention.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        SqlTableExpression tableExpression = ((SqlQueryExpression)qualifier).getTableExpression();
        if (tableExpression == null) {
            PsiElement psiElement = qualifier;
            if (psiElement == null) {
                SqlQualifyIdentifierIntention.$$$reportNull$$$0(9);
            }
            return psiElement;
        }
        SqlFromClause fromClause = tableExpression.getFromClause();
        if (fromClause == null) {
            PsiElement psiElement = qualifier;
            if (psiElement == null) {
                SqlQualifyIdentifierIntention.$$$reportNull$$$0(10);
            }
            return psiElement;
        }
        SqlExpression fromExpression = fromClause.getFromExpression();
        if (fromExpression == null) {
            PsiElement psiElement = qualifier;
            if (psiElement == null) {
                SqlQualifyIdentifierIntention.$$$reportNull$$$0(11);
            }
            return psiElement;
        }
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)fromExpression.getDasType(), SqlTableType.class);
        if (type == null) {
            PsiElement psiElement = qualifier;
            if (psiElement == null) {
                SqlQualifyIdentifierIntention.$$$reportNull$$$0(12);
            }
            return psiElement;
        }
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            PsiElement columnQualifier;
            if (type.getColumnElement(i2) != targetElement || (columnQualifier = type.getColumnQualifier(i2)) == null) continue;
            PsiElement psiElement = columnQualifier;
            if (psiElement == null) {
                SqlQualifyIdentifierIntention.$$$reportNull$$$0(13);
            }
            return psiElement;
        }
        PsiElement psiElement = qualifier;
        if (psiElement == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(14);
        }
        return psiElement;
    }

    @NotNull
    private static Collection<Object> getParentObjects(@Nullable SqlIdentifier identifier) {
        DasObject res2;
        if (identifier == null) {
            List<Object> list = Collections.emptyList();
            if (list == null) {
                SqlQualifyIdentifierIntention.$$$reportNull$$$0(15);
            }
            return list;
        }
        LinkedHashSet<Object> parents = new LinkedHashSet<Object>();
        PsiElement parent = identifier.getParent();
        PsiPolyVariantReference ref2 = (PsiPolyVariantReference)ObjectUtils.tryCast((Object)parent.getReference(), PsiPolyVariantReference.class);
        if (ref2 != null) {
            ResolveResult[] results2;
            for (ResolveResult result2 : results2 = ref2.multiResolve(false)) {
                PsiElement qualifier = SqlQualifyIdentifierIntention.getQualifierElement(result2);
                if (qualifier != null) {
                    ContainerUtil.addIfNotNull(parents, (Object)SqlQualifyIdentifierIntention.adjustQualifier(qualifier, result2.getElement()));
                    continue;
                }
                DasObject object = (DasObject)ObjectUtils.tryCast((Object)result2.getElement(), DasObject.class);
                if (object != null) {
                    object = object.getDasParent();
                }
                ContainerUtil.addIfNotNull(parents, (Object)object);
            }
        }
        if ((res2 = (DasObject)ObjectUtils.tryCast((Object)parent, DasObject.class)) != null) {
            res2 = res2.getDasParent();
        }
        if (res2 != null) {
            ContainerUtil.addIfNotNull(parents, (Object)res2);
        }
        LinkedHashSet<Object> linkedHashSet = parents;
        if (linkedHashSet == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(16);
        }
        return linkedHashSet;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(17);
        }
        if (!(file instanceof SqlFile)) {
            return false;
        }
        return !JBIterable.from((Iterable)editor2.getCaretModel().getAllCarets()).flatten(c2 -> SqlQualifyIdentifierIntention.getTopmostIdentifiers(file, c2)).filter(id -> SqlQualifyIdentifierIntention.canBeQualified(id)).isEmpty();
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target2) {
        if (target2 == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(18);
        }
        return new SqlQualifyIdentifierIntention(true);
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(19);
        }
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        int depth = 0;
        MultiMap names = MultiMap.createLinkedSet();
        for (SqlIdentifier identifier : JBIterable.from((Iterable)editor2.getCaretModel().getAllCarets()).flatten(c2 -> SqlQualifyIdentifierIntention.getTopmostIdentifiers(file, c2))) {
            for (Object p2 : SqlQualifyIdentifierIntention.getParentObjects(identifier)) {
                ObjectName name2;
                int d = SqlQualifyIdentifierIntention.getDepth(language, SqlQualifyIdentifierIntention.getKind(p2));
                if (depth > d) continue;
                if (depth < d) {
                    depth = d;
                    names.clear();
                }
                if ((name2 = SqlQualifyIdentifierIntention.getName(p2)) == null) continue;
                names.putValue((Object)identifier, (Object)name2);
            }
        }
        if (!names.isEmpty()) {
            this.performQualification((MultiMap<SqlIdentifier, ObjectName>)names, editor2, file, language);
        }
    }

    private void performQualification(MultiMap<SqlIdentifier, ObjectName> names, Editor editor2, PsiFile file, SqlLanguageDialectEx language) {
        Document document = editor2.getDocument();
        ArrayList<Pair> unique = new ArrayList<Pair>();
        ArrayList<Pair<RangeMarker, Collection<ObjectName>>> nonUnique = new ArrayList<Pair<RangeMarker, Collection<ObjectName>>>();
        for (Map.Entry entry : names.entrySet()) {
            RangeMarker marker = document.createRangeMarker(((SqlIdentifier)entry.getKey()).getTextRange());
            Collection variants = (Collection)entry.getValue();
            if (variants.size() == 1) {
                unique.add(Pair.create((Object)marker, (Object)variants));
                continue;
            }
            if (variants.size() <= 1) continue;
            nonUnique.add((Pair<RangeMarker, Collection<ObjectName>>)Pair.create((Object)marker, (Object)variants));
        }
        SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings(file);
        Dbms dbms = SqlImplUtil.getDbms((PsiElement)file);
        if (!unique.isEmpty()) {
            this.runCommand(file.getProject(), editor2, () -> {
                for (Pair pair : unique) {
                    SqlIntentionUtil.qualifyReference((RangeMarker)pair.first, (Iterable)pair.second, NamingServices.getNamingService(dbms), settings);
                }
            });
        }
        if (!nonUnique.isEmpty()) {
            this.qualifyWithChooser(file.getProject(), editor2, language, settings, nonUnique, 0, dbms);
        }
    }

    private void runCommand(Project project, Editor editor2, Runnable runnable) {
        if (this.myIsPreview) {
            runnable.run();
        } else {
            WriteCommandAction.runWriteCommandAction((Project)editor2.getProject(), (String)this.getText(), (String)this.getText(), (Runnable)runnable, (PsiFile[])new PsiFile[]{PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument())});
        }
    }

    private void qualifyWithChooser(Project project, Editor editor2, SqlLanguageDialectEx language, SqlCodeStyleSettings settings, List<Pair<RangeMarker, Collection<ObjectName>>> nonUnique, int i2, @NotNull Dbms dbms) {
        if (dbms == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(20);
        }
        RangeMarker identifier = (RangeMarker)nonUnique.get((int)i2).first;
        List variants = JBIterable.from((Iterable)((Iterable)nonUnique.get((int)i2).second)).transform(Collections::singletonList).toList();
        NamingService namingService = NamingServices.getNamingService(dbms);
        Consumer consumer = v -> {
            this.runCommand(project, editor2, () -> SqlIntentionUtil.qualifyReference(identifier, v, namingService, settings));
            if (i2 + 1 < nonUnique.size()) {
                this.qualifyWithChooser(project, editor2, language, settings, nonUnique, i2 + 1, dbms);
            }
        };
        if (this.myIsPreview) {
            consumer.consume((Object)((Iterable)ContainerUtil.getFirstItem((List)variants)));
        } else {
            SqlIntentionUtil.chooseQualifier(editor2, (Segment)identifier, variants, namingService, settings, language, (Consumer<? super Iterable<ObjectName>>)consumer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 5, 6, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlQualifyIdentifierIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlQualifyIdentifierIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentObjectNames";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustQualifier";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canBeQualified";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParentObjectNames";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "adjustQualifier";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "qualifyWithChooser";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 5, 6, 17, 18, 19, 20 -> new IllegalArgumentException(string);
        };
    }
}

