/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mongo.js.ExpressionParser;
import com.intellij.sql.dialects.mongo.js.FunctionParser;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.util.ThreeState;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JSArrowFunctionDetector {
    public static final JSArrowFunctionDetector INSTANCE = new JSArrowFunctionDetector();
    private static final Map<IElementType, IElementType> PARENS = new HashMap<IElementType, IElementType>();

    private JSArrowFunctionDetector() {
    }

    public boolean isArrowFunctionExpression(@NotNull PsiBuilder builder, @NotNull FunctionParser parser2) {
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(0);
        }
        if (parser2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(1);
        }
        PsiBuilder.Marker marker = builder.mark();
        boolean result2 = this.checkArrowFunctionExpression(builder, parser2);
        marker.rollbackTo();
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkArrowFunctionExpression(@NotNull PsiBuilder builder, @NotNull FunctionParser parser2) {
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(2);
        }
        if (parser2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(3);
        }
        this.skipAngleBrackets(builder);
        if (builder.getTokenType() != JSElementTypes.LPAR) {
            return false;
        }
        IElementType next = builder.lookAhead(1);
        if (!parser2.isValidFirstParameterStart(next)) {
            return false;
        }
        builder.advanceLexer();
        if (next == JSElementTypes.RPAR) {
            builder.advanceLexer();
            if (builder.getTokenType() == JSElementTypes.COLON) {
                return true;
            }
        } else {
            while (!builder.eof()) {
                ThreeState subResult;
                IElementType tokenType = builder.getTokenType();
                if (tokenType == JSElementTypes.RPAR) {
                    builder.advanceLexer();
                    break;
                }
                if (tokenType == JSElementTypes.COMMA) {
                    if (builder.lookAhead(1) == JSElementTypes.EQ) {
                        return true;
                    }
                    builder.advanceLexer();
                }
                if ((subResult = this.checkCommaSeparatedListElement(builder, parser2)) == ThreeState.UNSURE) continue;
                return subResult.toBoolean();
            }
        }
        Boolean data = (Boolean)builder.getUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING);
        try {
            builder.putUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING, (Object)true);
            if (builder.getTokenType() == JSElementTypes.COLON && !parser2.myJavaScriptParser.getTypeParser().tryParseArrowFunctionReturnType()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            builder.putUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING, (Object)data);
        }
        return JSElementTypes.ARROWS.contains(builder.getTokenType());
    }

    @NotNull
    private ThreeState checkCommaSeparatedListElement(@NotNull PsiBuilder builder, @NotNull FunctionParser parser2) {
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(4);
        }
        if (parser2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(5);
        }
        boolean seenEquals = false;
        boolean seenColon = false;
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (PARENS.containsKey(tokenType)) {
                if (this.skipParentheses(builder)) continue;
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    JSArrowFunctionDetector.$$$reportNull$$$0(6);
                }
                return threeState;
            }
            if (tokenType == JSElementTypes.COMMA || tokenType == JSElementTypes.RPAR) break;
            if (seenEquals) {
                builder.advanceLexer();
                continue;
            }
            if (tokenType == JSElementTypes.EQ) {
                seenEquals = true;
            } else if (tokenType == JSElementTypes.QUEST) {
                IElementType lookahead = builder.lookAhead(1);
                if (lookahead == JSElementTypes.COLON || lookahead == JSElementTypes.EQ || lookahead == JSElementTypes.COMMA || lookahead == JSElementTypes.RPAR) {
                    ThreeState threeState = ThreeState.YES;
                    if (threeState == null) {
                        JSArrowFunctionDetector.$$$reportNull$$$0(7);
                    }
                    return threeState;
                }
                if (!seenColon || !parser2.supportsColonTypeCast()) {
                    ThreeState threeState = ThreeState.NO;
                    if (threeState == null) {
                        JSArrowFunctionDetector.$$$reportNull$$$0(8);
                    }
                    return threeState;
                }
            } else if (tokenType == JSElementTypes.COLON) {
                if (!parser2.supportsColonTypeCast()) {
                    ThreeState threeState = ThreeState.YES;
                    if (threeState == null) {
                        JSArrowFunctionDetector.$$$reportNull$$$0(9);
                    }
                    return threeState;
                }
                seenColon = true;
            } else if (!seenColon && JSElementTypes.ARROWS.contains(tokenType)) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    JSArrowFunctionDetector.$$$reportNull$$$0(10);
                }
                return threeState;
            }
            builder.advanceLexer();
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(11);
        }
        return threeState;
    }

    public boolean isArrowFunctionType(@NotNull PsiBuilder builder, @NotNull FunctionParser parser2) {
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(12);
        }
        if (parser2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(13);
        }
        PsiBuilder.Marker marker = builder.mark();
        boolean result2 = this.checkArrowFunctionType(builder, parser2);
        marker.rollbackTo();
        return result2;
    }

    public boolean checkArrowFunctionType(@NotNull PsiBuilder builder, @NotNull FunctionParser parser2) {
        ThreeState state;
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(14);
        }
        if (parser2 == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(15);
        }
        if (builder.getTokenType() == JSElementTypes.LT) {
            return true;
        }
        if (builder.getTokenType() != JSElementTypes.LPAR) {
            return false;
        }
        IElementType next = builder.lookAhead(1);
        if (!parser2.isValidFirstParameterStart(next)) {
            return false;
        }
        if (next == JSElementTypes.RPAR || next == JSElementTypes.DOT_DOT_DOT) {
            return true;
        }
        builder.advanceLexer();
        boolean foundParameter = false;
        while (!builder.eof() && parser2.myJavaScriptParser.isIdentifierName(builder.getTokenType())) {
            builder.advanceLexer();
            foundParameter = true;
        }
        if ((builder.getTokenType() == JSElementTypes.LBRACE || builder.getTokenType() == JSElementTypes.LBRACKET) && (state = this.skipAndCheckUnionOrIntersection(builder)) == ThreeState.NO) {
            builder.advanceLexer();
            foundParameter = true;
        }
        if (!foundParameter) {
            return false;
        }
        next = builder.getTokenType();
        if (next == JSElementTypes.COLON || next == JSElementTypes.COMMA || next == JSElementTypes.QUEST || next == JSElementTypes.EQ) {
            return true;
        }
        if (next != JSElementTypes.RPAR) {
            return false;
        }
        builder.advanceLexer();
        return JSElementTypes.ARROWS.contains(builder.getTokenType());
    }

    private void skipAngleBrackets(@NotNull PsiBuilder builder) {
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(16);
        }
        if (builder.getTokenType() == JSElementTypes.LT) {
            builder.advanceLexer();
            int balance = 1;
            while (!builder.eof()) {
                IElementType tokenType = builder.getTokenType();
                if (tokenType == JSElementTypes.LT) {
                    ++balance;
                } else if (tokenType == JSElementTypes.GT) {
                    --balance;
                }
                builder.advanceLexer();
                if (balance != 0) continue;
                break;
            }
        }
    }

    private boolean skipParentheses(@NotNull PsiBuilder builder) {
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(17);
        }
        ArrayDeque<IElementType> leftParens = new ArrayDeque<IElementType>();
        IElementType firstToken = builder.getTokenType();
        assert (PARENS.containsKey(firstToken));
        leftParens.push(firstToken);
        builder.advanceLexer();
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == PARENS.get(leftParens.peek())) {
                leftParens.pop();
            } else {
                if (PARENS.containsValue(tokenType)) {
                    return false;
                }
                if (PARENS.containsKey(tokenType)) {
                    leftParens.push(tokenType);
                }
            }
            builder.advanceLexer();
            if (!leftParens.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private ThreeState skipAndCheckUnionOrIntersection(@NotNull PsiBuilder builder) {
        if (builder == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(18);
        }
        IElementType lpar = builder.getTokenType();
        IElementType rpar = PARENS.get(lpar);
        boolean hasUnionOrIntersection = false;
        builder.advanceLexer();
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == rpar) {
                ThreeState threeState = ThreeState.fromBoolean((boolean)hasUnionOrIntersection);
                if (threeState == null) {
                    JSArrowFunctionDetector.$$$reportNull$$$0(19);
                }
                return threeState;
            }
            if (PARENS.containsValue(tokenType)) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    JSArrowFunctionDetector.$$$reportNull$$$0(20);
                }
                return threeState;
            }
            if (tokenType == JSElementTypes.OR || tokenType == JSElementTypes.AND) {
                hasUnionOrIntersection = true;
            }
            if (PARENS.containsKey(tokenType)) {
                ThreeState isUnionOrIntersectionInner = this.skipAndCheckUnionOrIntersection(builder);
                if (isUnionOrIntersectionInner == ThreeState.UNSURE) {
                    ThreeState threeState = ThreeState.UNSURE;
                    if (threeState == null) {
                        JSArrowFunctionDetector.$$$reportNull$$$0(21);
                    }
                    return threeState;
                }
                hasUnionOrIntersection |= isUnionOrIntersectionInner == ThreeState.YES;
            }
            builder.advanceLexer();
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            JSArrowFunctionDetector.$$$reportNull$$$0(22);
        }
        return threeState;
    }

    static {
        PARENS.put(JSElementTypes.LPAR, JSElementTypes.RPAR);
        PARENS.put(JSElementTypes.LBRACE, JSElementTypes.RBRACE);
        PARENS.put(JSElementTypes.LBRACKET, JSElementTypes.RBRACKET);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11, 19, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mongo/js/JSArrowFunctionDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mongo/js/JSArrowFunctionDetector";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "checkCommaSeparatedListElement";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "skipAndCheckUnionOrIntersection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isArrowFunctionExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkArrowFunctionExpression";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkCommaSeparatedListElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isArrowFunctionType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkArrowFunctionType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "skipAngleBrackets";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "skipParentheses";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "skipAndCheckUnionOrIntersection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11, 19, 20, 21, 22 -> new IllegalStateException(string);
        };
    }
}

