/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.functions;

import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.FunToken;
import com.intellij.sql.dialects.functions.FunctionLexer;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartFMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionDefinitionParser {
    private static final Logger LOG = Logger.getInstance((String)SqlFunctionDefinitionParser.class.getName());
    private static final String NAME_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"functions", "function", "name"});
    private static final String NAME_ATTR_LOCATION1 = NanoXmlUtil.createLocation((String[])new String[]{"functions", "function"});
    private static final String NAME_ATTR_LOCATION2 = NanoXmlUtil.createLocation((String[])new String[]{"functions", "macro"});
    private static final String PROTOTYPE_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"functions", "function", "prototype"});
    private static final String PROTOTYPE_MACRO_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"functions", "macro"});
    private final FunctionLexer myLexer;
    private final SqlLanguageDialectEx myDialect;
    private final Map<String, BuiltinFunction.Parameter[]> myCustomMap;
    private final Map<String, BuiltinFunction.Type> myExtraTypes;

    public SqlFunctionDefinitionParser(@NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            SqlFunctionDefinitionParser.$$$reportNull$$$0(0);
        }
        this.myCustomMap = new HashMap<String, BuiltinFunction.Parameter[]>();
        this.myExtraTypes = new HashMap<String, BuiltinFunction.Type>();
        this.myDialect = dialect;
        this.myLexer = new FunctionLexer();
    }

    public List<BuiltinFunction> parse(String text2) {
        return this.parseXmlFormat(text2);
    }

    private List<BuiltinFunction> parseXmlFormat(String text2) {
        final ArrayList<BuiltinFunction> list = new ArrayList<BuiltinFunction>();
        NanoXmlUtil.parse((Reader)new StringReader(text2), (IXMLBuilder)new NanoXmlUtil.BaseXmlBuilder(){
            final List<BuiltinFunction.Prototype> myPrototypes = new ArrayList<BuiltinFunction.Prototype>();
            final List<String> myNames = new ArrayList<String>();
            final HashMap<String, String> myDialectAttrs = new HashMap();
            final HashMap<String, String> myPrototypeAttrs = new HashMap();
            int myPrototypeId = 0;
            String myCurPCDataLocation;
            StringBuilder myCurPCData = new StringBuilder();

            public void startElement(String name2, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                super.startElement(name2, nsPrefix, nsURI, systemID, lineNr);
                if ("function".equals(name2) || "macro".equals(name2)) {
                    this.myPrototypes.clear();
                    this.myNames.clear();
                    this.myDialectAttrs.clear();
                    this.myPrototypeId = 0;
                } else if ("prototype".equals(name2)) {
                    this.myPrototypeAttrs.clear();
                }
            }

            public void endElement(String name2, String nsPrefix, String nsURI) throws Exception {
                boolean macro = false;
                String functionName = (String)ContainerUtil.getFirstItem(this.myNames);
                if (NAME_LOCATION.equals(this.myCurPCDataLocation)) {
                    this.myNames.add(this.myCurPCData.toString());
                } else if (PROTOTYPE_LOCATION.equals(this.myCurPCDataLocation) || (macro = PROTOTYPE_MACRO_LOCATION.equals(this.myCurPCDataLocation))) {
                    BuiltinFunction.Type returnType;
                    BuiltinFunction.Parameter[] params;
                    SqlFunctionDefinitionParser.this.myLexer.start(this.myCurPCData, 0, this.myCurPCData.length(), 2);
                    BuiltinFunction.ParameterBlock headBlock = null;
                    if (!macro) {
                        BuiltinFunction.ParameterBlockType headType;
                        boolean opt;
                        IElementType type = SqlFunctionDefinitionParser.this.getTokenType();
                        boolean bl = opt = type == FunToken.LEFT_BRACKET;
                        Object object = opt ? BuiltinFunction.ParameterBlockType.OPTIONAL_SEQUENCE : (headType = type == FunToken.LEFT_BRACE ? BuiltinFunction.ParameterBlockType.SEQUENCE : null);
                        if (headType != null) {
                            SqlFunctionDefinitionParser.this.advanceLexer();
                            BuiltinFunction.Parameter[] head = SqlFunctionDefinitionParser.this.parseParameterList(this.myPrototypeId, functionName, headType);
                            if (head != null && head.length > 0) {
                                headBlock = new BuiltinFunction.ParameterBlock(this.myPrototypeId, headType, head, false);
                            }
                            if (!SqlFunctionDefinitionParser.this.consumeToken(true, opt ? FunToken.RIGHT_BRACKET : FunToken.RIGHT_BRACE)) {
                                SqlFunctionDefinitionParser.this.error(functionName, (opt ? "]" : "}") + " expected");
                            }
                        }
                    }
                    if (!macro && !SqlFunctionDefinitionParser.this.consumeToken(true, FunToken.LEFT_PAREN)) {
                        SqlFunctionDefinitionParser.this.error(functionName, "( expected");
                    }
                    if ((params = SqlFunctionDefinitionParser.this.parseParameterList(this.myPrototypeId, functionName, BuiltinFunction.ParameterBlockType.SEQUENCE)) == null) {
                        SqlFunctionDefinitionParser.this.error(functionName, "params not parsed");
                    }
                    if (!macro && !SqlFunctionDefinitionParser.this.consumeToken(true, FunToken.RIGHT_PAREN)) {
                        SqlFunctionDefinitionParser.this.error(functionName, ") expected");
                    }
                    BuiltinFunction.ParameterBlock tailBlock = null;
                    if (!macro && SqlFunctionDefinitionParser.this.consumeToken(true, FunToken.COLON)) {
                        returnType = (BuiltinFunction.Type)ObjectUtils.chooseNotNull((Object)SqlFunctionDefinitionParser.this.parseType(functionName), (Object)SqlFunctionsUtil.ANY);
                        BuiltinFunction.Parameter[] tail = SqlFunctionDefinitionParser.this.parseParameterList(this.myPrototypeId, functionName, BuiltinFunction.ParameterBlockType.SEQUENCE);
                        if (tail != null && tail.length > 0) {
                            tailBlock = new BuiltinFunction.ParameterBlock(this.myPrototypeId, BuiltinFunction.ParameterBlockType.SEQUENCE, tail, false);
                            SqlFunctionDefinitionParser.this.error(functionName, "unexpected tail block");
                        }
                    } else {
                        if (!macro) {
                            SqlFunctionDefinitionParser.this.error(functionName, ":<type> expected");
                        }
                        returnType = SqlFunctionsUtil.ANY;
                    }
                    if (params != null) {
                        SmartFMap attributes = SmartFMap.emptyMap().plusAll(this.myPrototypeAttrs);
                        this.myPrototypes.add(new BuiltinFunction.Prototype(null, returnType, this.myPrototypeId++, (BuiltinFunction.Parameter)headBlock, params, (Map)attributes));
                    }
                }
                this.myCurPCData.setLength(0);
                this.myCurPCDataLocation = null;
                if (name2.equals("function") || (macro = name2.equals("macro"))) {
                    String primaryName = DbUtil.intern2((String)ContainerUtil.getFirstItem(this.myNames));
                    if (macro) {
                        if (primaryName == null) {
                            SqlFunctionDefinitionParser.this.error(functionName, "macro name not found");
                        } else if (this.myPrototypes.isEmpty()) {
                            IElementType nodeType = SqlFunctionDefinitionParser.this.myDialect.getFunctionParserExtension(StringUtil.toUpperCase((String)primaryName));
                            if (nodeType == null) {
                                SqlFunctionDefinitionParser.this.error(functionName, "external macro " + primaryName + " not found");
                            } else {
                                SqlFunctionDefinitionParser.this.myCustomMap.put(primaryName, new BuiltinFunction.Parameter[]{new BuiltinFunction.ExternalParameter(this.myPrototypeId++, nodeType, this.myNames.size() < 2 ? primaryName : this.myNames.get(1))});
                            }
                        } else {
                            SqlFunctionDefinitionParser.this.myCustomMap.put(primaryName, this.myPrototypes.get(0).getParams());
                        }
                    } else {
                        LinkedHashMap<String, String> dialectAttrs = this.myDialectAttrs.isEmpty() ? Collections.emptyMap() : new LinkedHashMap<String, String>(this.myDialectAttrs);
                        for (String alias : this.myNames) {
                            list.add(new BuiltinFunction(DbUtil.intern(alias), primaryName, dialectAttrs, this.myPrototypes, SqlFunctionDefinitionParser.this.myDialect.getDbms()));
                        }
                    }
                }
                super.endElement(name2, nsPrefix, nsURI);
            }

            public void addAttribute(String key2, String nsPrefix, String nsURI, String value, String type) {
                String location = this.getLocation();
                if (PROTOTYPE_LOCATION.equals(location) && "id".equals(key2)) {
                    this.myPrototypeId = Integer.parseInt(value);
                } else if ("name".equals(key2) && (NAME_ATTR_LOCATION1.equals(location) || NAME_ATTR_LOCATION2.equals(location)) || "display-name".equals(key2) && NAME_ATTR_LOCATION2.equals(location)) {
                    this.myNames.add(DbUtil.intern(value));
                } else if (NAME_ATTR_LOCATION1.equals(location)) {
                    this.myDialectAttrs.put(DbUtil.intern(key2), DbUtil.intern(value));
                } else if (PROTOTYPE_LOCATION.equals(location)) {
                    this.myPrototypeAttrs.put(DbUtil.intern(key2), DbUtil.intern(value));
                }
            }

            public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
                String location = this.getLocation();
                String text2 = 1.readText((Reader)reader);
                if (!location.equals(this.myCurPCDataLocation)) {
                    this.myCurPCData.setLength(0);
                    this.myCurPCData.append(text2);
                    this.myCurPCDataLocation = location;
                } else {
                    this.myCurPCData.append(text2);
                }
            }
        });
        return list;
    }

    @Nullable
    private <T> T error(String functionName, @NonNls String message) {
        CharSequence seq;
        try {
            seq = this.myLexer.getBufferSequence();
        }
        catch (RuntimeException ignore) {
            seq = "";
        }
        int SPACE = 20;
        int pos = this.myLexer.getTokenStart();
        int offset = Math.max(0, pos - SPACE);
        @NonNls String context = seq.subSequence(offset, Math.min(this.myLexer.getTokenEnd() + SPACE, this.myLexer.getBufferEnd())).toString();
        LOG.error(functionName + " [" + pos + "]: " + message + "\n    curToken = " + this.getTokenType() + "\n    curTokenText = '" + this.getTokenText() + "'\n    context = '" + context + "'\n    ___________" + StringUtil.repeat((String)"_", (int)(pos - offset)) + "^");
        return null;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    BuiltinFunction.Parameter @Nullable [] parseParameterList(int prototypeId, String functionName, BuiltinFunction.ParameterBlockType currentBlockType) {
        IElementType curType;
        FunToken separator;
        ArrayList<Object> result2 = new ArrayList<Object>();
        FunToken funToken = separator = currentBlockType == BuiltinFunction.ParameterBlockType.CHOICE ? FunToken.BAR : FunToken.COMMA;
        while ((curType = this.getTokenType()) != FunToken.RIGHT_PAREN && curType != FunToken.RIGHT_BRACKET && curType != FunToken.RIGHT_BRACE) {
            if (currentBlockType == BuiltinFunction.ParameterBlockType.CHOICE) {
                BuiltinFunction.Parameter[] parameters = this.parseParameterList(prototypeId, functionName, BuiltinFunction.ParameterBlockType.SEQUENCE);
                if (parameters == null || parameters.length == 0) {
                    return (BuiltinFunction.Parameter[])this.error(functionName, "no parameters");
                }
                if (parameters.length == 1) {
                    result2.add(parameters[0]);
                } else {
                    result2.add(new BuiltinFunction.ParameterBlock(prototypeId, BuiltinFunction.ParameterBlockType.SEQUENCE, parameters, false));
                }
            } else if (curType == FunToken.LEFT_PAREN || curType == FunToken.LEFT_BRACKET || curType == FunToken.LEFT_BRACE) {
                FunToken closingType;
                this.advanceLexer();
                BuiltinFunction.ParameterBlockType parameterBlockType = curType == FunToken.LEFT_PAREN ? BuiltinFunction.ParameterBlockType.SEQUENCE : (curType == FunToken.LEFT_BRACKET ? BuiltinFunction.ParameterBlockType.OPTIONAL_SEQUENCE : BuiltinFunction.ParameterBlockType.CHOICE);
                BuiltinFunction.Parameter[] parameters = this.parseParameterList(prototypeId, functionName, parameterBlockType);
                if (parameters == null) {
                    return (BuiltinFunction.Parameter[])this.error(functionName, "no parameters");
                }
                FunToken funToken2 = curType == FunToken.LEFT_PAREN ? FunToken.RIGHT_PAREN : (closingType = curType == FunToken.LEFT_BRACKET ? FunToken.RIGHT_BRACKET : FunToken.RIGHT_BRACE);
                if (!this.consumeToken(true, closingType)) {
                    return (BuiltinFunction.Parameter[])this.error(functionName, closingType + " expected");
                }
                BuiltinFunction.ParameterBlockQuantifier quantifier = null;
                if (this.consumeToken(true, FunToken.ELLIPSIS)) {
                    quantifier = BuiltinFunction.ParameterBlockQuantifier.ELLIPSIS;
                } else if (this.consumeToken(true, FunToken.NON_GREEDY_ELLIPSIS)) {
                    quantifier = BuiltinFunction.ParameterBlockQuantifier.NON_GREEDY_ELLIPSIS;
                } else if (this.consumeToken(true, FunToken.STAR)) {
                    quantifier = BuiltinFunction.ParameterBlockQuantifier.STAR;
                }
                result2.add(new BuiltinFunction.ParameterBlock(prototypeId, parameterBlockType, parameters, quantifier));
            } else if (curType == FunToken.COMMA) {
                this.advanceLexer();
                result2.add(BuiltinFunction.COMMA);
            } else if (curType == FunToken.SYNTAX) {
                String tokenText = this.getTokenText();
                assert (tokenText != null);
                result2.add(new BuiltinFunction.SyntaxParameter(prototypeId, tokenText.startsWith("\\") ? tokenText.substring(1) : tokenText));
                this.advanceLexer();
            } else {
                BuiltinFunction.Type type;
                if (curType != FunToken.IDENT) break;
                String name2 = this.consumeTokenText(true, FunToken.IDENT);
                boolean colon = this.consumeToken(true, FunToken.COLON);
                BuiltinFunction.Type type2 = type = colon ? this.parseType(functionName) : null;
                if (type == null) {
                    BuiltinFunction.Parameter[] parameters = this.myCustomMap.get(name2);
                    if (parameters != null) {
                        for (BuiltinFunction.Parameter parameter : parameters) {
                            result2.add(parameter.copyWithPrototype(prototypeId));
                        }
                    } else {
                        result2.add(new BuiltinFunction.Keyword(prototypeId, name2));
                    }
                } else {
                    String refTypeName = type == SqlFunctionsUtil.REF && this.consumeToken(true, FunToken.SLASH) ? this.consumeTokenText(false, FunToken.IDENT) : null;
                    boolean many = this.consumeToken(true, FunToken.ELLIPSIS);
                    if (type == SqlFunctionsUtil.REF && refTypeName == null) {
                        this.error(functionName, "/refType required");
                    }
                    result2.add(refTypeName == null ? new BuiltinFunction.SimpleParameter(prototypeId, name2, type, many) : new BuiltinFunction.ReferenceParameter(prototypeId, name2, type, refTypeName, many));
                }
            }
            if (!this.consumeToken(true, separator) || separator != FunToken.COMMA) continue;
            result2.add(BuiltinFunction.COMMA);
        }
        return result2.isEmpty() ? BuiltinFunction.Parameter.EMPTY_ARRAY : result2.toArray(BuiltinFunction.Parameter.EMPTY_ARRAY);
    }

    @NotNull
    private String parseTypeArgs(@NotNull String functionName) {
        if (functionName == null) {
            SqlFunctionDefinitionParser.$$$reportNull$$$0(1);
        }
        if (this.getTokenType() == FunToken.RIGHT_PAREN) {
            return "";
        }
        StringBuilder res2 = new StringBuilder();
        while (true) {
            DasType dasType;
            if (res2.length() != 0) {
                res2.append(", ");
            }
            String name2 = this.consumeTokenText(false, FunToken.IDENT);
            this.consumeToken(false, FunToken.COLON);
            BuiltinFunction.Type arg = this.parseType(functionName);
            DasType dasType2 = dasType = arg != null ? arg.getDasType() : null;
            if (dasType == null) {
                this.error(functionName, "Table type arguments, type expected");
                break;
            }
            res2.append("\"").append(name2).append("\" ").append(dasType.getSpecification());
            if (this.getTokenType() == FunToken.RIGHT_PAREN) break;
            this.consumeToken(false, FunToken.COMMA);
        }
        String string = res2.toString();
        if (string == null) {
            SqlFunctionDefinitionParser.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private BuiltinFunction.Type createTableType(@NotNull String args2) {
        String spec;
        BuiltinFunction.Type res2;
        if (args2 == null) {
            SqlFunctionDefinitionParser.$$$reportNull$$$0(3);
        }
        if ((res2 = this.myExtraTypes.get(spec = this.myDialect.getTypeSystem().getTableTypeSpecification(args2))) == null) {
            res2 = SqlFunctionsUtil.newType(spec, DataTypeFactory.of(spec));
            this.myExtraTypes.put(spec, res2);
        }
        BuiltinFunction.Type type = res2;
        if (type == null) {
            SqlFunctionDefinitionParser.$$$reportNull$$$0(4);
        }
        return type;
    }

    @NotNull
    private BuiltinFunction.Type createArrayType(@NotNull BuiltinFunction.Type base) {
        String key2;
        BuiltinFunction.Type res2;
        if (base == null) {
            SqlFunctionDefinitionParser.$$$reportNull$$$0(5);
        }
        if ((res2 = this.myExtraTypes.get(key2 = base.getName() + "[]")) == null) {
            DasType baseDasType = (DasType)ObjectUtils.notNull((Object)base.getDasType(), DasTypeSystemBase.UNKNOWN);
            DasArrayType arrayType = this.myDialect.getTypeSystem().getArrayType(baseDasType);
            res2 = new BuiltinFunction.Type(key2, (DasType)arrayType);
            this.myExtraTypes.put(key2, res2);
        }
        BuiltinFunction.Type type = res2;
        if (type == null) {
            SqlFunctionDefinitionParser.$$$reportNull$$$0(6);
        }
        return type;
    }

    @Nullable
    private BuiltinFunction.Type parseType(String functionName) {
        String typeName = this.consumeTypeName();
        if (typeName == null) {
            return (BuiltinFunction.Type)this.error(functionName, "Type expected");
        }
        BuiltinFunction.Type type = this.findType(typeName);
        if (type == null) {
            LOG.info("Available types: " + this.myDialect.getBuiltInTypes().keySet());
            return (BuiltinFunction.Type)this.error(functionName, typeName + " type not found");
        }
        if (this.myLexer.getTokenType() == FunToken.LEFT_BRACKET) {
            int s = this.myLexer.getTokenStart();
            int e = Math.min(this.myLexer.getBufferEnd(), s + 2);
            if ("[]".contentEquals(this.myLexer.getBufferSequence().subSequence(s, e))) {
                this.consumeToken(false, FunToken.LEFT_BRACKET);
                this.consumeToken(false, FunToken.RIGHT_BRACKET);
                return this.createArrayType(type);
            }
        } else {
            if (type == SqlFunctionsUtil.TABLE && this.myLexer.getTokenType() == FunToken.LEFT_PAREN) {
                this.consumeToken(false, FunToken.LEFT_PAREN);
                if (this.consumeToken(true, FunToken.ELLIPSIS)) {
                    this.consumeToken(false, FunToken.IDENT);
                    return SqlFunctionsUtil.UNNEST;
                }
                String args2 = this.parseTypeArgs(functionName);
                this.consumeToken(false, FunToken.RIGHT_PAREN);
                return this.createTableType(args2);
            }
            if (type == SqlFunctionsUtil.SETOF && this.myLexer.getTokenType() == FunToken.LEFT_PAREN) {
                this.consumeToken(false, FunToken.LEFT_PAREN);
                BuiltinFunction.Type item = (BuiltinFunction.Type)ObjectUtils.chooseNotNull((Object)this.parseType(functionName), (Object)SqlFunctionsUtil.ANY);
                this.consumeToken(false, FunToken.RIGHT_PAREN);
                DasType dasType = (DasType)ObjectUtils.notNull((Object)item.getDasType(), DasTypeSystemBase.UNKNOWN);
                return this.createTableType(functionName + " " + dasType.getSpecification());
            }
            if (type == SqlFunctionsUtil.TUPLE && this.myLexer.getTokenType() == FunToken.LEFT_PAREN) {
                this.consumeToken(false, FunToken.LEFT_PAREN);
                BuiltinFunction.Type item = (BuiltinFunction.Type)ObjectUtils.chooseNotNull((Object)this.parseType(functionName), (Object)SqlFunctionsUtil.ANY);
                this.consumeToken(false, FunToken.RIGHT_PAREN);
            }
        }
        return type;
    }

    private String consumeTypeName() {
        return this.consumeTokenText(true, FunToken.IDENT);
    }

    @Nullable
    private BuiltinFunction.Type findType(@Nullable String type) {
        if (type == null) {
            return null;
        }
        BuiltinFunction.Type builtInType = this.myDialect.getBuiltInTypes().get(type);
        if (builtInType != null) {
            return builtInType;
        }
        if (type.startsWith("P")) {
            String s = type.substring("P".length());
            try {
                return new BuiltinFunction.ParamType(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private void advanceLexer() {
        this.myLexer.advance();
    }

    private void skipCommentsAndWhiteSpaces() {
        IElementType type = this.myLexer.getTokenType();
        while (type == FunToken.COMMENT || type == FunToken.WHITE_SPACE) {
            this.myLexer.advance();
            type = this.myLexer.getTokenType();
        }
    }

    @Nullable
    private IElementType getTokenType() {
        this.skipCommentsAndWhiteSpaces();
        return this.myLexer.getTokenType();
    }

    @Nullable
    private String getTokenText() {
        if (this.myLexer.getTokenType() == null) {
            return null;
        }
        String s = this.myLexer.getBufferSequence().subSequence(this.myLexer.getTokenStart(), this.myLexer.getTokenEnd()).toString();
        return DbUtil.intern(s);
    }

    private boolean consumeToken(boolean optional, IElementType type) {
        if (this.getTokenType() == type) {
            this.advanceLexer();
            return true;
        }
        if (!optional) {
            throw new AssertionError((Object)(type.toString() + " expected"));
        }
        return false;
    }

    @Nullable
    private String consumeTokenText(boolean optional, IElementType type) {
        if (this.getTokenType() == type) {
            String result2 = this.getTokenText();
            this.advanceLexer();
            return result2;
        }
        if (!optional) {
            throw new AssertionError((Object)(type + " expected, found " + this.getTokenType()));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/functions/SqlFunctionDefinitionParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/functions/SqlFunctionDefinitionParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeArgs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseTypeArgs";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTableType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createArrayType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6 -> new IllegalStateException(string);
        };
    }
}

