/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.CommonBundle;
import com.intellij.codeWithMe.ClientId;
import com.intellij.database.DbScopeProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.DbEditorDialogBase;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.editors.DatabaseEditorBase;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.editors.ObjectEditorWithPreview;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.database.view.ui.ErrorNotificationWrapperPanel;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.ResultProcessorProvider;
import com.intellij.database.view.ui.TableSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 x*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\u0004uvwxB\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u00106\u001a\u00020\u0016J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\b\u0010;\u001a\u0004\u0018\u00010:J\b\u0010<\u001a\u000208H\u0016J\b\u0010=\u001a\u00020,H\u0002J\b\u0010>\u001a\u00020,H\u0002J\b\u0010?\u001a\u00020\u001eH\u0016J\u0015\u0010@\u001a\u00070A\u00a2\u0006\u0002\bB2\u0006\u0010C\u001a\u00020,H$J\u0006\u0010D\u001a\u000208J\u0006\u0010E\u001a\u000208J\u000e\u0010F\u001a\u0002082\u0006\u0010-\u001a\u00020,J\u000e\u0010G\u001a\u0002082\u0006\u0010H\u001a\u00020*J\b\u0010I\u001a\u00020\u0006H\u0016J\u0015\u0010J\u001a\u0002082\u0006\u0010K\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u000fJ\b\u0010L\u001a\u000208H\u0016J\u0006\u0010M\u001a\u00020,J\u001a\u0010N\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020A0P0OH\u0016J\b\u0010R\u001a\u00020\nH\u0016J'\u0010S\u001a\u0002HT\"\b\b\u0001\u0010T*\u00020U2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020,H\u0002\u00a2\u0006\u0002\u0010YJ%\u0010Z\u001a\u0002HT\"\b\b\u0001\u0010T*\u00020U2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020,\u00a2\u0006\u0002\u0010YJ+\u0010[\u001a\u0004\u0018\u0001HT\"\b\b\u0001\u0010T*\u00020U2\b\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010X\u001a\u00020,H\u0007\u00a2\u0006\u0002\u0010YJ\u0015\u0010\\\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010^0]H\u0014\u00a2\u0006\u0002\u0010_J\b\u0010`\u001a\u000208H\u0004J\u0010\u0010a\u001a\u0002082\u0006\u0010b\u001a\u00020,H\u0016J\b\u0010c\u001a\u00020^H\u0014J\b\u0010d\u001a\u00020^H\u0002J\b\u0010e\u001a\u00020,H\u0014J\b\u0010f\u001a\u000208H\u0014J\n\u0010g\u001a\u0004\u0018\u00010AH\u0014J\n\u0010h\u001a\u0004\u0018\u00010iH\u0014J\b\u0010j\u001a\u00020AH\u0016J\n\u0010k\u001a\u0004\u0018\u00010iH\u0016J\u0012\u0010l\u001a\u0002082\b\u0010m\u001a\u0004\u0018\u00010nH\u0004J\n\u0010o\u001a\u0004\u0018\u00010pH\u0014J\b\u0010q\u001a\u00020,H\u0016J\r\u0010r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010s\u001a\u00020*H\u0007J\b\u0010t\u001a\u00020\u0002H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0004\u0018\u00018\u0000X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\f0\"R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010#\u001a\f0$R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010-\u001a\u00020,2\u0006\u0010+\u001a\u00020,@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001a\u00100\u001a\u00020,X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010/\"\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006y"}, d2={"Lcom/intellij/database/view/ui/AbstractDbRefactoringDialog;", "Ed", "Lcom/intellij/database/view/editors/DatabaseEditorBaseEx;", "Lcom/intellij/openapi/ui/DialogWrapper;", "Lcom/intellij/database/view/ui/ResultProcessorProvider;", "context", "Lcom/intellij/database/view/editors/DatabaseEditorContext;", "<init>", "(Lcom/intellij/database/view/editors/DatabaseEditorContext;)V", "myProject", "Lcom/intellij/openapi/project/Project;", "myEditor", "getMyEditor", "()Lcom/intellij/database/view/editors/DatabaseEditorBaseEx;", "setMyEditor", "(Lcom/intellij/database/view/editors/DatabaseEditorBaseEx;)V", "Lcom/intellij/database/view/editors/DatabaseEditorBaseEx;", "myEditorPreview", "Lcom/intellij/database/view/editors/ObjectEditorWithPreview;", "getMyEditorPreview", "()Lcom/intellij/database/view/editors/ObjectEditorWithPreview;", "myState", "Lcom/intellij/database/view/editors/DatabaseEditorState;", "getMyState", "()Lcom/intellij/database/view/editors/DatabaseEditorState;", "editorModelsCache", "Lcom/intellij/database/view/models/EditorModelsCache;", "getEditorModelsCache", "()Lcom/intellij/database/view/models/EditorModelsCache;", "myModel", "Lcom/intellij/database/schemaEditor/model/DeModel;", "getMyModel", "()Lcom/intellij/database/schemaEditor/model/DeModel;", "myNewOkAction", "Lcom/intellij/database/view/ui/AbstractDbRefactoringDialog$MyOkAction;", "myPreviewAction", "Lcom/intellij/database/view/ui/AbstractDbRefactoringDialog$PreviewAction;", "myErrorPanel", "Lcom/intellij/database/view/ui/ErrorNotificationWrapperPanel;", "getMyErrorPanel", "()Lcom/intellij/database/view/ui/ErrorNotificationWrapperPanel;", "myProcessor", "Lcom/intellij/database/view/ui/AbstractDbRefactoringDialog$ResultProcessor;", "value", "", "refactoring", "getRefactoring", "()Z", "myPreviewUsages", "getMyPreviewUsages", "setMyPreviewUsages", "(Z)V", "myCentralPanel", "Ljavax/swing/JPanel;", "getState", "setOptions", "", "options", "Lcom/intellij/database/script/generator/ScriptingOptions;", "getOptions", "doCancelAction", "userCancelledCancel", "isModified", "getModel", "getTitle", "", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "modify", "finish", "finishAndShow", "setRefactoring", "setResultProcessor", "proc", "getContext", "setEditor", "editor", "settingsChanged", "isValid", "collectRenames", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/psi/PsiElement;", "getProject", "exportImpl", "De", "Lcom/intellij/database/schemaEditor/model/DeObject;", "obj", "Lcom/intellij/database/model/basic/BasicElement;", "withChildren", "(Lcom/intellij/database/model/basic/BasicElement;Z)Lcom/intellij/database/schemaEditor/model/DeObject;", "export", "exportOp", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "updateActions", "setOKActionEnabled", "isEnabled", "getOKAction", "getPreviewAction", "isRefactoringValid", "doOKAction", "getDimensionServiceKey", "createCenterPanel", "Ljavax/swing/JComponent;", "statement", "getPreferredFocusedComponent", "checkObjectInContext", "object", "Lcom/intellij/database/model/DasObject;", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "isPreviewUsages", "getEditor", "getProcessor", "getActiveEditor", "ResultProcessor", "MyOkAction", "PreviewAction", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nAbstractDbRefactoringDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDbRefactoringDialog.kt\ncom/intellij/database/view/ui/AbstractDbRefactoringDialog\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,349:1\n40#2,3:350\n*S KotlinDebug\n*F\n+ 1 AbstractDbRefactoringDialog.kt\ncom/intellij/database/view/ui/AbstractDbRefactoringDialog\n*L\n246#1:350,3\n*E\n"})
public abstract class AbstractDbRefactoringDialog<Ed extends DatabaseEditorBaseEx>
extends DialogWrapper
implements ResultProcessorProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @Nullable
    private Ed myEditor;
    @NotNull
    private final ObjectEditorWithPreview myEditorPreview;
    @NotNull
    private final DatabaseEditorState myState;
    @NotNull
    private final EditorModelsCache editorModelsCache;
    @NotNull
    private final DeModel myModel;
    @NotNull
    private final MyOkAction myNewOkAction;
    @NotNull
    private final PreviewAction myPreviewAction;
    @NotNull
    private final ErrorNotificationWrapperPanel myErrorPanel;
    @Nullable
    private ResultProcessor myProcessor;
    private boolean refactoring;
    private boolean myPreviewUsages;
    @NotNull
    private final JPanel myCentralPanel;

    public AbstractDbRefactoringDialog(@NotNull DatabaseEditorContext context) {
        SqlCodeStyleSettings sqlCodeStyleSettings;
        LocalDataSource ds;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context.getProject(), true);
        this.myPreviewUsages = true;
        this.myProject = context.getProject();
        LocalDataSource localDataSource = ds = DbImplUtil.getMaybeLocalDataSource(context.getDataSource());
        if (localDataSource != null) {
            sqlCodeStyleSettings = ScriptingTaskBuilderKt.getSqlCodeStyle(localDataSource);
        } else {
            SqlCodeStyleSettings sqlCodeStyleSettings2 = SqlCodeStyles.getSqlSettings((Project)this.myProject, (Language)((Language)context.getSqlDialect()));
            sqlCodeStyleSettings = sqlCodeStyleSettings2;
            Intrinsics.checkNotNullExpressionValue((Object)sqlCodeStyleSettings2, (String)"getSqlSettings(...)");
        }
        SqlCodeStyleSettings settings = sqlCodeStyleSettings;
        this.editorModelsCache = new EditorModelsCache(settings);
        this.setModal(true);
        this.myModel = Companion.createModel(context);
        this.myState = new DatabaseEditorState(context);
        this.myEditorPreview = new ObjectEditorWithPreview();
        this.myEditorPreview.subscribePreviewChanged(new ObjectEditorWithPreview.PreviewListener(){

            @Override
            public void changed() {
                this.updateActions();
            }
        });
        this.myCentralPanel = new JPanel(new BorderLayout());
        this.myErrorPanel = new ErrorNotificationWrapperPanel();
        this.myErrorPanel.add((Component)this.myEditorPreview.getComponent(), "Center");
        this.myCentralPanel.add((Component)this.myErrorPanel, "Center");
        this.myNewOkAction = new MyOkAction();
        this.myPreviewAction = new PreviewAction();
        this.setRefactoring(false);
        ResultProcessorProvider resultProcessorProvider = this;
        TableSettings tableSettings = DbRefactoringHelper.DB_SETTINGS;
        Intrinsics.checkNotNullExpressionValue((Object)tableSettings, (String)"DB_SETTINGS");
        this.setResultProcessor(new GenericEditingResultProcessor(resultProcessorProvider, tableSettings, null));
    }

    @Nullable
    protected final Ed getMyEditor() {
        return this.myEditor;
    }

    protected final void setMyEditor(@Nullable Ed Ed) {
        this.myEditor = Ed;
    }

    @NotNull
    protected final ObjectEditorWithPreview getMyEditorPreview() {
        return this.myEditorPreview;
    }

    @NotNull
    protected final DatabaseEditorState getMyState() {
        return this.myState;
    }

    @NotNull
    protected final EditorModelsCache getEditorModelsCache() {
        return this.editorModelsCache;
    }

    @NotNull
    protected final DeModel getMyModel() {
        return this.myModel;
    }

    @NotNull
    protected final ErrorNotificationWrapperPanel getMyErrorPanel() {
        return this.myErrorPanel;
    }

    protected final boolean getRefactoring() {
        return this.refactoring;
    }

    protected final boolean getMyPreviewUsages() {
        return this.myPreviewUsages;
    }

    protected final void setMyPreviewUsages(boolean bl) {
        this.myPreviewUsages = bl;
    }

    @NotNull
    public final DatabaseEditorState getState() {
        return this.myState;
    }

    public final void setOptions(@NotNull ScriptingOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.myEditorPreview.setOptions(options);
    }

    @Nullable
    public final ScriptingOptions getOptions() {
        ScriptingTask scriptingTask = this.myEditorPreview.getTask();
        return scriptingTask != null ? scriptingTask.getOptions() : null;
    }

    public void doCancelAction() {
        if (this.userCancelledCancel()) {
            return;
        }
        super.doCancelAction();
    }

    private final boolean userCancelledCancel() {
        return DbEditorDialogBase.Companion.userCancelledCancel(this.myProject, this.isModified());
    }

    private final boolean isModified() {
        return !this.myEditorPreview.isInvalid() && StringUtil.isNotEmpty((String)this.myEditorPreview.getStatement());
    }

    @Override
    @NotNull
    public DeModel getModel() {
        return this.myModel;
    }

    @NotNull
    protected abstract String getTitle(boolean var1);

    public final void finish() {
        this.myEditorPreview.updatePreview();
        this.init();
    }

    public final void finishAndShow() {
        this.finish();
        this.show();
    }

    public final void setRefactoring(boolean refactoring) {
        this.refactoring = refactoring;
        this.setTitle(this.getTitle(refactoring));
    }

    public final void setResultProcessor(@NotNull ResultProcessor proc) {
        Intrinsics.checkNotNullParameter((Object)proc, (String)"proc");
        if (this.myEditor != null) {
            throw new AssertionError((Object)"Result processor must be set before editor");
        }
        this.myProcessor = proc;
    }

    @Override
    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myState.context;
        Intrinsics.checkNotNullExpressionValue((Object)databaseEditorContext, (String)"context");
        return databaseEditorContext;
    }

    protected final void setEditor(@NotNull Ed editor2) {
        Intrinsics.checkNotNullParameter(editor2, (String)"editor");
        if (this.myEditor != null) {
            throw new AssertionError((Object)"Editor is already set");
        }
        ResultProcessor resultProcessor = this.myProcessor;
        if (resultProcessor == null) {
            throw new AssertionError((Object)"Result processor must be set before editor");
        }
        ResultProcessor processor2 = resultProcessor;
        this.myEditor = editor2;
        Disposer.register((Disposable)this.getDisposable(), (Disposable)((Disposable)editor2));
        this.myEditorPreview.setTrailWidget(processor2.getPreviewWidget());
        JComponent settings = processor2.getSettingsPanel();
        if (settings != null) {
            this.myCentralPanel.add((Component)settings, "South");
        }
        EditorModelBase editorModelBase = ((DatabaseEditorBase)editor2).getModel();
        Intrinsics.checkNotNullExpressionValue((Object)editorModelBase, (String)"getModel(...)");
        this.myEditorPreview.setEditor((DatabaseEditorBaseEx)editor2, processor2.createTraverser(editorModelBase));
        this.setTitle(this.getTitle(this.refactoring));
    }

    @Override
    public void settingsChanged() {
        this.myEditorPreview.updatePreview();
    }

    public final boolean isValid() {
        Ed Ed = this.myEditor;
        Intrinsics.checkNotNull(Ed);
        return ((DatabaseEditorBase)Ed).areEditorsValid();
    }

    @Override
    @NotNull
    public JBIterable<Pair<PsiElement, String>> collectRenames() {
        if (!this.refactoring) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        return DbRenamePsiElementProcessor.Companion.collectRenameElements(this.getModel(), this.getContext().getDataSource());
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.getContext().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    private final <De extends DeObject> De exportImpl(BasicElement obj2, boolean withChildren) {
        Object De = this.getModel().getExportHelper().exportDeep(this.getContext().getModel(), obj2, withChildren);
        Intrinsics.checkNotNullExpressionValue(De, (String)"exportDeep(...)");
        return De;
    }

    @NotNull
    public final <De extends DeObject> De export(@NotNull BasicElement obj2, boolean withChildren) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        return this.exportImpl(obj2, withChildren);
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    public final <De extends DeObject> De exportOp(@Nullable BasicElement obj2, boolean withChildren) {
        BasicElement basicElement = obj2;
        return basicElement == null ? null : (De)this.export(basicElement, withChildren);
    }

    @NotNull
    protected Action[] createActions() {
        Object[] objectArray = super.createActions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"createActions(...)");
        Object[] actions = objectArray;
        if (!this.refactoring) {
            return actions;
        }
        int idx = 0;
        if (actions.length != 0) {
            idx = actions[0] == this.getOKAction() ? 1 : actions.length - 1;
        }
        Object[] objectArray2 = ArrayUtil.insert((Object[])actions, (int)idx, (Object)this.getPreviewAction());
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"insert(...)");
        return (Action[])objectArray2;
    }

    protected final void updateActions() {
        boolean valid = this.isRefactoringValid();
        this.setOKActionEnabled(valid);
        this.getPreviewAction().setEnabled(valid && !this.collectRenames().isEmpty());
        this.myNewOkAction.updateText();
        if (this.myProcessor != null) {
            ResultProcessor resultProcessor = this.myProcessor;
            Intrinsics.checkNotNull((Object)resultProcessor);
            resultProcessor.update();
        }
    }

    public void setOKActionEnabled(boolean isEnabled) {
        this.getOKAction().setEnabled(isEnabled);
    }

    @NotNull
    protected Action getOKAction() {
        return (Action)((Object)this.myNewOkAction);
    }

    private final Action getPreviewAction() {
        return (Action)((Object)this.myPreviewAction);
    }

    protected boolean isRefactoringValid() {
        return !this.myEditorPreview.isInvalid() && !StringsKt.isBlank((CharSequence)this.statement());
    }

    protected void doOKAction() {
        this.processDoNotAskOnOk(0);
        ResultProcessor processor2 = this.myProcessor;
        if (processor2 != null && this.getOKAction().isEnabled()) {
            boolean $i$f$service = false;
            Class<DbScopeProvider> serviceClass$iv = DbScopeProvider.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            DbScopeProvider.launchWithModality$default((DbScopeProvider)object, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, processor2, null){
                int label;
                final /* synthetic */ AbstractDbRefactoringDialog<Ed> this$0;
                final /* synthetic */ ResultProcessor $processor;
                {
                    this.this$0 = $receiver;
                    this.$processor = $processor;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$processor, null){
                                int label;
                                private /* synthetic */ Object L$0;
                                final /* synthetic */ AbstractDbRefactoringDialog<Ed> this$0;
                                final /* synthetic */ ResultProcessor $processor;
                                {
                                    this.this$0 = $receiver;
                                    this.$processor = $processor;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object var1_1) {
                                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            var4_4 = $this$withContext = (CoroutineScope)this.L$0;
                                            var5_5 = this.$processor;
                                            $i$a$-runCatching-AbstractDbRefactoringDialog$doOKAction$1$1$res$1 = false;
                                            this.label = 1;
                                            v0 = var5_5.process((Continuation<? super Unit>)this);
                                            ** if (v0 != var8_2) goto lbl15
lbl14:
                                            // 1 sources

                                            return var8_2;
lbl15:
                                            // 1 sources

                                            ** GOTO lbl22
                                        }
                                        case 1: {
                                            $i$a$-runCatching-AbstractDbRefactoringDialog$doOKAction$1$1$res$1 = false;
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl22:
                                                // 2 sources

                                                var6_9 = Result.constructor-impl((Object)Unit.INSTANCE);
                                            }
                                            catch (Throwable var7_8) {
                                                var6_9 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var7_8));
                                            }
                                            res = var6_9;
                                            th = Result.exceptionOrNull-impl((Object)res);
                                            if (th != null) {
                                                if (!(th instanceof GenericEditingResultProcessor.AbortedByUserException)) {
                                                    v1 = this.this$0.getMyErrorPanel();
                                                    v2 = th.getMessage();
                                                    Intrinsics.checkNotNull((Object)v2);
                                                    v1.reportError(v2);
                                                }
                                            } else {
                                                this.this$0.close(0);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        }
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return AbstractDbRefactoringDialog.class.getName();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCentralPanel;
    }

    @Override
    @NotNull
    public String statement() {
        String string = this.myEditorPreview.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        return string;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myEditorPreview.getPreferredFocusedComponent();
    }

    protected final void checkObjectInContext(@Nullable DasObject object) {
        DasObject o = DbUtil.getDasObject(object);
        BasicModel model = this.getContext().getModel();
        if (object != null && model != null && ((JBTreeTraverser)model.traverser().filter(Conditions.is((Object)o))).bfsTraversal().first() == null) {
            throw new AssertionError((Object)("Object " + object.getName() + " " + object.getClass().getName() + " " + object + " not in context"));
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo info2 = super.doValidate();
        if (info2 != null || this.myProcessor == null) {
            return info2;
        }
        ResultProcessor resultProcessor = this.myProcessor;
        Intrinsics.checkNotNull((Object)resultProcessor);
        return resultProcessor.validate();
    }

    @Override
    public boolean isPreviewUsages() {
        return this.myPreviewUsages;
    }

    @NotNull
    public Ed getEditor() {
        Ed Ed = this.myEditor;
        Intrinsics.checkNotNull(Ed);
        return Ed;
    }

    @TestOnly
    @NotNull
    public final ResultProcessor getProcessor() {
        ResultProcessor resultProcessor = this.myProcessor;
        Intrinsics.checkNotNull((Object)resultProcessor);
        return resultProcessor;
    }

    @NotNull
    public DatabaseEditorBaseEx getActiveEditor() {
        Ed Ed = this.myEditor;
        Intrinsics.checkNotNull(Ed);
        return Ed;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/view/ui/AbstractDbRefactoringDialog$Companion;", "", "<init>", "()V", "createModel", "Lcom/intellij/database/schemaEditor/model/DeModel;", "context", "Lcom/intellij/database/view/editors/DatabaseEditorContext;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DeModel createModel(@NotNull DatabaseEditorContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            SchemaEditor schemaEditor = context.getSchemaEditor();
            Intrinsics.checkNotNullExpressionValue((Object)schemaEditor, (String)"getSchemaEditor(...)");
            SchemaEditor editor2 = schemaEditor;
            DeModel deModel = editor2.createModel(context, context.getModel());
            Intrinsics.checkNotNullExpressionValue((Object)deModel, (String)"createModel(...)");
            DeModel model = deModel;
            return new DeModel(model);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/database/view/ui/AbstractDbRefactoringDialog$MyOkAction;", "Lcom/intellij/openapi/ui/DialogWrapper$OkAction;", "Lcom/intellij/openapi/ui/DialogWrapper;", "<init>", "(Lcom/intellij/database/view/ui/AbstractDbRefactoringDialog;)V", "updateText", "", "isEnabled", "", "doAction", "e", "Ljava/awt/event/ActionEvent;", "intellij.database.impl"})
    private final class MyOkAction
    extends DialogWrapper.OkAction {
        public MyOkAction() {
            super((DialogWrapper)AbstractDbRefactoringDialog.this);
        }

        public final void updateText() {
            Object object = AbstractDbRefactoringDialog.this.myProcessor;
            if (object == null || (object = object.getCurrentAction()) == null) {
                object = CommonBundle.getOkButtonText();
            }
            this.putValue("Name", object);
        }

        public boolean isEnabled() {
            return super.isEnabled() && AbstractDbRefactoringDialog.this.isRefactoringValid();
        }

        protected void doAction(@Nullable ActionEvent e) {
            AbstractDbRefactoringDialog.this.setMyPreviewUsages(false);
            super.doAction(e);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/view/ui/AbstractDbRefactoringDialog$PreviewAction;", "Lcom/intellij/openapi/ui/DialogWrapper$OkAction;", "Lcom/intellij/openapi/ui/DialogWrapper;", "<init>", "(Lcom/intellij/database/view/ui/AbstractDbRefactoringDialog;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.database.impl"})
    private final class PreviewAction
    extends DialogWrapper.OkAction {
        public PreviewAction() {
            super((DialogWrapper)AbstractDbRefactoringDialog.this);
            this.putValue("Name", RefactoringBundle.message((String)"preview.button"));
            this.putValue("Default", false);
            if (SystemInfo.isMac) {
                this.putValue("FocusedAction", true);
            }
        }

        public void actionPerformed(@Nullable ActionEvent e) {
            AbstractDbRefactoringDialog.this.setMyPreviewUsages(true);
            super.doAction(e);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&J\u000e\u0010\u0004\u001a\u00020\u0005H\u00a6@\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0003H&J\u000f\u0010\f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000eH&J\b\u0010\u000f\u001a\u00020\u0005H&J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/view/ui/AbstractDbRefactoringDialog$ResultProcessor;", "", "getPreviewWidget", "Ljavax/swing/JComponent;", "process", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createTraverser", "Lcom/intellij/database/view/editors/DdlPreview$ModelTraverser;", "editor", "Lcom/intellij/database/view/models/EditorModelBase;", "getSettingsPanel", "getCurrentAction", "", "Lorg/jetbrains/annotations/Nls;", "update", "validate", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.database.impl"})
    public static interface ResultProcessor {
        @Nullable
        public JComponent getPreviewWidget();

        @Nullable
        public Object process(@NotNull Continuation<? super Unit> var1);

        @NotNull
        public DdlPreview.ModelTraverser createTraverser(@NotNull EditorModelBase var1);

        @Nullable
        public JComponent getSettingsPanel();

        @Nullable
        public String getCurrentAction();

        public void update();

        @Nullable
        public ValidationInfo validate();
    }
}

