/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.applier;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.applier.DbSingleValueModelMultiApplier;
import com.intellij.database.schemaEditor.model.state.DbSingleValueModelState;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DbNameModelMultiApplier<E extends BasicElement, S extends DbSingleValueModelState<String>>
extends DbSingleValueModelMultiApplier<E, String, S> {
    private static void disambiguate(List<String> names) {
        Object2IntOpenHashMap counters = new Object2IntOpenHashMap();
        for (String name2 : names) {
            counters.put((Object)name2, counters.containsKey((Object)name2) ? 0 : -1);
        }
        for (int i2 = 0; i2 < names.size(); ++i2) {
            int cnt;
            String name2;
            name2 = names.get(i2);
            if (name2 == null || (cnt = counters.getInt((Object)name2)) == -1) continue;
            names.set(i2, name2 + "_" + ++cnt);
            counters.put((Object)name2, cnt);
        }
    }

    @Override
    protected void applyImpl(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner, @NotNull List<DbEditorModel<E, S>> models2) {
        DbSingleValueModelState state;
        if (model == null) {
            DbNameModelMultiApplier.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            DbNameModelMultiApplier.$$$reportNull$$$0(1);
        }
        if (models2 == null) {
            DbNameModelMultiApplier.$$$reportNull$$$0(2);
        }
        if ((state = (DbSingleValueModelState)model.getState()).isInconsistent()) {
            return;
        }
        List names = ContainerUtil.map(models2, m -> this.generateName((DbSingleValueModelState)model.getState(), (DbSingleValueModelState)m.getState()));
        DbNameModelMultiApplier.disambiguate(names);
        for (int i2 = 0; i2 < models2.size(); ++i2) {
            ((DbSingleValueModelState)models2.get(i2).getState()).setValue((String)names.get(i2));
        }
    }

    private String generateName(@NotNull S sourceState, S targetState) {
        if (sourceState == null) {
            DbNameModelMultiApplier.$$$reportNull$$$0(3);
        }
        return (String)((DbSingleValueModelState)sourceState).getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceState";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/model/applier/DbNameModelMultiApplier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generateName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

