/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IconManager;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbPresentation
extends DbPresentationCore {
    public static final Comparator<String> NAMES_COMPARATOR = (s1, s2) -> StringUtil.compare((String)s1, (String)s2, (boolean)true);

    @Deprecated
    public static boolean isUnnamed(@NotNull DasObject o) {
        if (o == null) {
            DbPresentation.$$$reportNull$$$0(0);
        }
        if (StringUtil.isNotEmpty((String)o.getName())) {
            return false;
        }
        if (o.getKind() == ObjectKind.CAST) {
            return false;
        }
        if (o.getKind() != ObjectKind.ROUTINE) {
            return true;
        }
        DasObject parent = o.getDasParent();
        return parent == null || parent.getKind() != ObjectKind.PACKAGE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/psi/DbPresentation", "isUnnamed"));
    }

    public static final class Provider
    extends PresentationProvider<DasObject> {
        @Nullable
        public String getName(@Nullable DasObject object) {
            return object == null ? null : DbPresentationCore.getPresentableName(object, true);
        }

        @Nullable
        public Icon getIcon(@Nullable DasObject object) {
            if (object == null) {
                return null;
            }
            Icon baseIcon = DbPresentationCore.getIcon(object.getKind());
            return IconManager.getInstance().createDeferredIcon(baseIcon, (Object)object, DbPresentationCore::getIcon);
        }

        @Nullable
        public String getTypeName(DasObject object) {
            if (object == null) {
                return null;
            }
            Dbms dbms = DbImplUtil.getDbms(object);
            return DbPresentationCore.getPresentableName(object.getKind(), dbms);
        }
    }
}

