/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.ui;

import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanTreeNode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlanRenderers {
    @NotNull
    public static Balloon createHintsBalloon(PlanModel.Hint[] hints, DbDataSource dataSource) {
        @NlsSafe StringBuilder combined = new StringBuilder();
        ArrayList actions = new ArrayList();
        for (int i2 = 0; i2 < hints.length; ++i2) {
            PlanModel.Hint hint = hints[i2];
            if (i2 != 0) {
                combined.append("\n<hr>\n");
            }
            DataSourceProblem.formatText(combined, actions, hint.getText().replace("\n", "<br>"), hint.getActions());
        }
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(combined.toString(), MessageType.WARNING, ev -> {
            if (ev.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            PlanModel.Action action = (PlanModel.Action)DataSourceProblem.extractAction(ev.getDescription(), actions);
            if (action != null) {
                action.perform(dataSource);
            }
        }).createBalloon();
        if (balloon == null) {
            PlanRenderers.$$$reportNull$$$0(0);
        }
        return balloon;
    }

    @Nullable
    public static Icon getIcon(PlanModel.GenericNode node) {
        PlanModel.NodeType nodeType = node.getType();
        if (nodeType.isKindOf(PlanModel.NodeType.SET_OP)) {
            return AllIcons.Toolbar.Filterdups;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.TEMPORARY)) {
            return DatabaseIcons.Table;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.SUBQUERY)) {
            return ((PlanModel.SubQueryNode)node).isCorrelated() ? AllIcons.Actions.Refresh : AllIcons.Actions.Rollback;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.SELECT)) {
            return DatabaseIcons.SqlSelectStatement;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.STATEMENT)) {
            return DatabaseIcons.SqlDmlStatement;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.INDEX_SCAN)) {
            return DatabaseIcons.GoldKey;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.DATA)) {
            return DatabaseIcons.Table;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.GROUP_BY)) {
            return DatabaseIcons.SqlGroupByType;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.RECURSION)) {
            return AllIcons.Gutter.RecursiveMethod;
        }
        if (nodeType.isKindOf(PlanModel.NodeType.REUSE)) {
            return AllIcons.Ide.Link;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/ui/PlanRenderers", "createHintsBalloon"));
    }

    public static class ActionRenderer
    extends Box
    implements TreeCellRenderer {
        private final Icon myIcon = AllIcons.General.Warning;
        private final Icon myBrighterIcon = IconUtil.brighter((Icon)this.myIcon, (int)6);
        private final JLabel myLabel = new JLabel();
        private final JLabel myHintLabel = new JLabel(this.myBrighterIcon);
        private PlanModel.GenericNode myCurrent = null;

        public ActionRenderer(final Project project) {
            super(0);
            this.add(this.myLabel);
            this.add(Box.createHorizontalStrut(10));
            this.add(this.myHintLabel);
            this.myHintLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DbDataSource dataSource;
                    if (myCurrent == null) {
                        return;
                    }
                    PlanModel plan = myCurrent.getModel();
                    String dsId = plan == null ? null : plan.getDataSourceId();
                    DbDataSource dbDataSource = dataSource = dsId == null ? null : DbPsiFacade.getInstance(project).findDataSource(dsId);
                    if (dataSource == null) {
                        return;
                    }
                    Point point = new Point(e.getXOnScreen() - e.getX() + myHintLabel.getWidth(), e.getYOnScreen() - e.getY() + myHintLabel.getHeight());
                    PlanModel.Hint[] hints = myCurrent.getHints();
                    PlanRenderers.createHintsBalloon(hints, dataSource).show(new RelativePoint(point), Balloon.Position.below);
                }
            });
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            PlanTreeNode node = (PlanTreeNode)ObjectUtils.tryCast((Object)value, PlanTreeNode.class);
            this.myLabel.setForeground(UIUtil.getListForeground((boolean)selected, (boolean)hasFocus));
            PlanModel.GenericNode genericNode = this.myCurrent = node == null ? null : node.getNode();
            if (this.myCurrent == null) {
                this.myLabel.setIcon(null);
                this.myLabel.setText(null);
            } else {
                this.myLabel.setIcon(PlanRenderers.getIcon(this.myCurrent));
                this.myLabel.setText(this.myCurrent.getDisplayTitle());
            }
            this.myHintLabel.setVisible(this.myCurrent != null && this.myCurrent.getHints().length != 0);
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.myHintLabel.isVisible()) {
                PointerInfo info2 = MouseInfo.getPointerInfo();
                Point pt = info2 == null ? null : info2.getLocation();
                boolean hovered = false;
                if (pt != null) {
                    SwingUtilities.convertPointFromScreen(pt, this);
                    hovered = this.myHintLabel.getBounds().contains(pt);
                }
                this.myHintLabel.setIcon(hovered ? this.myBrighterIcon : this.myIcon);
            }
            super.paintComponent(g);
        }
    }
}

