/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.docker.cli;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.CliRunTarget;
import com.intellij.database.cli.CliRunTargetProvider;
import com.intellij.database.docker.cli.CliDockerRunTargetProvider;
import com.intellij.database.docker.cli.DockerFileChooserDialog;
import com.intellij.database.docker.utils.DockerUtilsKt;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerContainerStatus;
import com.intellij.docker.DockerServerRuntimesManager;
import com.intellij.docker.agent.cli.model.DockerExecCommandCliBuilder;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.util.DockerJavaUtilsKt;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerRuntime;
import com.intellij.docker.runtimes.DockerServerRuntime;
import com.intellij.docker.ui.components.DockerComboWithAutoDetect;
import com.intellij.docker.utils.DockerCliUtilsKt;
import com.intellij.docker.vfs.DockerFileSystem;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FactoryMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/docker/cli/CliDockerRunTargetProvider;", "Lcom/intellij/database/cli/CliRunTargetProvider;", "<init>", "()V", "displayName", "", "Lorg/jetbrains/annotations/Nls;", "getDisplayName", "()Ljava/lang/String;", "createRunTarget", "Lcom/intellij/database/cli/CliRunTarget;", "project", "Lcom/intellij/openapi/project/Project;", "ContainerRenderer", "intellij.database.docker"})
public final class CliDockerRunTargetProvider
extends CliRunTargetProvider {
    public CliDockerRunTargetProvider() {
        super("cli.run.target.docker");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message("database.cli.integration.run.target.docker.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public CliRunTarget createRunTarget(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new CliRunTarget(this, project){
            private final Lazy serverCombo$delegate;
            private final Lazy containerCombo$delegate;
            private final Map<DockerApplicationRuntime, DockerFileSystem> fileSystems;
            private final SmartList<Runnable> runTargetChangeListeners;
            private String expectedContainerId;
            private final Lazy componentMap$delegate;
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super($receiver);
                this.serverCombo$delegate = LazyKt.lazy(createRunTarget.1::serverCombo_delegate$lambda$0);
                this.containerCombo$delegate = LazyKt.lazy(createRunTarget.1::containerCombo_delegate$lambda$1);
                Map map2 = FactoryMap.create(arg_0 -> createRunTarget.1.fileSystems$lambda$4(arg_0 -> createRunTarget.1.fileSystems$lambda$3(this, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"create(...)");
                this.fileSystems = map2;
                this.runTargetChangeListeners = new SmartList();
                this.componentMap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HashMap<String, JComponent>>((Object)this){

                    public final HashMap<String, JComponent> invoke() {
                        return createRunTarget.1.access$createComponentMap(this.receiver);
                    }
                }));
            }

            private final DockerComboWithAutoDetect getServerCombo() {
                Lazy lazy = this.serverCombo$delegate;
                return (DockerComboWithAutoDetect)lazy.getValue();
            }

            private final ComboBox<Object> getContainerCombo() {
                Lazy lazy = this.containerCombo$delegate;
                return (ComboBox)lazy.getValue();
            }

            private final HashMap<String, JComponent> createComponentMap() {
                FixedSizeButton fixedSizeButton;
                this.getContainerCombo().setRenderer((ListCellRenderer)ContainerRenderer.INSTANCE);
                this.getServerCombo().addChangeListener(arg_0 -> createRunTarget.1.createComponentMap$lambda$5(this, arg_0));
                this.getContainerCombo().addItemListener(arg_0 -> createRunTarget.1.createComponentMap$lambda$7(this, arg_0));
                FixedSizeButton $this$createComponentMap_u24lambda_u248 = fixedSizeButton = new FixedSizeButton((JComponent)this.getContainerCombo());
                boolean bl = false;
                $this$createComponentMap_u24lambda_u248.setIcon(AllIcons.Actions.Refresh);
                FixedSizeButton refreshButton = fixedSizeButton;
                refreshButton.addActionListener(arg_0 -> createRunTarget.1.createComponentMap$lambda$9(this, arg_0));
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.add((Component)this.getContainerCombo(), "Center");
                panel2.add((Component)refreshButton, "East");
                LinkedHashMap<K, V> map2 = new LinkedHashMap<K, V>();
                ((Map)map2).put(DatabaseBundle.message("database.cli.docker.server", new Object[0]), this.getServerCombo());
                ((Map)map2).put(DatabaseBundle.message("database.cli.docker.container", new Object[0]), panel2);
                return map2;
            }

            private final void refreshContainers() {
                String[] stringArray = new String[]{DatabaseBundle.message("dialog.message.docker.container.loading", new Object[0])};
                this.getContainerCombo().setModel((ComboBoxModel)new DefaultComboBoxModel<String>(stringArray));
                RemoteServer server = this.getServerCombo().getSelectedServer();
                if (server == null) {
                    return;
                }
                DockerServerRuntimesManager.Companion.getInstance(this.$project).getOrCreateConnection(server).thenAcceptAsync(arg_0 -> createRunTarget.1.refreshContainers$lambda$14(arg_0 -> createRunTarget.1.refreshContainers$lambda$13(this, arg_0), arg_0));
            }

            private final DockerApplicationRuntime getSelectedContainer() {
                Object object = this.getContainerCombo().getSelectedItem();
                return object instanceof DockerApplicationRuntime ? (DockerApplicationRuntime)object : null;
            }

            private final DockerFileSystem getSelectedFileSystem() {
                DockerFileSystem dockerFileSystem;
                DockerApplicationRuntime dockerApplicationRuntime = this.getSelectedContainer();
                if (dockerApplicationRuntime != null) {
                    DockerApplicationRuntime it = dockerApplicationRuntime;
                    boolean bl = false;
                    dockerFileSystem = this.fileSystems.get(it);
                } else {
                    dockerFileSystem = null;
                }
                return dockerFileSystem;
            }

            private final VirtualFile getCurrentRoot() {
                DockerFileSystem dockerFileSystem = this.getSelectedFileSystem();
                return dockerFileSystem != null ? dockerFileSystem.getRoot() : null;
            }

            public void serialize(PropertiesComponent properties2, String keyPrefix) {
                Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
                Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
                DockerComboWithAutoDetect.DockerServerItem dockerServerItem = this.getServerCombo().getSelectedItem();
                properties2.setValue(keyPrefix + "_DOCKER_SERVER_NAME", dockerServerItem != null ? dockerServerItem.getServerName() : null);
                DockerApplicationRuntime dockerApplicationRuntime = this.getSelectedContainer();
                properties2.setValue(keyPrefix + "_DOCKER_CONTAINER_ID", dockerApplicationRuntime != null ? dockerApplicationRuntime.getId() : null);
            }

            public void deserialize(PropertiesComponent properties2, String keyPrefix) {
                Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
                Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
                String string = properties2.getValue(keyPrefix + "_DOCKER_SERVER_NAME");
                if (string == null) {
                    return;
                }
                String serverName = string;
                this.expectedContainerId = properties2.getValue(keyPrefix + "_DOCKER_CONTAINER_ID");
                this.getServerCombo().selectServerInCombo(serverName);
            }

            public Map<String, JComponent> getComponentMap() {
                Lazy lazy = this.componentMap$delegate;
                return (Map)lazy.getValue();
            }

            public boolean getSupportsCommandLineValidation() {
                return false;
            }

            public FileChooserDescriptor patchFileChooserDescriptor(FileChooserDescriptor descriptor2) {
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                VirtualFile virtualFile = this.getCurrentRoot();
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile root = virtualFile;
                return descriptor2.withRoots(CollectionsKt.listOfNotNull((Object)root)).withShowHiddenFiles(true);
            }

            public void addRunTargetChangeListener(Runnable runnable) {
                Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
                ((Collection)this.runTargetChangeListeners).add(runnable);
            }

            public PathChooserDialog createPathChooser(FileChooserDescriptor descriptor2, Project project, Component parentComponent) {
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
                return (PathChooserDialog)new DockerFileChooserDialog(descriptor2, parentComponent, project, this);
            }

            public String getPresentableUrl(VirtualFile virtualFile) {
                Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
                VirtualFile virtualFile2 = this.getCurrentRoot();
                if (virtualFile2 == null) {
                    return super.getPresentableUrl(virtualFile);
                }
                VirtualFile root = virtualFile2;
                String string = VfsUtil.getRelativePath((VirtualFile)virtualFile, (VirtualFile)root);
                if (string == null) {
                    string = "";
                }
                return "/" + string;
            }

            public boolean validateFilePath(String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                VirtualFile virtualFile = this.getCurrentRoot();
                if (virtualFile == null) {
                    return super.validateFilePath(path);
                }
                VirtualFile root = virtualFile;
                VirtualFile vFile = root.findFileByRelativePath(path);
                return vFile != null && vFile.isValid() && vFile.exists();
            }

            public ValidationInfo validateModel(CliModel model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                DockerApplicationRuntime container = this.getSelectedContainer();
                if (container == null) {
                    return new ValidationInfo(DatabaseBundle.message("dialog.message.docker.container.not.selected", new Object[0]));
                }
                if (this.getCurrentRoot() == null) {
                    return new ValidationInfo(DatabaseBundle.message("dialog.message.docker.file.system.not.accessible", new Object[0]));
                }
                return null;
            }

            @NlsSafe
            public String patchPathLabel(String label) {
                Intrinsics.checkNotNullParameter((Object)label, (String)"label");
                return label + " " + DatabaseBundle.message("database.cli.integration.run.target.path.suffix", new Object[0]);
            }

            public String getPort(String defaultPort) {
                DockerApplicationRuntime dockerApplicationRuntime = this.getSelectedContainer();
                if (dockerApplicationRuntime == null || (dockerApplicationRuntime = dockerApplicationRuntime.getAgentContainer()) == null || (dockerApplicationRuntime = dockerApplicationRuntime.getInfo()) == null) {
                    return super.getPort(defaultPort);
                }
                DockerApplicationRuntime containerInfo = dockerApplicationRuntime;
                DockerPortBinding[] dockerPortBindingArray = DockerJavaUtilsKt.getDockerPortBindings((CreateContainerCmd)((CreateContainerCmd)containerInfo));
                if (dockerPortBindingArray == null || (dockerPortBindingArray = (DockerPortBinding[])ArraysKt.firstOrNull((Object[])dockerPortBindingArray)) == null) {
                    return super.getPort(defaultPort);
                }
                DockerPortBinding[] portBinding = dockerPortBindingArray;
                return String.valueOf(portBinding.getContainerPort());
            }

            /*
             * WARNING - void declaration
             */
            public GeneralCommandLine adjustCommandLine(GeneralCommandLine commandLine) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
                File inputFile = commandLine.getInputFile();
                String[] command = null;
                if (inputFile != null) {
                    String inputPath = PathUtil.toSystemIndependentName((String)inputFile.getPath());
                    String string = commandLine.getCommandLineString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLineString(...)");
                    String innerCommand = string;
                    String[] stringArray = new String[]{"sh", "-c", innerCommand + " < " + inputPath};
                    command = stringArray;
                } else {
                    Collection collection = CollectionsKt.listOf((Object)commandLine.getExePath());
                    List list = commandLine.getParametersList().getList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
                    Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)collection, (Iterable)list);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    command = thisCollection$iv.toArray(new String[0]);
                }
                DockerExecCommandCliBuilder dockerExecCommandCliBuilder = new DockerExecCommandCliBuilder().withCommand(Arrays.copyOf(command, command.length)).withInteractive(Boolean.valueOf(true)).withTTy(Boolean.valueOf(true));
                Object object = this.getSelectedContainer();
                if (object == null || (object = object.getContainerName()) == null) {
                    object = "";
                }
                DockerExecCommandCliBuilder dockerExecCommandCliBuilder2 = dockerExecCommandCliBuilder.withName((String)object);
                Map map2 = commandLine.getEffectiveEnvironment();
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEffectiveEnvironment(...)");
                Map $i$f$toTypedArray = map2;
                DockerExecCommandCliBuilder dockerExecCommandCliBuilder3 = dockerExecCommandCliBuilder2;
                boolean $i$f$filter = false;
                void var7_10 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$filterTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv$iv;
                    Map.Entry<K, V> entry = element$iv$iv = iterator.next();
                    boolean bl = false;
                    String k = (String)entry.getKey();
                    Intrinsics.checkNotNull((Object)k);
                    if (!(((CharSequence)k).length() > 0 && Character.isLetter(StringsKt.first((CharSequence)k)))) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                DockerExecCommandCliBuilder dockerExecCommandCliBuilder4 = dockerExecCommandCliBuilder3.withEnvironment(destination$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)dockerExecCommandCliBuilder4, (String)"withEnvironment(...)");
                DockerApplicationRuntime dockerApplicationRuntime = this.getSelectedContainer();
                Intrinsics.checkNotNull((Object)dockerApplicationRuntime);
                ServerConfiguration serverConfiguration = dockerApplicationRuntime.getServer().getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)serverConfiguration, (String)"getConfiguration(...)");
                return DockerCliUtilsKt.buildCommandLineBlocking$default((DockerExecCommandCliBuilder)dockerExecCommandCliBuilder4, (DockerCloudConfiguration)((DockerCloudConfiguration)serverConfiguration), (boolean)false, (int)2, null);
            }

            private static final DockerComboWithAutoDetect serverCombo_delegate$lambda$0() {
                return new DockerComboWithAutoDetect(null, null, 3, null);
            }

            private static final ComboBox containerCombo_delegate$lambda$1() {
                return new ComboBox();
            }

            private static final DockerFileSystem fileSystems$lambda$3(createRunTarget.1 this$0, DockerApplicationRuntime runtime) {
                DockerFileSystem dockerFileSystem;
                DockerFileSystem it = dockerFileSystem = new DockerFileSystem(runtime);
                boolean bl = false;
                Disposer.register((Disposable)this$0, (Disposable)((Disposable)it));
                return dockerFileSystem;
            }

            private static final DockerFileSystem fileSystems$lambda$4(Function1 $tmp0, Object p0) {
                return (DockerFileSystem)$tmp0.invoke(p0);
            }

            private static final void createComponentMap$lambda$5(createRunTarget.1 this$0, ChangeEvent changeEvent) {
                this$0.refreshContainers();
            }

            private static final void createComponentMap$lambda$7(createRunTarget.1 this$0, ItemEvent itemEvent) {
                Iterable $this$forEach$iv = (Iterable)this$0.runTargetChangeListeners;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Runnable it = (Runnable)element$iv;
                    boolean bl = false;
                    it.run();
                }
                DockerApplicationRuntime dockerApplicationRuntime = this$0.getSelectedContainer();
                this$0.expectedContainerId = dockerApplicationRuntime != null ? dockerApplicationRuntime.getId() : null;
            }

            private static final void createComponentMap$lambda$9(createRunTarget.1 this$0, ActionEvent it) {
                this$0.refreshContainers();
            }

            private static final boolean refreshContainers$lambda$13$lambda$10(DockerApplicationRuntime it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getStatus() instanceof DockerContainerStatus.Up;
            }

            private static final Unit refreshContainers$lambda$13(createRunTarget.1 this$0, DockerServerRuntime runtime) {
                Object[] containers;
                Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
                Sequence $this$toArray$iv = SequencesKt.filter(DockerUtilsKt.findContainers((DockerRuntime)runtime), createRunTarget.1::refreshContainers$lambda$13$lambda$10);
                boolean $i$f$toArray = false;
                Collection $this$toTypedArray$iv$iv = SequencesKt.toList((Sequence)$this$toArray$iv);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                Object[] $this$sortBy$iv = containers = thisCollection$iv$iv.toArray(new DockerApplicationRuntime[0]);
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.length > 1) {
                    ArraysKt.sortWith((Object[])$this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            DockerApplicationRuntime it = (DockerApplicationRuntime)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getContainerName());
                            it = (DockerApplicationRuntime)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getContainerName())));
                        }
                    });
                }
                this$0.getContainerCombo().setModel((ComboBoxModel)new DefaultComboBoxModel<Object>(containers));
                if (this$0.expectedContainerId != null) {
                    Object containerToSelect;
                    block4: {
                        Object object;
                        Object[] $this$firstOrNull$iv = containers;
                        boolean $i$f$firstOrNull = false;
                        int n = $this$firstOrNull$iv.length;
                        for (int j = 0; j < n; ++j) {
                            Object element$iv;
                            Object it = element$iv = $this$firstOrNull$iv[j];
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)this$0.expectedContainerId)) continue;
                            object = element$iv;
                            break block4;
                        }
                        object = containerToSelect = null;
                    }
                    if (containerToSelect != null) {
                        this$0.getContainerCombo().setSelectedItem(containerToSelect);
                    }
                }
                return Unit.INSTANCE;
            }

            private static final void refreshContainers$lambda$14(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }

            public static final /* synthetic */ HashMap access$createComponentMap(createRunTarget.1 $this) {
                return $this.createComponentMap();
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J<\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/docker/cli/CliDockerRunTargetProvider$ContainerRenderer;", "Ljavax/swing/ListCellRenderer;", "", "<init>", "()V", "myLabel", "Ljavax/swing/JLabel;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.database.docker"})
    private static final class ContainerRenderer
    implements ListCellRenderer<Object> {
        @NotNull
        public static final ContainerRenderer INSTANCE = new ContainerRenderer();
        @NotNull
        private static final JLabel myLabel = new JLabel();

        private ContainerRenderer() {
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends Object> list, @Nullable Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (value instanceof DockerApplicationRuntime) {
                myLabel.setText(((DockerApplicationRuntime)value).getPresentableName());
                myLabel.setIcon(((DockerApplicationRuntime)value).getStatus().getIcon());
            } else {
                Object object = value;
                if (object == null || (object = object.toString()) == null) {
                    object = "";
                }
                myLabel.setText((String)object);
                myLabel.setIcon(null);
            }
            return myLabel;
        }
    }
}

