/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.FixWithProgress;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseConfigEditorConsumer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BestDriverValidator
extends DatabaseConfigValidator<LocalDataSource> {
    private static final String APPROVED_DRIVER = "APPROVED_DRIVER";

    @Override
    public Class<LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    @Override
    public void collectProblems(@NotNull Project project, final @NotNull LocalDataSource dataSource, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        Dbms dsDbms;
        DatabaseDriver driver;
        if (project == null) {
            BestDriverValidator.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            BestDriverValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            BestDriverValidator.$$$reportNull$$$0(2);
        }
        if ((driver = dataSource.getDatabaseDriver()) == null || !driver.isPredefined() || driver.getId().equals(dataSource.getAdditionalProperty(APPROVED_DRIVER))) {
            return;
        }
        Dbms driverDbms = DbImplUtilCore.getDbms(driver);
        if (driverDbms == (dsDbms = dataSource.getDbms())) {
            return;
        }
        final DatabaseDriver bestDriver = DbImplUtilCore.guessDatabaseDriver(dsDbms);
        if (bestDriver == null || !bestDriver.isPredefined()) {
            return;
        }
        String description = DatabaseBundle.message("BestDriverValidator.message", StringUtil.escapeXmlEntities((String)bestDriver.getName()));
        DatabaseConfigEditorConsumer ignore = editor2 -> {
            DataSourceConfigurable configurable;
            DataSourceConfigurable dataSourceConfigurable = configurable = editor2 == null ? null : editor2.getConfigurable(dataSource, true, DataSourceConfigurable.class);
            if (configurable == null) {
                return;
            }
            configurable.setExtraProperty(APPROVED_DRIVER, driver.getId());
        };
        FixWithProgress fix = new FixWithProgress(DatabaseBundle.message("BestDriverValidator.switch.driver", new Object[0])){

            @Override
            public void run(@NotNull ProgressIndicator indicator, @Nullable DatabaseConfigEditor editor2) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor2 == null) {
                    return;
                }
                UIUtil.invokeAndWaitIfNeeded(() -> {
                    DataSourceConfigurable configurable = editor2.getConfigurable(dataSource, true, DataSourceConfigurable.class);
                    if (configurable == null) {
                        return;
                    }
                    configurable.setDriver(bestDriver);
                });
            }

            @Override
            public boolean canBeExecutedWithoutUI() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/validation/BestDriverValidator$1", "run"));
            }
        };
        DataSourceProblem.Navigate navigate = new DataSourceProblem.Navigate(bestDriver);
        DataSourceProblem.HyperText text2 = new DataSourceProblem.HyperText(DatabaseBundle.message("BestDriverValidator.title", new Object[0]), description + DatabaseBundle.message("BestDriverValidator.switch.driver.2", new Object[0]), description, navigate, ignore, fix);
        problems.consume((Object)new DataSourceProblem(dataSource, APPROVED_DRIVER, DataSourceProblem.Level.WARNING, text2, fix));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "problems";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dataSource/validation/BestDriverValidator";
        objectArray[2] = "collectProblems";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

