/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseSshTunnelEstablisher;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshTunnelListener;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseSshTunnelsManager {
    private static final Logger LOG = Logger.getInstance(DatabaseSshTunnelsManager.class);
    private final Project myProject;
    private final Map<LocalDataSource, MySshTunnelsInfo> myTunnelsMap;
    private final ConcurrentMap<Integer, MySshTunnelStateInfo> myTunnelStates;

    public DatabaseSshTunnelsManager(@NotNull Project project) {
        if (project == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(0);
        }
        this.myTunnelsMap = new ConcurrentHashMap<LocalDataSource, MySshTunnelsInfo>();
        this.myTunnelStates = CollectionFactory.createConcurrentWeakMap();
        this.myProject = project;
        this.myProject.getMessageBus().connect().subscribe(SshTunnelListener.TOPIC, (localPort, th) -> {
            MySshTunnelStateInfo stateInfo = (MySshTunnelStateInfo)this.myTunnelStates.get(localPort);
            if (stateInfo != null) {
                stateInfo.state = th;
            }
        });
    }

    @NotNull
    public List<DatabaseSshTunnelEstablisher.SshTunnel> getTunnels(@NotNull LocalDataSource source) {
        MySshTunnelsInfo tunnelsInfo;
        if (source == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(1);
        }
        List<Object> list = (tunnelsInfo = this.myTunnelsMap.get(source)) == null ? Collections.emptyList() : tunnelsInfo.tunnels;
        if (list == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public Throwable getTunnelsState(@NotNull LocalDataSource dataSource) {
        MySshTunnelsInfo tunnelsInfo;
        if (dataSource == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(3);
        }
        return (tunnelsInfo = this.myTunnelsMap.get(dataSource)) == null ? null : this.getTunnelsState(tunnelsInfo.tunnels);
    }

    @Nullable
    private Throwable getTunnelsState(@NotNull List<DatabaseSshTunnelEstablisher.SshTunnel> tunnels) {
        if (tunnels == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(4);
        }
        for (DatabaseSshTunnelEstablisher.SshTunnel tunnel : tunnels) {
            MySshTunnelStateInfo stateInfo = (MySshTunnelStateInfo)this.myTunnelStates.get(tunnel.localPort);
            Throwable state = stateInfo == null ? null : stateInfo.state;
            if (state == null) continue;
            return state;
        }
        return null;
    }

    public void createTunnels(@NotNull LocalDataSource dataSource) throws ExecutionException {
        if (dataSource == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(5);
        }
        try {
            Pair<SshSession, List<DatabaseSshTunnelEstablisher.SshTunnel>> pair = DatabaseSshTunnelEstablisher.createTunnelsSync(this.myProject, dataSource);
            if (pair == null) {
                return;
            }
            MySshTunnelsInfo tunnelsInfo = new MySshTunnelsInfo((SshSession)pair.getFirst(), (List)pair.getSecond());
            for (DatabaseSshTunnelEstablisher.SshTunnel tunnel : tunnelsInfo.tunnels) {
                MySshTunnelStateInfo existing2 = (MySshTunnelStateInfo)this.myTunnelStates.get(tunnel.localPort);
                if (existing2 != null && existing2.session == tunnelsInfo.session) continue;
                this.myTunnelStates.put(tunnel.localPort, new MySshTunnelStateInfo(tunnelsInfo.session));
            }
            this.myTunnelsMap.put(dataSource, tunnelsInfo);
        }
        catch (SshException | UnsupportedOperationException e) {
            throw new ExecutionException(DatabaseBundle.message("dialog.message.ssh", e.getMessage()), e);
        }
    }

    public void validateSshTunnels(@NotNull LocalDataSource dataSource) throws ExecutionException {
        MySshTunnelsInfo tunnelsInfo;
        if (dataSource == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(6);
        }
        if ((tunnelsInfo = this.myTunnelsMap.get(dataSource)) == null) {
            if (DataSourceSshTunnelConfiguration.hasTunnel(dataSource)) {
                LOG.warn("The tunnel was dropped. Recreating...");
                this.createTunnels(dataSource);
            }
            return;
        }
        Throwable tunnelsState = this.getTunnelsState(tunnelsInfo.tunnels);
        if (tunnelsInfo.session.isConnected() && tunnelsState == null) {
            return;
        }
        LOG.warn("The tunnel is dead", tunnelsState);
        this.destroyTunnels(dataSource);
        LOG.warn("Long live the tunnel!");
        this.createTunnels(dataSource);
    }

    public void destroyAllTunnels() {
        ArrayList<MySshTunnelsInfo> tunnelsInfos = new ArrayList<MySshTunnelsInfo>(this.myTunnelsMap.values());
        this.myTunnelsMap.clear();
        for (MySshTunnelsInfo tunnelsInfo : tunnelsInfos) {
            this.destroyTunnelsImpl(tunnelsInfo);
        }
    }

    public void destroyTunnels(@NotNull LocalDataSource dataSource) {
        MySshTunnelsInfo tunnelsInfo;
        if (dataSource == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(7);
        }
        if ((tunnelsInfo = this.myTunnelsMap.remove(dataSource)) == null) {
            return;
        }
        this.destroyTunnelsImpl(tunnelsInfo);
    }

    private void destroyTunnelsImpl(@NotNull MySshTunnelsInfo tunnelsInfo) {
        if (tunnelsInfo == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(8);
        }
        for (DatabaseSshTunnelEstablisher.SshTunnel tunnel : tunnelsInfo.tunnels) {
            this.myTunnelStates.remove(tunnel.localPort);
        }
        DatabaseSshTunnelsManager.destroyTunnelsImpl(tunnelsInfo.session);
    }

    private static void destroyTunnelsImpl(@NotNull SshSession session) {
        if (session == null) {
            DatabaseSshTunnelsManager.$$$reportNull$$$0(9);
        }
        try {
            session.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/DatabaseSshTunnelsManager";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tunnels";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tunnelsInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/DatabaseSshTunnelsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTunnels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTunnels";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTunnelsState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTunnels";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateSshTunnels";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "destroyTunnels";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "destroyTunnelsImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class MySshTunnelsInfo {
        final SshSession session;
        final List<DatabaseSshTunnelEstablisher.SshTunnel> tunnels;

        private MySshTunnelsInfo(@NotNull SshSession session, @NotNull List<DatabaseSshTunnelEstablisher.SshTunnel> tunnels) {
            if (session == null) {
                MySshTunnelsInfo.$$$reportNull$$$0(0);
            }
            if (tunnels == null) {
                MySshTunnelsInfo.$$$reportNull$$$0(1);
            }
            this.session = session;
            this.tunnels = tunnels;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "session";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tunnels";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/DatabaseSshTunnelsManager$MySshTunnelsInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MySshTunnelStateInfo {
        final SshSession session;
        Throwable state;

        private MySshTunnelStateInfo(@NotNull SshSession session) {
            if (session == null) {
                MySshTunnelStateInfo.$$$reportNull$$$0(0);
            }
            this.session = session;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/console/DatabaseSshTunnelsManager$MySshTunnelStateInfo", "<init>"));
        }
    }
}

