#!/bin/sh

# panic: sofree:1883 curvnet is NULL, so=0xfffff8017ca59000
# cpuid = 8
# time = 1746559098
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe0182b5c8d0
# vpanic() at vpanic+0x136/frame 0xfffffe0182b5ca00
# panic() at panic+0x43/frame 0xfffffe0182b5ca60
# sorele_locked() at sorele_locked+0x25f/frame 0xfffffe0182b5ca90
# uipc_sendfile_wait() at uipc_sendfile_wait+0x1df/frame 0xfffffe0182b5caf0
# vn_sendfile() at vn_sendfile+0x59b/frame 0xfffffe0182b5cd70
# sendfile() at sendfile+0x129/frame 0xfffffe0182b5ce00
# amd64_syscall() at amd64_syscall+0x15a/frame 0xfffffe0182b5cf30
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe0182b5cf30
# --- syscall (0, FreeBSD ELF64, syscall), rip = 0x8223fb72a, rsp = 0x824baaf58, rbp = 0x824baaf90 ---
# KDB: enter: panic
# [ thread pid 6382 tid 103296 ]
# Stopped at      kdb_enter+0x33: movq    $0,0x122f202(%rip)
# db> x/s version
# version: FreeBSD 15.0-CURRENT #0 main-n277057-794e792121ba-dirty: Tue May  6 18:34:20 CEST 2025
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO
# db> 

[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
set -u
prog=$(basename "$0" .sh)
cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=f04b36c4f2b84533225a1bd695a0aed2efa559e5
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// syzbot+7b0b20cf2c672c181d98@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <time.h>
#include <unistd.h>

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i = 0;
  for (; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void loop(void)
{
  if (write(1, "executing program\n", sizeof("executing program\n") - 1)) {
  }
  int i, call, thread;
  for (call = 0; call < 8; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      event_timedwait(&th->done, 50);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
}

uint64_t r[5] = {0xffffffffffffffff, 0xffffffffffffffff, 0xffffffffffffffff,
                 0xffffffffffffffff, 0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res = 0;
  switch (call) {
  case 0:
    memcpy((void*)0x200000000480, "./file0\000", 8);
    res = syscall(
        SYS_open, /*file=*/0x200000000480ul,
        /*flags=O_NONBLOCK|O_CREAT|O_RDWR|0x80000000000000*/ 0x80000000000206ul,
        /*mode=*/0ul);
    if (res != -1)
      r[0] = res;
    break;
  case 1:
    syscall(SYS_ftruncate, /*fd=*/r[0], /*len=*/0x3862ul);
    break;
  case 2:
    res = syscall(SYS_socket, /*domain=*/2ul, /*type=*/2ul, /*proto=*/0x88);
    if (res != -1)
      r[1] = res;
    break;
  case 3:
    res = syscall(SYS_socketpair, /*domain=*/1ul, /*type=SOCK_STREAM*/ 1ul,
                  /*proto=*/0, /*fds=*/0x200000000180ul);
    if (res != -1) {
      r[2] = *(uint32_t*)0x200000000180;
      r[3] = *(uint32_t*)0x200000000184;
    }
    break;
  case 4:
    syscall(SYS_dup2, /*oldfd=*/r[2], /*newfd=*/r[1]);
    break;
  case 5:
    memcpy((void*)0x200000000140, "./file0\000", 8);
    res = syscall(SYS_open, /*file=*/0x200000000140ul, /*flags=*/0ul,
                  /*mode=*/0ul);
    if (res != -1)
      r[4] = res;
    break;
  case 6:
    syscall(SYS_sendfile, /*fd=*/r[4], /*s=*/r[1], /*offset=*/0ul,
            /*nbytes=*/0ul, /*hdtr=*/0ul, /*sbytes=*/0ul,
            /*flags=SF_SYNC|SF_NOCACHE*/ 0x14ul);
    break;
  case 7:
    syscall(SYS_dup2, /*oldfd=*/r[4], /*newfd=*/r[3]);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, /*addr=*/0x200000000000ul, /*len=*/0x1000000ul,
          /*prot=PROT_WRITE|PROT_READ|PROT_EXEC*/ 7ul,
          /*flags=MAP_FIXED|MAP_ANONYMOUS|MAP_PRIVATE*/ 0x1012ul,
          /*fd=*/(intptr_t)-1, /*offset=*/0ul);
  const char* reason;
  (void)reason;
  loop();
  return 0;
}
EOF
mycc -o /tmp/$prog -Wall -Wextra -O0 /tmp/$prog.c -lpthread || exit 1

(cd ../testcases/swap; ./swap -t 3m -i 30 -l 100 > /dev/null 2>&1) &
sleep 5

work=/tmp/$prog.dir
rm -rf $work
mkdir $work
cd /tmp/$prog.dir
for i in `jot 30`; do
	(
		mkdir d$i
		cd d$i
		timeout 3m /tmp/$prog > /dev/null 2>&1 &
	)
done
while pgrep -q $prog; do sleep 2; done
while pkill swap; do :; done
wait

rm -rf /tmp/$prog /tmp/$prog.c /tmp/$prog.core /tmp/$prog.?????? $work
exit 0
