/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.property;

import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotList;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.model.parser.AbstractJavaInfoTest;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.jupiter.api.Test;

public class BorderPropertyEditorTest
extends SwingModelTest {
    @Test
    public void test_getText_defaultBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        panel.refresh();
        Property borderProperty = panel.getPropertyByTitle("border");
        BorderPropertyEditorTest.assertEquals(null, (Object)BorderPropertyEditorTest.getPropertyText(borderProperty));
    }

    @Test
    public void test_getText_noBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(null);\n\t}\n}");
        panel.refresh();
        Property borderProperty = panel.getPropertyByTitle("border");
        BorderPropertyEditorTest.assertEquals((Object)"(no border)", (Object)BorderPropertyEditorTest.getPropertyText(borderProperty));
    }

    @Test
    public void test_getText_EmptyBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new EmptyBorder(0, 0, 0, 0));\n\t}\n}");
        panel.refresh();
        Property borderProperty = panel.getPropertyByTitle("border");
        BorderPropertyEditorTest.assertEquals((Object)"EmptyBorder", (Object)BorderPropertyEditorTest.getPropertyText(borderProperty));
    }

    @Test
    public void test_getClipboardSource_EmptyBorder() throws Exception {
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBorder(new EmptyBorder(1, 2, 3, 4));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)BorderPropertyEditorTest.getJavaInfoByName("button");
        GenericProperty borderProperty = (GenericProperty)button.getPropertyByTitle("border");
        PropertyEditor propertyEditor = borderProperty.getEditor();
        BorderPropertyEditorTest.assertEquals((Object)"new javax.swing.border.EmptyBorder(1, 2, 3, 4)", (Object)((IClipboardSourceProvider)propertyEditor).getClipboardSource(borderProperty));
        BorderPropertyEditorTest.doCopyPaste(button, new AbstractJavaInfoTest.PasteProcedure<ComponentInfo>(){

            @Override
            public void run(ComponentInfo copy) throws Exception {
                ((FlowLayoutInfo)panel.getLayout()).add(copy, null);
            }
        });
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBorder(new EmptyBorder(1, 2, 3, 4));\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBorder(new EmptyBorder(1, 2, 3, 4));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_getClipboardSource_hasNotConstants() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tint notConst = 4;\n\t\t\tbutton.setBorder(new EmptyBorder(1, 2, 3, notConst));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)BorderPropertyEditorTest.getJavaInfoByName("button");
        GenericProperty borderProperty = (GenericProperty)button.getPropertyByTitle("border");
        PropertyEditor propertyEditor = borderProperty.getEditor();
        IClipboardSourceProvider pe = (IClipboardSourceProvider)propertyEditor;
        String cs = pe.getClipboardSource(borderProperty);
        BorderPropertyEditorTest.assertEquals(null, (Object)cs);
        BorderPropertyEditorTest.doCopyPaste(button, copy -> ((FlowLayoutInfo)panel.getLayout()).add(copy, null));
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tint notConst = 4;\n\t\t\tbutton.setBorder(new EmptyBorder(1, 2, 3, notConst));\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_editor_defaultBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        panel.refresh();
        Property modelProperty = panel.getPropertyByTitle("border");
        PropertyEditor modelEditor = modelProperty.getEditor();
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = modelEditor.activate(null, modelProperty, null);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBot shell = bot.shell("Border editor").bot();
            BorderPropertyEditorTest.assertEquals((Object)"(default)", (Object)shell.comboBox().getText());
        }));
    }

    @Test
    public void test_editor_noBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(null);\n\t}\n}");
        panel.refresh();
        Property modelProperty = panel.getPropertyByTitle("border");
        PropertyEditor modelEditor = modelProperty.getEditor();
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = modelEditor.activate(null, modelProperty, null);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBot shell = bot.shell("Border editor").bot();
            BorderPropertyEditorTest.assertEquals((Object)"(no border)", (Object)shell.comboBox().getText());
        }));
    }

    @Test
    public void test_editor_bevelBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new BevelBorder(BevelBorder.RAISED, new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 0, 255), new Color(255, 0, 255)));\n\t}\n}");
        panel.refresh();
        Property modelProperty = panel.getPropertyByTitle("border");
        PropertyEditor modelEditor = modelProperty.getEditor();
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = modelEditor.activate(null, modelProperty, null);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBot shell = bot.shell("Border editor").bot();
            BorderPropertyEditorTest.assertEquals((Object)"BevelBorder", (Object)shell.comboBox().getText());
            BorderPropertyEditorTest.assertEquals((Object)"(255, 0, 0)", (Object)shell.label(2).getText());
            BorderPropertyEditorTest.assertEquals((Object)"(0, 255, 0)", (Object)shell.label(4).getText());
            BorderPropertyEditorTest.assertEquals((Object)"(0, 0, 255)", (Object)shell.label(6).getText());
            BorderPropertyEditorTest.assertEquals((Object)"(255, 0, 255)", (Object)shell.label(8).getText());
            BorderPropertyEditorTest.assertTrue((boolean)shell.radio("raised").isSelected());
            shell.radio("lowered").click();
            shell.toolbarButtonWithTooltip("Reset color to default").click();
            BorderPropertyEditorTest.assertEquals((Object)"(default)", (Object)shell.label(2).getText());
            BorderPropertyEditorTest.assertTrue((boolean)shell.radio("lowered").isSelected());
            shell.button("OK").click();
        }));
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new BevelBorder(BevelBorder.LOWERED, null, new Color(0, 255, 0), new Color(0, 0, 255), new Color(255, 0, 255)));\n\t}\n}");
    }

    @Test
    public void test_editor_compoundBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new javax.swing.border.CompoundBorder());\n\t}\n}");
        panel.refresh();
        Property modelProperty = panel.getPropertyByTitle("border");
        PropertyEditor modelEditor = modelProperty.getEditor();
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = modelEditor.activate(null, modelProperty, null);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBotShell shellBot = bot.shell("Border editor");
            SWTBot shell = shellBot.bot();
            BorderPropertyEditorTest.assertEquals((Object)"", (Object)shell.textWithLabel("Outside border:").getText());
            BorderPropertyEditorTest.assertEquals((Object)"", (Object)shell.textWithLabel("Inside border:").getText());
            shell.button("Edit...").click();
            SWTBot shell2 = bot.shell("Border editor", (Shell)shellBot.widget).bot();
            shell2.comboBox().setSelection("EmptyBorder");
            shell2.button("OK").click();
            BorderPropertyEditorTest.assertEquals((Object)"javax.swing.border.EmptyBorder", (Object)shell.textWithLabel("Outside border:").getText());
            BorderPropertyEditorTest.assertEquals((Object)"", (Object)shell.textWithLabel("Inside border:").getText());
            shell.button("Edit...", 1).click();
            SWTBot shell3 = bot.shell("Border editor", (Shell)shellBot.widget).bot();
            shell3.comboBox().setSelection("EtchedBorder");
            shell3.button("OK").click();
            BorderPropertyEditorTest.assertEquals((Object)"javax.swing.border.EmptyBorder", (Object)shell.textWithLabel("Outside border:").getText());
            BorderPropertyEditorTest.assertEquals((Object)"javax.swing.border.EtchedBorder", (Object)shell.textWithLabel("Inside border:").getText());
            shell.button("Swap").click();
            BorderPropertyEditorTest.assertEquals((Object)"javax.swing.border.EtchedBorder", (Object)shell.textWithLabel("Outside border:").getText());
            BorderPropertyEditorTest.assertEquals((Object)"javax.swing.border.EmptyBorder", (Object)shell.textWithLabel("Inside border:").getText());
            shell.button("OK").click();
        }));
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new CompoundBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null), new EmptyBorder(0, 0, 0, 0)));\n\t}\n}");
    }

    @Test
    public void test_editor_emptyBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new EmptyBorder(1, 2, 3, 4));\n\t}\n}");
        panel.refresh();
        Property modelProperty = panel.getPropertyByTitle("border");
        PropertyEditor modelEditor = modelProperty.getEditor();
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = modelEditor.activate(null, modelProperty, null);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBot shell = bot.shell("Border editor").bot();
            BorderPropertyEditorTest.assertEquals((int)1, (int)shell.spinnerWithLabel("Top:").getSelection());
            BorderPropertyEditorTest.assertEquals((int)2, (int)shell.spinnerWithLabel("Left:").getSelection());
            BorderPropertyEditorTest.assertEquals((int)3, (int)shell.spinnerWithLabel("Bottom:").getSelection());
            BorderPropertyEditorTest.assertEquals((int)4, (int)shell.spinnerWithLabel("Right:").getSelection());
            shell.spinnerWithLabel("Top:").setSelection(5);
            shell.spinnerWithLabel("Left:").setSelection(6);
            shell.spinnerWithLabel("Bottom:").setSelection(7);
            shell.spinnerWithLabel("Right:").setSelection(8);
            BorderPropertyEditorTest.assertEquals((int)5, (int)shell.spinnerWithLabel("Top:").getSelection());
            BorderPropertyEditorTest.assertEquals((int)6, (int)shell.spinnerWithLabel("Left:").getSelection());
            BorderPropertyEditorTest.assertEquals((int)7, (int)shell.spinnerWithLabel("Bottom:").getSelection());
            BorderPropertyEditorTest.assertEquals((int)8, (int)shell.spinnerWithLabel("Right:").getSelection());
            shell.button("OK").click();
        }));
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new EmptyBorder(5, 6, 7, 8));\n\t}\n}");
    }

    @Test
    public void test_editor_etchedBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new EtchedBorder(EtchedBorder.RAISED, new Color(0, 255, 0), new Color(0, 0, 255)));\n\t}\n}");
        panel.refresh();
        Property modelProperty = panel.getPropertyByTitle("border");
        PropertyEditor modelEditor = modelProperty.getEditor();
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = modelEditor.activate(null, modelProperty, null);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBot shell = bot.shell("Border editor").bot();
            BorderPropertyEditorTest.assertEquals((Object)"EtchedBorder", (Object)shell.comboBox().getText());
            BorderPropertyEditorTest.assertEquals((Object)"(0, 255, 0)", (Object)shell.label(2).getText());
            BorderPropertyEditorTest.assertEquals((Object)"(0, 0, 255)", (Object)shell.label(4).getText());
            BorderPropertyEditorTest.assertTrue((boolean)shell.radio("raised").isSelected());
            shell.radio("lowered").click();
            shell.toolbarButtonWithTooltip("Reset color to default").click();
            BorderPropertyEditorTest.assertEquals((Object)"(default)", (Object)shell.label(2).getText());
            BorderPropertyEditorTest.assertTrue((boolean)shell.radio("lowered").isSelected());
            shell.button("OK").click();
        }));
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new EtchedBorder(EtchedBorder.LOWERED, null, new Color(0, 0, 255)));\n\t}\n}");
    }

    @Test
    public void test_editor_lineBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new LineBorder(new Color(0, 0, 255), 5, true));\n\t}\n}");
        panel.refresh();
        Property modelProperty = panel.getPropertyByTitle("border");
        PropertyEditor modelEditor = modelProperty.getEditor();
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = modelEditor.activate(null, modelProperty, null);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBot shell = bot.shell("Border editor").bot();
            BorderPropertyEditorTest.assertEquals((Object)"LineBorder", (Object)shell.comboBox().getText());
            BorderPropertyEditorTest.assertEquals((Object)"(0, 0, 255)", (Object)shell.label(1).getText());
            BorderPropertyEditorTest.assertEquals((int)5, (int)shell.spinnerWithLabel("Thickness:").getSelection());
            BorderPropertyEditorTest.assertTrue((boolean)shell.radio("rounded").isSelected());
            shell.radio("square").click();
            shell.spinnerWithLabel("Thickness:").setSelection(10);
            shell.toolbarButtonWithTooltip("Reset color to default").click();
            BorderPropertyEditorTest.assertEquals((Object)"(default)", (Object)shell.label(1).getText());
            BorderPropertyEditorTest.assertEquals((int)10, (int)shell.spinnerWithLabel("Thickness:").getSelection());
            BorderPropertyEditorTest.assertTrue((boolean)shell.radio("square").isSelected());
            shell.button("OK").click();
        }));
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new LineBorder(null, 10));\n\t}\n}");
    }

    @Test
    public void test_editor_matteBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new MatteBorder(1, 2, 3, 4, (java.awt.Color) new Color(0, 0, 255)));\n\t}\n}");
        panel.refresh();
        Property modelProperty = panel.getPropertyByTitle("border");
        PropertyEditor modelEditor = modelProperty.getEditor();
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = modelEditor.activate(null, modelProperty, null);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBot shell = bot.shell("Border editor").bot();
            BorderPropertyEditorTest.assertEquals((Object)"MatteBorder", (Object)shell.comboBox().getText());
            BorderPropertyEditorTest.assertEquals((Object)"(0, 0, 255)", (Object)shell.label(1).getText());
            BorderPropertyEditorTest.assertEquals((int)1, (int)shell.spinnerWithLabel("Top:").getSelection());
            BorderPropertyEditorTest.assertEquals((int)2, (int)shell.spinnerWithLabel("Left:").getSelection());
            BorderPropertyEditorTest.assertEquals((int)3, (int)shell.spinnerWithLabel("Bottom:").getSelection());
            BorderPropertyEditorTest.assertEquals((int)4, (int)shell.spinnerWithLabel("Right:").getSelection());
            shell.toolbarButtonWithTooltip("Reset color to default").click();
            shell.spinnerWithLabel("Top:").setSelection(5);
            shell.spinnerWithLabel("Left:").setSelection(6);
            shell.spinnerWithLabel("Bottom:").setSelection(7);
            shell.spinnerWithLabel("Right:").setSelection(8);
            BorderPropertyEditorTest.assertEquals((Object)"(default)", (Object)shell.label(1).getText());
            BorderPropertyEditorTest.assertEquals((int)5, (int)shell.spinnerWithLabel("Top:").getSelection());
            BorderPropertyEditorTest.assertEquals((int)6, (int)shell.spinnerWithLabel("Left:").getSelection());
            BorderPropertyEditorTest.assertEquals((int)7, (int)shell.spinnerWithLabel("Bottom:").getSelection());
            BorderPropertyEditorTest.assertEquals((int)8, (int)shell.spinnerWithLabel("Right:").getSelection());
            shell.button("OK").click();
        }));
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new MatteBorder(5, 6, 7, 8, (Color) null));\n\t}\n}");
    }

    @Test
    public void test_editor_softBevelBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new SoftBevelBorder(BevelBorder.RAISED, new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 0, 255), new Color(255, 0, 255)));\n\t}\n}");
        panel.refresh();
        Property modelProperty = panel.getPropertyByTitle("border");
        PropertyEditor modelEditor = modelProperty.getEditor();
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = modelEditor.activate(null, modelProperty, null);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBot shell = bot.shell("Border editor").bot();
            BorderPropertyEditorTest.assertEquals((Object)"SoftBevelBorder", (Object)shell.comboBox().getText());
            BorderPropertyEditorTest.assertEquals((Object)"(255, 0, 0)", (Object)shell.label(2).getText());
            BorderPropertyEditorTest.assertEquals((Object)"(0, 255, 0)", (Object)shell.label(4).getText());
            BorderPropertyEditorTest.assertEquals((Object)"(0, 0, 255)", (Object)shell.label(6).getText());
            BorderPropertyEditorTest.assertEquals((Object)"(255, 0, 255)", (Object)shell.label(8).getText());
            BorderPropertyEditorTest.assertTrue((boolean)shell.radio("raised").isSelected());
            shell.radio("lowered").click();
            shell.toolbarButtonWithTooltip("Reset color to default").click();
            BorderPropertyEditorTest.assertEquals((Object)"(default)", (Object)shell.label(2).getText());
            BorderPropertyEditorTest.assertTrue((boolean)shell.radio("lowered").isSelected());
            shell.button("OK").click();
        }));
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new SoftBevelBorder(BevelBorder.LOWERED, null, new Color(0, 255, 0), new Color(0, 0, 255), new Color(255, 0, 255)));\n\t}\n}");
    }

    @Test
    public void test_editor_titledBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new TitledBorder(new LineBorder(null), \"MyTitle\", TitledBorder.TRAILING, TitledBorder.BOTTOM, null, Color.RED));\n\t}\n}");
        panel.refresh();
        Property modelProperty = panel.getPropertyByTitle("border");
        PropertyEditor modelEditor = modelProperty.getEditor();
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = modelEditor.activate(null, modelProperty, null);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBotShell shellBot = bot.shell("Border editor");
            SWTBot shell = shellBot.bot();
            BorderPropertyEditorTest.assertEquals((Object)"TitledBorder", (Object)shell.comboBox().getText());
            BorderPropertyEditorTest.assertEquals((Object)"MyTitle", (Object)shell.textWithLabel("Title:").getText());
            BorderPropertyEditorTest.assertEquals((Object)"Trailing", (Object)shell.comboBoxWithLabel("Title justification:").getText());
            BorderPropertyEditorTest.assertEquals((Object)"Bottom", (Object)shell.comboBoxWithLabel("Title position:").getText());
            BorderPropertyEditorTest.assertEquals((Object)"(255, 0, 0)", (Object)shell.label(4).getText());
            BorderPropertyEditorTest.assertEquals((Object)"javax.swing.border.LineBorder", (Object)shell.textWithLabel("Border:").getText());
            shell.textWithLabel("Title:").setText("NotMyTitle");
            shell.comboBoxWithLabel("Title justification:").setSelection("Left");
            shell.comboBoxWithLabel("Title position:").setSelection("Below Top");
            shell.toolbarButtonWithTooltip("Reset color to default").click();
            shell.button("Edit...").click();
            SWTBot shell2 = bot.shell("Border editor", (Shell)shellBot.widget).bot();
            shell2.comboBox().setSelection("EmptyBorder");
            shell2.button("OK").click();
            BorderPropertyEditorTest.assertEquals((Object)"TitledBorder", (Object)shell.comboBox().getText());
            BorderPropertyEditorTest.assertEquals((Object)"NotMyTitle", (Object)shell.textWithLabel("Title:").getText());
            BorderPropertyEditorTest.assertEquals((Object)"Left", (Object)shell.comboBoxWithLabel("Title justification:").getText());
            BorderPropertyEditorTest.assertEquals((Object)"Below Top", (Object)shell.comboBoxWithLabel("Title position:").getText());
            BorderPropertyEditorTest.assertEquals((Object)"(default)", (Object)shell.label(4).getText());
            BorderPropertyEditorTest.assertEquals((Object)"javax.swing.border.EmptyBorder", (Object)shell.textWithLabel("Border:").getText());
            shell.button("OK").click();
        }));
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new TitledBorder(new EmptyBorder(0, 0, 0, 0), \"NotMyTitle\", TitledBorder.LEFT, TitledBorder.BELOW_TOP, null, null));\n\t}\n}");
    }

    @Test
    public void test_editor_swingBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(UIManager.getBorder(\"Button.border\"));\n\t}\n}");
        panel.refresh();
        Property modelProperty = panel.getPropertyByTitle("border");
        PropertyEditor modelEditor = modelProperty.getEditor();
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = modelEditor.activate(null, modelProperty, null);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBot shell = bot.shell("Border editor").bot();
            BorderPropertyEditorTest.assertEquals((Object)"Swing", (Object)shell.comboBox().getText());
            SWTBotList list = shell.list();
            BorderPropertyEditorTest.assertEquals((int)1, (int)list.selectionCount());
            BorderPropertyEditorTest.assertEquals((Object)"Button.border", (Object)list.selection()[0]);
            list.select("TitledBorder.border");
            BorderPropertyEditorTest.assertEquals((int)1, (int)list.selectionCount());
            BorderPropertyEditorTest.assertEquals((Object)"TitledBorder.border", (Object)list.selection()[0]);
            shell.button("OK").click();
        }));
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(UIManager.getBorder(\"TitledBorder.border\"));\n\t}\n}");
    }
}

