/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.model;

import java.awt.BorderLayout;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.BorderLayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.jupiter.api.Test;

public class BorderLayoutTest
extends AbstractLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        BorderLayoutTest.setLayout(panel, BorderLayout.class);
        this.assertEditor("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout(0, 0));\n\t}\n}");
    }

    @Test
    public void test_getComponent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tfinal JButton button = new JButton();\n\t\t\tadd(button, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        panel.refresh();
        try {
            ComponentInfo component = (ComponentInfo)panel.getChildrenComponents().get(0);
            BorderLayoutTest.assertSame((Object)component.getObject(), (Object)layout.getComponent("North"));
            BorderLayoutTest.assertNull((Object)layout.getComponent("West"));
            BorderLayoutTest.assertNull((Object)layout.getComponent("East"));
            BorderLayoutTest.assertNull((Object)layout.getComponent("South"));
            BorderLayoutTest.assertNull((Object)layout.getComponent("Center"));
        }
        finally {
            panel.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE() throws Exception {
        String lines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t}\n}";
        ContainerInfo panel = this.parseContainer(lines);
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = BorderLayoutTest.createJButton();
        layout.command_CREATE(newComponent, "North");
        BorderLayoutTest.assertInstanceOf(InvocationChildAssociation.class, (Object)newComponent.getAssociation());
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_nullRegion() throws Exception {
        String lines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t}\n}";
        ContainerInfo panel = this.parseContainer(lines);
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = BorderLayoutTest.createJButton();
        layout.command_CREATE(newComponent, null);
        BorderLayoutTest.assertInstanceOf(InvocationChildAssociation.class, (Object)newComponent.getAssociation());
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_withTarget() throws Exception {
        String lines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tadd(new JButton(), BorderLayout.NORTH);\n\t}\n}";
        ContainerInfo panel = this.parseContainer(lines);
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        ComponentInfo target = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo newComponent = BorderLayoutTest.createJButton();
        layout.command_CREATE(newComponent, "West", target);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, BorderLayout.WEST);\n\t\t}\n\t\tadd(new JButton(), BorderLayout.NORTH);\n\t}\n}");
    }

    @Test
    public void test_MOVE() throws Exception {
        this.check_MOVE("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_MOVE_lazy() throws Exception {
        String source = "public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tadd(getButton(), BorderLayout.NORTH);\n\t}\n\tprivate JButton button;\n\tprivate JButton getButton() {\n\t\tif (button == null) {\n\t\t\tbutton = new JButton();\n\t\t}\n\t\treturn button;\n\t}\n}";
        String source2 = source.replace("NORTH", "SOUTH");
        this.check_MOVE(source, source2);
    }

    @Test
    public void test_MOVE_implicitCenter() throws Exception {
        this.check_MOVE("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    private void check_MOVE(String lines) throws Exception {
        this.check_MOVE(lines, "public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, BorderLayout.SOUTH);\n\t\t}\n\t}\n}");
    }

    private void check_MOVE(String lines, String expectedLines) throws Exception {
        ContainerInfo panel = this.parseContainer(lines);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Association initialAssociation = button.getAssociation();
        Statement initialStatement = initialAssociation.getStatement();
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        layout.command_MOVE(button, "South");
        this.assertEditor(expectedLines);
        BorderLayoutTest.assertSame((Object)initialAssociation, (Object)button.getAssociation());
        BorderLayoutTest.assertSame((Object)initialStatement, (Object)button.getAssociation().getStatement());
    }

    @Test
    public void test_REGION() throws Exception {
        String lines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tadd(new JButton(), BorderLayout.NORTH);\n\t}\n}";
        ContainerInfo panel = this.parseContainer(lines);
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        layout.command_REGION(button, "West");
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tadd(new JButton(), BorderLayout.WEST);\n\t}\n}");
    }

    @Test
    public void test_reparentingVariable() throws Exception {
        String lines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tadd(panel, BorderLayout.NORTH);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tbutton.setEnabled(false);\n\t\t\t\tpanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}";
        String expectedLines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tadd(panel, BorderLayout.NORTH);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, BorderLayout.SOUTH);\n\t\t\tbutton.setEnabled(false);\n\t\t}\n\t}\n}";
        this.check_reparenting(lines, expectedLines);
    }

    @Test
    public void test_reparentingLazy() throws Exception {
        String lines = "public class Test extends JPanel {\n\tprivate JPanel panel;\n\tprivate JButton button;\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tadd(getPanel(), BorderLayout.NORTH);\n\t}\n\tprivate JPanel getPanel() {\n\t\tif (panel == null) {\n\t\t\tpanel = new JPanel();\n\t\t\tpanel.add(getButton());\n\t\t}\n\t\treturn panel;\n\t}\n\tprivate JButton getButton() {\n\t\tif (button == null) {\n\t\t\tbutton = new JButton();\n\t\t}\n\t\treturn button;\n\t}\n}";
        String expectedLines = "public class Test extends JPanel {\n\tprivate JPanel panel;\n\tprivate JButton button;\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tadd(getPanel(), BorderLayout.NORTH);\n\t\tadd(getButton(), BorderLayout.SOUTH);\n\t}\n\tprivate JPanel getPanel() {\n\t\tif (panel == null) {\n\t\t\tpanel = new JPanel();\n\t\t}\n\t\treturn panel;\n\t}\n\tprivate JButton getButton() {\n\t\tif (button == null) {\n\t\t\tbutton = new JButton();\n\t\t}\n\t\treturn button;\n\t}\n}";
        this.check_reparenting(lines, expectedLines);
    }

    private void check_reparenting(String lines, String expectedLines) throws Exception {
        ContainerInfo panel = this.parseContainer(lines);
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        layout.command_MOVE(button, "South");
        Association association = button.getAssociation();
        BorderLayoutTest.assertInstanceOf(CompilationUnit.class, (Object)association.getStatement().getRoot());
        this.assertEditor(expectedLines);
    }

    @Test
    public void test_constraintsProperty() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property constraintsProperty = button.getPropertyByTitle("Constraints");
        BorderLayoutTest.assertNotNull((Object)constraintsProperty);
        BorderLayoutTest.assertTrue((boolean)constraintsProperty.getCategory().isSystem());
        BorderLayoutTest.assertSame((Object)constraintsProperty, (Object)button.getPropertyByTitle("Constraints"));
        BorderLayoutTest.assertTrue((boolean)constraintsProperty.isModified());
        BorderLayoutTest.assertEquals((Object)"North", (Object)constraintsProperty.getValue());
        constraintsProperty.setValue((Object)"South");
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, BorderLayout.SOUTH);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_constraintsProperty_unsupportedRegion() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, BorderLayout.BEFORE_FIRST_LINE);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property constraintsProperty = button.getPropertyByTitle("Constraints");
        BorderLayoutTest.assertEquals((Object)"", (Object)constraintsProperty.getValue());
    }

    @Test
    public void test_getEmptyRegion_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tadd(new JButton(), BorderLayout.NORTH);\n\t}\n}");
        panel.refresh();
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        BorderLayoutTest.assertSame((Object)"South", (Object)layout.getEmptyRegion());
    }

    @Test
    public void test_getEmptyRegion_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tadd(new JButton(), BorderLayout.SOUTH);\n\t}\n}");
        panel.refresh();
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        BorderLayoutTest.assertSame((Object)"North", (Object)layout.getEmptyRegion());
    }

    @Test
    public void test_getEmptyRegion_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tadd(new JButton(), BorderLayout.NORTH);\n\t\tadd(new JButton(), BorderLayout.SOUTH);\n\t}\n}");
        panel.refresh();
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        BorderLayoutTest.assertSame((Object)"West", (Object)layout.getEmptyRegion());
    }

    @Test
    public void test_getEmptyRegion_4() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tadd(new JButton(), BorderLayout.NORTH);\n\t\tadd(new JButton(), BorderLayout.SOUTH);\n\t\tadd(new JButton(), BorderLayout.WEST);\n\t\tadd(new JButton(), BorderLayout.EAST);\n\t\tadd(new JButton(), BorderLayout.CENTER);\n\t}\n}");
        panel.refresh();
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        BorderLayoutTest.assertSame(null, (Object)layout.getEmptyRegion());
    }
}

