/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.FormLayout;

import org.assertj.core.api.Assertions;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.tools.CreationTool;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.swing.FormLayout.palette.DefaultComponentFactoryCreateLabelEntryInfo;
import org.eclipse.wb.internal.swing.FormLayout.palette.DefaultComponentFactoryCreateTitleEntryInfo;
import org.eclipse.wb.internal.swing.FormLayout.parser.DefaultComponentFactoryCreationSupport;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.eclipse.wb.tests.designer.swing.model.layout.FormLayout.AbstractFormLayoutTest;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class DefaultComponentFactoryTest
extends AbstractFormLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_createLabel() throws Exception {
        ContainerInfo panel = this.parseContainer("import com.jgoodies.forms.factories.DefaultComponentFactory;", "public class Test extends JPanel {", "  public Test() {", "    {", "      JLabel label = DefaultComponentFactory.getInstance().createLabel('A');", "      add(label);", "    }", "  }", "  // filler filler filler", "}");
        DefaultComponentFactoryTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(label)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {opaque} {local-unique: label} {/DefaultComponentFactory.getInstance().createLabel('A')/ /add(label)/}");
        panel.refresh();
        ComponentInfo component = (ComponentInfo)panel.getChildrenComponents().get(0);
        DefaultComponentFactoryTest.assertInstanceOf(DefaultComponentFactoryCreationSupport.class, (Object)component.getCreationSupport());
        DefaultComponentFactoryTest.assertTrue((boolean)JavaInfoUtils.canMove((JavaInfo)component));
        DefaultComponentFactoryTest.assertTrue((boolean)JavaInfoUtils.canReparent((JavaInfo)component));
        component.getPropertyByTitle("text").setValue((Object)"B");
        this.assertEditor("import com.jgoodies.forms.factories.DefaultComponentFactory;", "public class Test extends JPanel {", "  public Test() {", "    {", "      JLabel label = DefaultComponentFactory.getInstance().createLabel('B');", "      add(label);", "    }", "  }", "  // filler filler filler", "}");
        DefaultComponentFactoryTest.assertTrue((boolean)component.canDelete());
        component.delete();
        this.assertEditor("import com.jgoodies.forms.factories.DefaultComponentFactory;", "public class Test extends JPanel {", "  public Test() {", "  }", "  // filler filler filler", "}");
    }

    @DisposeProjectAfter
    @Disabled
    @Test
    public void test_createLabel_tool() throws Exception {
        DefaultComponentFactoryTest.do_projectDispose();
        DefaultComponentFactoryTest.do_projectCreate();
        this.m_useFormsImports = false;
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        DefaultComponentFactoryCreateLabelEntryInfo entry = new DefaultComponentFactoryCreateLabelEntryInfo();
        DefaultComponentFactoryTest.assertEquals((Object)entry.getClass().getName(), (Object)entry.getId());
        DefaultComponentFactoryTest.assertNotNull((Object)entry.getIcon());
        DefaultComponentFactoryTest.assertTrue((boolean)entry.initialize(null, this.m_lastParseInfo));
        CreationTool creationTool = (CreationTool)entry.createTool();
        ICreationFactory creationFactory = creationTool.getFactory();
        creationFactory.activate();
        ComponentInfo newComponent = (ComponentInfo)creationFactory.getNewObject();
        DefaultComponentFactoryTest.assertInstanceOf(DefaultComponentFactoryCreationSupport.class, (Object)newComponent.getCreationSupport());
        Image image = newComponent.getImage();
        DefaultComponentFactoryTest.assertNotNull((Object)image);
        Rectangle bounds = image.getBounds();
        Assertions.assertThat((int)bounds.width).isGreaterThan(50).isLessThan(100);
        Assertions.assertThat((int)bounds.height).isGreaterThan(10).isLessThan(20);
        image.dispose();
        ((FlowLayoutInfo)panel.getLayout()).add(newComponent, null);
        this.assertEditor("import com.jgoodies.forms.factories.DefaultComponentFactory;", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JLabel label = DefaultComponentFactory.getInstance().createLabel('New JGoodies label');", "      add(label);", "    }", "  }", "}");
    }

    @Test
    public void test_createTitle() throws Exception {
        ContainerInfo panel = this.parseContainer("import com.jgoodies.forms.factories.DefaultComponentFactory;", "public class Test extends JPanel {", "  public Test() {", "    {", "      JLabel label = DefaultComponentFactory.getInstance().createTitle('A');", "      add(label);", "    }", "  }", "}");
        DefaultComponentFactoryTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(label)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {opaque} {local-unique: label} {/DefaultComponentFactory.getInstance().createTitle('A')/ /add(label)/}");
        panel.refresh();
        ComponentInfo component = (ComponentInfo)panel.getChildrenComponents().get(0);
        DefaultComponentFactoryTest.assertInstanceOf(DefaultComponentFactoryCreationSupport.class, (Object)component.getCreationSupport());
        component.getPropertyByTitle("text").setValue((Object)"B");
        this.assertEditor("import com.jgoodies.forms.factories.DefaultComponentFactory;", "public class Test extends JPanel {", "  public Test() {", "    {", "      JLabel label = DefaultComponentFactory.getInstance().createTitle('B');", "      add(label);", "    }", "  }", "}");
    }

    @Test
    public void test_createTitle_tool() throws Exception {
        DefaultComponentFactoryTest.do_projectDispose();
        DefaultComponentFactoryTest.do_projectCreate();
        this.m_useFormsImports = false;
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        DefaultComponentFactoryCreateTitleEntryInfo entry = new DefaultComponentFactoryCreateTitleEntryInfo();
        DefaultComponentFactoryTest.assertEquals((Object)entry.getClass().getName(), (Object)entry.getId());
        DefaultComponentFactoryTest.assertNotNull((Object)entry.getIcon());
        DefaultComponentFactoryTest.assertTrue((boolean)entry.initialize(null, this.m_lastParseInfo));
        CreationTool creationTool = (CreationTool)entry.createTool();
        ICreationFactory creationFactory = creationTool.getFactory();
        creationFactory.activate();
        ComponentInfo newComponent = (ComponentInfo)creationFactory.getNewObject();
        DefaultComponentFactoryTest.assertInstanceOf(DefaultComponentFactoryCreationSupport.class, (Object)newComponent.getCreationSupport());
        ((FlowLayoutInfo)panel.getLayout()).add(newComponent, null);
        this.assertEditor("import com.jgoodies.forms.factories.DefaultComponentFactory;", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JLabel label = DefaultComponentFactory.getInstance().createTitle('New JGoodies title');", "      add(label);", "    }", "  }", "}");
    }
}

