/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.rcp;

import org.apache.commons.lang3.NotImplementedException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.model.jface.action.ActionContainerInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ActionInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.CoolBarManagerInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.MenuManagerInfo;
import org.eclipse.wb.internal.rcp.model.rcp.ActionBarAdvisorInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class ActionBarAdvisorTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_0() throws Exception {
        ActionBarAdvisorInfo advisor = (ActionBarAdvisorInfo)this.parseJavaInfo("public class Test extends ActionBarAdvisor {", "  public Test(IActionBarConfigurer configurer) {", "    super(configurer);", "  }", "  protected void fillCoolBar(ICoolBarManager coolBar) {", "  }", "  protected void fillMenuBar(IMenuManager menuBar) {", "  }", "  protected void makeActions(IWorkbenchWindow window) {", "  }", "}");
        ActionBarAdvisorTest.assertHierarchy("{this: org.eclipse.ui.application.ActionBarAdvisor} {this} {}", "  {parameter} {menuBar} {}", "  {parameter} {coolBar} {}");
        MenuManagerInfo menuBar = (MenuManagerInfo)advisor.getChildren().get(0);
        ActionBarAdvisorTest.assertEquals((Object)"menuBar", (Object)menuBar.getVariableSupport().getName());
        CoolBarManagerInfo coolBar = (CoolBarManagerInfo)advisor.getChildren().get(1);
        ActionBarAdvisorTest.assertEquals((Object)"coolBar", (Object)coolBar.getVariableSupport().getName());
        advisor.refresh();
        ActionBarAdvisorTest.assertNoErrors((JavaInfo)advisor);
        ActionBarAdvisorTest.assertEquals((int)advisor.getBounds().width, (int)600);
        ActionBarAdvisorTest.assertEquals((int)advisor.getBounds().height, (int)500);
        IActionBarConfigurer o_IActionBarConfigurer = (IActionBarConfigurer)ReflectionUtils.invokeMethod2((Object)advisor.getObject(), (String)"getActionBarConfigurer");
        try {
            o_IActionBarConfigurer.toString();
            ActionBarAdvisorTest.fail();
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        IWorkbenchWindowConfigurer o_IWorkbenchWindowConfigurer = o_IActionBarConfigurer.getWindowConfigurer();
        try {
            o_IActionBarConfigurer.toString();
            ActionBarAdvisorTest.fail();
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        IWorkbenchWindow o_IWorkbenchWindow = o_IWorkbenchWindowConfigurer.getWindow();
        ActionBarAdvisorTest.assertSame((Object)DesignerPlugin.getActiveWorkbenchWindow(), (Object)o_IWorkbenchWindow);
    }

    @Test
    public void test_ActionBarAdvisor_TopBoundsSupport() throws Exception {
        ActionBarAdvisorInfo advisor = (ActionBarAdvisorInfo)this.parseJavaInfo("public class Test extends ActionBarAdvisor {", "  public Test(IActionBarConfigurer configurer) {", "    super(configurer);", "  }", "}");
        advisor.refresh();
        ActionBarAdvisorTest.assertNoErrors((JavaInfo)advisor);
        ActionBarAdvisorTest.assertEquals((int)advisor.getBounds().width, (int)600);
        ActionBarAdvisorTest.assertEquals((int)advisor.getBounds().height, (int)500);
        advisor.getTopBoundsSupport().setSize(450, 300);
        advisor.refresh();
        ActionBarAdvisorTest.assertEquals((int)advisor.getBounds().width, (int)450);
        ActionBarAdvisorTest.assertEquals((int)advisor.getBounds().height, (int)300);
    }

    @Test
    public void test_addAction() throws Exception {
        ActionBarAdvisorInfo advisor = (ActionBarAdvisorInfo)this.parseJavaInfo("public class Test extends ActionBarAdvisor {", "  public Test(IActionBarConfigurer configurer) {", "    super(configurer);", "  }", "  protected void fillMenuBar(IMenuManager menuBar) {", "  }", "  protected void makeActions(IWorkbenchWindow window) {", "  }", "}");
        advisor.refresh();
        ActionBarAdvisorTest.assertNoErrors((JavaInfo)advisor);
        ActionInfo action = ActionContainerInfo.createNew((JavaInfo)advisor);
        MenuManagerInfo menuManager = advisor.getMenuManager();
        menuManager.command_CREATE(action, null);
        this.assertEditor("public class Test extends ActionBarAdvisor {", "  private Action action;", "  public Test(IActionBarConfigurer configurer) {", "    super(configurer);", "  }", "  protected void fillMenuBar(IMenuManager menuBar) {", "    menuBar.add(action);", "  }", "  protected void makeActions(IWorkbenchWindow window) {", "    {", "      action = new Action('New Action') {", "      };", "      register(action);", "    }", "  }", "}");
        ActionBarAdvisorTest.assertHierarchy("{this: org.eclipse.ui.application.ActionBarAdvisor} {this} {/register(action)/}", "  {parameter} {menuBar} {/menuBar.add(action)/}", "    {void} {void} {/menuBar.add(action)/}", "  {org.eclipse.wb.internal.rcp.model.jface.action.ActionContainerInfo}", "    {new: org.eclipse.jface.action.Action} {field-unique: action} {/new Action('New Action')/ /register(action)/ /menuBar.add(action)/}");
        advisor.refresh();
        ActionBarAdvisorTest.assertNoErrors((JavaInfo)advisor);
    }

    @Test
    public void test_getWorkbench_getSharedImages() throws Exception {
        ActionBarAdvisorInfo advisor = (ActionBarAdvisorInfo)this.parseJavaInfo("public class Test extends ActionBarAdvisor {", "  private Action action;", "  public Test(IActionBarConfigurer configurer) {", "    super(configurer);", "  }", "  protected void makeActions(IWorkbenchWindow window) {", "    ISharedImages images = window.getWorkbench().getSharedImages();", "    {", "      action = new Action() {", "      };", "      action.setImageDescriptor(images.getImageDescriptor(ISharedImages.IMG_TOOL_BACK));", "    }", "  }", "}");
        advisor.refresh();
        ActionBarAdvisorTest.assertNoErrors((JavaInfo)advisor);
    }

    @Test
    public void test_newToolBarContributionItem() throws Exception {
        ActionBarAdvisorInfo advisor = (ActionBarAdvisorInfo)this.parseJavaInfo("public class Test extends ActionBarAdvisor {", "  public Test(IActionBarConfigurer configurer) {", "    super(configurer);", "  }", "  protected void fillCoolBar(ICoolBarManager coolBar) {", "    IToolBarManager toolBar = new ToolBarManager(SWT.FLAT | SWT.RIGHT);", "    coolBar.add(new ToolBarContributionItem(toolBar));", "  }", "}");
        advisor.refresh();
        ActionBarAdvisorTest.assertNoErrors((JavaInfo)advisor);
    }

    @Test
    public void test_WorkbenchWindowAdvisor_properties_allNames() throws Exception {
        ActionBarAdvisorTest.setFileContentSrc("test/ApplicationWorkbenchWindowAdvisor.java", ActionBarAdvisorTest.getSourceDQ("package test;", "import org.eclipse.ui.application.*;", "public class ApplicationWorkbenchWindowAdvisor extends WorkbenchWindowAdvisor {", "  public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {", "    super(configurer);", "  }", "  public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {", "    return new Test(configurer);", "  }", "}"));
        ActionBarAdvisorTest.setFileContentSrc("test/Test.java", ActionBarAdvisorTest.getSourceDQ("package test;", "import org.eclipse.ui.application.*;", "public class Test extends ActionBarAdvisor {", "  public Test(IActionBarConfigurer configurer) {", "    super(configurer);", "  }", "}"));
        ActionBarAdvisorTest.waitForAutoBuild();
        ICompilationUnit unit = m_testProject.getJavaProject().findType("test.Test").getCompilationUnit();
        ActionBarAdvisorInfo advisor = (ActionBarAdvisorInfo)this.parseCompilationUnit(unit);
        ActionBarAdvisorTest.assertNotNull((Object)advisor.getPropertyByTitle("initialSize"));
        ActionBarAdvisorTest.assertNotNull((Object)advisor.getPropertyByTitle("shellStyle"));
        ActionBarAdvisorTest.assertNotNull((Object)advisor.getPropertyByTitle("showCoolBar"));
        ActionBarAdvisorTest.assertNotNull((Object)advisor.getPropertyByTitle("showMenuBar"));
        ActionBarAdvisorTest.assertNotNull((Object)advisor.getPropertyByTitle("showPerspectiveBar"));
        ActionBarAdvisorTest.assertNotNull((Object)advisor.getPropertyByTitle("showProgressIndicator"));
        ActionBarAdvisorTest.assertNotNull((Object)advisor.getPropertyByTitle("showStatusLine"));
        ActionBarAdvisorTest.assertNotNull((Object)advisor.getPropertyByTitle("title"));
        ActionBarAdvisorTest.assertSame((Object)advisor.getPropertyByTitle("title"), (Object)advisor.getPropertyByTitle("title"));
    }

    @Test
    public void test_WorkbenchWindowAdvisor_properties_showStatusLine() throws Exception {
        ActionBarAdvisorTest.setFileContentSrc("test/ApplicationWorkbenchWindowAdvisor.java", ActionBarAdvisorTest.getSourceDQ("package test;", "import org.eclipse.ui.application.*;", "public class ApplicationWorkbenchWindowAdvisor extends WorkbenchWindowAdvisor {", "  public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {", "    super(configurer);", "  }", "  public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {", "    return new Test(configurer);", "  }", "  public void preWindowOpen() {", "    IWorkbenchWindowConfigurer configurer = getWindowConfigurer();", "    configurer.setShowStatusLine(false);", "  }", "}"));
        ActionBarAdvisorTest.setFileContentSrc("test/Test.java", ActionBarAdvisorTest.getSourceDQ("package test;", "import org.eclipse.ui.application.*;", "public class Test extends ActionBarAdvisor {", "  public Test(IActionBarConfigurer configurer) {", "    super(configurer);", "  }", "}"));
        ActionBarAdvisorTest.waitForAutoBuild();
        ActionBarAdvisorInfo advisor = (ActionBarAdvisorInfo)this.parseCompilationUnit(m_testProject.getCompilationUnit("test.Test"));
        Property propertySL = advisor.getPropertyByTitle("showStatusLine");
        ActionBarAdvisorTest.assertTrue((boolean)propertySL.isModified());
        ActionBarAdvisorTest.assertEquals((Object)Boolean.FALSE, (Object)propertySL.getValue());
        propertySL.setValue((Object)true);
        ActionBarAdvisorTest.assertUnitContents(ActionBarAdvisorTest.getSourceDQ("package test;", "import org.eclipse.ui.application.*;", "public class ApplicationWorkbenchWindowAdvisor extends WorkbenchWindowAdvisor {", "  public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {", "    super(configurer);", "  }", "  public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {", "    return new Test(configurer);", "  }", "  public void preWindowOpen() {", "    IWorkbenchWindowConfigurer configurer = getWindowConfigurer();", "  }", "}"), "test.ApplicationWorkbenchWindowAdvisor");
    }

    @Test
    public void test_WorkbenchWindowAdvisor_properties_title() throws Exception {
        ActionBarAdvisorTest.setFileContentSrc("test/ApplicationWorkbenchWindowAdvisor.java", ActionBarAdvisorTest.getSourceDQ("package test;", "import org.eclipse.ui.application.*;", "public class ApplicationWorkbenchWindowAdvisor extends WorkbenchWindowAdvisor {", "  public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {", "    super(configurer);", "  }", "  public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {", "    return new Test(configurer);", "  }", "  public void preWindowOpen() {", "    IWorkbenchWindowConfigurer configurer = getWindowConfigurer();", "    configurer.setTitle('A');", "  }", "}"));
        ActionBarAdvisorTest.setFileContentSrc("test/Test.java", ActionBarAdvisorTest.getSourceDQ("package test;", "import org.eclipse.ui.application.*;", "public class Test extends ActionBarAdvisor {", "  public Test(IActionBarConfigurer configurer) {", "    super(configurer);", "  }", "}"));
        ActionBarAdvisorTest.waitForAutoBuild();
        ActionBarAdvisorInfo advisor = (ActionBarAdvisorInfo)this.parseCompilationUnit(m_testProject.getCompilationUnit("test.Test"));
        Property propertyTitle = advisor.getPropertyByTitle("title");
        ActionBarAdvisorTest.assertTrue((boolean)propertyTitle.isModified());
        ActionBarAdvisorTest.assertEquals((Object)"A", (Object)propertyTitle.getValue());
        propertyTitle.setValue((Object)"B");
        ActionBarAdvisorTest.assertUnitContents(ActionBarAdvisorTest.getSourceDQ("package test;", "import org.eclipse.ui.application.*;", "public class ApplicationWorkbenchWindowAdvisor extends WorkbenchWindowAdvisor {", "  public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {", "    super(configurer);", "  }", "  public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {", "    return new Test(configurer);", "  }", "  public void preWindowOpen() {", "    IWorkbenchWindowConfigurer configurer = getWindowConfigurer();", "    configurer.setTitle('B');", "  }", "}"), "test.ApplicationWorkbenchWindowAdvisor");
        ActionBarAdvisorTest.assertTrue((boolean)propertyTitle.isModified());
        ActionBarAdvisorTest.assertEquals((Object)"B", (Object)propertyTitle.getValue());
        propertyTitle.setValue(Property.UNKNOWN_VALUE);
        ActionBarAdvisorTest.assertUnitContents(ActionBarAdvisorTest.getSourceDQ("package test;", "import org.eclipse.ui.application.*;", "public class ApplicationWorkbenchWindowAdvisor extends WorkbenchWindowAdvisor {", "  public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {", "    super(configurer);", "  }", "  public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {", "    return new Test(configurer);", "  }", "  public void preWindowOpen() {", "    IWorkbenchWindowConfigurer configurer = getWindowConfigurer();", "  }", "}"), "test.ApplicationWorkbenchWindowAdvisor");
        ActionBarAdvisorTest.assertFalse((boolean)propertyTitle.isModified());
        ActionBarAdvisorTest.assertEquals((Object)Property.UNKNOWN_VALUE, (Object)propertyTitle.getValue());
        propertyTitle.setValue((Object)"C");
        ActionBarAdvisorTest.assertUnitContents(ActionBarAdvisorTest.getSourceDQ("package test;", "import org.eclipse.ui.application.*;", "public class ApplicationWorkbenchWindowAdvisor extends WorkbenchWindowAdvisor {", "  public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {", "    super(configurer);", "  }", "  public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {", "    return new Test(configurer);", "  }", "  public void preWindowOpen() {", "    IWorkbenchWindowConfigurer configurer = getWindowConfigurer();", "    configurer.setTitle('C');", "  }", "}"), "test.ApplicationWorkbenchWindowAdvisor");
        ActionBarAdvisorTest.assertTrue((boolean)propertyTitle.isModified());
        ActionBarAdvisorTest.assertEquals((Object)"C", (Object)propertyTitle.getValue());
    }

    @Test
    public void test_WorkbenchWindowAdvisor_properties_newMethod() throws Exception {
        ActionBarAdvisorTest.setFileContentSrc("test/ApplicationWorkbenchWindowAdvisor.java", ActionBarAdvisorTest.getSourceDQ("package test;", "import org.eclipse.ui.application.*;", "public class ApplicationWorkbenchWindowAdvisor extends WorkbenchWindowAdvisor {", "  public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {", "    super(configurer);", "  }", "  public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {", "    return new Test(configurer);", "  }", "}"));
        ActionBarAdvisorTest.setFileContentSrc("test/Test.java", ActionBarAdvisorTest.getSourceDQ("package test;", "import org.eclipse.ui.application.*;", "public class Test extends ActionBarAdvisor {", "  public Test(IActionBarConfigurer configurer) {", "    super(configurer);", "  }", "}"));
        ActionBarAdvisorTest.waitForAutoBuild();
        ActionBarAdvisorInfo advisor = (ActionBarAdvisorInfo)this.parseCompilationUnit(m_testProject.getCompilationUnit("test.Test"));
        Property propertyTitle = advisor.getPropertyByTitle("title");
        propertyTitle.setValue((Object)"B");
        ActionBarAdvisorTest.assertUnitContents(ActionBarAdvisorTest.getSourceDQ("package test;", "import org.eclipse.ui.application.*;", "public class ApplicationWorkbenchWindowAdvisor extends WorkbenchWindowAdvisor {", "  public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {", "    super(configurer);", "  }", "  public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {", "    return new Test(configurer);", "  }", "  public void preWindowOpen() {", "    IWorkbenchWindowConfigurer configurer = getWindowConfigurer();", "    configurer.setTitle('B');", "  }", "}"), "test.ApplicationWorkbenchWindowAdvisor");
        ActionBarAdvisorTest.assertTrue((boolean)propertyTitle.isModified());
        ActionBarAdvisorTest.assertEquals((Object)"B", (Object)propertyTitle.getValue());
    }

    private static void assertUnitContents(String content, String typeName) throws JavaModelException {
        ActionBarAdvisorTest.assertEquals((Object)content, (Object)m_testProject.getCompilationUnit(typeName).getBuffer().getContents());
    }

    @Override
    protected String[] getTestSource_decorate(String ... lines) {
        lines = CodeUtils.join((String[])new String[]{"package test;", "import org.eclipse.swt.SWT;", "import org.eclipse.jface.action.*;", "import org.eclipse.ui.*;", "import org.eclipse.ui.application.*;"}, (String[])lines);
        return lines;
    }
}

