/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.palette;

import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wb.internal.core.editor.palette.model.entry.AttributesProvider;
import org.eclipse.wb.internal.core.editor.palette.model.entry.AttributesProviders;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.core.palette.AbstractPaletteTest;
import org.junit.jupiter.api.Test;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AttributesProvidersTest
extends AbstractPaletteTest {
    @Test
    public void test_getIConfigurationElement() throws Exception {
        String POINT_ID = "org.eclipse.wb.tests.testPoint";
        try {
            String contribution = "<testObject attr='someValue'/>";
            TestUtils.addDynamicExtension(POINT_ID, contribution);
            List elements = ExternalFactoriesHelper.getElements((String)POINT_ID, (String)"testObject");
            Assertions.assertThat((List)elements).hasSize(1);
            IConfigurationElement configurationElement = (IConfigurationElement)elements.get(0);
            AttributesProvider provider = AttributesProviders.get((IConfigurationElement)configurationElement);
            AttributesProvidersTest.assertEquals((Object)"someValue", (Object)provider.getAttribute("attr"));
            AttributesProvidersTest.assertNull((Object)provider.getAttribute("noSuchAttribute"));
        }
        finally {
            TestUtils.removeDynamicExtension(POINT_ID);
        }
    }

    @Test
    public void test_getXML() throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(new InputSource(new StringReader("<rootElement attr='someValue'/>")), new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                AttributesProvider provider = AttributesProviders.get((Attributes)attributes);
                AttributesProvidersTest.assertEquals((Object)"someValue", (Object)provider.getAttribute("attr"));
                AttributesProvidersTest.assertNull((Object)provider.getAttribute("noSuchAttribute"));
            }
        });
    }

    @Test
    public void test_getMap() throws Exception {
        Map<String, String> attributes = Map.of("attr", "someValue");
        AttributesProvider provider = AttributesProviders.get(attributes);
        AttributesProvidersTest.assertEquals((Object)"someValue", (Object)provider.getAttribute("attr"));
        AttributesProvidersTest.assertNull((Object)provider.getAttribute("noSuchAttribute"));
    }
}

