/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls.ui;

import org.apache.commons.lang3.function.FailableBiConsumer;
import org.eclipse.swt.widgets.List;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotList;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.nls.ui.PropertiesComposite;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.core.nls.ui.AbstractDialogTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.eclipse.wb.tests.swtbot.designer.bot.UIUtil;
import org.eclipse.wb.tests.utils.SWTBotEditableSource;
import org.junit.jupiter.api.Test;

public class PropertiesCompositeTest
extends AbstractDialogTest {
    @Test
    public void test_noSources() throws Exception {
        String initialSource = this.getTestSource("// filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) {
                SWTBot shell = bot.shell("Externalize strings").bot();
                PropertiesCompositeTest.assertItems(shell, "Properties");
                PropertiesCompositeTest.assertEquals((int)0, (int)shell.list().itemCount());
            }
        });
    }

    @Test
    public void test_possibleSources() throws Exception {
        PropertiesCompositeTest.setFileContentSrc("test/messages.properties", PropertiesCompositeTest.getSourceDQ("#Direct ResourceBundle", "frame.title=My JFrame"));
        PropertiesCompositeTest.setFileContentSrc("test/messages2.properties", PropertiesCompositeTest.getSourceDQ("#Direct ResourceBundle", "frame.name=My name"));
        String initialSource = this.getTestSource("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) {
                SWTBot shell = bot.shell("Externalize strings").bot();
                PropertiesCompositeTest.assertItems(shell, "test.messages", "test.messages2", "Properties");
                shell.tabItem("Properties").activate();
                SWTBotList sourcesList = shell.list();
                PropertiesCompositeTest.assertItems(sourcesList, "test.messages (Direct ResourceBundle usage)", "test.messages2 (Direct ResourceBundle usage)");
            }
        });
    }

    @Test
    public void test_existingSources() throws Exception {
        PropertiesCompositeTest.setFileContentSrc("test/messages.properties", PropertiesCompositeTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        PropertiesCompositeTest.setFileContentSrc("test/messages_it.properties", PropertiesCompositeTest.getSourceDQ("frame.title=My JFrame IT"));
        PropertiesCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\tsetTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) {
                SWTBot shell = bot.shell("Externalize strings").bot();
                PropertiesCompositeTest.assertItems(shell, "test.messages", "Properties");
                shell.tabItem("Properties").activate();
                SWTBotList sourcesList = shell.list();
                PropertiesCompositeTest.assertItems(sourcesList, "test.messages (Direct ResourceBundle usage)");
            }
        });
    }

    @Test
    public void test_properties() throws Exception {
        PropertiesCompositeTest.setFileContentSrc("test/messages.properties", PropertiesCompositeTest.getSourceDQ("#Direct ResourceBundle"));
        String initialSource = this.getTestSource("public class Test extends JFrame {\n\tpublic Test() {\n\t\tsetTitle(\"My JFrame\");\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tgetContentPane().add(button, BorderLayout.NORTH);\n\t\t}\n\t\t{\n\t\t\tJTextField textField = new JTextField();\n\t\t\tgetContentPane().add(textField, BorderLayout.SOUTH);\n\t\t}\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) throws Exception {
                SWTBot shell = bot.shell("Externalize strings").bot();
                PropertiesCompositeTest.assertItems(shell, "test.messages", "Properties");
                shell.tabItem("Properties").activate();
                SWTBotList sourcesList = shell.list();
                SWTBotTree propertiesTree = shell.tree();
                SWTBotButton externalizeButton = shell.button("Externalize");
                PropertiesCompositeTest.assertNotNull((Object)PropertiesCompositeTest.getItem(propertiesTree, "(javax.swing.JFrame)", "title: My JFrame"));
                PropertiesCompositeTest.assertNotNull((Object)PropertiesCompositeTest.getItem(propertiesTree, "(javax.swing.JFrame)", "getContentPane()", "button", "text: New button"));
                PropertiesCompositeTest.assertNull((Object)PropertiesCompositeTest.getItem(propertiesTree, "(javax.swing.JFrame)", "getContentPane()", "textField"));
                SWTBotTreeItem buttonItem = PropertiesCompositeTest.getItem(propertiesTree, "(javax.swing.JFrame)", "getContentPane()", "button");
                SWTBotTreeItem buttonTextItem = PropertiesCompositeTest.getItem(buttonItem, "text: New button");
                PropertiesCompositeTest.assertFalse((boolean)externalizeButton.isEnabled());
                PropertiesCompositeTest.assertTrue((boolean)buttonItem.isGrayed());
                PropertiesCompositeTest.assertFalse((boolean)buttonItem.isChecked());
                PropertiesCompositeTest.assertFalse((boolean)buttonTextItem.isChecked());
                buttonItem.check();
                PropertiesCompositeTest.assertTrue((boolean)buttonItem.isChecked());
                PropertiesCompositeTest.assertTrue((boolean)buttonTextItem.isChecked());
                PropertiesCompositeTest.assertTrue((boolean)externalizeButton.isEnabled());
                PropertiesCompositeTest.assertTrue((boolean)externalizeButton.isEnabled());
                UIThreadRunnable.syncExec(() -> {
                    ((List)sWTBotList.widget).deselectAll();
                    ((List)sWTBotList.widget).notifyListeners(13, null);
                });
                PropertiesCompositeTest.assertFalse((boolean)externalizeButton.isEnabled());
                sourcesList.select(0);
                PropertiesCompositeTest.assertTrue((boolean)externalizeButton.isEnabled());
                shell.button("&Enable all").click();
                PropertiesCompositeTest.assertTrue((boolean)buttonTextItem.isChecked());
                shell.button("D&isable all").click();
                PropertiesCompositeTest.assertFalse((boolean)buttonTextItem.isChecked());
                buttonItem.check();
                shell.button("E&xternalize").click();
                PropertiesCompositeTest.assertNull((Object)PropertiesCompositeTest.getItem(propertiesTree, "(javax.swing.JFrame)", "getContentPane()", "button", "text: New button"));
                PropertiesCompositeTest.assertNull((Object)PropertiesCompositeTest.getItem(propertiesTree, "(javax.swing.JFrame)", "getContentPane()", "button"));
                PropertiesCompositeTest.assertNull((Object)PropertiesCompositeTest.getItem(propertiesTree, "(javax.swing.JFrame)", "getContentPane()"));
                SWTBotEditableSource editableSource = PropertiesCompositeTest.getEditableSource(shell);
                PropertiesCompositeTest.assertEquals((Object)"New button", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "Test.button.text"));
            }
        });
    }

    @Test
    public void test_open_NewSourceDialog() throws Exception {
        String initialSource = this.getTestSource("// filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) throws Exception {
                SWTBot shell = bot.shell("Externalize strings").bot();
                PropertiesCompositeTest.assertItems(shell, "Properties");
                SWTBotList sourcesList = shell.list();
                PropertiesCompositeTest.assertEquals((int)0, (int)sourcesList.itemCount());
                shell.button("&New...").click();
                bot.shell("New source").bot().button("Cancel").click();
            }
        });
    }

    private static SWTBotTreeItem getItem(SWTBotTree tree, String ... pathElements) {
        try {
            return tree.expandNode(pathElements);
        }
        catch (WidgetNotFoundException e) {
            return null;
        }
    }

    private static SWTBotTreeItem getItem(SWTBotTreeItem item, String ... pathElements) {
        try {
            return item.expandNode(pathElements);
        }
        catch (WidgetNotFoundException e) {
            return null;
        }
    }

    private static SWTBotEditableSource getEditableSource(SWTBot shell) throws Exception {
        PropertiesComposite composite = (PropertiesComposite)shell.getFinder().findControls(WidgetOfType.widgetOfType(PropertiesComposite.class)).get(0);
        IEditableSource editableSource = (IEditableSource)UIUtil.syncCall(() -> ReflectionUtils.invokeMethod((Object)composite, (String)"getSelectedSource()", (Object[])new Object[0]));
        return new SWTBotEditableSource(editableSource);
    }
}

