/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.variable.ExposedPropertyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.BorderLayoutInfo;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.junit.jupiter.api.Test;

public class ExposedPropertyTest
extends AbstractVariableTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_object() throws Exception {
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public final class Test extends JFrame {", "  public Test() {", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ExposedPropertyVariableSupport variableSupport = (ExposedPropertyVariableSupport)contentPane.getVariableSupport();
        ExposedPropertyTest.assertEquals((Object)"property", (Object)variableSupport.toString());
        ExposedPropertyTest.assertEquals((Object)"getContentPane()", (Object)variableSupport.getTitle());
        ExposedPropertyTest.assertTrue((boolean)variableSupport.hasExpression(null));
        NodeTarget target22 = ExposedPropertyTest.getNodeBlockTarget((JavaInfo)frame, true, new int[0]);
        ExposedPropertyTest.assertEquals((Object)"getContentPane()", (Object)variableSupport.getReferenceExpression(target22));
        ExposedPropertyTest.assertEquals((Object)"getContentPane().", (Object)variableSupport.getAccessExpression(target22));
        ExposedPropertyTest.assertEquals((Object)"thisContentPane", (Object)variableSupport.getComponentName());
        ExposedPropertyTest.assertFalse((boolean)variableSupport.hasName());
        try {
            variableSupport.getName();
            ExposedPropertyTest.fail();
        }
        catch (IllegalStateException target22) {
            // empty catch block
        }
        try {
            variableSupport.setName("foo");
            ExposedPropertyTest.fail();
        }
        catch (IllegalStateException target22) {
            // empty catch block
        }
        ExposedPropertyTest.assertFalse((boolean)variableSupport.canConvertLocalToField());
        try {
            variableSupport.convertLocalToField();
            ExposedPropertyTest.fail();
        }
        catch (IllegalStateException target22) {
            // empty catch block
        }
        ExposedPropertyTest.assertFalse((boolean)variableSupport.canConvertFieldToLocal());
        try {
            variableSupport.convertFieldToLocal();
            ExposedPropertyTest.fail();
        }
        catch (IllegalStateException target22) {
            // empty catch block
        }
        target22 = variableSupport.getStatementTarget();
        StatementTarget frameTarget = frame.getVariableSupport().getStatementTarget();
        ExposedPropertyTest.assertSame((Object)frameTarget.getBlock(), (Object)target22.getBlock());
        ExposedPropertyTest.assertSame((Object)frameTarget.getStatement(), (Object)target22.getStatement());
        ExposedPropertyTest.assertEquals((Object)frameTarget.isBefore(), (Object)target22.isBefore());
    }

    @Test
    public void test_getChildTarget() throws Exception {
        ContainerInfo frame = this.parseContainer("public final class Test extends JFrame {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        VariableSupport variableSupport = contentPane.getVariableSupport();
        StatementTarget target = variableSupport.getChildTarget();
        ExposedPropertyTest.assertEquals((Object)JavaInfoUtils.getTarget((JavaInfo)frame, null).toString(), (Object)target.toString());
    }

    @Test
    public void test_addButton() throws Exception {
        ContainerInfo frame = this.parseContainer("public final class Test extends JFrame {", "  public Test() {", "    getContentPane().setEnabled(true);", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        BorderLayoutInfo layout = (BorderLayoutInfo)contentPane.getLayout();
        ComponentInfo button = ExposedPropertyTest.createJButton();
        layout.command_CREATE(button, "North");
        this.assertEditor("public final class Test extends JFrame {", "  public Test() {", "    getContentPane().setEnabled(true);", "    {", "      JButton button = new JButton();", "      getContentPane().add(button, BorderLayout.NORTH);", "    }", "  }", "}");
    }

    @Test
    public void test_getStatementTarget_noRelatedNodes() throws Exception {
        ExposedPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private JButton m_button;", "  public MyPanel() {", "    add(getButton());", "  }", "  public JButton getButton() {", "    if (m_button == null) {", "      m_button = new JButton();", "    }", "    return m_button;", "  }", "}"));
        ExposedPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        ComponentInfo button = (ComponentInfo)ExposedPropertyTest.getJavaInfoByName("getButton()");
        StatementTarget target = button.getVariableSupport().getStatementTarget();
        ExposedPropertyTest.assertTarget(target, ExposedPropertyTest.getBlock((JavaInfo)panel, new int[0]), null, true);
    }

    @Test
    public void test_getStatementTarget_hasRelatedStatement() throws Exception {
        ExposedPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private JButton m_button;", "  public MyPanel() {", "    add(getButton());", "  }", "  public JButton getButton() {", "    if (m_button == null) {", "      m_button = new JButton();", "    }", "    return m_button;", "  }", "}"));
        ExposedPropertyTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setEnabled(false);", "    getButton().setBorderPainted(true);", "    getButton().setAutoscrolls(true);", "  }", "  protected void configureButton() {", "  }", "}");
        ComponentInfo button = (ComponentInfo)ExposedPropertyTest.getJavaInfoByName("getButton()");
        StatementTarget target = button.getVariableSupport().getStatementTarget();
        ExposedPropertyTest.assertTarget(target, ExposedPropertyTest.getBlock((JavaInfo)panel, new int[0]), null, true);
    }

    @Test
    public void test_nullComponent() throws Exception {
        ExposedPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public JButton getButton() {", "    return null;", "  }", "}"));
        ExposedPropertyTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ExposedPropertyTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_ignoreDisconnectedComponent() throws Exception {
        ExposedPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private JButton m_button;", "  public JButton getButton() {", "    if (m_button == null) {", "      m_button = new JButton();", "    }", "    return m_button;", "  }", "}"));
        ExposedPropertyTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ExposedPropertyTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_forceDisconnectedComponent() throws Exception {
        ExposedPropertyTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private JButton m_button;", "  public JButton getButton() {", "    if (m_button == null) {", "      m_button = new JButton();", "    }", "    return m_button;", "  }", "}"));
        ExposedPropertyTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ExposedPropertyTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='getButton'>", "      <tag name='exposeDisconnectedComponent' value='true'/>", "    </method>", "  </methods>", "</component>"));
        ExposedPropertyTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ExposedPropertyTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {method: public javax.swing.JButton test.MyPanel.getButton()} {property} {}");
    }
}

