/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.jvm.util;

import io.github.toolfactory.jvm.util.Strings;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class TempFileHolder
implements Closeable {
    private static File mainTemporaryFolder;
    private File file = null;
    boolean isPosix = false;

    public TempFileHolder(String fileName) throws IOException {
        this.file = new File(mainTemporaryFolder.getAbsolutePath() + "/" + fileName);
        if (this.file.exists()) {
            throw new IllegalArgumentException(Strings.compile((String)"Temporary file {} already exists", (Object[])new Object[]{this.file.getAbsolutePath()}));
        }
        this.file.createNewFile();
        try {
            this.isPosix = this.file.toPath().getFileSystem().supportedFileAttributeViews().contains("posix");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public File getFile() {
        return this.file;
    }

    public boolean isPosix() {
        return this.isPosix;
    }

    @Override
    public void close() throws IOException {
        if (this.file != null) {
            boolean deleted = false;
            if (this.isPosix) {
                deleted = this.file.delete();
            }
            if (!deleted) {
                this.file.deleteOnExit();
            }
        }
    }

    static {
        File toDelete = null;
        try {
            toDelete = File.createTempFile("_BW_TEMP_", "_temp");
        }
        catch (IOException exception) {
            throw new RuntimeException("Unable to create temporary folder", exception);
        }
        File tempFolder = toDelete.getParentFile();
        File folder = new File(tempFolder.getAbsolutePath() + "/Burningwave/" + UUID.randomUUID().toString() + "_" + System.currentTimeMillis());
        if (!folder.exists()) {
            folder.mkdirs();
            folder.deleteOnExit();
        }
        toDelete.delete();
        mainTemporaryFolder = folder;
    }
}

