/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.model;

import java.awt.GridLayout;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.GridLayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.jupiter.api.Test;

public class GridLayoutTest
extends AbstractLayoutTest {
    @Test
    public void test_setLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        GridLayoutTest.setLayout(panel, GridLayout.class);
        this.assertEditor("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout(1, 0, 0, 0));\n\t}\n}");
    }

    @Test
    public void test_setColumns() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout(2, 0));\n\t}\n}");
        GridLayoutInfo layout = (GridLayoutInfo)panel.getLayout();
        layout.getPropertyByTitle("columns").setValue((Object)5);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout(0, 5));\n\t}\n}");
    }

    @Test
    public void test_Switching_fromNullLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJLabel label = new JLabel(\"New label\");\n\t\t\tlabel.setBounds(12, 50, 61, 15);\n\t\t\tadd(label);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tbutton.setBounds(229, 82, 85, 27);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJTextField textField = new JTextField();\n\t\t\ttextField.setBounds(85, 45, 140, 25);\n\t\t\tadd(textField);\n\t\t\ttextField.setColumns(10);\n\t\t}\n\t\t{\n\t\t\tJComboBox comboBox = new JComboBox();\n\t\t\tcomboBox.setBounds(85, 12, 134, 27);\n\t\t\tadd(comboBox);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridLayoutTest.setLayout(panel, GridLayout.class);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout(0, 3, 0, 0));\n\t\t{\n\t\t\tJLabel label = new JLabel(\"\");\n\t\t\tadd(label);\n\t\t}\n\t\t{\n\t\t\tJComboBox comboBox = new JComboBox();\n\t\t\tadd(comboBox);\n\t\t}\n\t\t{\n\t\t\tJLabel label = new JLabel(\"\");\n\t\t\tadd(label);\n\t\t}\n\t\t{\n\t\t\tJLabel label = new JLabel(\"New label\");\n\t\t\tadd(label);\n\t\t}\n\t\t{\n\t\t\tJTextField textField = new JTextField();\n\t\t\tadd(textField);\n\t\t\ttextField.setColumns(10);\n\t\t}\n\t\t{\n\t\t\tJLabel label = new JLabel(\"\");\n\t\t\tadd(label);\n\t\t}\n\t\t{\n\t\t\tJLabel label = new JLabel(\"\");\n\t\t\tadd(label);\n\t\t}\n\t\t{\n\t\t\tJLabel label = new JLabel(\"\");\n\t\t\tadd(label);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }
}

