/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.model;

import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gef.AbstractLayoutPolicyTest;
import org.junit.jupiter.api.Test;

public class FlowLayoutGefTest
extends AbstractLayoutPolicyTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setLayout() throws Exception {
        String source = "public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tfinal JButton button = new JButton(\"New button\");\n\t\t\tadd(button, BorderLayout.SOUTH);\n\t\t}\n\t}\n}";
        String source2 = "public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));\n\t\t{\n\t\t\tfinal JButton button = new JButton(\"New button\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}";
        this.check_setLayout(source, "java.awt.FlowLayout", source2, 10, 10);
    }

    @Test
    public void test_setLayout2() throws Exception {
        String source = "public class Test extends JFrame {\n\tpublic Test() {\n\t\t{\n\t\t\tfinal JButton button = new JButton(\"New button\");\n\t\t\tgetContentPane().add(button, BorderLayout.SOUTH);\n\t\t}\n\t}\n}";
        String source2 = "public class Test extends JFrame {\n\tpublic Test() {\n\t\tgetContentPane().setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));\n\t\t{\n\t\t\tfinal JButton button = new JButton(\"New button\");\n\t\t\tgetContentPane().add(button);\n\t\t}\n\t}\n}";
        this.check_setLayout(source, "java.awt.FlowLayout", source2, 10, 50);
    }

    @Test
    public void test_CREATE_onEmpty() throws Exception {
        ContainerInfo panel = this.openContainer("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)panel, 10, 10);
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_beforeExisting() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton(\"Button\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)panel, 10, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_afterExisting() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton(\"Button\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)panel, -10, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton(\"Button\");\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_hasExposed() throws Exception {
        FlowLayoutGefTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {\n\tprotected final JButton m_button;\n\tpublic MyPanel() {\n\t\t{\n\t\t\tm_button = new JButton(\"Button\");\n\t\t\tadd(m_button);\n\t\t}\n\t}\n}"));
        FlowLayoutGefTest.waitForAutoBuild();
        ContainerInfo panel = this.openContainer("// filler filler filler\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t}\n}");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)panel, 10, 10);
        this.canvas.click();
        this.assertEditor("// filler filler filler\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_RTL_onEmpty() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);\n\t}\n}");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)panel, 10, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_RTL_last() throws Exception {
        this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);\n\t\t{\n\t\t\tJButton existing = new JButton(\"Button\");\n\t\t\tadd(existing);\n\t\t}\n\t}\n}");
        ComponentInfo existing = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("existing");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.target(existing).outX(-5).inY(5).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);\n\t\t{\n\t\t\tJButton existing = new JButton(\"Button\");\n\t\t\tadd(existing);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_RTL_beforeExisting() throws Exception {
        this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);\n\t\t{\n\t\t\tJButton existing = new JButton(\"Button\");\n\t\t\tadd(existing);\n\t\t}\n\t}\n}");
        ComponentInfo existing = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("existing");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.target(existing).in(-5, 5).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton existing = new JButton(\"Button\");\n\t\t\tadd(existing);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_RTL_betweenExisting() throws Exception {
        this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);\n\t\t{\n\t\t\tJButton buttonA = new JButton(\"ButtonA\");\n\t\t\tadd(buttonA);\n\t\t}\n\t\t{\n\t\t\tJButton buttonB = new JButton(\"ButtonB\");\n\t\t\tadd(buttonB);\n\t\t}\n\t}\n}");
        ComponentInfo button = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("buttonA");
        this.loadCreationTool("javax.swing.JButton");
        this.canvas.target(button).outX(-5).inY(5).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);\n\t\t{\n\t\t\tJButton buttonA = new JButton(\"ButtonA\");\n\t\t\tadd(buttonA);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton buttonB = new JButton(\"ButtonB\");\n\t\t\tadd(buttonB);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_MOVE_twoComponents() throws Exception {
        String lines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton buttonA = new JButton(\"Button A\");\n\t\t\tadd(buttonA);\n\t\t}\n\t\t{\n\t\t\tJButton buttonB = new JButton(\"Button B\");\n\t\t\tadd(buttonB);\n\t\t}\n\t}\n}";
        this.openContainer(lines);
        ComponentInfo buttonA = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("buttonA");
        ComponentInfo buttonB = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("buttonB");
        this.canvas.select(buttonA, buttonB);
        FlowLayoutGefTest.assertEquals((int)2, (int)this.m_viewerCanvas.getSelectedEditParts().size());
        this.canvas.beginDrag(buttonB, 10, 5);
        this.canvas.dragTo((Object)buttonA, -10, 0);
        this.canvas.endDrag();
        this.assertEditor(lines);
    }

    @Test
    public void test_MOVE_localVariable() throws Exception {
        String source = "public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton(\"Button 1\");\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button 2\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}";
        String source2 = "public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton(\"Button 2\");\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button 1\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}";
        this.check_MOVE(source, source2);
    }

    @Test
    public void test_MOVE_lazy() throws Exception {
        String source = "public class Test extends JPanel {\n\tprivate JButton button_1;\n\tprivate JButton button_2;\n\tpublic Test() {\n\t\tadd(getButton_1());\n\t\tadd(getButton_2());\n\t}\n\tprivate JButton getButton_1() {\n\t\tif (button_1 == null) {\n\t\t\tbutton_1 = new JButton(\"Button 1\");\n\t\t}\n\t\treturn button_1;\n\t}\n\tprivate JButton getButton_2() {\n\t\tif (button_2 == null) {\n\t\t\tbutton_2 = new JButton(\"button 2\");\n\t\t}\n\t\treturn button_2;\n\t}\n}";
        String source2 = "public class Test extends JPanel {\n\tprivate JButton button_1;\n\tprivate JButton button_2;\n\tpublic Test() {\n\t\tadd(getButton_2());\n\t\tadd(getButton_1());\n\t}\n\tprivate JButton getButton_1() {\n\t\tif (button_1 == null) {\n\t\t\tbutton_1 = new JButton(\"Button 1\");\n\t\t}\n\t\treturn button_1;\n\t}\n\tprivate JButton getButton_2() {\n\t\tif (button_2 == null) {\n\t\t\tbutton_2 = new JButton(\"button 2\");\n\t\t}\n\t\treturn button_2;\n\t}\n}";
        this.check_MOVE(source, source2);
    }

    private void check_MOVE(String source, String source2) throws Exception {
        ContainerInfo panel = this.openContainer(source);
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        this.canvas.beginDrag(button_2);
        this.canvas.dragTo((Object)button_2, -10, 0);
        this.canvas.endDrag();
        this.canvas.assertNoFeedbackFigures();
        this.assertEditor(source);
        this.canvas.beginDrag(button_1);
        this.canvas.dragTo((Object)button_2, 10, 0);
        this.canvas.endDrag();
        this.canvas.assertNoFeedbackFigures();
        this.assertEditor(source);
        this.canvas.beginDrag(button_2);
        this.canvas.dragTo((Object)button_1, 10, 0);
        this.canvas.endDrag();
        this.canvas.assertNoFeedbackFigures();
        this.assertEditor(source2);
    }

    @Test
    public void test_ADD() throws Exception {
        this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"Button\");\n\t\t\tadd(button, BorderLayout.NORTH);\n\t\t}\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tpanel.setBackground(Color.PINK);\n\t\t\tpanel.setPreferredSize(new Dimension(0, 150));\n\t\t\tadd(panel, BorderLayout.SOUTH);\n\t\t}\n\t}\n}");
        ComponentInfo button = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("button");
        ComponentInfo inner = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("panel");
        this.canvas.beginDrag(button);
        this.canvas.dragTo((Object)inner, 10, 10);
        this.canvas.endDrag();
        this.canvas.assertFeedbackFigures(0);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tpanel.setBackground(Color.PINK);\n\t\t\tpanel.setPreferredSize(new Dimension(0, 150));\n\t\t\tadd(panel, BorderLayout.SOUTH);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"Button\");\n\t\t\t\tpanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_ADD_twoComponents() throws Exception {
        String lines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton buttonA = new JButton(\"ButtonA\");\n\t\t\tadd(buttonA, BorderLayout.NORTH);\n\t\t}\n\t\t{\n\t\t\tJButton buttonB = new JButton(\"ButtonB\");\n\t\t\tadd(buttonB, BorderLayout.SOUTH);\n\t\t}\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tpanel.setBackground(Color.PINK);\n\t\t\tpanel.setPreferredSize(new Dimension(0, 150));\n\t\t\tadd(panel, BorderLayout.CENTER);\n\t\t}\n\t}\n}";
        this.openContainer(lines);
        ComponentInfo buttonA = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("buttonA");
        ComponentInfo buttonB = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("buttonB");
        ComponentInfo inner = (ComponentInfo)FlowLayoutGefTest.getJavaInfoByName("panel");
        this.canvas.select(buttonA, buttonB);
        FlowLayoutGefTest.assertEquals((int)2, (int)this.m_viewerCanvas.getSelectedEditParts().size());
        this.canvas.beginDrag(buttonB, 10, 5);
        this.canvas.dragTo((Object)inner, 10, 10);
        this.canvas.endDrag();
        this.canvas.assertFeedbackFigures(0);
        this.assertEditor(lines);
    }
}

