/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout;

import java.awt.LayoutManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.SwingToolkitDescription;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractLayoutTest
extends SwingModelTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        AbstractLayoutTest.configureForTest();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        AbstractLayoutTest.configureDefaults();
        super.tearDown();
    }

    public static void configureForTest() {
        IPreferenceStore preferences = SwingToolkitDescription.INSTANCE.getPreferences();
        preferences.setValue("templateLayoutName", "${defaultName}");
    }

    public static void configureDefaults() {
        IPreferenceStore preferences = SwingToolkitDescription.INSTANCE.getPreferences();
        preferences.setToDefault("templateLayoutName");
    }

    protected static void setLayout(ContainerInfo container, Class<? extends LayoutManager> layoutClass) throws Exception {
        LayoutInfo newLayout = (LayoutInfo)JavaInfoUtils.createJavaInfo((AstEditor)container.getEditor(), layoutClass, (CreationSupport)new ConstructorCreationSupport());
        container.setLayout(newLayout);
    }
}

