/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import org.eclipse.wb.internal.rcp.model.widgets.ToolBarInfo;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.junit.jupiter.api.Test;

public class ToolBarGefTest
extends RcpGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_canvas_CREATE_item() throws Exception {
        ToolBarInfo toolBar = (ToolBarInfo)this.openJavaInfo("public class Test extends ToolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        this.loadCreationTool("org.eclipse.swt.widgets.ToolItem");
        this.canvas.moveTo((Object)toolBar, 5, 5);
        this.canvas.click();
        this.assertEditor("public class Test extends ToolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      ToolItem toolItem = new ToolItem(this, SWT.NONE);", "      toolItem.setText('New Item');", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_CREATE_control_good() throws Exception {
        this.openJavaInfo("public class Test extends ToolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      ToolItem item = new ToolItem(this, SWT.SEPARATOR);", "      item.setWidth(100);", "    }", "  }", "}");
        Object item = ToolBarGefTest.getJavaInfoByName("item");
        this.loadButton();
        this.canvas.moveTo(item, 5, 5);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(item));
        this.canvas.assertCommandNotNull();
        this.canvas.click();
        this.assertEditor("public class Test extends ToolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      ToolItem item = new ToolItem(this, SWT.SEPARATOR);", "      item.setWidth(100);", "      {", "        Button button = new Button(this, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_CREATE_control_notSeparator() throws Exception {
        this.openJavaInfo("public class Test extends ToolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      ToolItem item = new ToolItem(this, SWT.NONE);", "    }", "  }", "}");
        Object item = ToolBarGefTest.getJavaInfoByName("item");
        this.loadButton();
        this.canvas.moveTo(item, 5, 5);
        this.canvas.assertNoFeedbacks();
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_canvas_CREATE_control_alreadyHasControl() throws Exception {
        this.openJavaInfo("public class Test extends ToolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      ToolItem item = new ToolItem(this, SWT.SEPARATOR);", "      item.setWidth(100);", "      {", "        Button existing = new Button(this, SWT.NONE);", "        item.setControl(existing);", "      }", "    }", "  }", "}");
        Object item = ToolBarGefTest.getJavaInfoByName("item");
        this.loadButton();
        this.canvas.moveTo(item, 5, 5);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(item));
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_tree_CREATE_item() throws Exception {
        ToolBarInfo toolBar = (ToolBarInfo)this.openJavaInfo("public class Test extends ToolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        this.loadCreationTool("org.eclipse.swt.widgets.ToolItem");
        this.tree.moveOn(toolBar);
        this.tree.click();
        this.assertEditor("public class Test extends ToolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      ToolItem toolItem = new ToolItem(this, SWT.NONE);", "      toolItem.setText('New Item');", "    }", "  }", "}");
    }

    @Test
    public void test_tree_CREATE_control_good() throws Exception {
        this.openJavaInfo("public class Test extends ToolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      ToolItem item = new ToolItem(this, SWT.SEPARATOR);", "      item.setWidth(100);", "    }", "  }", "}");
        Object item = ToolBarGefTest.getJavaInfoByName("item");
        this.loadButton();
        this.tree.moveOn(item);
        this.tree.assertFeedback_on(item);
        this.tree.assertCommandNotNull();
        this.tree.click();
        this.assertEditor("public class Test extends ToolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      ToolItem item = new ToolItem(this, SWT.SEPARATOR);", "      item.setWidth(100);", "      {", "        Button button = new Button(this, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_tree_CREATE_control_notSeparator() throws Exception {
        this.openJavaInfo("public class Test extends ToolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      ToolItem item = new ToolItem(this, SWT.NONE);", "    }", "  }", "}");
        Object item = ToolBarGefTest.getJavaInfoByName("item");
        this.loadButton();
        this.tree.moveOn(item);
        this.tree.assertCommandNull();
    }

    @Test
    public void test_tree_CREATE_control_alreadyHasControl() throws Exception {
        this.openJavaInfo("public class Test extends ToolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      ToolItem item = new ToolItem(this, SWT.SEPARATOR);", "      item.setWidth(100);", "      {", "        Button existing = new Button(this, SWT.NONE);", "        item.setControl(existing);", "      }", "    }", "  }", "}");
        Object item = ToolBarGefTest.getJavaInfoByName("item");
        this.loadButton();
        this.tree.moveOn(item);
        this.tree.assertFeedback_on(item);
        this.tree.assertCommandNull();
    }
}

