/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.palette;

import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.EntryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ComponentEntryInfo;
import org.eclipse.wb.tests.designer.core.palette.AbstractPaletteTest;
import org.junit.jupiter.api.Test;

public class CategoryInfoTest
extends AbstractPaletteTest {
    @Test
    public void test_toString() throws Exception {
        CategoryInfo category = new CategoryInfo();
        category.setId("1");
        category.setName("category 1");
        ComponentEntryInfo component = new ComponentEntryInfo();
        component.setComponentClassName("javax.swing.JButton");
        category.addEntry((EntryInfo)component);
        CategoryInfoTest.assertEquals((Object)"Category(id='1', name='category 1', entries=[Component(class='javax.swing.JButton')])", (Object)category.toString());
    }

    @Test
    public void test_open() throws Exception {
        CategoryInfo category = new CategoryInfo();
        CategoryInfoTest.assertFalse((boolean)category.isOpen());
        category.setOpen(true);
        CategoryInfoTest.assertTrue((boolean)category.isOpen());
    }

    @Test
    public void test_entries() throws Exception {
        CategoryInfo category = new CategoryInfo();
        CategoryInfoTest.assertTrue((boolean)category.getEntries().isEmpty());
        ComponentEntryInfo entry_1 = new ComponentEntryInfo();
        entry_1.setId("1");
        ComponentEntryInfo entry_2 = new ComponentEntryInfo();
        entry_2.setId("2");
        category.addEntry((EntryInfo)entry_1);
        category.addEntry((EntryInfo)entry_2);
        CategoryInfoTest.assertEquals((int)2, (int)category.getEntries().size());
        CategoryInfoTest.assertSame((Object)entry_1, category.getEntries().get(0));
        CategoryInfoTest.assertSame((Object)entry_2, category.getEntries().get(1));
        category.getEntries().clear();
        category.addEntry((EntryInfo)entry_1);
        category.addEntry(0, (EntryInfo)entry_2);
        CategoryInfoTest.assertEquals((int)2, (int)category.getEntries().size());
        CategoryInfoTest.assertSame((Object)entry_2, category.getEntries().get(0));
        CategoryInfoTest.assertSame((Object)entry_1, category.getEntries().get(1));
        category.removeEntry(null);
        CategoryInfoTest.assertEquals((int)2, (int)category.getEntries().size());
        category.removeEntry((EntryInfo)entry_1);
        CategoryInfoTest.assertEquals((int)1, (int)category.getEntries().size());
        CategoryInfoTest.assertSame((Object)entry_2, category.getEntries().get(0));
        category.removeEntry((EntryInfo)entry_2);
        CategoryInfoTest.assertEquals((int)0, (int)category.getEntries().size());
    }

    @Test
    public void test_parse() throws Exception {
        CategoryInfoTest.addPaletteExtension(new String[]{"<category id='id_1' name='name 1' description='description 1'/>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("id_1");
        CategoryInfoTest.assertEquals((Object)"id_1", (Object)category.getId());
        CategoryInfoTest.assertEquals((Object)"name 1", (Object)category.getName());
        CategoryInfoTest.assertEquals((Object)"description 1", (Object)category.getDescription());
        CategoryInfoTest.assertTrue((boolean)category.isVisible());
        CategoryInfoTest.assertTrue((boolean)category.isOpen());
        CategoryInfoTest.assertFalse((boolean)category.isOptional());
    }

    @Test
    public void test_parse_notDefault() throws Exception {
        CategoryInfoTest.addPaletteExtension(new String[]{"<category id='id_1' name='name 1' visible='false' open='false' optional='true'/>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("id_1");
        CategoryInfoTest.assertEquals((Object)"id_1", (Object)category.getId());
        CategoryInfoTest.assertFalse((boolean)category.isVisible());
        CategoryInfoTest.assertFalse((boolean)category.isOpen());
        CategoryInfoTest.assertTrue((boolean)category.isOptional());
    }
}

