/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JToolBar;
import org.apache.commons.lang3.NotImplementedException;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.VoidInvocationCreationSupport;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.model.variable.VoidInvocationVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JToolBarInfo;
import org.eclipse.wb.internal.swing.model.component.JToolBarSeparatorCreationSupport;
import org.eclipse.wb.internal.swing.model.component.JToolBarSeparatorInfo;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.junit.jupiter.api.Test;

public class VoidInvocationTest
extends AbstractVariableTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_object() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    bar.addSeparator();", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        JToolBarSeparatorInfo separator = (JToolBarSeparatorInfo)bar.getChildrenComponents().get(0);
        VoidInvocationVariableSupport variableSupport = (VoidInvocationVariableSupport)separator.getVariableSupport();
        VoidInvocationTest.assertEquals((Object)"void", (Object)variableSupport.toString());
        VoidInvocationTest.assertEquals((Object)"addSeparator()", (Object)variableSupport.getTitle());
        VoidInvocationTest.assertFalse((boolean)variableSupport.isDefault());
        VoidInvocationTest.assertFalse((boolean)variableSupport.hasName());
        try {
            variableSupport.getName();
            VoidInvocationTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        VoidInvocationTest.assertFalse((boolean)variableSupport.canConvertLocalToField());
        VoidInvocationTest.assertFalse((boolean)variableSupport.canConvertFieldToLocal());
        try {
            variableSupport.convertLocalToField();
            VoidInvocationTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.convertFieldToLocal();
            VoidInvocationTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.getReferenceExpression(null);
            VoidInvocationTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.getAccessExpression(null);
            VoidInvocationTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.getStatementTarget();
            VoidInvocationTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void test_noProperties() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    bar.addSeparator(new Dimension(100, 50));", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        JToolBarSeparatorInfo separator = (JToolBarSeparatorInfo)bar.getChildrenComponents().get(0);
        Object[] properties = separator.getProperties();
        Assertions.assertThat((Object[])properties).hasSize(1);
        VoidInvocationTest.assertNotNull((Object)PropertyUtils.getByPath((Property[])properties, (String)"Factory"));
        VoidInvocationTest.assertNotNull((Object)PropertyUtils.getByPath((Property[])properties, (String)"Factory/size"));
    }

    @Test
    public void test_add() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        JToolBarSeparatorCreationSupport creationSupport = new JToolBarSeparatorCreationSupport((JavaInfo)bar);
        JToolBarSeparatorInfo separator = (JToolBarSeparatorInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JToolBar.Separator.class, (CreationSupport)creationSupport);
        bar.command_CREATE(separator, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    bar.addSeparator();", "  }", "}");
        VoidInvocationTest.assertEquals((Object)"addSeparator()", (Object)separator.getVariableSupport().getTitle());
    }

    @Test
    public void test_moveInner() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    {", "      JButton button = new JButton();", "      bar.add(button);", "    }", "    bar.addSeparator();", "  }", "}");
        JToolBarInfo bar = (JToolBarInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)bar.getChildrenComponents().get(0);
        JToolBarSeparatorInfo separator = (JToolBarSeparatorInfo)bar.getChildrenComponents().get(1);
        bar.command_MOVE((ComponentInfo)separator, button);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JToolBar bar = new JToolBar();", "    add(bar);", "    bar.addSeparator();", "    {", "      JButton button = new JButton();", "      bar.add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_parseComponent_hasComponent() throws Exception {
        this.prepare_parseComponent();
        String[] lines = new String[]{"class Test extends JPanel {", "  Test() {", "    MyBar bar = new MyBar();", "    add(bar);", "    //", "    JButton button = new JButton();", "    bar.addItem(button);", "  }", "}"};
        this.parseContainer(lines);
        VoidInvocationTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(bar)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyBar} {local-unique: bar} {/new MyBar()/ /add(bar)/ /bar.addItem(button)/}", "    {void} {void} {/bar.addItem(button)/}", "      {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /bar.addItem(button)/}");
    }

    @Test
    public void test_parseComponent_invalidComponent() throws Exception {
        this.prepare_parseComponent();
        String[] lines = new String[]{"class Test extends JPanel {", "  Test() {", "    MyBar bar = new MyBar();", "    add(bar);", "    //", "    bar.addItem(null);", "  }", "}"};
        this.parseContainer(lines);
        VoidInvocationTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(bar)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyBar} {local-unique: bar} {/new MyBar()/ /add(bar)/ /bar.addItem(null)/}");
    }

    private void prepare_parseComponent() throws Exception {
        VoidInvocationTest.setFileContentSrc("test/MyBar.java", this.getTestSource("public class MyBar extends JPanel {", "  public void addItem(Component content) {", "    JPanel wrapper = new JPanel();", "    add(wrapper);", "    wrapper.add(content);", "  }", "}"));
        VoidInvocationTest.setFileContentSrc("test/MyBar.wbp-component.xml", VoidInvocationTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addItem'>", "      <parameter type='java.awt.Component'>", "        <tag name='voidFactory.requiredJavaInfo' value='true'/>", "      </parameter>", "      <tag name='voidFactory.creationSupport' value='" + Test_CreationSupport.class.getName() + "'/>", "      <tag name='voidFactory.componentClass' value='java.awt.Component'/>", "    </method>", "  </methods>", "  <parameters>", "    <parameter name='layout.has'>false</parameter>", "  </parameters>", "</component>"));
        VoidInvocationTest.waitForAutoBuild();
    }

    public static class Test_CreationSupport
    extends VoidInvocationCreationSupport {
        public Test_CreationSupport(JavaInfo hostJavaInfo, MethodDescription description, MethodInvocation invocation, JavaInfo[] argumentInfos) {
            super(hostJavaInfo, description, invocation);
            VoidInvocationTest.assertNotNull((Object)argumentInfos[0]);
        }

        protected Object getObject(Object toolbar) throws Exception {
            Component[] components = ((Container)toolbar).getComponents();
            return components[components.length - 1];
        }

        protected String add_getMethodSource() throws Exception {
            throw new NotImplementedException();
        }
    }
}

