/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.jdt.core;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.swt.SWT;
import org.eclipse.wb.internal.core.BundleResourceProvider;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.NoOpProgressMonitor;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.IProjectClasspathListener;
import org.eclipse.wb.internal.core.utils.pde.ReflectivePDE;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.osgi.framework.Bundle;

public final class ProjectUtils {
    private ProjectUtils() {
    }

    public static float getJavaVersion(IJavaProject javaProject) {
        String complianceString = ProjectUtils.getJavaVersionString(javaProject);
        return Float.parseFloat(complianceString);
    }

    public static String getJavaVersionString(IJavaProject javaProject) {
        return javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
    }

    public static boolean isAtLeastJDKVersion(IJavaProject project, Float minimumVersion) {
        String complianceString;
        if (project != null && (complianceString = ProjectUtils.getJavaVersionString(project)) != null) {
            float compliance = Float.parseFloat(complianceString);
            return compliance >= minimumVersion.floatValue();
        }
        return false;
    }

    public static Map<String, String> getOptions(IJavaProject project) {
        return project.getOptions(true);
    }

    public static void waitForAutoBuild() {
        boolean success;
        while (!(success = ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                IJobManager jobManager = Job.getJobManager();
                jobManager.wakeUp(ResourcesPlugin.FAMILY_AUTO_BUILD);
                jobManager.wakeUp(ResourcesPlugin.FAMILY_AUTO_BUILD);
                jobManager.wakeUp(ResourcesPlugin.FAMILY_AUTO_BUILD);
                jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NoOpProgressMonitor());
            }
        }))) {
        }
    }

    public static void ensureResourceType(IJavaProject javaProject, Bundle bundle, String typeName) throws Exception {
        String versionString = ProjectUtils.getVersionString(javaProject);
        String path = "/resources/" + versionString + "/" + typeName.replace('.', '/') + ".java";
        String contents = BundleResourceProvider.get((Bundle)bundle).getFileString(path);
        IType type = javaProject.findType(typeName);
        if (type == null) {
            ProjectUtils.createCompilationUnitWithType(javaProject, typeName, contents);
            return;
        }
        ICompilationUnit compilationUnit = type.getCompilationUnit();
        if (compilationUnit == null) {
            return;
        }
        if (!compilationUnit.getSource().equals(contents)) {
            ProjectUtils.updateCompilationUnitWithType(compilationUnit, contents);
        }
    }

    private static String getVersionString(IJavaProject javaProject) {
        return "1.8";
    }

    private static void createCompilationUnitWithType(IJavaProject javaProject, String typeName, String contents) throws Exception {
        String packageName = CodeUtils.getPackage(typeName);
        String unitName = CodeUtils.getShortClass(typeName) + ".java";
        IContainer sourceContainer = CodeUtils.getSourceContainers(javaProject, false).get(0);
        IPackageFragmentRoot packageFragmentRoot = javaProject.getPackageFragmentRoot((IResource)sourceContainer);
        IPackageFragment packageFragment = packageFragmentRoot.createPackageFragment(packageName, true, null);
        ICompilationUnit unit = packageFragment.createCompilationUnit(unitName, contents, true, null);
        ProjectUtils.saveCompilationUnitWithType(unit);
    }

    private static void updateCompilationUnitWithType(ICompilationUnit unit, String contents) throws Exception {
        if (unit.getResource().getResourceAttributes().isReadOnly()) {
            return;
        }
        unit.getBuffer().setContents(contents);
        ProjectUtils.saveCompilationUnitWithType(unit);
    }

    private static void saveCompilationUnitWithType(ICompilationUnit unit) throws Exception {
        unit.getBuffer().save(null, true);
        ProjectUtils.waitForAutoBuild();
    }

    public static boolean hasType(IJavaProject project, String className) {
        return (Boolean)ExecutionUtils.runObjectIgnore(() -> project.findType(className) != null, (Object)false);
    }

    public static void addJar(IJavaProject javaProject, Bundle bundle, String jarPath, String srcPath) throws Exception {
        String jarName = ProjectUtils.copyFile(javaProject, bundle, jarPath);
        String srcName = ProjectUtils.copyFile(javaProject, bundle, srcPath);
        ProjectUtils.addClasspathEntry(javaProject, jarName, srcName);
    }

    public static String copyFile(IJavaProject javaProject, Bundle bundle, String path) throws Exception {
        if (path == null) {
            return null;
        }
        String name = FilenameUtils.getName((String)path);
        IFile file = javaProject.getProject().getFile(name);
        InputStream stream = bundle.getEntry(path).openStream();
        IOUtils2.setFileContents((IFile)file, (InputStream)stream);
        return name;
    }

    public static void addJar(IJavaProject javaProject, String jarPathString, String srcPathString) throws Exception {
        IFile srcFile;
        IProject project = javaProject.getProject();
        String jarFileName = FilenameUtils.getName((String)jarPathString);
        String srcFileName = FilenameUtils.getName((String)srcPathString);
        IFile jarFile = project.getFile(jarFileName);
        if (!jarFile.exists()) {
            FileInputStream jarStream = new FileInputStream(jarPathString);
            IOUtils2.setFileContents((IFile)jarFile, (InputStream)jarStream);
        }
        if (srcPathString != null && !(srcFile = project.getFile(srcFileName)).exists()) {
            FileInputStream srcStream = new FileInputStream(srcPathString);
            IOUtils2.setFileContents((IFile)srcFile, (InputStream)srcStream);
        }
        ProjectUtils.addClasspathEntry(javaProject, jarFileName, srcFileName);
    }

    public static void addExternalJar(IJavaProject javaProject, String jarPathString, String srcPathString) throws Exception {
        Path jarPath = new Path(jarPathString);
        Path srcPath = srcPathString != null ? new Path(srcPathString) : null;
        IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)jarPath, (IPath)srcPath, null);
        ProjectUtils.addClasspathEntry(javaProject, newEntry);
    }

    public static void addClasspathEntry(IJavaProject javaProject, IClasspathEntry entry) throws CoreException {
        Object[] entries = javaProject.getRawClasspath();
        entries = (IClasspathEntry[])ArrayUtils.add((Object[])entries, (Object)entry);
        javaProject.setRawClasspath((IClasspathEntry[])entries, null);
    }

    public static void addClasspathEntry(IJavaProject javaProject, String jarPathString, String srcPathString) throws Exception {
        IProject project = javaProject.getProject();
        IPath jarPath = project.getFullPath().append(jarPathString);
        IPath srcPath = srcPathString != null ? project.getFullPath().append(srcPathString) : null;
        IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)jarPath, (IPath)srcPath, null);
        ProjectUtils.addClasspathEntry(javaProject, entry);
        List listeners = ExternalFactoriesHelper.getElementsInstances(IProjectClasspathListener.class, (String)"org.eclipse.wb.core.projectClasspathListeners", (String)"listener");
        for (IProjectClasspathListener listener : listeners) {
            listener.addClasspathEntry(javaProject, jarPathString, srcPathString);
        }
    }

    public static void addPluginLibraries(IJavaProject javaProject, String pluginId) throws Exception {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        CollectionUtils.addAll(entries, (Object[])javaProject.getRawClasspath());
        ReflectivePDE.addPluginLibraries(pluginId, entries);
        ProjectUtils.setRawClasspath(javaProject, entries);
    }

    public static SortedSet<String> getAllPluginLibraries() {
        TreeSet<String> symbolicNames = new TreeSet<String>();
        symbolicNames.add("org.eclipse.osgi");
        symbolicNames.add("org.eclipse.core.commands");
        symbolicNames.add("org.eclipse.equinox.common");
        symbolicNames.add("org.eclipse.equinox.registry");
        symbolicNames.add("org.eclipse.core.runtime");
        symbolicNames.add("org.eclipse.text");
        symbolicNames.add("org.eclipse.jface");
        symbolicNames.add("org.eclipse.jface.text");
        symbolicNames.add("org.eclipse.ui.workbench");
        symbolicNames.add("com.ibm.icu");
        symbolicNames.add("org.eclipse.ui.forms");
        String pluginId = "org.eclipse.swt." + SWT.getPlatform() + "." + Platform.getOS();
        boolean isMacCocoa64 = EnvironmentUtils.IS_MAC;
        if (isMacCocoa64 || !EnvironmentUtils.IS_MAC) {
            pluginId = pluginId + "." + Platform.getOSArch();
        }
        symbolicNames.add(pluginId);
        symbolicNames.add("jakarta.annotation-api");
        symbolicNames.add("org.eclipse.e4.ui.di");
        return symbolicNames;
    }

    public static void requireProject(IJavaProject project, IJavaProject requiredProject) throws JavaModelException {
        Object[] rawClasspath = project.getRawClasspath();
        rawClasspath = (IClasspathEntry[])ArrayUtils.add((Object[])rawClasspath, (Object)JavaCore.newProjectEntry((IPath)requiredProject.getPath()));
        project.setRawClasspath((IClasspathEntry[])rawClasspath, null);
    }

    public static void requireModuleAttribute(IJavaProject javaProject) throws CoreException {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        IClasspathAttribute moduleAttribute = JavaCore.newClasspathAttribute((String)"module", (String)"true");
        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (1 == entry.getEntryKind() && ClasspathEntry.getExtraAttribute((IClasspathEntry)entry, (String)"module") == null) {
                IClasspathAttribute[] extraAttributes = (IClasspathAttribute[])ReflectionUtils.getFieldObject((Object)entry, (String)"extraAttributes");
                if (extraAttributes == null) {
                    extraAttributes = new IClasspathAttribute[]{moduleAttribute};
                } else {
                    extraAttributes = Arrays.copyOf(extraAttributes, extraAttributes.length + 1);
                    extraAttributes[extraAttributes.length - 1] = moduleAttribute;
                }
                ReflectionUtils.setField((Object)entry, (String)"extraAttributes", (Object)extraAttributes);
            }
            entries.add(entry);
            ++n2;
        }
        ProjectUtils.setRawClasspath(javaProject, entries);
    }

    public static void removeClasspathEntries(IJavaProject javaProject, Predicate<IClasspathEntry> predicate) throws CoreException {
        IClasspathEntry[] existingEntries;
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = existingEntries = javaProject.getRawClasspath();
        int n = existingEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (!predicate.test(entry)) {
                newEntries.add(entry);
            }
            ++n2;
        }
        ProjectUtils.setRawClasspath(javaProject, newEntries);
    }

    private static void setRawClasspath(IJavaProject javaProject, List<IClasspathEntry> entries) throws JavaModelException {
        javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), null);
    }

    public static boolean hasNature(IProject project, String natureId) {
        return (Boolean)ExecutionUtils.runObjectIgnore(() -> project.hasNature(natureId), (Object)false);
    }

    public static void addNature(IProject project, String natureId) throws Exception {
        IProjectDescription description = project.getDescription();
        ArrayList<String> natureIds = new ArrayList<String>();
        CollectionUtils.addAll(natureIds, (Object[])description.getNatureIds());
        natureIds.add(natureId);
        description.setNatureIds(natureIds.toArray(new String[natureIds.size()]));
        project.setDescription(description, null);
    }

    public static void removeNature(IProject project, String natureId) throws Exception {
        IProjectDescription description = project.getDescription();
        ArrayList natureIds = new ArrayList();
        CollectionUtils.addAll(natureIds, (Object[])description.getNatureIds());
        natureIds.remove(natureId);
        description.setNatureIds(natureIds.toArray(new String[natureIds.size()]));
        project.setDescription(description, null);
    }

    public static IPath getOSPath(IPath path) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = workspaceRoot.findMember(path);
        return resource != null ? resource.getLocation() : null;
    }

    public static List<IFile> findFiles(IJavaProject javaProject, String filePath) throws Exception {
        ArrayList<IFile> files = new ArrayList<IFile>();
        ProjectUtils.findFiles(files, javaProject, filePath, new HashSet<IJavaProject>());
        return files;
    }

    private static void findFiles(List<IFile> files, IJavaProject javaProject, String filePath, Set<IJavaProject> visitedProjects) throws Exception {
        if (!javaProject.exists()) {
            return;
        }
        if (visitedProjects.contains(javaProject)) {
            return;
        }
        visitedProjects.add(javaProject);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String[] stringArray = javaProject.getRequiredProjectNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            IJavaProject requiredJavaProject = JavaCore.create((IProject)workspaceRoot.getProject(projectName));
            ProjectUtils.findFiles(files, requiredJavaProject, filePath, visitedProjects);
            ++n2;
        }
        IProject project = javaProject.getProject();
        IFile file = project.getFile((IPath)new Path(filePath));
        if (file.exists()) {
            files.add(file);
        }
    }
}

