/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.preferences.code;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wb.internal.core.model.description.ToolkitDescriptionJava;
import org.eclipse.wb.internal.core.model.generation.GenerationDescription;
import org.eclipse.wb.internal.core.model.generation.GenerationPropertiesComposite;
import org.eclipse.wb.internal.core.model.generation.GenerationSettings;
import org.eclipse.wb.internal.core.model.generation.preview.GenerationPreview;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.variable.description.VariableSupportDescription;
import org.eclipse.wb.internal.core.preferences.Messages;
import org.eclipse.wb.internal.core.preferences.code.GenerationDescriptionEditor;
import org.eclipse.wb.internal.core.utils.binding.DataBindManager;
import org.eclipse.wb.internal.core.utils.binding.IDataEditor;
import org.eclipse.wb.internal.core.utils.binding.IDataProvider;
import org.eclipse.wb.internal.core.utils.binding.editors.controls.CheckButtonEditor;
import org.eclipse.wb.internal.core.utils.binding.editors.controls.ComboTextEditor;
import org.eclipse.wb.internal.core.utils.binding.providers.BooleanPreferenceProvider;
import org.eclipse.wb.internal.core.utils.binding.providers.StringPreferenceProvider;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.jdt.ui.JdtUiUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public abstract class CodeGenerationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final DataBindManager m_bindManager = new DataBindManager();
    private final GenerationSettings m_settings;
    private final IPreferenceStore m_preferences;
    private TabFolder m_variablesTabFolder;
    private TabFolder m_statementsTabFolder;
    private StatementGeneratorDescription[] m_currentStatementDescriptions;
    private SourceViewer m_previewViewer;
    private final Listener m_descriptionPropertiesListener = new Listener(){

        public void handleEvent(Event event) {
            CodeGenerationPreferencePage.this.m_descriptionPropertiesRunnable.run();
        }
    };
    private final Runnable m_descriptionPropertiesRunnable = new Runnable(){

        @Override
        public void run() {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CodeGenerationPreferencePage.this.updatePreview();
                }
            });
        }
    };
    private final Map<GenerationDescription, Composite> m_descriptionComposites = new HashMap<GenerationDescription, Composite>();
    private final Map<GenerationDescription, GenerationPropertiesComposite> m_descriptionPropertyComposites = new HashMap<GenerationDescription, GenerationPropertiesComposite>();

    public CodeGenerationPreferencePage(ToolkitDescriptionJava toolkit) {
        this.m_settings = toolkit.getGenerationSettings();
        this.m_preferences = toolkit.getPreferences();
    }

    protected Control createContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        GridLayoutFactory.create((Composite)contents).noMargins();
        Button deduceSettingsButton = new Button(contents, 32);
        deduceSettingsButton.setText(Messages.CodeGenerationPreferencePage_deduceFlag);
        this.m_bindManager.bind((IDataEditor)new CheckButtonEditor(deduceSettingsButton), (IDataProvider)new BooleanPreferenceProvider(this.m_preferences, "codeGeneration.deduceSettings"), true);
        Composite composite = new Composite(contents, 0);
        GridDataFactory.create((Control)composite).grabH().fill();
        GridLayoutFactory.create((Composite)composite).columns(2).noMargins();
        new Label(composite, 0).setText(Messages.CodeGenerationPreferencePage_forcedMethod);
        Combo methodCombo = new Combo(composite, 2048);
        methodCombo.setItems(this.getMethodForCombo());
        this.m_bindManager.bind((IDataEditor)new ComboTextEditor(methodCombo), (IDataProvider)new StringPreferenceProvider(this.m_preferences, "codeGeneration.forcedMethod"), true);
        this.createDefaultsComposite(contents);
        return contents;
    }

    protected String[] getMethodForCombo() {
        return new String[]{"createContents", "initialize", "jbInit", "initComponents", "initGUI"};
    }

    private void createDefaultsComposite(Composite parent) {
        Group container = new Group(parent, 0);
        GridDataFactory.create((Control)container).grab().fill();
        GridLayoutFactory.create((Composite)container).columns(2).equalColumns().noMargins();
        container.setText(Messages.CodeGenerationPreferencePage_defaultGroup);
        this.createVariableComposite((Composite)container);
        this.createStatementComposite((Composite)container);
        this.m_bindManager.bind((IDataEditor)new GenerationDescriptionEditor(this.m_variablesTabFolder), new IDataProvider(){

            public void setValue(Object value) {
                CodeGenerationPreferencePage.this.m_settings.setVariable((VariableSupportDescription)value);
            }

            public Object getValue(boolean def) {
                return def ? CodeGenerationPreferencePage.this.m_settings.getDefaultVariable() : CodeGenerationPreferencePage.this.m_settings.getVariable();
            }
        }, true);
        this.showCompatibleStatements();
        this.m_bindManager.bind((IDataEditor)new GenerationDescriptionEditor(this.m_statementsTabFolder), new IDataProvider(){

            public void setValue(Object value) {
                CodeGenerationPreferencePage.this.m_settings.setStatement((StatementGeneratorDescription)value);
            }

            public Object getValue(boolean def) {
                return def ? CodeGenerationPreferencePage.this.m_settings.getDefaultStatement() : CodeGenerationPreferencePage.this.m_settings.getStatement();
            }
        }, true);
        this.createPreviewComposite(container);
    }

    private void createVariableComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.create((Control)container).grabH().fill();
        GridLayoutFactory.create((Composite)container);
        new Label(container, 0).setText(Messages.CodeGenerationPreferencePage_variableLabel);
        this.m_variablesTabFolder = new TabFolder(container, 0);
        GridDataFactory.create((Control)this.m_variablesTabFolder).grab().fill();
        VariableSupportDescription[] variableSupportDescriptionArray = this.m_settings.getVariables();
        int n = variableSupportDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableSupportDescription description = variableSupportDescriptionArray[n2];
            TabItem tabItem = new TabItem(this.m_variablesTabFolder, 0);
            tabItem.setText(description.getName());
            tabItem.setData((Object)description);
            Composite composite = this.getDescriptionComposite(description, (Composite)this.m_variablesTabFolder);
            tabItem.setControl((Control)composite);
            ++n2;
        }
        Label hintLabel = new Label(container, 64);
        GridDataFactory.create((Control)hintLabel).hintHC(50);
        hintLabel.setText(Messages.CodeGenerationPreferencePage_hintVariableSelectingTab);
        this.m_variablesTabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CodeGenerationPreferencePage.this.showCompatibleStatements();
            }
        });
    }

    private VariableSupportDescription getSelectedVariable() {
        TabItem tabItem = this.m_variablesTabFolder.getSelection()[0];
        return (VariableSupportDescription)tabItem.getData();
    }

    private void createStatementComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.create((Control)container).grabH().fill();
        GridLayoutFactory.create((Composite)container);
        new Label(container, 0).setText(Messages.CodeGenerationPreferencePage_statementLabel);
        this.m_statementsTabFolder = new TabFolder(container, 0);
        GridDataFactory.create((Control)this.m_statementsTabFolder).grab().fill().hintVC(8);
        Label hintLabel = new Label(container, 64);
        GridDataFactory.create((Control)hintLabel).hintHC(50);
        hintLabel.setText(Messages.CodeGenerationPreferencePage_hintStatementSelectingTab);
    }

    private void showCompatibleStatements() {
        VariableSupportDescription variableDescription = this.getSelectedVariable();
        Object[] newStatements = this.m_settings.getStatements(variableDescription);
        if (Arrays.equals(this.m_currentStatementDescriptions, newStatements)) {
            return;
        }
        this.m_currentStatementDescriptions = newStatements;
        Object[] objectArray = this.m_statementsTabFolder.getItems();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem tabItem = objectArray[n2];
            tabItem.getControl().setSize(0, 0);
            tabItem.dispose();
            ++n2;
        }
        objectArray = newStatements;
        n = newStatements.length;
        n2 = 0;
        while (n2 < n) {
            TabItem description = objectArray[n2];
            TabItem tabItem = new TabItem(this.m_statementsTabFolder, 0);
            tabItem.setText(description.getName());
            tabItem.setData((Object)description);
            Composite composite = this.getDescriptionComposite((GenerationDescription)description, (Composite)this.m_statementsTabFolder);
            tabItem.setControl((Control)composite);
            ++n2;
        }
        this.updatePreview();
    }

    private StatementGeneratorDescription getSelectedStatement() {
        return (StatementGeneratorDescription)this.m_statementsTabFolder.getSelection()[0].getData();
    }

    private void createPreviewComposite(Group container) {
        Composite previewComposite = new Composite((Composite)container, 0);
        GridDataFactory.create((Control)previewComposite).spanH(2).grab().fill();
        GridLayoutFactory.create((Composite)previewComposite);
        new Label(previewComposite, 0).setText(Messages.CodeGenerationPreferencePage_previewLabel);
        this.m_previewViewer = JdtUiUtils.createJavaSourceViewer(previewComposite, 2560);
        GridDataFactory.create((Control)this.m_previewViewer.getControl()).hintVC(16).grab().fill();
        this.m_variablesTabFolder.addListener(13, this.m_descriptionPropertiesListener);
        this.m_statementsTabFolder.addListener(13, this.m_descriptionPropertiesListener);
        this.updatePreview();
    }

    private void updatePreview() {
        if (this.m_previewViewer == null) {
            return;
        }
        ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                VariableSupportDescription variableDescription = CodeGenerationPreferencePage.this.getSelectedVariable();
                StatementGeneratorDescription statementDescription = CodeGenerationPreferencePage.this.getSelectedStatement();
                GenerationPropertiesComposite variableComposite = CodeGenerationPreferencePage.this.getDescriptionPropertiesComposite(variableDescription);
                GenerationPropertiesComposite statementComposite = CodeGenerationPreferencePage.this.getDescriptionPropertiesComposite(statementDescription);
                GenerationPreview preview = CodeGenerationPreferencePage.this.m_settings.getPreview(variableDescription, statementDescription);
                if (preview != null) {
                    JdtUiUtils.setJavaSourceForViewer(CodeGenerationPreferencePage.this.m_previewViewer, preview.getPreview(variableComposite, statementComposite));
                } else {
                    JdtUiUtils.setJavaSourceForViewer(CodeGenerationPreferencePage.this.m_previewViewer, Messages.CodeGenerationPreferencePage_noPreviewMessage);
                }
            }
        });
    }

    private Composite getDescriptionComposite(GenerationDescription description, Composite parent) {
        Composite wrapper = this.m_descriptionComposites.get(description);
        if (wrapper == null) {
            wrapper = new Composite(parent, 0);
            GridLayoutFactory.create((Composite)wrapper);
            Label descriptionLabel = new Label(wrapper, 64);
            GridDataFactory.create((Control)descriptionLabel).grabH().fillH().hintHC(50);
            descriptionLabel.setText(MessageFormat.format(Messages.CodeGenerationPreferencePage_descriptionLabel, description.getDescription()));
            GenerationPropertiesComposite composite = description.createPropertiesComposite(wrapper, this.m_bindManager, this.m_preferences);
            GridDataFactory.create((Control)composite).grab().fill();
            this.m_descriptionPropertyComposites.put(description, composite);
            composite.addUpdateListener(this.m_descriptionPropertiesRunnable);
            this.m_descriptionComposites.put(description, wrapper);
        }
        return wrapper;
    }

    private GenerationPropertiesComposite getDescriptionPropertiesComposite(GenerationDescription description) {
        GenerationPropertiesComposite composite = this.m_descriptionPropertyComposites.get(description);
        Assert.isNotNull((Object)((Object)composite));
        return composite;
    }

    public boolean performOk() {
        this.m_bindManager.performCommit();
        return super.performOk();
    }

    protected void performDefaults() {
        this.m_bindManager.performDefault();
        this.showCompatibleStatements();
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }
}

