/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.databinding.rcp.model.beans;

import java.util.List;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.rcp.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.rcp.databinding.model.BindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.BeansObserveTypeContainer;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.BeanPropertyDescriptorBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.CollectionPropertyBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.FieldBeanBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.MethodBeanBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.ViewerObservablePropertyBindableInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.databinding.rcp.model.AbstractBindingTest;
import org.junit.Test;

public class BeanBindableTest
extends AbstractBindingTest {
    @Test
    public void test_fields_methods() throws Exception {
        CompositeInfo shell = this.parseComposite("import java.io.File;", "public class Test {", "  protected Shell m_shell;", "  private String m_name;", "  private File m_file;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}");
        BeanBindableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        BeanBindableTest.assertInstanceOf(BeansObserveTypeContainer.class, provider.getContainers().get(0));
        List observes = provider.getObserves(ObserveType.BEANS);
        BeanBindableTest.assertNotNull((Object)observes);
        BeanBindableTest.assertEquals((long)4L, (long)observes.size());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_shell - Shell|m_shell|org.eclipse.swt.widgets.Shell", observes.get(0));
        BeanBindableTest.assertSame((Object)shell.getPresentation().getIcon(), (Object)((IObserveInfo)observes.get(0)).getPresentation().getImageDescriptor());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_name - String|m_name|java.lang.String", observes.get(1));
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_file - File|m_file|java.io.File", observes.get(2));
        BeanBindableTest.assertBindable(MethodBeanBindableInfo.class, "getClass()|getClass()|java.lang.Class", observes.get(3));
    }

    @Test
    public void test_children_properties() throws Exception {
        CompositeInfo shell = this.parseComposite("import java.util.ArrayList;", "public class Test {", "  protected Shell m_shell;", "  private String m_name;", "  private ArrayList m_list;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}");
        BeanBindableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        BeanBindableTest.assertInstanceOf(BeansObserveTypeContainer.class, provider.getContainers().get(0));
        List observes = provider.getObserves(ObserveType.BEANS);
        BeanBindableTest.assertNotNull((Object)observes);
        BeanBindableTest.assertEquals((long)4L, (long)observes.size());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_name - String|m_name|java.lang.String", observes.get(1));
        List nameChildren = ((IObserveInfo)observes.get(1)).getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        BeanBindableTest.assertEquals((long)1L, (long)nameChildren.size());
        BeanBindableTest.assertBindable(MethodBeanBindableInfo.class, observes.get(1), true, "m_name.getClass()|m_name.getClass()|java.lang.Class", nameChildren.get(0));
        List nameProperties = ((IObserveInfo)observes.get(1)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        BeanBindableTest.assertEquals((long)4L, (long)nameProperties.size());
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, false, "blank|\"blank\"|boolean", nameProperties.get(0));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "bytes|\"bytes\"|[B", nameProperties.get(1));
        List bytesProperties = ((IObserveInfo)nameProperties.get(1)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        BeanBindableTest.assertEquals((long)1L, (long)bytesProperties.size());
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, nameProperties.get(1), true, "class|\"bytes.class\"|java.lang.Class", bytesProperties.get(0));
        FieldBeanBindableInfo nameField = (FieldBeanBindableInfo)observes.get(1);
        BeanBindableTest.assertNull((Object)nameField.resolvePropertyReference("bytez"));
        BeanBindableTest.assertSame(nameProperties.get(1), (Object)nameField.resolvePropertyReference("\"bytes\""));
        BeanBindableTest.assertSame(bytesProperties.get(0), (Object)nameField.resolvePropertyReference("\"bytes.class\""));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "class|\"class\"|java.lang.Class", nameProperties.get(2));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, false, "empty|\"empty\"|boolean", nameProperties.get(3));
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_list - ArrayList|m_list|java.util.ArrayList", observes.get(2));
        List listChildren = ((IObserveInfo)observes.get(2)).getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        BeanBindableTest.assertEquals((long)1L, (long)listChildren.size());
        BeanBindableTest.assertBindable(MethodBeanBindableInfo.class, observes.get(2), true, "m_list.getClass()|m_list.getClass()|java.lang.Class", listChildren.get(0));
        List listProperties = ((IObserveInfo)observes.get(2)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        if (Runtime.version().feature() >= 21) {
            BeanBindableTest.assertEquals((long)5L, (long)listProperties.size());
        } else {
            BeanBindableTest.assertEquals((long)3L, (long)listProperties.size());
        }
        BeanBindableTest.assertBindable(CollectionPropertyBindableInfo.class, null, false, "Collection as WritableList/Properties.selfList()|m_list|java.util.ArrayList", listProperties.get(0));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "class|\"class\"|java.lang.Class", listProperties.get(1));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, false, "empty|\"empty\"|boolean", listProperties.get(2));
        if (Runtime.version().feature() >= 21) {
            BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "first|\"first\"|java.lang.Object", listProperties.get(3));
            BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "last|\"last\"|java.lang.Object", listProperties.get(4));
        }
    }

    @Test
    public void test_superClass_thisMethods() throws Exception {
        BeanBindableTest.setFileContentSrc("test/TestSuper.java", BeanBindableTest.getSourceDQ("package test;", "public class TestSuper {", "  public String getBean() {", "    return null;", "  }", "}"));
        BeanBindableTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("import java.io.File;", "public class Test extends TestSuper {", "  protected Shell m_shell;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "  public String getName() {", "    return null;", "  }", "}");
        BeanBindableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        BeanBindableTest.assertInstanceOf(BeansObserveTypeContainer.class, provider.getContainers().get(0));
        List observes = provider.getObserves(ObserveType.BEANS);
        BeanBindableTest.assertNotNull((Object)observes);
        BeanBindableTest.assertEquals((long)4L, (long)observes.size());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_shell - Shell|m_shell|org.eclipse.swt.widgets.Shell", observes.get(0));
        BeanBindableTest.assertBindable(MethodBeanBindableInfo.class, "getBean()|getBean()|java.lang.String", observes.get(1));
        BeanBindableTest.assertBindable(MethodBeanBindableInfo.class, "getClass()|getClass()|java.lang.Class", observes.get(2));
        BeanBindableTest.assertBindable(MethodBeanBindableInfo.class, "getName()|getName()|java.lang.String", observes.get(3));
    }

    @Test
    public void test_viewer() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  protected Shell m_shell;", "  private ISelectionProvider m_selection;", "  private ICheckable m_checkable;", "  public static void main(String[] args) {", "    Test test = new Test();", "    test.open();", "  }", "  public void open() {", "    Display display = new Display();", "    createContents();", "    m_shell.open();", "    m_shell.layout();", "    while (!m_shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "  protected void createContents() {", "    m_shell = new Shell();", "  }", "}");
        BeanBindableTest.assertNotNull((Object)shell);
        DatabindingsProvider provider = this.getDatabindingsProvider();
        BeanBindableTest.assertInstanceOf(BeansObserveTypeContainer.class, provider.getContainers().get(0));
        List observes = provider.getObserves(ObserveType.BEANS);
        BeanBindableTest.assertNotNull((Object)observes);
        BeanBindableTest.assertEquals((long)4L, (long)observes.size());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_shell - Shell|m_shell|org.eclipse.swt.widgets.Shell", observes.get(0));
        BeanBindableTest.assertSame((Object)shell.getPresentation().getIcon(), (Object)((IObserveInfo)observes.get(0)).getPresentation().getImageDescriptor());
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_selection - ISelectionProvider|m_selection|org.eclipse.jface.viewers.ISelectionProvider", observes.get(1));
        BeanBindableTest.assertBindable(FieldBeanBindableInfo.class, "m_checkable - ICheckable|m_checkable|org.eclipse.jface.viewers.ICheckable", observes.get(2));
        BeanBindableTest.assertBindable(MethodBeanBindableInfo.class, "getClass()|getClass()|java.lang.Class", observes.get(3));
        List selectionProperties = ((IObserveInfo)observes.get(1)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        BeanBindableTest.assertEquals((long)4L, (long)selectionProperties.size());
        BeanBindableTest.assertBindable(ViewerObservablePropertyBindableInfo.class, null, false, "single selection|observeSingleSelection|java.lang.Object", selectionProperties.get(0));
        BeanBindableTest.assertBindable(ViewerObservablePropertyBindableInfo.class, null, false, "part of selection|observeSingleSelection|java.lang.Object", selectionProperties.get(1));
        BeanBindableTest.assertBindable(ViewerObservablePropertyBindableInfo.class, null, false, "multi selection|observeMultiSelection|java.lang.Object", selectionProperties.get(2));
        BeanBindableTest.assertBindable(BeanPropertyDescriptorBindableInfo.class, null, true, "selection|\"selection\"|org.eclipse.jface.viewers.ISelection", selectionProperties.get(3));
        List checkableProperties = ((IObserveInfo)observes.get(2)).getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable);
        BeanBindableTest.assertEquals((long)1L, (long)checkableProperties.size());
        BeanBindableTest.assertBindable(ViewerObservablePropertyBindableInfo.class, null, false, "checked elements|observeCheckedElements|java.lang.Object", checkableProperties.get(0));
    }

    public static void assertBindable(Class<?> testClass, String testString, Object object) throws Exception {
        BeanBindableTest.assertBindable(testClass, null, true, testString, object);
    }

    public static void assertBindable(Class<?> testClass, Object testParent, boolean propertiesState, String testString, Object object) throws Exception {
        BeanBindableTest.assertInstanceOf(testClass, object);
        BindableInfo bindable = (BindableInfo)object;
        BeanBindableTest.assertSame((Object)ObserveType.BEANS, (Object)bindable.getType());
        BeanBindableTest.assertNotNull((Object)bindable.getObjectType());
        BeanBindableTest.assertSame((Object)testParent, (Object)bindable.getParent());
        BeanBindableTest.assertEquals((Object)testString, (Object)(bindable.getPresentation().getText() + "|" + bindable.getReference() + "|" + bindable.getObjectType().getName()));
        BeanBindableTest.assertNotNull((Object)bindable.getPresentation());
        BeanBindableTest.assertNotNull((Object)bindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable));
        BeanBindableTest.assertNotNull((Object)bindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable));
        BeanBindableTest.assertEquals((Object)propertiesState, (Object)(!bindable.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).isEmpty() ? 1 : 0));
    }
}

