/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.ast;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.binding.BindingContext;
import org.eclipse.wb.internal.core.utils.ast.binding.DesignerMethodBinding;
import org.eclipse.wb.internal.core.utils.ast.binding.DesignerTypeBinding;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class BindingsTest
extends AbstractJavaTest {
    private static final Object[] NULL_ARG = new Object[1];

    @BeforeClass
    public static void setUpClass() throws Exception {
        BindingsTest.do_projectCreate();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Ignore
    @Test
    public void test_DesignerTypeBinding_1() throws Exception {
        String code = "private java.util.List foo() {return null;}";
        this.check_DesignerTypeBinding(code);
    }

    @Ignore
    @Test
    public void test_DesignerTypeBinding_2() throws Exception {
        String code = "private int foo() {return 0;}";
        this.check_DesignerTypeBinding(code);
    }

    @Ignore
    @Test
    public void test_DesignerTypeBinding_3() throws Exception {
        String code = "private int[] foo() {return null;}";
        this.check_DesignerTypeBinding(code);
    }

    @Ignore
    @Test
    public void test_DesignerTypeBinding_4() throws Exception {
        String code = "class Foo {} private Foo foo() {return null;}";
        this.check_DesignerTypeBinding(code);
    }

    @Test
    public void test_DesignerTypeBinding_getDeclaredMethods() throws Exception {
        this.createTypeDeclaration_TestC(BindingsTest.getSourceDQ("  // filler filler filler filler filler", "  private java.util.List foo() {", "    return null;", "  }"));
        ITypeBinding sourceBinding = this.getNode("java.util.List", Type.class).resolveBinding();
        ITypeBinding ourBinding = this.m_lastEditor.getBindingContext().get(sourceBinding);
        BindingsTest.assertEquals((Object)"java.util.List", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)ourBinding, (boolean)false));
        BindingsTest.assertNotNull((Object)AstNodeUtils.getMethodBySignature((ITypeBinding)ourBinding, (String)"get(int)"));
    }

    @Test
    public void test_DesignerTypeBinding_getTypeBounds() throws Exception {
        this.createTypeDeclaration_TestC(BindingsTest.getSourceDQ("  // filler filler filler filler filler", "  private <T extends java.util.List> T foo() {", "    return null;", "  }"));
        ITypeBinding sourceBinding = this.getNode("T foo()", Type.class).resolveBinding();
        ITypeBinding ourBinding = this.m_lastEditor.getBindingContext().get(sourceBinding);
        BindingsTest.assertEquals((Object)"T", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)ourBinding, (boolean)false));
        BindingsTest.assertEquals((Object)"java.util.List", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)ourBinding.getTypeBounds()[0], (boolean)false));
    }

    @Test
    public void test_DesignerTypeBinding_getTypeDeclaration() throws Exception {
        this.createTypeDeclaration_TestC(BindingsTest.getSourceDQ("  // filler filler filler filler filler", "  // filler filler filler filler filler", "  private void foo() {", "    new java.util.ArrayList<Double>();", "  }"));
        ClassInstanceCreation node = this.getNode("new java.util.ArrayList", ClassInstanceCreation.class);
        ITypeBinding sourceBinding = node.resolveTypeBinding();
        ITypeBinding ourBinding = this.m_lastEditor.getBindingContext().get(sourceBinding);
        BindingsTest.assertEquals((Object)"java.util.ArrayList", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)ourBinding, (boolean)false));
        BindingsTest.assertFalse((boolean)ourBinding.isGenericType());
        Object[] typeArguments = ourBinding.getTypeArguments();
        Assertions.assertThat((Object[])typeArguments).hasSize(1);
        Object typeArgument = typeArguments[0];
        BindingsTest.assertEquals((Object)"java.lang.Double", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)typeArgument, (boolean)false));
        ITypeBinding declarationBinding = ourBinding.getTypeDeclaration();
        BindingsTest.assertEquals((Object)"java.util.ArrayList", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)declarationBinding, (boolean)false));
        BindingsTest.assertTrue((boolean)declarationBinding.isGenericType());
        Object[] typeParameters = declarationBinding.getTypeParameters();
        Assertions.assertThat((Object[])typeParameters).hasSize(1);
        Object typeParameter = typeParameters[0];
        BindingsTest.assertTrue((boolean)typeParameter.isTypeVariable());
        BindingsTest.assertEquals((Object)"E", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)typeParameter, (boolean)false));
        BindingsTest.assertEquals((Object)"java.lang.Object", (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)typeParameter.getTypeBounds()[0], (boolean)false));
    }

    private void check_DesignerTypeBinding(String code) throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(code);
        ITypeBinding originalBinding = typeDeclaration.getMethods()[0].resolveBinding().getReturnType();
        ITypeBinding ourBinding = this.m_lastEditor.getBindingContext().get(originalBinding);
        BindingsTest.assert_sameTypeBindings(originalBinding, ourBinding);
        BindingsTest.assert_methodFails(ourBinding, "isEqualTo", NULL_ARG);
        BindingsTest.assert_methodFails(ourBinding, "isAssignmentCompatible", NULL_ARG);
        BindingsTest.assert_methodFails(ourBinding, "isCastCompatible", NULL_ARG);
        BindingsTest.assert_methodFails(ourBinding, "isSubTypeCompatible", NULL_ARG);
        BindingsTest.assert_methodFails(ourBinding, "createArrayType", 0);
    }

    @Test
    public void test_DesignerTypeBinding_anonymous() throws Exception {
        this.createTypeDeclaration_TestC(BindingsTest.getSourceDQ("  // filler filler filler filler filler", "  private Object field_1 = new Object() { // marker_1", "  };", "  private Object field_2 = new Object() { // marker_2", "  };"));
        ITypeBinding binding_1 = this.getNode("marker_1", ClassInstanceCreation.class).resolveTypeBinding();
        ITypeBinding binding_2 = this.getNode("marker_2", ClassInstanceCreation.class).resolveTypeBinding();
        BindingContext context = new BindingContext();
        ITypeBinding copy_1 = context.get(binding_1);
        ITypeBinding copy_2 = context.get(binding_2);
        BindingsTest.assertNotSame((Object)copy_1, (Object)copy_2);
    }

    @Test
    public void test_DesignerTypeBinding_generics() throws Exception {
        this.createModelType("test", "G.java", BindingsTest.getSourceDQ("package test;", "public class G<N> {", "  private N value;", "  public G(N value){", "    this.value = value;", "  }", "}"));
        BindingsTest.waitForAutoBuild();
        this.createTypeDeclaration_TestC(BindingsTest.getSourceDQ("  // filler filler filler filler filler", "  private G field_0 = new/*marker_0*/ G(new Long(1));", "  private G field_1 = new/*marker_1*/ G<java.lang.Double>(1.5);", "  private G field_2 = new/*marker_2*/ G<java.lang.Integer>(1);", "  private G field_3 = new/*marker_3*/ G<java.util.List<java.lang.String>>(null);"));
        ITypeBinding binding_0 = this.getNode("marker_0", ClassInstanceCreation.class).resolveTypeBinding();
        ITypeBinding binding_1 = this.getNode("marker_1", ClassInstanceCreation.class).resolveTypeBinding();
        ITypeBinding binding_2 = this.getNode("marker_2", ClassInstanceCreation.class).resolveTypeBinding();
        ITypeBinding binding_3 = this.getNode("marker_3", ClassInstanceCreation.class).resolveTypeBinding();
        BindingContext context = new BindingContext();
        ITypeBinding copy_0 = context.get(binding_0, true);
        ITypeBinding copy_1 = context.get(binding_1, true);
        ITypeBinding copy_2 = context.get(binding_2, true);
        ITypeBinding copy_3 = context.get(binding_3, true);
        BindingsTest.assertNotSame((Object)copy_1, (Object)copy_0);
        BindingsTest.assertNotSame((Object)copy_2, (Object)copy_0);
        BindingsTest.assertNotSame((Object)copy_2, (Object)copy_1);
        BindingsTest.assert_TypeBinding_names(copy_0, "test.G", "test.G");
        BindingsTest.assert_TypeBinding_names(copy_1, "test.G", "test.G<java.lang.Double>");
        BindingsTest.assert_TypeBinding_names(copy_2, "test.G", "test.G<java.lang.Integer>");
        BindingsTest.assert_TypeBinding_names(copy_3, "test.G", "test.G<java.util.List<java.lang.String>>");
    }

    private static void assert_TypeBinding_names(ITypeBinding binding, String expectedRaw, String expectedGeneric) {
        String rawName = AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding, (boolean)false, (boolean)false);
        String genericName = AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding, (boolean)false, (boolean)true);
        BindingsTest.assertEquals((Object)expectedRaw, (Object)rawName);
        BindingsTest.assertEquals((Object)expectedGeneric, (Object)genericName);
    }

    @Ignore
    @Test
    public void test_DesignerPackageBinding() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("");
        IPackageBinding originalBinding = typeDeclaration.resolveBinding().getPackage();
        IPackageBinding ourBinding = this.m_lastEditor.getBindingContext().get(originalBinding);
        BindingsTest.assert_sameProperties(IPackageBinding.class, originalBinding, ourBinding, new String[]{"getName", "isUnnamed"});
        BindingsTest.assert_methodFails(ourBinding, "isEqualTo", NULL_ARG);
    }

    @Ignore
    @Test
    public void test_DesignerMethodBinding_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(BindingsTest.getSourceDQ("  private int foo() {", "    return 0;", "  }"));
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        IMethodBinding originalBinding = methodDeclaration.resolveBinding();
        DesignerMethodBinding ourBinding = this.m_lastEditor.getBindingContext().get(originalBinding);
        BindingsTest.assert_sameProperties(IMethodBinding.class, originalBinding, ourBinding, new String[]{"getDeclaringClass", "getName", "getReturnType", "getParameterTypes", "getExceptionTypes", "getMethodDeclaration", "isConstructor", "getModifiers", "getDeclaringMember", "isVarargs"});
        BindingsTest.assert_methodFails(ourBinding, "getParameterAnnotations", 0);
        BindingsTest.assert_methodFails(ourBinding, "isSubsignature", NULL_ARG);
        BindingsTest.assert_methodFails(ourBinding, "overrides", NULL_ARG);
        BindingsTest.assert_methodFails(ourBinding, "isEqualTo", NULL_ARG);
    }

    @Test
    public void test_DesignerMethodBinding_getMethodDeclaration() throws Exception {
        this.createTypeDeclaration_TestC(BindingsTest.getSourceDQ("// filler filler filler filler filler", "  private void root() {", "    System.currentTimeMillis();", "    java.util.Arrays.asList('a', 'b', 'c');", "  }"));
        MethodInvocation invocation = this.getNode("System.", MethodInvocation.class);
        IMethodBinding originalBinding = invocation.resolveMethodBinding();
        DesignerMethodBinding ourBinding = this.m_lastEditor.getBindingContext().get(originalBinding);
        IMethodBinding declarationBinding = ourBinding.getMethodDeclaration();
        BindingsTest.assertSame((Object)ourBinding, (Object)declarationBinding);
        invocation = this.getNode("Arrays.", MethodInvocation.class);
        originalBinding = invocation.resolveMethodBinding();
        ourBinding = this.m_lastEditor.getBindingContext().get(originalBinding);
        declarationBinding = ourBinding.getMethodDeclaration();
        BindingsTest.assertNotSame((Object)ourBinding, (Object)declarationBinding);
        BindingsTest.assertEquals((Object)"asList(T[])", (Object)AstNodeUtils.getMethodSignature((IMethodBinding)declarationBinding));
    }

    @Test
    public void test_DesignerMethodBinding_removeParameterType() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC(BindingsTest.getSourceDQ("  private int foo(int a, float b, double c) {", "    return 0;", "  }"));
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        IMethodBinding originalBinding = methodDeclaration.resolveBinding();
        DesignerMethodBinding ourBinding = this.m_lastEditor.getBindingContext().get(originalBinding);
        BindingsTest.assertEquals((Object)"foo(int,float,double)", (Object)AstNodeUtils.getMethodSignature((IMethodBinding)ourBinding));
        ourBinding.removeParameterType(1);
        BindingsTest.assertEquals((Object)"foo(int,double)", (Object)AstNodeUtils.getMethodSignature((IMethodBinding)ourBinding));
    }

    @Ignore
    @Test
    public void test_DesignerMethodBinding_removeParameterType_whenGenerics() throws Exception {
        this.createTypeDeclaration_TestC(BindingsTest.getSourceDQ("  // filler filler filler filler filler", "  public <T extends java.util.List> void foo(int a, T b, double c) {", "  }", "  void bar() {", "    foo(0, new java.util.ArrayList(), 0.0);", "  }"));
        MethodInvocation invocation = this.getNode("foo(0", MethodInvocation.class);
        IMethodBinding originalBinding = AstNodeUtils.getMethodBinding((MethodInvocation)invocation);
        DesignerMethodBinding ourBinding = this.m_lastEditor.getBindingContext().get(originalBinding);
        BindingsTest.assertEquals((Object)"foo(int,java.util.ArrayList,double)", (Object)AstNodeUtils.getMethodSignature((IMethodBinding)ourBinding));
        BindingsTest.assertEquals((Object)"foo(int,T,double)", (Object)AstNodeUtils.getMethodGenericSignature((IMethodBinding)ourBinding));
        BindingsTest.assertEquals((Object)"foo(int,java.util.List,double)", (Object)AstNodeUtils.getMethodDeclarationSignature((IMethodBinding)ourBinding));
        ourBinding.removeParameterType(1);
        BindingsTest.assertEquals((Object)"foo(int,double)", (Object)AstNodeUtils.getMethodSignature((IMethodBinding)ourBinding));
        BindingsTest.assertEquals((Object)"foo(int,double)", (Object)AstNodeUtils.getMethodGenericSignature((IMethodBinding)ourBinding));
        BindingsTest.assertEquals((Object)"foo(int,double)", (Object)AstNodeUtils.getMethodDeclarationSignature((IMethodBinding)ourBinding));
    }

    @Ignore
    @Test
    public void test_DesignerVariableBinding_1() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("private int m_value;");
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        IVariableBinding originalBinding = ((VariableDeclarationFragment)fieldDeclaration.fragments().get(0)).resolveBinding();
        IVariableBinding ourBinding = this.m_lastEditor.getBindingContext().get(originalBinding);
        BindingsTest.assert_sameProperties(IVariableBinding.class, originalBinding, ourBinding, new String[]{"getName", "getDeclaringClass", "getType", "isField", "getModifiers"});
        BindingsTest.assert_methodFails(ourBinding, "isEqualTo", NULL_ARG);
    }

    @Test
    public void test_DesignerVariableBinding_2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_TestC("private java.util.List m_value;");
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        FieldDeclaration fieldDeclaration = typeDeclaration.getFields()[0];
        ITypeBinding fieldTypeBinding = fieldDeclaration.getType().resolveBinding();
        IVariableBinding ourVariable = this.m_lastEditor.getBindingContext().get("myField", typeBinding, fieldTypeBinding, true, 1);
        BindingsTest.assertEquals((Object)"myField", (Object)ourVariable.getName());
        BindingsTest.assertEquals((Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)fieldTypeBinding, (boolean)false), (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)ourVariable.getType(), (boolean)false));
        BindingsTest.assertEquals((Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)typeBinding, (boolean)false), (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)ourVariable.getDeclaringClass(), (boolean)false));
        BindingsTest.assertEquals((long)1L, (long)ourVariable.getModifiers());
    }

    @Ignore
    @Test
    public void test_getCopy() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test extends javax.swing.JFrame {\n\tpublic Test() {\n\t}\n}");
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((TypeDeclaration)typeDeclaration);
        DesignerTypeBinding typeBinding2 = this.m_lastEditor.getBindingContext().getCopy(typeBinding);
        BindingsTest.assertNotSame((Object)typeBinding, (Object)typeBinding2);
        BindingsTest.assert_sameTypeBindings(typeBinding, (ITypeBinding)typeBinding2);
    }

    private static void assert_sameTypeBindings(ITypeBinding expectedBinding, ITypeBinding actualBinding) throws Exception {
        BindingsTest.assert_sameProperties(ITypeBinding.class, expectedBinding, actualBinding, new String[]{"isPrimitive", "isNullType", "isArray", "getElementType", "getDimensions", "isClass", "isInterface", "isEnum", "getName", "getKey", "getPackage", "getDeclaringClass", "getSuperclass", "getInterfaces", "isTopLevel", "isNested", "isMember", "isLocal", "isAnonymous", "isGenericType", "isParameterizedType", "isTypeVariable", "getTypeArguments", "getTypeDeclaration", "getTypeParameters", "getTypeBounds", "getDeclaredMethods", "getModifiers", "getDeclaredModifiers", "getDeclaringMember", "isIntersectionType"});
    }

    private static void assert_methodFails(Object actualObject, String methodName, Object ... args) throws Exception {
        Method[] allMethods;
        Method[] methodArray = allMethods = actualObject.getClass().getMethods();
        int n = allMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            method.setAccessible(true);
            if (method.getName().equals(methodName)) {
                try {
                    method.invoke(actualObject, args);
                    BindingsTest.fail((String)("Method " + String.valueOf(method) + " should throw exception."));
                }
                catch (InvocationTargetException e) {
                    BindingsTest.assertInstanceOf(IllegalArgumentException.class, (Object)e.getCause());
                }
            }
            ++n2;
        }
    }

    private static void assert_sameProperties(Class<?> clazz, Object expectedObject, Object actualObject, String[] methodNames) throws Exception {
        Method[] allMethods = clazz.getMethods();
        int i = 0;
        while (i < allMethods.length) {
            Method method = allMethods[i];
            if (ArrayUtils.indexOf((Object[])methodNames, (Object)method.getName()) != -1) {
                Object expectedValue = method.invoke(expectedObject, new Object[0]);
                Object actualValue = method.invoke(actualObject, new Object[0]);
                BindingsTest.assert_equals(method, expectedValue, actualValue);
            } else if (method.getParameterTypes().length == 0) {
                BindingsTest.assert_methodFails(actualObject, method.getName(), new Object[0]);
            }
            ++i;
        }
    }

    private static void assert_equals(Method method, Object expectedValue, Object actualValue) {
        String message = "For method " + String.valueOf(method);
        if (expectedValue == null) {
            BindingsTest.assertNull((String)message, (Object)actualValue);
        } else if (expectedValue.getClass().isArray()) {
            BindingsTest.assertTrue((String)message, (boolean)actualValue.getClass().isArray());
            int length = Array.getLength(expectedValue);
            int i = 0;
            while (i < length) {
                Object expectedElement = Array.get(expectedValue, i);
                Object actualElement = Array.get(actualValue, i);
                BindingsTest.assert_equals(method, expectedElement, actualElement);
                ++i;
            }
        } else if (expectedValue instanceof IMethodBinding) {
            BindingsTest.assertEquals((Object)AstNodeUtils.getMethodSignature((IMethodBinding)((IMethodBinding)expectedValue)), (Object)AstNodeUtils.getMethodSignature((IMethodBinding)((IMethodBinding)actualValue)));
        } else if (expectedValue instanceof ITypeBinding) {
            BindingsTest.assertEquals((Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)((ITypeBinding)expectedValue), (boolean)false), (Object)AstNodeUtils.getFullyQualifiedName((ITypeBinding)((ITypeBinding)actualValue), (boolean)false));
        } else if (expectedValue instanceof IPackageBinding) {
            IPackageBinding expectedPackage = (IPackageBinding)expectedValue;
            IPackageBinding actualPackage = (IPackageBinding)actualValue;
            BindingsTest.assertEquals((String)message, (Object)expectedPackage.getName(), (Object)actualPackage.getName());
            BindingsTest.assertEquals((String)message, (Object)expectedPackage.isUnnamed(), (Object)actualPackage.isUnnamed());
        } else {
            BindingsTest.assertEquals((String)message, (Object)expectedValue, (Object)actualValue);
        }
    }
}

