/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.accessor;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ConstructorAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class ConstructorAccessorTest
extends SwingModelTest {
    @Test
    public void test_0() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton('text'));", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)button.getPropertyByTitle("text");
        ConstructorAccessor accessor = (ConstructorAccessor)ConstructorAccessorTest.getGenericPropertyAccessors(property).get(1);
        ConstructorAccessorTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)accessor.getDefaultValue((JavaInfo)button));
        ConstructorAccessorTest.assertEquals((Object)"text", (Object)((StringLiteral)accessor.getExpression((JavaInfo)button)).getLiteralValue());
    }

    @Test
    public void test_setExpression_newValue() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton('text'));", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)button.getPropertyByTitle("text");
        ConstructorAccessor accessor = (ConstructorAccessor)ConstructorAccessorTest.getGenericPropertyAccessors(property).get(1);
        ConstructorAccessorTest.assertTrue((boolean)accessor.setExpression((JavaInfo)button, "\"new text\""));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(new JButton('new text'));", "  }", "}");
    }

    @Test
    public void test_setExpression_nullValue() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton('text'));", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)button.getPropertyByTitle("text");
        ConstructorAccessor accessor = (ConstructorAccessor)ConstructorAccessorTest.getGenericPropertyAccessors(property).get(1);
        ConstructorAccessorTest.assertTrue((boolean)accessor.setExpression((JavaInfo)button, null));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(new JButton((String) null));", "  }", "}");
    }

    @Test
    public void test_setExpression_nullValue_noDefault() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton('text'));", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstructorAccessor accessor = new ConstructorAccessor(0, null);
        ConstructorAccessorTest.assertFalse((boolean)accessor.setExpression((JavaInfo)button, null));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(new JButton('text'));", "  }", "}");
    }

    @Test
    public void test_setExpression_replaceComponent() throws Exception {
        ConstructorAccessorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel(JButton button) {", "  }", "}"));
        ConstructorAccessorTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  private final JButton button_1 = new JButton();", "  private final JButton button_2 = new JButton();", "  private final MyPanel myPanel = new MyPanel(button_1);", "  public Test() {", "    add(button_1);", "    add(button_2);", "    add(myPanel);", "  }", "}");
        ContainerInfo myPanel = (ContainerInfo)ConstructorAccessorTest.getJavaInfoByName("myPanel");
        ComponentInfo button_1 = (ComponentInfo)ConstructorAccessorTest.getJavaInfoByName("button_1");
        ComponentInfo button_2 = (ComponentInfo)ConstructorAccessorTest.getJavaInfoByName("button_2");
        GenericProperty property = (GenericProperty)PropertyUtils.getByPath((ObjectInfo)myPanel, (String)"Constructor/button");
        ConstructorAccessorTest.assertNotNull((Object)property);
        ExpressionAccessor setterAccessor = ConstructorAccessorTest.getGenericPropertyAccessors(property).get(0);
        Expression expression = setterAccessor.getExpression((JavaInfo)myPanel);
        ConstructorAccessorTest.assertTrue((boolean)button_1.isRepresentedBy((ASTNode)expression));
        String source = TemplateUtils.format((String)"{0}", (Object[])new Object[]{button_2});
        setterAccessor.setExpression((JavaInfo)myPanel, source);
        this.assertEditor("public class Test extends JPanel {", "  private final JButton button_1 = new JButton();", "  private final JButton button_2 = new JButton();", "  private final MyPanel myPanel = new MyPanel(button_2);", "  public Test() {", "    add(button_1);", "    add(button_2);", "    add(myPanel);", "  }", "}");
    }
}

