/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.association;

import org.apache.commons.lang3.NotImplementedException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.wb.core.model.association.ImplicitObjectAssociation;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class ImplicitObjectAssociationTest
extends SwingModelTest {
    @Test
    public void test() throws Exception {
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "    getContentPane().add(new JButton());", "  }", "}");
        ComponentInfo contentPane = (ComponentInfo)frame.getChildrenComponents().get(0);
        ImplicitObjectAssociation association = (ImplicitObjectAssociation)contentPane.getAssociation();
        ImplicitObjectAssociationTest.assertSame((Object)contentPane, (Object)association.getJavaInfo());
        ImplicitObjectAssociationTest.assertTrue((boolean)association.canDelete());
        try {
            association.getSource();
            ImplicitObjectAssociationTest.fail();
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        ImplicitObjectAssociationTest.assertNull((Object)association.getStatement());
        try {
            association.move(null);
            ImplicitObjectAssociationTest.fail();
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        try {
            association.setParent(null);
            ImplicitObjectAssociationTest.fail();
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        ImplicitObjectAssociationTest.assertTrue((boolean)contentPane.canDelete());
        contentPane.delete();
        this.assertEditor("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_2() throws Exception {
        ImplicitObjectAssociationTest.setFileContentSrc("test/ComplexPanel.java", this.getTestSource("public class ComplexPanel extends JPanel {", "  private final JButton button = new JButton();", "  public ComplexPanel() {", "    add(button);", "  }", "  public JButton getButton() {", "    return button;", "  }", "}"));
        ImplicitObjectAssociationTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      ComplexPanel complexPanel = new ComplexPanel();", "      add(complexPanel);", "      complexPanel.getButton().setText('text');", "    }", "  }", "}");
        ContainerInfo complexPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo exposedButton = (ComponentInfo)complexPanel.getChildrenComponents().get(0);
        ImplicitObjectAssociation association = (ImplicitObjectAssociation)exposedButton.getAssociation();
        ImplicitObjectAssociationTest.assertEquals((Object)"ComplexPanel complexPanel = new ComplexPanel();", (Object)this.m_lastEditor.getSource((ASTNode)association.getStatement()));
    }
}

