/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.table.editparts;

import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.MouseWheelListener;
import org.eclipse.draw2d.SeparatorBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.property.table.editparts.AbstractPropertyEditPart;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;

public final class PropertyEditPart
extends AbstractPropertyEditPart {
    private final ISelectionChangedListener listener;
    private final PropertyChangeListener propListener;
    private TitleFigure titleFigure;
    private ValueFigure valueFigure;

    public PropertyEditPart(PropertyTable.PropertyInfo propertyInfo) {
        this.setModel(propertyInfo);
        this.listener = event -> this.refreshVisuals();
        this.propListener = event -> {
            if ("splitter".equals(event.getPropertyName())) {
                int width = (Integer)event.getNewValue();
                int height = this.getViewer().getRowHeight();
                this.titleFigure.setPreferredSize(width, height);
            }
        };
    }

    public void addNotify() {
        super.addNotify();
        this.getViewer().addSelectionChangedListener(this.listener);
        this.getViewer().addPropertyChangeListener(this.propListener);
    }

    public void removeNotify() {
        this.getViewer().removePropertyChangeListener(this.propListener);
        this.getViewer().removeSelectionChangedListener(this.listener);
        super.removeNotify();
    }

    public int getTitleX() {
        return 2 + this.getLevelIndent() * this.getModel().getLevel();
    }

    public int getTitleTextX() {
        return this.getTitleX() + this.getLevelIndent();
    }

    private int getLevelIndent() {
        return m_stateWidth + 4;
    }

    public boolean isLocationState(int x) {
        int levelX = this.getTitleX();
        return this.getModel().isComplex() && levelX <= x && x <= levelX + m_stateWidth;
    }

    private Font getBoldFont(Font font) {
        return (Font)this.getViewer().getResourceManager().create((DeviceResourceDescriptor)FontDescriptor.createFrom((Font)font).withStyle(1));
    }

    private Font getItalicFont(Font font) {
        return (Font)this.getViewer().getResourceManager().create((DeviceResourceDescriptor)FontDescriptor.createFrom((Font)font).withStyle(2));
    }

    private MouseMotionListener getMouseMotionListener(final PropertyFigure figureUnderCursor) {
        return new MouseMotionListener.Stub(){

            public void mouseHover(MouseEvent me) {
                Point location = Point.SINGLETON;
                location.setX(me.x);
                location.setY(me.y);
                figureUnderCursor.translateToAbsolute((Translatable)location);
                PropertyEditPart.this.getViewer().getTooltipHelper().displayToolTipNear(figureUnderCursor, location.x, location.y);
            }
        };
    }

    private MouseWheelListener getMouseWheelListener() {
        return event -> this.getViewer().getTooltipHelper().hideTooltip();
    }

    public Property getProperty() {
        return this.getModel().getProperty();
    }

    public PropertyTable.PropertyInfo getModel() {
        return (PropertyTable.PropertyInfo)super.getModel();
    }

    protected IFigure createFigure() {
        SeparatorBorder border = new SeparatorBorder(new Insets(0, 0, 1, 1), 32);
        border.setColor(COLOR_LINE);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.figure = new Figure();
        this.figure.setLayoutManager((LayoutManager)gridLayout);
        this.figure.setBorder((Border)border);
        this.titleFigure = new TitleFigure();
        this.titleFigure.setPreferredSize(new Dimension(this.getViewer().getSplitter(), this.getViewer().getRowHeight()));
        this.titleFigure.setOpaque(true);
        this.titleFigure.addMouseMotionListener(this.getMouseMotionListener(this.titleFigure));
        this.titleFigure.addMouseWheelListener(this.getMouseWheelListener());
        this.figure.add((IFigure)this.titleFigure, (Object)new GridData(4, 4, false, false));
        this.valueFigure = new ValueFigure();
        this.valueFigure.setPreferredSize(new Dimension(-1, this.getViewer().getRowHeight()));
        this.valueFigure.setOpaque(true);
        this.valueFigure.addMouseMotionListener(this.getMouseMotionListener(this.valueFigure));
        this.valueFigure.addMouseWheelListener(this.getMouseWheelListener());
        this.figure.add((IFigure)this.valueFigure, (Object)new GridData(4, 4, true, false));
        PropertyEditorPresentation presentation = this.getModel().getProperty().getEditor().getPresentation();
        if (presentation != null) {
            ++gridLayout.numColumns;
            this.figure.add(presentation.getFigure(this.getViewer(), this.getModel().getProperty()));
        }
        return this.figure;
    }

    protected void refreshVisuals() {
        if (this.isActiveProperty()) {
            this.titleFigure.setBackgroundColor(COLOR_PROPERTY_BG_SELECTED);
            this.valueFigure.setBackgroundColor(COLOR_PROPERTY_BG_SELECTED);
        } else {
            Property property = this.getModel().getProperty();
            try {
                if (property.isModified()) {
                    this.titleFigure.setBackgroundColor(COLOR_PROPERTY_BG_MODIFIED);
                    this.valueFigure.setBackgroundColor(COLOR_PROPERTY_BG_MODIFIED);
                } else {
                    this.titleFigure.setBackgroundColor(COLOR_PROPERTY_BG);
                    this.valueFigure.setBackgroundColor(COLOR_PROPERTY_BG);
                }
            }
            catch (Exception e) {
                DesignerPlugin.log(e);
            }
        }
    }

    private boolean isActiveProperty() {
        return this.getSelected() == 2;
    }

    public abstract sealed class PropertyFigure
    extends Figure
    permits TitleFigure, ValueFigure {
        public Property getProperty() {
            return PropertyEditPart.this.getProperty();
        }

        public PropertyTooltipProvider getPropertyTooltipProvider() {
            IAdaptable adaptable = this.getPropertyToolTipAdaptable();
            if (adaptable == null) {
                return null;
            }
            return (PropertyTooltipProvider)adaptable.getAdapter(PropertyTooltipProvider.class);
        }

        protected abstract IAdaptable getPropertyToolTipAdaptable();

        public String toString() {
            return "[%s] %s".formatted(((Object)((Object)this)).getClass().getSimpleName(), this.getProperty().getTitle());
        }
    }

    public final class TitleFigure
    extends PropertyFigure {
        protected void paintClientArea(Graphics graphics) {
            int height = this.bounds.height();
            int y = this.bounds.y();
            try {
                Property property = this.getProperty();
                if (PropertyEditPart.this.getModel().isShowComplex()) {
                    Image stateImage = PropertyEditPart.this.getModel().isExpanded() ? m_minusImage : m_plusImage;
                    DrawUtils.drawImageCV(graphics, stateImage, PropertyEditPart.this.getTitleX(), y, height);
                }
                graphics.setForegroundColor(COLOR_PROPERTY_FG_TITLE);
                if (PropertyEditPart.this.getViewer().getCategory(property).isAdvanced()) {
                    graphics.setForegroundColor(COLOR_PROPERTY_FG_ADVANCED);
                    graphics.setFont(PropertyEditPart.this.getItalicFont(this.getFont()));
                } else if (PropertyEditPart.this.getViewer().getCategory(property).isPreferred() || PropertyEditPart.this.getViewer().getCategory(property).isSystem()) {
                    graphics.setFont(PropertyEditPart.this.getBoldFont(this.getFont()));
                }
                if (PropertyEditPart.this.isActiveProperty()) {
                    graphics.setForegroundColor(COLOR_PROPERTY_FG_SELECTED);
                }
                int x = PropertyEditPart.this.getTitleTextX();
                DrawUtils.drawStringCV(graphics, property.getTitle(), x, y, PropertyEditPart.this.getViewer().getSplitter() - x, height);
            }
            catch (Throwable e) {
                DesignerPlugin.log(e);
            }
        }

        @Override
        protected IAdaptable getPropertyToolTipAdaptable() {
            return this.getProperty();
        }
    }

    public final class ValueFigure
    extends PropertyFigure {
        protected void paintClientArea(Graphics graphics) {
            int height = this.bounds.height();
            int y = this.bounds.y();
            try {
                Property property = this.getProperty();
                graphics.setFont(this.getFont());
                if (!PropertyEditPart.this.isActiveProperty()) {
                    graphics.setForegroundColor(COLOR_PROPERTY_FG_VALUE);
                }
                int x = PropertyEditPart.this.getViewer().getSplitter() + 4;
                int w = PropertyEditPart.this.getViewer().getControl().getClientArea().width - x - 1;
                property.getEditor().paint(property, graphics, x, y, w, height);
            }
            catch (Throwable e) {
                DesignerPlugin.log(e);
            }
        }

        @Override
        protected IAdaptable getPropertyToolTipAdaptable() {
            return this.getProperty().getEditor();
        }
    }
}

