/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.gef.Request;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.property.event.EventsProperty;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public final class OpenListenerEditPolicy
extends EditPolicy {
    private static final String DOUBLE_CLICK_LISTENER = "double-click.listener";
    private final String m_listenerName;
    private final JavaInfo m_javaInfo;

    public OpenListenerEditPolicy(JavaInfo javaInfo) {
        this.m_javaInfo = javaInfo;
        this.m_listenerName = JavaInfoUtils.getParameter(javaInfo, DOUBLE_CLICK_LISTENER);
    }

    public void performRequest(Request request) {
        if (!StringUtils.isEmpty((CharSequence)this.m_listenerName) && "open".equals(request.getType())) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    EventsProperty eventsProperty = (EventsProperty)OpenListenerEditPolicy.this.m_javaInfo.getPropertyByTitle("Events");
                    eventsProperty.openStubMethod(OpenListenerEditPolicy.this.m_listenerName);
                }
            });
        }
        super.performRequest(request);
    }
}

