/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.burningwave.core.Closeable;
import org.burningwave.core.Criteria;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.ThrowingFunction;
import org.burningwave.core.io.FileSystemItem;

public class JavaClass
extends io.github.toolfactory.jvm.util.JavaClass
implements Closeable {
    private ByteBuffer byteCode;

    public JavaClass(Class<?> cls) {
        this(StaticComponentContainer.Classes.getByteCode(cls));
    }

    public JavaClass(ByteBuffer byteCode) {
        super(byteCode);
        this.setByteCode0(byteCode);
    }

    public static JavaClass create(Class<?> cls) {
        return new JavaClass(cls);
    }

    public static JavaClass create(ByteBuffer byteCode) {
        return new JavaClass(byteCode);
    }

    public static void use(ByteBuffer byteCode, Consumer<JavaClass> javaClassConsumer) {
        try (JavaClass javaClass = JavaClass.create(byteCode);){
            javaClassConsumer.accept(javaClass);
        }
    }

    public static <T, E extends Throwable> T extractByUsing(ByteBuffer byteCode, ThrowingFunction<JavaClass, T, E> javaClassConsumer) throws E {
        try (JavaClass javaClass = JavaClass.create(byteCode);){
            T t = javaClassConsumer.apply(javaClass);
            return t;
        }
    }

    protected ByteBuffer getByteCode0() {
        return this.byteCode;
    }

    protected void setByteCode0(ByteBuffer byteCode) {
        this.byteCode = StaticComponentContainer.BufferHandler.duplicate(byteCode);
    }

    public String getPackagePath() {
        return this.packageName != null ? this.packageName.replace(".", "/") + "/" : null;
    }

    public String getClassFileName() {
        return this.simpleName.replace(".", "$") + ".class";
    }

    public String getPath() {
        String packagePath = this.getPackagePath();
        String classFileName = this.getClassFileName();
        String path = null;
        if (packagePath != null) {
            path = packagePath;
        }
        if (classFileName != null) {
            if (path == null) {
                path = "";
            }
            path = path + classFileName;
        }
        return path;
    }

    public ByteBuffer getByteCode() {
        return StaticComponentContainer.BufferHandler.duplicate(this.getByteCode0());
    }

    public byte[] toByteArray() {
        return StaticComponentContainer.BufferHandler.toByteArray(this.getByteCode());
    }

    public FileSystemItem storeToClassPath(String classPathFolder) {
        return StaticComponentContainer.Streams.store(classPathFolder + "/" + this.getPath(), this.getByteCode());
    }

    public JavaClass duplicate() {
        return new JavaClass(this.getByteCode0());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void close() {
        this.byteCode = null;
    }

    protected static class Criteria
    extends org.burningwave.core.Criteria<JavaClass, Criteria, Criteria.TestContext<JavaClass, Criteria>> {
        protected Criteria() {
        }

        public static Criteria create() {
            return new Criteria();
        }
    }
}

