/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.widgets;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.junit.Test;

public class CompositeTopBoundsTest
extends RcpGefTest {
    @Test
    public void test_resize_properties() throws Exception {
        Dimension oldSize = new Dimension(450, 300);
        Dimension newSize = new Dimension(400, 350);
        ICompilationUnit unit = this.check_resize_Composite("// no size", oldSize, newSize, newSize, "// no size");
        TestUtils.closeAllEditors();
        this.openDesign(unit);
        CompositeTopBoundsTest.assertEquals(newSize, this.canvas.getSize(this.m_contentEditPart));
    }

    @Test
    public void test_resize_pack() throws Exception {
        Dimension packSize = new Dimension(150, 50);
        Dimension newSize = new Dimension(400, 350);
        String sizeCode = EnvironmentUtils.IS_WINDOWS ? "button.setLayoutData(new RowData(" + (packSize.width - 3 - 3) + ", " + (packSize.height - 3 - 3) + "));\n\t\tpack();" : "button.setLayoutData(new RowData(" + (packSize.width - 4 - 4) + ", " + (packSize.height - 4 - 4) + "));\n\t\tpack();";
        ICompilationUnit unit = this.check_resize_Composite(sizeCode, packSize, newSize, packSize, sizeCode);
        TestUtils.closeAllEditors();
        this.openDesign(unit);
        CompositeTopBoundsTest.assertEquals(packSize, this.canvas.getSize(this.m_contentEditPart));
    }

    @Test
    public void test_resize_setSize_ints() throws Exception {
        Dimension oldSize = new Dimension(300, 200);
        Dimension newSize = new Dimension(400, 300);
        this.check_resize_Composite("setSize(300, 200);", oldSize, newSize, newSize, "setSize(400, 300);");
    }

    @Test
    public void test_resize_setSize_Point() throws Exception {
        Dimension oldSize = new Dimension(300, 200);
        Dimension newSize = new Dimension(400, 300);
        this.check_resize_Composite("setSize(new Point(300, 200));", oldSize, newSize, newSize, "setSize(new Point(400, 300));");
    }

    private ICompilationUnit check_resize_Composite(String oldSizeLine, Dimension oldSize, Dimension resizeSize, Dimension newSize, String newSizeLine) throws Exception {
        CompositeInfo composite = this.openComposite("class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new RowLayout());", "    Button button = new Button(this, SWT.NONE);", "    " + oldSizeLine, "  }", "}");
        CompositeTopBoundsTest.assertEquals(oldSize, this.canvas.getSize(composite));
        CompositeTopBoundsTest.waitEventLoop(50);
        this.canvas.beginResize(composite, 16);
        this.canvas.dragTo((Object)composite, resizeSize.width, 0).endDrag();
        this.canvas.beginResize(composite, 4);
        this.canvas.dragTo((Object)composite, 0, resizeSize.height).endDrag();
        CompositeTopBoundsTest.assertEquals(newSize, this.canvas.getSize(composite));
        this.assertEditor("class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new RowLayout());", "    Button button = new Button(this, SWT.NONE);", "    " + newSizeLine, "  }", "}");
        return this.m_lastEditor.getModelUnit();
    }
}

