/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.property.editor.font.FontPropertyEditor;
import org.eclipse.wb.tests.designer.swt.model.property.FontPropertyEditorTest;
import org.eclipse.wb.tests.designer.swt.model.property.PropertyEditorTestUtils;
import org.eclipse.wb.tests.designer.tests.common.GenericPropertyNoValue;
import org.junit.Before;
import org.junit.Test;

public class FontPropertyEditorTestNoManager
extends FontPropertyEditorTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("useResourceManager", false);
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_textSource_noValue() throws Exception {
        GenericPropertyNoValue property = new GenericPropertyNoValue(null, null, FontPropertyEditor.INSTANCE);
        FontPropertyEditorTestNoManager.assertNull((Object)PropertyEditorTestUtils.getText((Property)property));
        FontPropertyEditorTestNoManager.assertNull((Object)PropertyEditorTestUtils.getClipboardSource((Property)property));
    }

    @Test
    public void test_textSource_constructor_NORMAL() throws Exception {
        this.assert_getText_getClipboardSource_forSource("new Font(null, \"MS Shell Dlg\", 12, SWT.NORMAL)", "MS Shell Dlg 12", "new org.eclipse.swt.graphics.Font(null, \"MS Shell Dlg\", 12, org.eclipse.swt.SWT.NORMAL)");
    }

    @Test
    public void test_textSource_constructor_BOLD() throws Exception {
        this.assert_getText_getClipboardSource_forSource("new Font(null, \"MS Shell Dlg\", 12, SWT.BOLD)", "MS Shell Dlg 12 BOLD", "new org.eclipse.swt.graphics.Font(null, \"MS Shell Dlg\", 12, org.eclipse.swt.SWT.BOLD)");
    }

    @Test
    public void test_textSource_constructor_ITALIC() throws Exception {
        this.assert_getText_getClipboardSource_forSource("new Font(null, \"MS Shell Dlg\", 12, SWT.ITALIC)", "MS Shell Dlg 12 ITALIC", "new org.eclipse.swt.graphics.Font(null, \"MS Shell Dlg\", 12, org.eclipse.swt.SWT.ITALIC)");
    }

    @Test
    public void test_textSource_constructor_BOLD_ITALIC() throws Exception {
        this.assert_getText_getClipboardSource_forSource("new Font(null, \"MS Shell Dlg\", 12, SWT.BOLD | SWT.ITALIC)", "MS Shell Dlg 12 BOLD ITALIC", "new org.eclipse.swt.graphics.Font(null, \"MS Shell Dlg\", 12, org.eclipse.swt.SWT.BOLD | org.eclipse.swt.SWT.ITALIC)");
    }

    @Test
    public void test_textSource_over_JFace() throws Exception {
        this.assert_getText_getClipboardSource_forSource("JFaceResources.getBannerFont()", "getBannerFont()", "org.eclipse.jface.resource.JFaceResources.getBannerFont()");
    }
}

