/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.property;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.wb.core.controls.CSpinner;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.property.editor.border.BorderPropertyEditor;
import org.eclipse.wb.tests.designer.core.model.parser.AbstractJavaInfoTest;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.eclipse.wb.tests.utils.SWTBotCSpinner;
import org.junit.Test;

public class BorderPropertyEditorTest
extends SwingModelTest {
    @Test
    public void test_getText_defaultBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        panel.refresh();
        Property borderProperty = panel.getPropertyByTitle("border");
        BorderPropertyEditorTest.assertEquals(null, (Object)BorderPropertyEditorTest.getPropertyText(borderProperty));
    }

    @Test
    public void test_getText_noBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(null);\n\t}\n}");
        panel.refresh();
        Property borderProperty = panel.getPropertyByTitle("border");
        BorderPropertyEditorTest.assertEquals((Object)"(no border)", (Object)BorderPropertyEditorTest.getPropertyText(borderProperty));
    }

    @Test
    public void test_getText_EmptyBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new EmptyBorder(0, 0, 0, 0));\n\t}\n}");
        panel.refresh();
        Property borderProperty = panel.getPropertyByTitle("border");
        BorderPropertyEditorTest.assertEquals((Object)"EmptyBorder", (Object)BorderPropertyEditorTest.getPropertyText(borderProperty));
    }

    @Test
    public void test_getClipboardSource_EmptyBorder() throws Exception {
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBorder(new EmptyBorder(1, 2, 3, 4));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)BorderPropertyEditorTest.getJavaInfoByName("button");
        GenericProperty borderProperty = (GenericProperty)button.getPropertyByTitle("border");
        PropertyEditor propertyEditor = borderProperty.getEditor();
        BorderPropertyEditorTest.assertEquals((Object)"new javax.swing.border.EmptyBorder(1, 2, 3, 4)", (Object)((IClipboardSourceProvider)propertyEditor).getClipboardSource(borderProperty));
        BorderPropertyEditorTest.doCopyPaste(button, new AbstractJavaInfoTest.PasteProcedure<ComponentInfo>(){

            @Override
            public void run(ComponentInfo copy) throws Exception {
                ((FlowLayoutInfo)panel.getLayout()).add(copy, null);
            }
        });
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBorder(new EmptyBorder(1, 2, 3, 4));\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBorder(new EmptyBorder(1, 2, 3, 4));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_getClipboardSource_hasNotConstants() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tint notConst = 4;\n\t\t\tbutton.setBorder(new EmptyBorder(1, 2, 3, notConst));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)BorderPropertyEditorTest.getJavaInfoByName("button");
        GenericProperty borderProperty = (GenericProperty)button.getPropertyByTitle("border");
        PropertyEditor propertyEditor = borderProperty.getEditor();
        IClipboardSourceProvider pe = (IClipboardSourceProvider)propertyEditor;
        String cs = pe.getClipboardSource(borderProperty);
        BorderPropertyEditorTest.assertEquals(null, (Object)cs);
        BorderPropertyEditorTest.doCopyPaste(button, copy -> ((FlowLayoutInfo)panel.getLayout()).add(copy, null));
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tint notConst = 4;\n\t\t\tbutton.setBorder(new EmptyBorder(1, 2, 3, notConst));\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_modifyBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        panel.refresh();
        Property borderProperty = panel.getPropertyByTitle("border");
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            PropertyEditor editor = BorderPropertyEditor.INSTANCE;
            ReflectionUtils.invokeMethod2((Object)editor, (String)"openDialog", Property.class, (Object)borderProperty);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBot dialogBot = bot.shell("Border editor").bot();
            dialogBot.comboBox().setSelection("EmptyBorder");
            List<SWTBotCSpinner> spinners = this.getCSpinners(dialogBot);
            BorderPropertyEditorTest.assertEquals((long)spinners.size(), (long)4L);
            spinners.get(0).setSelection(10);
            spinners.get(1).setSelection(15);
            spinners.get(2).setSelection(20);
            spinners.get(3).setSelection(25);
            dialogBot.button("OK").click();
        }));
        panel.refresh();
        this.assertEditor("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetBorder(new EmptyBorder(10, 15, 20, 25));\n\t}\n}");
    }

    private List<SWTBotCSpinner> getCSpinners(SWTBot shell) {
        ArrayList<SWTBotCSpinner> spinners = new ArrayList<SWTBotCSpinner>();
        for (CSpinner spinner : shell.getFinder().findControls(WidgetOfType.widgetOfType(CSpinner.class))) {
            spinners.add(new SWTBotCSpinner(spinner));
        }
        return spinners;
    }
}

