/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.model;

import java.awt.BorderLayout;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.BorderLayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.Test;

public class BorderLayoutTest
extends AbstractLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        BorderLayoutTest.setLayout(panel, BorderLayout.class);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "  }", "}");
    }

    @Test
    public void test_getComponent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      final JButton button = new JButton();", "      add(button, BorderLayout.NORTH);", "    }", "  }", "}");
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        panel.refresh();
        try {
            ComponentInfo component = (ComponentInfo)panel.getChildrenComponents().get(0);
            BorderLayoutTest.assertSame((Object)component.getObject(), (Object)layout.getComponent("North"));
            BorderLayoutTest.assertNull((Object)layout.getComponent("West"));
            BorderLayoutTest.assertNull((Object)layout.getComponent("East"));
            BorderLayoutTest.assertNull((Object)layout.getComponent("South"));
            BorderLayoutTest.assertNull((Object)layout.getComponent("Center"));
        }
        finally {
            panel.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = BorderLayoutTest.createJButton();
        layout.command_CREATE(newComponent, "North");
        BorderLayoutTest.assertInstanceOf(InvocationChildAssociation.class, (Object)newComponent.getAssociation());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton();", "      add(button, BorderLayout.NORTH);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_nullRegion() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = BorderLayoutTest.createJButton();
        layout.command_CREATE(newComponent, null);
        BorderLayoutTest.assertInstanceOf(InvocationChildAssociation.class, (Object)newComponent.getAssociation());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_withTarget() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    add(new JButton(), BorderLayout.NORTH);", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        ComponentInfo target = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo newComponent = BorderLayoutTest.createJButton();
        layout.command_CREATE(newComponent, "West", target);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton();", "      add(button, BorderLayout.WEST);", "    }", "    add(new JButton(), BorderLayout.NORTH);", "  }", "}");
    }

    @Test
    public void test_MOVE() throws Exception {
        this.check_MOVE(new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton();", "      add(button, BorderLayout.NORTH);", "    }", "  }", "}"});
    }

    @Test
    public void test_MOVE_lazy() throws Exception {
        String[] source = new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    add(getButton(), BorderLayout.NORTH);", "  }", "  private JButton button;", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}"};
        String[] source2 = BorderLayoutTest.replace(source, "NORTH", "SOUTH");
        this.check_MOVE(source, source2);
    }

    @Test
    public void test_MOVE_implicitCenter() throws Exception {
        this.check_MOVE(new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}"});
    }

    private void check_MOVE(String[] lines) throws Exception {
        this.check_MOVE(lines, new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton();", "      add(button, BorderLayout.SOUTH);", "    }", "  }", "}"});
    }

    private void check_MOVE(String[] lines, String[] expectedLines) throws Exception {
        ContainerInfo panel = this.parseContainer(lines);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Association initialAssociation = button.getAssociation();
        Statement initialStatement = initialAssociation.getStatement();
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        layout.command_MOVE(button, "South");
        this.assertEditor(expectedLines);
        BorderLayoutTest.assertSame((Object)initialAssociation, (Object)button.getAssociation());
        BorderLayoutTest.assertSame((Object)initialStatement, (Object)button.getAssociation().getStatement());
    }

    @Test
    public void test_REGION() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    add(new JButton(), BorderLayout.NORTH);", "  }", "}"};
        ContainerInfo panel = this.parseContainer(lines);
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        layout.command_REGION(button, "West");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    add(new JButton(), BorderLayout.WEST);", "  }", "}");
    }

    @Test
    public void test_reparentingVariable() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JPanel panel = new JPanel();", "      add(panel, BorderLayout.NORTH);", "      {", "        JButton button = new JButton();", "        button.setEnabled(false);", "        panel.add(button);", "      }", "    }", "  }", "}"};
        String[] expectedLines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JPanel panel = new JPanel();", "      add(panel, BorderLayout.NORTH);", "    }", "    {", "      JButton button = new JButton();", "      add(button, BorderLayout.SOUTH);", "      button.setEnabled(false);", "    }", "  }", "}"};
        this.check_reparenting(lines, expectedLines);
    }

    @Test
    public void test_reparentingLazy() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  private JPanel panel;", "  private JButton button;", "  public Test() {", "    setLayout(new BorderLayout());", "    add(getPanel(), BorderLayout.NORTH);", "  }", "  private JPanel getPanel() {", "    if (panel == null) {", "      panel = new JPanel();", "      panel.add(getButton());", "    }", "    return panel;", "  }", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}"};
        String[] expectedLines = new String[]{"public class Test extends JPanel {", "  private JPanel panel;", "  private JButton button;", "  public Test() {", "    setLayout(new BorderLayout());", "    add(getPanel(), BorderLayout.NORTH);", "    add(getButton(), BorderLayout.SOUTH);", "  }", "  private JPanel getPanel() {", "    if (panel == null) {", "      panel = new JPanel();", "    }", "    return panel;", "  }", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}"};
        this.check_reparenting(lines, expectedLines);
    }

    private void check_reparenting(String[] lines, String[] expectedLines) throws Exception {
        ContainerInfo panel = this.parseContainer(lines);
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        layout.command_MOVE(button, "South");
        Association association = button.getAssociation();
        BorderLayoutTest.assertInstanceOf(CompilationUnit.class, (Object)association.getStatement().getRoot());
        this.assertEditor(expectedLines);
    }

    @Test
    public void test_constraintsProperty() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton();", "      add(button, BorderLayout.NORTH);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property constraintsProperty = button.getPropertyByTitle("Constraints");
        BorderLayoutTest.assertNotNull((Object)constraintsProperty);
        BorderLayoutTest.assertTrue((boolean)constraintsProperty.getCategory().isSystem());
        BorderLayoutTest.assertSame((Object)constraintsProperty, (Object)button.getPropertyByTitle("Constraints"));
        BorderLayoutTest.assertTrue((boolean)constraintsProperty.isModified());
        BorderLayoutTest.assertEquals((Object)"North", (Object)constraintsProperty.getValue());
        constraintsProperty.setValue((Object)"South");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton();", "      add(button, BorderLayout.SOUTH);", "    }", "  }", "}");
    }

    @Test
    public void test_constraintsProperty_unsupportedRegion() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton();", "      add(button, BorderLayout.BEFORE_FIRST_LINE);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property constraintsProperty = button.getPropertyByTitle("Constraints");
        BorderLayoutTest.assertEquals((Object)"", (Object)constraintsProperty.getValue());
    }

    @Test
    public void test_getEmptyRegion_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    add(new JButton(), BorderLayout.NORTH);", "  }", "}");
        panel.refresh();
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        BorderLayoutTest.assertSame((Object)"South", (Object)layout.getEmptyRegion());
    }

    @Test
    public void test_getEmptyRegion_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    add(new JButton(), BorderLayout.SOUTH);", "  }", "}");
        panel.refresh();
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        BorderLayoutTest.assertSame((Object)"North", (Object)layout.getEmptyRegion());
    }

    @Test
    public void test_getEmptyRegion_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    add(new JButton(), BorderLayout.NORTH);", "    add(new JButton(), BorderLayout.SOUTH);", "  }", "}");
        panel.refresh();
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        BorderLayoutTest.assertSame((Object)"West", (Object)layout.getEmptyRegion());
    }

    @Test
    public void test_getEmptyRegion_4() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    add(new JButton(), BorderLayout.NORTH);", "    add(new JButton(), BorderLayout.SOUTH);", "    add(new JButton(), BorderLayout.WEST);", "    add(new JButton(), BorderLayout.EAST);", "    add(new JButton(), BorderLayout.CENTER);", "  }", "}");
        panel.refresh();
        BorderLayoutInfo layout = (BorderLayoutInfo)panel.getLayout();
        BorderLayoutTest.assertSame(null, (Object)layout.getEmptyRegion());
    }
}

