/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gbl;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.generation.statement.lazy.LazyStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.variable.description.LazyVariableDescription;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.Activator;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.AbstractGridBagConstraintsInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagConstraintsInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingTestUtils;
import org.eclipse.wb.tests.designer.swing.model.layout.gbl.AbstractGridBagLayoutTest;
import org.junit.After;
import org.junit.Ignore;
import org.junit.Test;

public class GridBagLayoutTest
extends AbstractGridBagLayoutTest {
    @Override
    @After
    public void tearDown() throws Exception {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        preferences.setToDefault("GridBagLayout.changeInsets.forGaps");
        preferences.setToDefault("GridBagLayout.gap.column");
        preferences.setToDefault("GridBagLayout.gap.row");
        super.tearDown();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_fieldAssignment() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton('button');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 2;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo gbc = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button);
        GridBagLayoutTest.assertRelatedNodes((JavaInfo)gbc, new String[]{"new GridBagConstraints()", "gbc.gridx = 1", "gbc.gridy = 2", "add(button, gbc)"});
        GridBagLayoutTest.assertVisible((ObjectInfo)gbc, false);
        GridBagConstraints gbcObject = gbc.getGridBagConstraints();
        GridBagLayoutTest.assertEquals((long)1L, (long)gbcObject.gridx);
        GridBagLayoutTest.assertEquals((long)2L, (long)gbcObject.gridy);
    }

    @Test
    public void test_extraParentChild() throws Exception {
        GridBagLayoutTest.setFileContentSrc("test/AFrame.java", this.getTestSource("public class AFrame extends JFrame {", "  protected void addGB(Container parent, Component child, int x, int y) {", "    GridBagConstraints constraints = new GridBagConstraints();", "    constraints.gridx = x;", "    constraints.gridy = y;", "    parent.add(child, constraints);", "  }", "}"));
        GridBagLayoutTest.setFileContentSrc("test/AFrame.wbp-component.xml", GridBagLayoutTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addGB'>", "      <parameter type='java.awt.Container' parent2='true'/>", "      <parameter type='java.awt.Component' child2='true'/>", "      <parameter type='int'/>", "      <parameter type='int'/>", "    </method>", "  </methods>", "</component>"));
        GridBagLayoutTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends AFrame {", "  public Test() {", "    getContentPane().setLayout(new GridBagLayout());", "    addGB(getContentPane(), new JButton('1 x 1'), 1, 1);", "    addGB(getContentPane(), new JButton('2 x 2'), 2, 2);", "  }", "}");
        frame.refresh();
        GridBagLayoutTest.assertNoErrors((JavaInfo)frame);
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        GridBagLayout gblObject = (GridBagLayout)contentPane.getContainer().getLayout();
        GridBagLayoutTest.assertEquals((long)2L, (long)contentPane.getChildrenComponents().size());
        Container container = contentPane.getContainer();
        Component[] components = container.getComponents();
        GridBagLayoutTest.assertEquals((long)2L, (long)components.length);
        ComponentInfo button = (ComponentInfo)contentPane.getChildrenComponents().get(0);
        GridBagConstraints gbcObject = gblObject.getConstraints(button.getComponent());
        GridBagLayoutTest.assertEquals((long)1L, (long)gbcObject.gridx);
        GridBagLayoutTest.assertEquals((long)1L, (long)gbcObject.gridy);
        button = (ComponentInfo)contentPane.getChildrenComponents().get(1);
        gbcObject = gblObject.getConstraints(button.getComponent());
        GridBagLayoutTest.assertEquals((long)2L, (long)gbcObject.gridx);
        GridBagLayoutTest.assertEquals((long)2L, (long)gbcObject.gridy);
    }

    @Test
    public void test_ComboBox_andBaseline() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.rowWeights = new double[]{1.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JComboBox combo = new JComboBox();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.anchor = GridBagConstraints.BASELINE;", "      add(combo, gbc);", "    }", "  }", "}");
        this.refresh();
        GridBagLayoutTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_keepSize() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setSize(600, 250);", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "  }", "}");
        this.refresh();
        GridBagLayoutTest.assertEquals((Object)new Dimension(600, 250), (Object)panel.getBounds().getSize());
    }

    @Test
    public void test_grid() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    layout.columnWidths = new int[]{0, 0, 0, 0};", "    layout.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};", "    layout.rowHeights = new int[]{0, 0, 0, 0};", "    layout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};", "    {", "      JButton button = new JButton('button 0 0');", "      add(button, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,", "          GridBagConstraints.CENTER, GridBagConstraints.BOTH,", "          new Insets(0, 0, 5, 5), 0, 0));", "    }", "    {", "      JButton button = new JButton('button 1 0 2 1');", "      add(button, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0,", "          GridBagConstraints.CENTER, GridBagConstraints.BOTH,", "          new Insets(0, 0, 5, 5), 0, 0));", "    }", "    {", "      JButton button = new JButton('button 1 1');", "      add(button, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0,", "          GridBagConstraints.CENTER, GridBagConstraints.BOTH,", "          new Insets(0, 0, 5, 5), 0, 0));", "    }", "    {", "      JButton button = new JButton('button 1 2');", "      add(button, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0,", "          GridBagConstraints.CENTER, GridBagConstraints.BOTH,", "          new Insets(0, 0, 5, 15), 0, 0));", "    }", "    {", "      JButton button = new JButton('button 2 2');", "      add(button, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0,", "          GridBagConstraints.CENTER, GridBagConstraints.BOTH,", "          new Insets(0, 0, 5, 5), 0, 0));", "    }", "  }", "}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        List childrenComponents = panel.getChildrenComponents();
        ComponentInfo[] components = childrenComponents.toArray(new ComponentInfo[childrenComponents.size()]);
        GridBagLayoutTest.assertEquals((long)5L, (long)components.length);
        panel.refresh();
        IGridInfo gridInfo = layout.getGridInfo();
        GridBagLayoutTest.assertEquals((long)3L, (long)gridInfo.getColumnCount());
        GridBagLayoutTest.assertEquals((long)3L, (long)gridInfo.getRowCount());
        Interval[] intervals = gridInfo.getColumnIntervals();
        GridBagLayoutTest.assertEquals((long)3L, (long)intervals.length);
        GridBagLayoutTest.assertTrue((intervals[0].length() > 20 ? 1 : 0) != 0);
        GridBagLayoutTest.assertTrue((intervals[1].length() > 20 ? 1 : 0) != 0);
        GridBagLayoutTest.assertTrue((intervals[2].length() > 20 ? 1 : 0) != 0);
        intervals = gridInfo.getRowIntervals();
        GridBagLayoutTest.assertEquals((long)3L, (long)intervals.length);
        GridBagLayoutTest.assertTrue((intervals[0].length() > 20 ? 1 : 0) != 0);
        GridBagLayoutTest.assertTrue((intervals[1].length() > 20 ? 1 : 0) != 0);
        GridBagLayoutTest.assertTrue((intervals[2].length() > 20 ? 1 : 0) != 0);
        GridBagLayoutTest.assertEquals((Object)new Rectangle(0, 0, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)components[0]));
        GridBagLayoutTest.assertEquals((Object)new Rectangle(1, 0, 2, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)components[1]));
        GridBagLayoutTest.assertEquals((Object)new Rectangle(1, 1, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)components[2]));
        GridBagLayoutTest.assertEquals((Object)new Rectangle(1, 2, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)components[3]));
        GridBagLayoutTest.assertEquals((Object)new Rectangle(2, 2, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)components[4]));
        gridInfo.getCellsRectangle(new Rectangle(0, 0, 1, 1));
        GridBagLayoutTest.assertEquals((Object)new Insets(0, 0, 0, 0), (Object)gridInfo.getInsets());
        GridBagLayoutTest.assertEquals((long)25L, (long)gridInfo.getVirtualColumnSize());
        GridBagLayoutTest.assertEquals((long)5L, (long)gridInfo.getVirtualColumnGap());
        GridBagLayoutTest.assertEquals((long)25L, (long)gridInfo.getVirtualRowSize());
        GridBagLayoutTest.assertEquals((long)5L, (long)gridInfo.getVirtualRowGap());
        GridBagLayoutTest.assertSame((Object)components[0], (Object)gridInfo.getOccupied(0, 0));
        GridBagLayoutTest.assertSame((Object)components[1], (Object)gridInfo.getOccupied(1, 0));
        GridBagLayoutTest.assertSame((Object)components[1], (Object)gridInfo.getOccupied(2, 0));
        GridBagLayoutTest.assertNull((Object)gridInfo.getOccupied(0, 1));
        GridBagLayoutTest.assertSame((Object)components[2], (Object)gridInfo.getOccupied(1, 1));
    }

    @Test
    public void test_grid_noComponents() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "  }", "}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        panel.refresh();
        IGridInfo gridInfo = layout.getGridInfo();
        GridBagLayoutTest.assertEquals((long)0L, (long)gridInfo.getColumnCount());
        GridBagLayoutTest.assertEquals((long)0L, (long)gridInfo.getRowCount());
    }

    @Test
    public void test_grid_spannedColumn_includeFiller() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[]{0, 0};", "    layout.columnWeights = new double[]{0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints constraints = new GridBagConstraints();", "      constraints.gridx = 0;", "      constraints.gridwidth = 2;", "      add(button, constraints);", "    }", "  }", "}");
        this.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)GridBagLayoutTest.getJavaInfoByName("button");
        IGridInfo gridInfo = layout.getGridInfo();
        GridBagLayoutTest.assertEquals((long)2L, (long)gridInfo.getColumnCount());
        Rectangle cells = gridInfo.getComponentCells((IAbstractComponentInfo)button);
        Rectangle cellsRectangle = gridInfo.getCellsRectangle(cells);
        GridBagLayoutTest.assertEquals((Object)new Rectangle(0, 0, 2, 1), (Object)cells);
        GridBagLayoutTest.assertEquals((long)cellsRectangle.x, (long)0L);
        Assertions.assertThat((int)cellsRectangle.width).isGreaterThan(400);
    }

    @Test
    public void test_grid_spannedRow_includeFiller() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.rowHeights = new int[]{0, 0};", "    layout.rowWeights = new double[]{0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints constraints = new GridBagConstraints();", "      constraints.gridy = 0;", "      constraints.gridheight = 2;", "      add(button, constraints);", "    }", "  }", "}");
        this.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)GridBagLayoutTest.getJavaInfoByName("button");
        IGridInfo gridInfo = layout.getGridInfo();
        GridBagLayoutTest.assertEquals((long)2L, (long)gridInfo.getRowCount());
        Rectangle cells = gridInfo.getComponentCells((IAbstractComponentInfo)button);
        Rectangle cellsRectangle = gridInfo.getCellsRectangle(cells);
        GridBagLayoutTest.assertEquals((Object)new Rectangle(0, 0, 1, 2), (Object)cells);
        GridBagLayoutTest.assertEquals((long)cellsRectangle.y, (long)0L);
        Assertions.assertThat((int)cellsRectangle.height).isGreaterThan(250);
    }

    @Test
    public void test_grid_emptyColumn() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 1 0');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        this.check_grid_emptyColumn(panel);
    }

    @Test
    public void test_grid_emptyColumn_JFrame() throws Exception {
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    getContentPane().setLayout(layout);", "    {", "      JButton button = new JButton('button 1 0');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      getContentPane().add(button, gbc);", "    }", "  }", "}");
        ContainerInfo panel = (ContainerInfo)frame.getChildrenComponents().get(0);
        this.check_grid_emptyColumn(panel);
    }

    @Test
    public void test_grid_emptyColumn2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[]{};", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 1 0');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        this.check_grid_emptyColumn(panel);
    }

    @Test
    public void test_grid_emptyColumn3() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[]{0, 0, 0};", "    layout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 1 0');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        this.check_grid_emptyColumn(panel);
    }

    @Test
    public void test_grid_emptyColumn_spanned() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 0 2 1');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridwidth = 2;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        this.check_grid_emptyColumn(panel);
    }

    private void check_grid_emptyColumn(ContainerInfo panel) throws Exception {
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        panel.getRoot().refresh();
        IGridInfo gridInfo = layout.getGridInfo();
        Interval[] intervals = gridInfo.getColumnIntervals();
        GridBagLayoutTest.assertEquals((long)2L, (long)intervals.length);
        GridBagLayoutTest.assertTrue((intervals[1].length() > 50 ? 1 : 0) != 0);
        GridBagLayoutTest.assertEquals((long)gridInfo.getVirtualColumnSize(), (long)intervals[0].length());
        GridBagLayoutTest.assertEquals((long)gridInfo.getVirtualColumnGap(), (long)(intervals[1].begin() - intervals[0].end()));
    }

    @Test
    public void test_grid_emptyColumn4() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[]{150};", "    layout.columnWeights = new double[]{0.0};", "    setLayout(layout);", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        IGridInfo gridInfo = layout.getGridInfo();
        Interval[] intervals = gridInfo.getColumnIntervals();
        GridBagLayoutTest.assertEquals((long)1L, (long)intervals.length);
        GridBagLayoutTest.assertEquals((long)145L, (long)intervals[0].length());
    }

    @Test
    public void test_grid_emptyRow() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 1');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
        this.check_grid_emptyRow(panel);
    }

    @Ignore
    @Test
    public void test_grid_emptyRow_spanned() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 1');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.gridheight = 2;", "      add(button, gbc);", "    }", "  }", "}");
        this.check_grid_emptyRow(panel);
    }

    private void check_grid_emptyRow(ContainerInfo panel) throws Exception {
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        IGridInfo gridInfo = layout.getGridInfo();
        Interval[] intervals = gridInfo.getRowIntervals();
        GridBagLayoutTest.assertEquals((long)2L, (long)intervals.length);
        GridBagLayoutTest.assertTrue((intervals[1].length() > 20 ? 1 : 0) != 0);
        GridBagLayoutTest.assertEquals((long)gridInfo.getVirtualRowSize(), (long)intervals[0].length());
        GridBagLayoutTest.assertEquals((long)gridInfo.getVirtualRowGap(), (long)(intervals[1].begin() - intervals[0].end()));
    }

    @Test
    public void test_grid_lessWeightThanDimensions() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[]{200};", "    layout.columnWeights = new double[]{0.0};", "    layout.rowHeights = new int[]{30};", "    layout.rowWeights = new double[]{0.0};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        IGridInfo gridInfo = layout.getGridInfo();
        Object[] intervals = gridInfo.getColumnIntervals();
        Assertions.assertThat((Object[])intervals).hasSize(2);
        intervals = gridInfo.getRowIntervals();
        Assertions.assertThat((Object[])intervals).hasSize(2);
    }

    @Test
    public void test_grid_emptyRow_whenPack() throws Exception {
        GridBagLayoutTest.setFileContentSrc("test/MyFrame.java", this.getTestSource("public class MyFrame extends JFrame {", "  protected void finishInit() {", "    pack();", "  }", "}"));
        GridBagLayoutTest.setFileContentSrc("test/MyFrame.wbp-component.xml", GridBagLayoutTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='finishInit'/>", "  </methods>", "  <parameters>", "    <parameter name='topBounds.pack'>true</parameter>", "  </parameters>", "</component>"));
        GridBagLayoutTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("class Test extends MyFrame {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    getContentPane().setLayout(layout);", "    {", "      JButton button = new JButton('button 0 1');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      getContentPane().add(button, gbc);", "    }", "    finishInit();", "  }", "}");
        this.refresh();
        ComponentInfo button = (ComponentInfo)GridBagLayoutTest.getJavaInfoByName("button");
        Rectangle frameBounds = frame.getAbsoluteBounds();
        Rectangle buttonBounds = button.getAbsoluteBounds();
        Assertions.assertThat((int)frameBounds.getTopLeft().x).isLessThanOrEqualTo(buttonBounds.getTopLeft().x);
        Assertions.assertThat((int)frameBounds.getTopLeft().y).isLessThanOrEqualTo(buttonBounds.getTopLeft().y);
        Assertions.assertThat((int)frameBounds.getBottomRight().x).isGreaterThanOrEqualTo(buttonBounds.getBottomRight().x);
        Assertions.assertThat((int)frameBounds.getBottomRight().y).isGreaterThanOrEqualTo(buttonBounds.getBottomRight().y);
    }

    @Test
    public void test_replaceGBL() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(layout)/ /add(button, gbc)/}", "  {new: java.awt.GridBagLayout} {local-unique: layout} {/new GridBagLayout()/ /setLayout(layout)/}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button, gbc)/}", "    {new: java.awt.GridBagConstraints} {local-unique: gbc} {/new GridBagConstraints()/ /gbc.gridx = 1/ /gbc.gridy = 1/ /add(button, gbc)/}");
        panel.refresh();
        LayoutInfo flowLayout = (LayoutInfo)GridBagLayoutTest.createJavaInfo("java.awt.FlowLayout");
        panel.setLayout(flowLayout);
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/ /setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5))/}", "  {new: java.awt.FlowLayout} {empty} {/setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5))/}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}");
    }

    @Test
    public void test_replaceGBL_whenVirtualConstraints() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(layout)/ /add(button)/}", "  {new: java.awt.GridBagLayout} {local-unique: layout} {/new GridBagLayout()/ /setLayout(layout)/}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}", "    {virtual-GBL-constraints} {virtual-GBL-constraints} {}");
        panel.refresh();
        LayoutInfo flowLayout = (LayoutInfo)GridBagLayoutTest.createJavaInfo("java.awt.FlowLayout");
        panel.setLayout(flowLayout);
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/ /setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5))/}", "  {new: java.awt.FlowLayout} {empty} {/setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5))/}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}");
    }

    @Test
    public void test_setLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        GridBagLayoutInfo gbl = (GridBagLayoutInfo)GridBagLayoutTest.createJavaInfo("java.awt.GridBagLayout");
        panel.setLayout((LayoutInfo)gbl);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    GridBagLayout gridBagLayout = new GridBagLayout();", "    gridBagLayout.columnWidths = new int[]{0};", "    gridBagLayout.rowHeights = new int[]{0};", "    gridBagLayout.columnWeights = new double[]{Double.MIN_VALUE};", "    gridBagLayout.rowWeights = new double[]{Double.MIN_VALUE};", "    setLayout(gridBagLayout);", "  }", "}");
    }

    @Test
    public void test_CREATE_empty_0() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "  }", "}");
        panel.refresh();
        Activator.getDefault().getPreferenceStore().setValue("GridBagLayout.longConstraints", true);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      add(button, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_empty_1() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0};", "    layout.rowHeights = new int[] {0};", "    layout.columnWeights = new double[] {Double.MIN_VALUE};", "    layout.rowWeights = new double[] {Double.MIN_VALUE};", "    setLayout(layout);", "  }", "}");
        panel.refresh();
        Activator.getDefault().getPreferenceStore().setValue("GridBagLayout.longConstraints", true);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_empty_2() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0};", "    layout.rowHeights = new int[] {0};", "    layout.columnWeights = new double[] {Double.MIN_VALUE};", "    layout.rowWeights = new double[] {Double.MIN_VALUE};", "    setLayout(layout);", "  }", "}");
        panel.refresh();
        Activator.getDefault().getPreferenceStore().setValue("GridBagLayout.longConstraints", true);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 2, false, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0, 0, 0};", "    layout.rowHeights = new int[] {0, 0, 0};", "    layout.columnWeights = new double[] {0.0, 0.0, 0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_insertColumn_insertRow() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 0');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 0, true, 0, true);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0, 0};", "    layout.rowHeights = new int[] {0, 0, 0};", "    layout.columnWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton('button 0 0');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_appendColumn_appendRow() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 0');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 1, false, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0, 0};", "    layout.rowHeights = new int[] {0, 0, 0};", "    layout.columnWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 0');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_appendColumn() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 0');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 1, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 0');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_insertColumn_appendRow_expandSpanColumn() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 0 2 1');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.gridwidth = 2;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 1, true, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 0 2 1');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 0);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.gridwidth = 3;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_appendColumn_insertRow_expandSpanRow() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 0 1 2');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.gridheight = 2;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 1, false, 1, true);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 0 1 2');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.gridheight = 3;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 0);", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_appendColumn_differentGap() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        preferences.setValue("GridBagLayout.gap.column", 10);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 1, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 10);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_appendRow_differentGap() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        preferences.setValue("GridBagLayout.gap.row", 10);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 0, false, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 10, 0);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_appendRow_dontChangeInsets_soNoGap() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        preferences.setValue("GridBagLayout.changeInsets.forGaps", false);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 0, false, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_last_hasEmptyCell() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(button_1, gbc);", "    }", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      add(button_2, gbc);", "    }", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE_last(button);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 0);", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(button_1, gbc);", "    }", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      add(button_2, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_last_noEmptyCell() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_1, gbc);", "    }", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE_last(button);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 0);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button_1, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_tooLittleElements_rowHeight() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.rowHeights = new int[] {};", "    layout.rowWeights = new double[] {};", "    setLayout(layout);", "    {", "      JButton button = new JButton('existing');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 0, false, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.rowHeights = new int[] {0, 0};", "    layout.rowWeights = new double[] {0.0, 0.0};", "    setLayout(layout);", "    {", "      JButton button = new JButton('existing');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 0);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_0() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0, 0};", "    layout.rowHeights = new int[] {0, 0, 0};", "    layout.columnWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 0');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton('button 1 1');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button_00 = (ComponentInfo)panel.getChildrenComponents().get(0);
                layout.command_MOVE(button_00, 1, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0, 0};", "    layout.rowHeights = new int[] {0, 0, 0};", "    layout.columnWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 0');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 0);", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton('button 1 1');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_1() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0, 0};", "    layout.rowHeights = new int[] {0, 0, 0};", "    layout.columnWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 0 1');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton('button 1 1');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button_11 = (ComponentInfo)panel.getChildrenComponents().get(1);
                layout.command_MOVE(button_11, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0, 0};", "    layout.rowHeights = new int[] {0, 0, 0};", "    layout.columnWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};", "    layout.rowWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};", "    setLayout(layout);", "    {", "      JButton button = new JButton('button 1 1');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "    {", "      JButton button = new JButton('button 0 1');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 0, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, 1.0};", "    layout.rowWeights = new double[] {0.0, 1.0};", "    setLayout(layout);", "    {", "      JPanel innerPanel = new JPanel();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(innerPanel, gbc);", "      {", "        JButton button = new JButton('button');", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
        panel.refresh();
        final GridBagLayoutInfo gridLayout = (GridBagLayoutInfo)panel.getLayout();
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        final FlowLayoutInfo flowLayout = (FlowLayoutInfo)innerPanel.getLayout();
        final ComponentInfo button = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                gridLayout.command_MOVE(button, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, 1.0};", "    layout.rowWeights = new double[] {0.0, 1.0};", "    setLayout(layout);", "    {", "      JButton button = new JButton('button');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(innerPanel, gbc);", "    }", "  }", "}");
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                flowLayout.move(button, null);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, 1.0};", "    layout.rowWeights = new double[] {0.0, 1.0};", "    setLayout(layout);", "    {", "      JPanel innerPanel = new JPanel();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(innerPanel, gbc);", "      {", "        JButton button = new JButton('button');", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                gridLayout.command_MOVE(button, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0, 0};", "    layout.rowHeights = new int[] {0, 0};", "    layout.columnWeights = new double[] {0.0, 1.0};", "    layout.rowWeights = new double[] {0.0, 1.0};", "    setLayout(layout);", "    {", "      JButton button = new JButton('button');", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.insets = new Insets(0, 0, 5, 5);", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(innerPanel, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_4() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button_1 = new JButton('button 1');", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton('button 2');", "      add(button_2);", "    }", "    {", "      JButton button_3 = new JButton('button 3');", "      add(button_3);", "    }", "  }", "}");
        panel.refresh();
        Activator.getDefault().getPreferenceStore().setValue("GridBagLayout.longConstraints", true);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(2);
                layout.command_MOVE(button_2, 2, false, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button_1 = new JButton('button 1');", "      add(button_1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 5, 5), 0, 0));", "    }", "    {", "      JButton button_2 = new JButton('button 2');", "      add(button_2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 5, 5), 0, 0));", "    }", "    {", "      JButton button_3 = new JButton('button 3');", "      add(button_3, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_5() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button_1 = new JButton('button 1');", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton('button 2');", "      add(button_2);", "    }", "    {", "      JButton button_3 = new JButton('button 3');", "      add(button_3);", "    }", "  }", "}");
        panel.refresh();
        Activator.getDefault().getPreferenceStore().setValue("GridBagLayout.longConstraints", true);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(2);
                layout.command_MOVE(button_2, 0, false, 0, true);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    {", "      JButton button_3 = new JButton('button 3');", "      add(button_3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 5, 5), 0, 0));", "    }", "    {", "      JButton button_1 = new JButton('button 1');", "      add(button_1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 5), 0, 0));", "    }", "    {", "      JButton button_2 = new JButton('button 2');", "      add(button_2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 5), 0, 0));", "    }", "  }", "}");
    }

    @Test
    public void test_DELETE_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutTest.assertEquals((long)1L, (long)layout.getColumns().size());
        GridBagLayoutTest.assertEquals((long)1L, (long)layout.getRows().size());
        ((ComponentInfo)panel.getChildrenComponents().get(0)).delete();
        GridBagLayoutTest.assertEquals((long)0L, (long)layout.getColumns().size());
        GridBagLayoutTest.assertEquals((long)0L, (long)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "  }", "}");
    }

    @Test
    public void test_DELETE_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0};", "    layout.rowHeights = new int[] {0};", "    layout.columnWeights = new double[] {0.0};", "    layout.rowWeights = new double[] {0.0};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutTest.assertEquals((long)1L, (long)layout.getColumns().size());
        GridBagLayoutTest.assertEquals((long)1L, (long)layout.getRows().size());
        ((ComponentInfo)panel.getChildrenComponents().get(0)).delete();
        GridBagLayoutTest.assertEquals((long)1L, (long)layout.getColumns().size());
        GridBagLayoutTest.assertEquals((long)1L, (long)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWidths = new int[] {0};", "    layout.rowHeights = new int[] {0};", "    layout.columnWeights = new double[] {0.0};", "    layout.rowWeights = new double[] {0.0};", "    setLayout(layout);", "  }", "}");
    }

    @Test
    public void test_DELETE_3() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWeights = new double[] {1.0};", "    layout.rowWeights = new double[] {1.0};", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutTest.assertEquals((long)1L, (long)layout.getColumns().size());
        GridBagLayoutTest.assertEquals((long)1L, (long)layout.getRows().size());
        ((ComponentInfo)panel.getChildrenComponents().get(0)).delete();
        GridBagLayoutTest.assertEquals((long)0L, (long)layout.getColumns().size());
        GridBagLayoutTest.assertEquals((long)0L, (long)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    layout.columnWeights = new double[] {};", "    layout.rowWeights = new double[] {};", "    setLayout(layout);", "  }", "}");
    }

    @Test
    public void test_setCells_0() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.insets = new Insets(0, 0, 5, 5);", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
                layout.command_setCells(button_0, new Rectangle(0, 0, 2, 1));
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridwidth = 2;", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.insets = new Insets(0, 0, 5, 0);", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_1, gbc);", "    }", "  }", "}");
    }

    @Test
    public void test_setCells_1() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      gbc.insets = new Insets(0, 0, 5, 5);", "      add(button_0, gbc);", "    }", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      gbc.insets = new Insets(0, 0, 5, 0);", "      add(button_1, gbc);", "    }", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_2, gbc);", "    }", "  }", "}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutTest.assertEquals((long)2L, (long)layout.getColumns().size());
        GridBagLayoutTest.assertEquals((long)2L, (long)layout.getRows().size());
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ComponentInfo button_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
                layout.command_setCells(button_0, new Rectangle(0, 1, 1, 1));
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button_1 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 0;", "      gbc.insets = new Insets(0, 0, 5, 0);", "      add(button_1, gbc);", "    }", "    {", "      JButton button_0 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 1;", "      gbc.insets = new Insets(0, 0, 0, 5);", "      add(button_0, gbc);", "    }", "    {", "      JButton button_2 = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button_2, gbc);", "    }", "  }", "}");
    }

    @Ignore
    @Test
    public void test_clipboard() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    {", "      JPanel inner = new JPanel();", "      add(inner);", "      GridBagLayout layout = new GridBagLayout();", "      layout.columnWidths = new int[]{10, 20, 0};", "      layout.columnWeights = new double[]{1.0, 2.0, Double.MIN_VALUE};", "      layout.rowHeights = new int[]{10, 20, 30, 0};", "      layout.rowWeights = new double[]{1.0, 2.0, 3.0, Double.MIN_VALUE};", "      inner.setLayout(layout);", "      {", "        JButton button = new JButton();", "        GridBagConstraints gbc = new GridBagConstraints();", "        gbc.gridx = 1;", "        gbc.gridy = 2;", "        inner.add(button, gbc);", "      }", "    }", "  }", "}");
        panel.refresh();
        ContainerInfo inner = (ContainerInfo)GridBagLayoutTest.getJavaInfoByName("inner");
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)inner);
        ContainerInfo newInner = (ContainerInfo)memento.create((JavaInfo)panel);
        ((FlowLayoutInfo)panel.getLayout()).add((ComponentInfo)newInner, null);
        memento.apply();
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    {", "      JPanel inner = new JPanel();", "      add(inner);", "      GridBagLayout layout = new GridBagLayout();", "      layout.columnWidths = new int[]{10, 20, 0};", "      layout.columnWeights = new double[]{1.0, 2.0, Double.MIN_VALUE};", "      layout.rowHeights = new int[]{10, 20, 30, 0};", "      layout.rowWeights = new double[]{1.0, 2.0, 3.0, Double.MIN_VALUE};", "      inner.setLayout(layout);", "      {", "        JButton button = new JButton();", "        GridBagConstraints gbc = new GridBagConstraints();", "        gbc.gridx = 1;", "        gbc.gridy = 2;", "        inner.add(button, gbc);", "      }", "    }", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      GridBagLayout gridBagLayout = new GridBagLayout();", "      gridBagLayout.columnWidths = new int[]{10, 20, 0};", "      gridBagLayout.rowHeights = new int[]{10, 20, 30, 0};", "      gridBagLayout.columnWeights = new double[]{1.0, 2.0, Double.MIN_VALUE};", "      gridBagLayout.rowWeights = new double[]{1.0, 2.0, 3.0, Double.MIN_VALUE};", "      panel.setLayout(gridBagLayout);", "      {", "        JButton button = new JButton();", "        GridBagConstraints gbc = new GridBagConstraints();", "        gbc.gridx = 1;", "        gbc.gridy = 2;", "        panel.add(button, gbc);", "      }", "    }", "  }", "}");
    }

    @Ignore
    @Test
    public void test_clipboard_disableAutoAlignment() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    {", "      JPanel inner = new JPanel();", "      add(inner);", "      inner.setLayout(new GridBagLayout());", "      {", "        JLabel label = new JLabel();", "        GridBagConstraints gbc = new GridBagConstraints();", "        gbc.gridx = 0;", "        gbc.gridy = 0;", "        inner.add(label, gbc);", "      }", "      {", "        JTextField textField = new JTextField();", "        GridBagConstraints gbc = new GridBagConstraints();", "        gbc.gridx = 1;", "        gbc.gridy = 0;", "        inner.add(textField, gbc);", "      }", "    }", "  }", "}");
        panel.refresh();
        ContainerInfo inner = (ContainerInfo)GridBagLayoutTest.getJavaInfoByName("inner");
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)inner);
        ContainerInfo newInner = (ContainerInfo)memento.create((JavaInfo)panel);
        ((FlowLayoutInfo)panel.getLayout()).add((ComponentInfo)newInner, null);
        memento.apply();
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    {", "      JPanel inner = new JPanel();", "      add(inner);", "      inner.setLayout(new GridBagLayout());", "      {", "        JLabel label = new JLabel();", "        GridBagConstraints gbc = new GridBagConstraints();", "        gbc.gridx = 0;", "        gbc.gridy = 0;", "        inner.add(label, gbc);", "      }", "      {", "        JTextField textField = new JTextField();", "        GridBagConstraints gbc = new GridBagConstraints();", "        gbc.gridx = 1;", "        gbc.gridy = 0;", "        inner.add(textField, gbc);", "      }", "    }", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      GridBagLayout gridBagLayout = new GridBagLayout();", "      gridBagLayout.columnWidths = new int[]{0, 0, 0};", "      gridBagLayout.rowHeights = new int[]{0, 0};", "      gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};", "      gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};", "      panel.setLayout(gridBagLayout);", "      {", "        JLabel label = new JLabel();", "        GridBagConstraints gbc = new GridBagConstraints();", "        gbc.insets = new Insets(0, 0, 0, 5);", "        gbc.gridx = 0;", "        gbc.gridy = 0;", "        panel.add(label, gbc);", "      }", "      {", "        JTextField textField = new JTextField();", "        GridBagConstraints gbc = new GridBagConstraints();", "        gbc.gridx = 1;", "        gbc.gridy = 0;", "        panel.add(textField, gbc);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_autoRename_lazyVariable() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                SwingTestUtils.setGenerations(LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE);
                SwingTestUtils.setLazyMethodModifier(0);
                try {
                    ComponentInfo button_1 = GridBagLayoutTest.createJButton();
                    layout.command_CREATE(button_1, 0, false, 0, false);
                    GridBagLayoutTest.this.assertEditor("class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    setLayout(new GridBagLayout());", "    GridBagConstraints gbc = new GridBagConstraints();", "    gbc.gridx = 0;", "    gbc.gridy = 0;", "    add(getButton(), gbc);", "  }", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}");
                    GridBagLayoutTest.setText_withAlwaysRename((JavaInfo)button_1, "aaa");
                    GridBagLayoutTest.this.assertEditor("class Test extends JPanel {", "  private JButton aaaButton;", "  public Test() {", "    setLayout(new GridBagLayout());", "    GridBagConstraints gbc = new GridBagConstraints();", "    gbc.gridx = 0;", "    gbc.gridy = 0;", "    add(getAaaButton(), gbc);", "  }", "  private JButton getAaaButton() {", "    if (aaaButton == null) {", "      aaaButton = new JButton();", "      aaaButton.setText('aaa');", "    }", "    return aaaButton;", "  }", "}");
                    ComponentInfo button_2 = GridBagLayoutTest.createJButton();
                    layout.command_CREATE(button_2, 1, false, 0, false);
                    GridBagLayoutTest.this.assertEditor("class Test extends JPanel {", "  private JButton aaaButton;", "  private JButton button;", "  public Test() {", "    setLayout(new GridBagLayout());", "    GridBagConstraints gbc = new GridBagConstraints();", "    gbc.insets = new Insets(0, 0, 0, 5);", "    gbc.gridx = 0;", "    gbc.gridy = 0;", "    add(getAaaButton(), gbc);", "    GridBagConstraints gbc_1 = new GridBagConstraints();", "    gbc_1.gridx = 1;", "    gbc_1.gridy = 0;", "    add(getButton(), gbc_1);", "  }", "  private JButton getAaaButton() {", "    if (aaaButton == null) {", "      aaaButton = new JButton();", "      aaaButton.setText('aaa');", "    }", "    return aaaButton;", "  }", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}");
                }
                finally {
                    SwingTestUtils.setGenerationDefaults();
                }
            }
        });
    }

    @Test
    public void test_useJPanelWithGBL() throws Exception {
        GridBagLayoutTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    layout.columnWidths = new int[]{0, 0};", "    layout.columnWeights = new double[]{0.0, Double.MIN_VALUE};", "    layout.rowHeights = new int[]{0, 0};", "    layout.rowWeights = new double[]{0.0, Double.MIN_VALUE};", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 0;", "      gbc.gridy = 0;", "      add(button, gbc);", "    }", "  }", "}"));
        GridBagLayoutTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    add(new MyPanel());", "  }", "}");
        panel.refresh();
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new BorderLayout())/ /add(new MyPanel())/}", "  {new: java.awt.BorderLayout} {empty} {/setLayout(new BorderLayout())/}", "  {new: test.MyPanel} {empty} {/add(new MyPanel())/}", "    {implicit-layout: java.awt.GridBagLayout} {implicit-layout} {}");
        ContainerInfo inner = (ContainerInfo)panel.getChildrenComponents().get(0);
        GridBagLayoutInfo layout = (GridBagLayoutInfo)inner.getLayout();
        IGridInfo gridInfo = layout.getGridInfo();
        GridBagLayoutTest.assertEquals((long)1L, (long)gridInfo.getColumnCount());
        GridBagLayoutTest.assertEquals((long)1L, (long)layout.getColumns().size());
    }

    @Test
    public void test_danglingGBL() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    GridBagLayout danglingLayout = new GridBagLayout();", "  }", "}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_componentInFiller() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    GridBagLayout layout = new GridBagLayout();", "    setLayout(layout);", "    layout.columnWidths = new int[]{0, 0};", "    layout.columnWeights = new double[]{0.0, Double.MIN_VALUE};", "    layout.rowHeights = new int[]{0, 0};", "    layout.rowWeights = new double[]{0.0, Double.MIN_VALUE};", "    {", "      JButton button = new JButton();", "      GridBagConstraints gbc = new GridBagConstraints();", "      gbc.gridx = 1;", "      gbc.gridy = 1;", "      add(button, gbc);", "    }", "  }", "}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        IGridInfo gridInfo = layout.getGridInfo();
        GridBagLayoutTest.assertEquals((long)2L, (long)gridInfo.getColumnCount());
        GridBagLayoutTest.assertEquals((long)2L, (long)gridInfo.getRowCount());
        Assertions.assertThat((List)layout.getColumns()).hasSize(2);
        Assertions.assertThat((List)layout.getRows()).hasSize(2);
    }

    @Test
    public void test_setLayout_whenContainerOnGBL() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  private JPanel inner;", "  public Test() {", "    setLayout(new GridBagLayout());", "    GridBagConstraints gbc = new GridBagConstraints();", "    gbc.gridx = 0;", "    gbc.gridy = 0;", "    add(getInner(), gbc);", "  }", "  private JPanel getInner() {", "    if (inner == null) {", "      inner = new JPanel();", "    }", "    return inner;", "  }", "}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new GridBagLayout())/ /add(getInner(), gbc)/}", "  {new: java.awt.GridBagLayout} {empty} {/setLayout(new GridBagLayout())/}", "  {new: javax.swing.JPanel} {lazy: inner getInner()} {/new JPanel()/ /inner/ /add(getInner(), gbc)/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {new: java.awt.GridBagConstraints} {local-unique: gbc} {/new GridBagConstraints()/ /gbc.gridx = 0/ /gbc.gridy = 0/ /add(getInner(), gbc)/}");
        panel.refresh();
        ContainerInfo inner = (ContainerInfo)GridBagLayoutTest.getJavaInfoByName("inner");
        LayoutInfo newLayout = (LayoutInfo)GridBagLayoutTest.createJavaInfo("java.awt.GridLayout");
        inner.setLayout(newLayout);
        this.assertEditor("class Test extends JPanel {", "  private JPanel inner;", "  public Test() {", "    setLayout(new GridBagLayout());", "    GridBagConstraints gbc = new GridBagConstraints();", "    gbc.gridx = 0;", "    gbc.gridy = 0;", "    add(getInner(), gbc);", "  }", "  private JPanel getInner() {", "    if (inner == null) {", "      inner = new JPanel();", "      inner.setLayout(new GridLayout(1, 0, 0, 0));", "    }", "    return inner;", "  }", "}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new GridBagLayout())/ /add(getInner(), gbc)/}", "  {new: java.awt.GridBagLayout} {empty} {/setLayout(new GridBagLayout())/}", "  {new: javax.swing.JPanel} {lazy: inner getInner()} {/new JPanel()/ /inner/ /add(getInner(), gbc)/ /inner.setLayout(new GridLayout(1, 0, 0, 0))/}", "    {new: java.awt.GridBagConstraints} {local-unique: gbc} {/new GridBagConstraints()/ /gbc.gridx = 0/ /gbc.gridy = 0/ /add(getInner(), gbc)/}", "    {new: java.awt.GridLayout} {empty} {/inner.setLayout(new GridLayout(1, 0, 0, 0))/}");
    }

    @Test
    public void test_JPopupMenu() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton('button');", "      add(button, new GridBagConstraints());", "    }", "    {", "      JPopupMenu popupMenu = new JPopupMenu();", "      addPopup(this, popupMenu);", "    }", "  }", "  private static void addPopup(Component component, JPopupMenu popup) {", "  }", "}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new GridBagLayout())/ /add(button, new GridBagConstraints())/ /addPopup(this, popupMenu)/}", "  {new: java.awt.GridBagLayout} {empty} {/setLayout(new GridBagLayout())/}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton('button')/ /add(button, new GridBagConstraints())/}", "    {new: java.awt.GridBagConstraints} {empty} {/add(button, new GridBagConstraints())/}", "  {new: javax.swing.JPopupMenu} {local-unique: popupMenu} {/new JPopupMenu()/ /addPopup(this, popupMenu)/}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)GridBagLayoutTest.getJavaInfoByName("button");
        Assertions.assertThat((List)layout.getComponents()).containsExactly((Object[])new ComponentInfo[]{button});
    }

    @Test
    public void test_relativeRemainder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"Button1\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button2\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button3\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button4\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tc.gridwidth = GridBagConstraints.REMAINDER; // end row\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button5\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tc.gridwidth = GridBagConstraints.REMAINDER; // end row\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button6\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tc.gridwidth = GridBagConstraints.RELATIVE; // next-to-last in row\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button7\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tc.gridwidth = GridBagConstraints.REMAINDER; // end row\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button8\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tc.gridwidth = 1;\n\t\t\tc.gridheight = 2;\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button9\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tc.gridwidth = GridBagConstraints.REMAINDER; // end row\n\t\t\tc.gridheight = 1;\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button10\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tc.gridwidth = GridBagConstraints.REMAINDER; // end row\n\t\t\tc.gridheight = 1;\n\t\t\tadd(button, c);\n\t\t}\n\t}\n}");
        panel.refresh();
        List buttons = panel.getChildren(ContainerInfo.class);
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        ContainerInfo button = (ContainerInfo)buttons.get(0);
        AbstractGridBagConstraintsInfo constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button1\"");
        GridBagLayoutTest.assertEquals((long)constraints.x, (long)0L);
        GridBagLayoutTest.assertEquals((long)constraints.y, (long)0L);
        GridBagLayoutTest.assertEquals((long)constraints.width, (long)1L);
        GridBagLayoutTest.assertEquals((long)constraints.height, (long)1L);
        button = (ContainerInfo)buttons.get(1);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button2\"");
        GridBagLayoutTest.assertEquals((long)constraints.x, (long)1L);
        GridBagLayoutTest.assertEquals((long)constraints.y, (long)0L);
        GridBagLayoutTest.assertEquals((long)constraints.width, (long)1L);
        GridBagLayoutTest.assertEquals((long)constraints.height, (long)1L);
        button = (ContainerInfo)buttons.get(2);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button3\"");
        GridBagLayoutTest.assertEquals((long)constraints.x, (long)2L);
        GridBagLayoutTest.assertEquals((long)constraints.y, (long)0L);
        GridBagLayoutTest.assertEquals((long)constraints.width, (long)1L);
        GridBagLayoutTest.assertEquals((long)constraints.height, (long)1L);
        button = (ContainerInfo)buttons.get(3);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button4\"");
        GridBagLayoutTest.assertEquals((long)constraints.x, (long)3L);
        GridBagLayoutTest.assertEquals((long)constraints.y, (long)0L);
        GridBagLayoutTest.assertEquals((long)constraints.width, (long)1L);
        GridBagLayoutTest.assertEquals((long)constraints.height, (long)1L);
        button = (ContainerInfo)buttons.get(4);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button5\"");
        GridBagLayoutTest.assertEquals((long)constraints.x, (long)0L);
        GridBagLayoutTest.assertEquals((long)constraints.y, (long)1L);
        GridBagLayoutTest.assertEquals((long)constraints.width, (long)4L);
        GridBagLayoutTest.assertEquals((long)constraints.height, (long)1L);
        button = (ContainerInfo)buttons.get(5);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button6\"");
        GridBagLayoutTest.assertEquals((long)constraints.x, (long)0L);
        GridBagLayoutTest.assertEquals((long)constraints.y, (long)2L);
        GridBagLayoutTest.assertEquals((long)constraints.width, (long)3L);
        GridBagLayoutTest.assertEquals((long)constraints.height, (long)1L);
        button = (ContainerInfo)buttons.get(6);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button7\"");
        GridBagLayoutTest.assertEquals((long)constraints.x, (long)3L);
        GridBagLayoutTest.assertEquals((long)constraints.y, (long)2L);
        GridBagLayoutTest.assertEquals((long)constraints.width, (long)1L);
        GridBagLayoutTest.assertEquals((long)constraints.height, (long)1L);
        button = (ContainerInfo)buttons.get(7);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button8\"");
        GridBagLayoutTest.assertEquals((long)constraints.x, (long)0L);
        GridBagLayoutTest.assertEquals((long)constraints.y, (long)3L);
        GridBagLayoutTest.assertEquals((long)constraints.width, (long)1L);
        GridBagLayoutTest.assertEquals((long)constraints.height, (long)2L);
        button = (ContainerInfo)buttons.get(8);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button9\"");
        GridBagLayoutTest.assertEquals((long)constraints.x, (long)1L);
        GridBagLayoutTest.assertEquals((long)constraints.y, (long)3L);
        GridBagLayoutTest.assertEquals((long)constraints.width, (long)3L);
        GridBagLayoutTest.assertEquals((long)constraints.height, (long)1L);
        button = (ContainerInfo)buttons.get(9);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button10\"");
        GridBagLayoutTest.assertEquals((long)constraints.x, (long)1L);
        GridBagLayoutTest.assertEquals((long)constraints.y, (long)4L);
        GridBagLayoutTest.assertEquals((long)constraints.width, (long)3L);
        GridBagLayoutTest.assertEquals((long)constraints.height, (long)1L);
    }
}

