/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.absolute.ConstraintsAbsoluteLayoutDataInfo;
import org.eclipse.wb.internal.swing.model.layout.absolute.ConstraintsAbsoluteLayoutInfo;
import org.eclipse.wb.tests.designer.ResourceUtils;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.Test;

public class ConstraintsAbsoluteLayoutTest
extends AbstractLayoutTest {
    @Override
    protected void configureNewProject() throws Exception {
        super.configureNewProject();
        ResourceUtils.resources2project(m_testProject, "resources/Swing/absolute");
        ConstraintsAbsoluteLayoutTest.waitForAutoBuild();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MyLayout());", "    {", "      JButton button = new JButton();", "      add(button, new MyConstraints(1, 2, 3, 4));", "    }", "  }", "}");
        panel.refresh();
        ConstraintsAbsoluteLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new MyLayout())/ /add(button, new MyConstraints(1, 2, 3, 4))/}", "  {new: test.MyLayout} {empty} {/setLayout(new MyLayout())/}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button, new MyConstraints(1, 2, 3, 4))/}", "    {new: test.MyConstraints} {empty} {/add(button, new MyConstraints(1, 2, 3, 4))/}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property boundsProperty = button.getPropertyByTitle("Bounds");
        ConstraintsAbsoluteLayoutTest.assertEquals((Object)"(1, 2, 3, 4)", (Object)ConstraintsAbsoluteLayoutTest.getPropertyText(boundsProperty));
        ConstraintsAbsoluteLayoutTest.assertBoundsSubProperty_getValue(button, "x", 1);
        ConstraintsAbsoluteLayoutTest.assertBoundsSubProperty_getValue(button, "y", 2);
        ConstraintsAbsoluteLayoutTest.assertBoundsSubProperty_getValue(button, "width", 3);
        ConstraintsAbsoluteLayoutTest.assertBoundsSubProperty_getValue(button, "height", 4);
    }

    private static void assertBoundsSubProperty_getValue(ComponentInfo component, String name, int expected) throws Exception {
        Property property = PropertyUtils.getByPath((ObjectInfo)component, (String)("Bounds/" + name));
        ConstraintsAbsoluteLayoutTest.assertNotNull((Object)property);
        ConstraintsAbsoluteLayoutTest.assertEquals((Object)expected, (Object)property.getValue());
    }

    @Test
    public void test_getConstraints_existing() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MyLayout());", "    {", "      JButton button = new JButton();", "      add(button, new MyConstraints(1, 2, 3, 4));", "    }", "  }", "}");
        panel.refresh();
        ConstraintsAbsoluteLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new MyLayout())/ /add(button, new MyConstraints(1, 2, 3, 4))/}", "  {new: test.MyLayout} {empty} {/setLayout(new MyLayout())/}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button, new MyConstraints(1, 2, 3, 4))/}", "    {new: test.MyConstraints} {empty} {/add(button, new MyConstraints(1, 2, 3, 4))/}");
        String expectedSource = this.m_lastEditor.getSource();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstraintsAbsoluteLayoutDataInfo constraints = ConstraintsAbsoluteLayoutInfo.getConstraints((ComponentInfo)button);
        ConstraintsAbsoluteLayoutTest.assertNotNull((Object)constraints);
        ConstraintsAbsoluteLayoutTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_getConstraints_new() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MyLayout());", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ConstraintsAbsoluteLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new MyLayout())/ /add(button)/}", "  {new: test.MyLayout} {empty} {/setLayout(new MyLayout())/}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstraintsAbsoluteLayoutDataInfo constraints = ConstraintsAbsoluteLayoutInfo.getConstraints((ComponentInfo)button);
        ConstraintsAbsoluteLayoutTest.assertNotNull((Object)constraints);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MyLayout());", "    {", "      JButton button = new JButton();", "      add(button, new MyConstraints(0, 0, 0, 0));", "    }", "  }", "}");
        ConstraintsAbsoluteLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new MyLayout())/ /add(button, new MyConstraints(0, 0, 0, 0))/}", "  {new: test.MyLayout} {empty} {/setLayout(new MyLayout())/}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button, new MyConstraints(0, 0, 0, 0))/}", "    {new: test.MyConstraints} {empty} {/add(button, new MyConstraints(0, 0, 0, 0))/}");
    }

    @Test
    public void test_Constraints_isNotVisibleInTree() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MyLayout());", "    {", "      JButton button = new JButton();", "      add(button, new MyConstraints(1, 2, 3, 4));", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstraintsAbsoluteLayoutDataInfo constraints = ConstraintsAbsoluteLayoutInfo.getConstraints((ComponentInfo)button);
        ConstraintsAbsoluteLayoutTest.assertVisibleInTree((ObjectInfo)constraints, false);
    }

    @Test
    public void test_CREATE() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MyLayout());", "  }", "}");
        panel.refresh();
        ConstraintsAbsoluteLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new MyLayout())/}", "  {new: test.MyLayout} {empty} {/setLayout(new MyLayout())/}");
        ConstraintsAbsoluteLayoutInfo layout = (ConstraintsAbsoluteLayoutInfo)panel.getLayout();
        ComponentInfo newButton = ConstraintsAbsoluteLayoutTest.createJButton();
        layout.command_CREATE(newButton, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MyLayout());", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        ConstraintsAbsoluteLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new MyLayout())/ /add(button)/}", "  {new: test.MyLayout} {empty} {/setLayout(new MyLayout())/}", "  {new: javax.swing.JButton empty} {local-unique: button} {/new JButton()/ /add(button)/}");
        layout.command_BOUNDS(newButton, new Point(1, 2), new Dimension(3, 4));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MyLayout());", "    {", "      JButton button = new JButton();", "      add(button, new MyConstraints(1, 2, 3, 4));", "    }", "  }", "}");
        ConstraintsAbsoluteLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new MyLayout())/ /add(button, new MyConstraints(1, 2, 3, 4))/}", "  {new: test.MyLayout} {empty} {/setLayout(new MyLayout())/}", "  {new: javax.swing.JButton empty} {local-unique: button} {/new JButton()/ /add(button, new MyConstraints(1, 2, 3, 4))/}", "    {new: test.MyConstraints} {empty} {/add(button, new MyConstraints(1, 2, 3, 4))/}");
    }

    @Test
    public void test_setWidth_preferred() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MyLayout());", "    {", "      JButton button = new JButton();", "      add(button, new MyConstraints(10, 20, 100, 50));", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = PropertyUtils.getByPath((ObjectInfo)button, (String)"Bounds/width");
        property.setValue((Object)button.getPreferredSize().width);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MyLayout());", "    {", "      JButton button = new JButton();", "      add(button, new MyConstraints(10, 20, 0, 50));", "    }", "  }", "}");
    }

    @Test
    public void test_setHeight_preferred() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MyLayout());", "    {", "      JButton button = new JButton();", "      add(button, new MyConstraints(10, 20, 100, 50));", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = PropertyUtils.getByPath((ObjectInfo)button, (String)"Bounds/height");
        property.setValue((Object)button.getPreferredSize().height);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MyLayout());", "    {", "      JButton button = new JButton();", "      add(button, new MyConstraints(10, 20, 100, 0));", "    }", "  }", "}");
    }
}

