/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.rcp.model.widgets.TreeColumnInfo;
import org.eclipse.wb.internal.rcp.model.widgets.TreeInfo;
import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class TreeTest
extends RcpModelTest {
    private static int BORDER_WIDTH = 1;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Ignore
    @Test
    public void test_TreeColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Tree tree = new Tree(this, SWT.BORDER);", "    tree.setHeaderVisible(true);", "    {", "      TreeColumn treeColumn_1 = new TreeColumn(tree, SWT.NONE);", "      treeColumn_1.setWidth(50);", "    }", "    {", "      TreeColumn treeColumn_2 = new TreeColumn(tree, SWT.NONE);", "      treeColumn_2.setWidth(100);", "    }", "  }", "}");
        shell.refresh();
        TreeInfo tree = (TreeInfo)shell.getChildrenControls().get(0);
        List columns = tree.getColumns();
        Assertions.assertThat((List)columns).hasSize(2);
        TreeColumnInfo column_1 = (TreeColumnInfo)columns.get(0);
        TreeColumnInfo column_2 = (TreeColumnInfo)columns.get(1);
        Rectangle modelBounds = column_1.getModelBounds();
        TreeTest.assertNotNull((Object)modelBounds);
        TreeTest.assertEquals((long)BORDER_WIDTH, (long)modelBounds.x);
        TreeTest.assertEquals((long)BORDER_WIDTH, (long)modelBounds.y);
        TreeTest.assertEquals((long)50L, (long)modelBounds.width);
        Assertions.assertThat((int)modelBounds.height).isGreaterThan(15).isLessThan(25);
        Rectangle bounds = column_1.getBounds();
        TreeTest.assertEquals((long)BORDER_WIDTH, (long)bounds.x);
        TreeTest.assertEquals((long)BORDER_WIDTH, (long)bounds.y);
        TreeTest.assertEquals((long)modelBounds.width, (long)bounds.width);
        TreeTest.assertEquals((long)modelBounds.height, (long)bounds.height);
        modelBounds = column_2.getModelBounds();
        TreeTest.assertNotNull((Object)modelBounds);
        TreeTest.assertEquals((long)(BORDER_WIDTH + 50), (long)modelBounds.x);
        TreeTest.assertEquals((long)BORDER_WIDTH, (long)modelBounds.y);
    }

    @Ignore
    @Test
    public void test_TreeColumn_copyPaste() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Tree tree = new Tree(this, SWT.BORDER);", "      tree.setHeaderVisible(true);", "      {", "        TreeColumn treeColumn_1 = new TreeColumn(tree, SWT.NONE);", "        treeColumn_1.setWidth(50);", "      }", "      {", "        TreeColumn treeColumn_2 = new TreeColumn(tree, SWT.RIGHT);", "        treeColumn_2.setWidth(100);", "      }", "    }", "  }", "}");
        shell.refresh();
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        TreeInfo tree = (TreeInfo)TreeTest.getJavaInfoByName("tree");
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)tree);
        TreeInfo newTree = (TreeInfo)memento.create((JavaInfo)shell);
        fillLayout.command_CREATE((ControlInfo)newTree, null);
        memento.apply();
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Tree tree = new Tree(this, SWT.BORDER);", "      tree.setHeaderVisible(true);", "      {", "        TreeColumn treeColumn_1 = new TreeColumn(tree, SWT.NONE);", "        treeColumn_1.setWidth(50);", "      }", "      {", "        TreeColumn treeColumn_2 = new TreeColumn(tree, SWT.RIGHT);", "        treeColumn_2.setWidth(100);", "      }", "    }", "    {", "      Tree tree = new Tree(this, SWT.BORDER);", "      tree.setHeaderVisible(true);", "      {", "        TreeColumn treeColumn = new TreeColumn(tree, SWT.NONE);", "        treeColumn.setWidth(50);", "      }", "      {", "        TreeColumn treeColumn = new TreeColumn(tree, SWT.RIGHT);", "        treeColumn.setWidth(100);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_TreeColumn_setWidth() throws Exception {
        this.parseComposite("class Test extends Shell {", "  public Test() {", "    Tree tree = new Tree(this, SWT.BORDER);", "    {", "      TreeColumn treeColumn = new TreeColumn(tree, SWT.NONE);", "      treeColumn.setWidth(100);", "    }", "  }", "}");
        this.refresh();
        TreeInfo tree = (TreeInfo)TreeTest.getJavaInfoByName("tree");
        TreeColumnInfo column = (TreeColumnInfo)tree.getColumns().get(0);
        Property widthProperty = column.getPropertyByTitle("width");
        TreeTest.assertEquals((Object)100, (Object)widthProperty.getValue());
        column.setWidth(120);
        TreeTest.assertEquals((Object)120, (Object)widthProperty.getValue());
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    Tree tree = new Tree(this, SWT.BORDER);", "    {", "      TreeColumn treeColumn = new TreeColumn(tree, SWT.NONE);", "      treeColumn.setWidth(120);", "    }", "  }", "}");
    }

    @Test
    public void test_add_TreeColumn() throws Exception {
        this.parseComposite("class Test extends Shell {", "  public Test() {", "    Tree tree = new Tree(this, SWT.BORDER);", "  }", "}");
        TreeInfo tree = (TreeInfo)TreeTest.getJavaInfoByName("tree");
        TreeTest.assertTrue((boolean)tree.getColumns().isEmpty());
        TreeColumnInfo newColumn = (TreeColumnInfo)TreeTest.createJavaInfo("org.eclipse.swt.widgets.TreeColumn");
        TreeTest.flowContainer_CREATE((JavaInfo)tree, newColumn, null);
        List columns = tree.getColumns();
        Assertions.assertThat((List)columns).hasSize(1);
        TreeTest.assertTrue((boolean)columns.contains(newColumn));
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    Tree tree = new Tree(this, SWT.BORDER);", "    {", "      TreeColumn treeColumn = new TreeColumn(tree, SWT.NONE);", "      treeColumn.setWidth(100);", "      treeColumn.setText('New Column');", "    }", "  }", "}");
    }

    @Test
    public void test_move_TreeColumn() throws Exception {
        this.parseComposite("class Test extends Shell {", "  public Test() {", "    Tree tree = new Tree(this, SWT.BORDER);", "    {", "      TreeColumn treeColumn_1 = new TreeColumn(tree, SWT.NONE);", "      treeColumn_1.setText('Column 1');", "    }", "    {", "      TreeColumn treeColumn_2 = new TreeColumn(tree, SWT.NONE);", "      treeColumn_2.setText('Column 2');", "    }", "  }", "}");
        TreeInfo tree = (TreeInfo)TreeTest.getJavaInfoByName("tree");
        List columns = tree.getColumns();
        Assertions.assertThat((List)columns).hasSize(2);
        TreeColumnInfo column_1 = (TreeColumnInfo)columns.get(0);
        TreeColumnInfo column_2 = (TreeColumnInfo)columns.get(1);
        TreeTest.flowContainer_MOVE((JavaInfo)tree, column_2, column_1);
        TreeTest.assertSame((Object)column_2, tree.getColumns().get(0));
        TreeTest.assertSame((Object)column_1, tree.getColumns().get(1));
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    Tree tree = new Tree(this, SWT.BORDER);", "    {", "      TreeColumn treeColumn_2 = new TreeColumn(tree, SWT.NONE);", "      treeColumn_2.setText('Column 2');", "    }", "    {", "      TreeColumn treeColumn_1 = new TreeColumn(tree, SWT.NONE);", "      treeColumn_1.setText('Column 1');", "    }", "  }", "}");
    }

    @Test
    public void test_reparent_TreeColumn() throws Exception {
        this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    //", "    Tree tree_1 = new Tree(this, SWT.BORDER);", "    {", "      TreeColumn treeColumn_1 = new TreeColumn(tree_1, SWT.NONE);", "      treeColumn_1.setText('Column 1');", "    }", "    //", "    Tree tree_2 = new Tree(this, SWT.BORDER);", "    {", "      TreeColumn treeColumn_2 = new TreeColumn(tree_2, SWT.NONE);", "      treeColumn_2.setText('Column 2');", "    }", "  }", "}");
        TreeInfo tree_1 = (TreeInfo)TreeTest.getJavaInfoByName("tree_1");
        TreeColumnInfo column_1 = (TreeColumnInfo)tree_1.getColumns().get(0);
        TreeInfo tree_2 = (TreeInfo)TreeTest.getJavaInfoByName("tree_2");
        TreeColumnInfo column_2 = (TreeColumnInfo)tree_2.getColumns().get(0);
        TreeTest.flowContainer_MOVE((JavaInfo)tree_2, column_1, column_2);
        List columns = tree_2.getColumns();
        Assertions.assertThat((List)columns).hasSize(2);
        TreeTest.assertSame((Object)column_1, columns.get(0));
        TreeTest.assertSame((Object)column_2, columns.get(1));
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    //", "    Tree tree_1 = new Tree(this, SWT.BORDER);", "    //", "    Tree tree_2 = new Tree(this, SWT.BORDER);", "    {", "      TreeColumn treeColumn_1 = new TreeColumn(tree_2, SWT.NONE);", "      treeColumn_1.setText('Column 1');", "    }", "    {", "      TreeColumn treeColumn_2 = new TreeColumn(tree_2, SWT.NONE);", "      treeColumn_2.setText('Column 2');", "    }", "  }", "}");
    }

    @Test
    public void test_column_exposed() throws Exception {
        TreeTest.setFileContentSrc("test/ExposedComposite.java", this.getTestSource("public class ExposedComposite extends Composite {", "  private TreeColumn m_treeColumn;", "  private Tree m_tree;", "  //", "  public ExposedComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "    m_tree = new Tree(this, SWT.BORDER);", "    {", "      m_treeColumn = new TreeColumn(m_tree, SWT.NONE);", "      m_treeColumn.setWidth(100);", "      m_treeColumn.setText('New Column');", "    }", "  }", "  public TreeColumn getColumn() {", "    return m_treeColumn;", "  }", "  public Tree getTree() {", "    return m_tree;", "  }", "}"));
        TreeTest.waitForAutoBuild();
        this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExposedComposite composite = new ExposedComposite(this, SWT.NONE);", "  }", "}");
        TreeTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/ /new ExposedComposite(this, SWT.NONE)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {new: test.ExposedComposite} {local-unique: composite} {/new ExposedComposite(this, SWT.NONE)/}", "    {implicit-layout: org.eclipse.swt.layout.GridLayout} {implicit-layout} {}", "    {method: public org.eclipse.swt.widgets.Tree test.ExposedComposite.getTree()} {property} {}", "      {method: public org.eclipse.swt.widgets.TreeColumn test.ExposedComposite.getColumn()} {property} {}", "      {virtual-layout_data: org.eclipse.swt.layout.GridData} {virtual-layout-data} {}");
    }

    @Test
    public void test_item_exposed() throws Exception {
        TreeTest.setFileContentSrc("test/ExposedComposite.java", this.getTestSource("public class ExposedComposite extends Composite {", "  private TreeItem m_treeItem;", "  private Tree m_tree;", "  //", "  public ExposedComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "    m_tree = new Tree(this, SWT.BORDER);", "    {", "      TreeColumn treeColumn = new TreeColumn(m_tree, SWT.NONE);", "      treeColumn.setWidth(100);", "      treeColumn.setText('New Column');", "    }", "    {", "      m_treeItem = new TreeItem(m_tree, SWT.NONE);", "      m_treeItem.setText('New Item');", "    }", "  }", "  public TreeItem getItem() {", "    return m_treeItem;", "  }", "  public Tree getTree() {", "    return m_tree;", "  }", "}"));
        TreeTest.waitForAutoBuild();
        this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ExposedComposite composite = new ExposedComposite(this, SWT.NONE);", "  }", "}");
        TreeTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/ /new ExposedComposite(this, SWT.NONE)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {new: test.ExposedComposite} {local-unique: composite} {/new ExposedComposite(this, SWT.NONE)/}", "    {implicit-layout: org.eclipse.swt.layout.GridLayout} {implicit-layout} {}", "    {method: public org.eclipse.swt.widgets.Tree test.ExposedComposite.getTree()} {property} {}", "      {method: public org.eclipse.swt.widgets.TreeItem test.ExposedComposite.getItem()} {property} {}", "      {virtual-layout_data: org.eclipse.swt.layout.GridData} {virtual-layout-data} {}");
    }
}

