/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.rcp;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.rcp.model.rcp.ViewCategoryPropertyEditor;
import org.eclipse.wb.internal.rcp.model.rcp.ViewPartInfo;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.eclipse.wb.tests.designer.rcp.model.rcp.AbstractPdeTest;
import org.junit.After;
import org.junit.Test;

public class ViewCategoryPropertyEditorTest
extends RcpModelTest {
    @Override
    @After
    public void tearDown() throws Exception {
        ViewCategoryPropertyEditorTest.do_projectDispose();
        super.tearDown();
    }

    @Test
    public void test_existingAttribute() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null, "testplugin.Activator");
        AbstractPdeTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' class='test.Test' category='category_1'/>", "  </extension>", "</plugin>");
        Property categoryProperty = this.parseAndGetCategoryProperty();
        ViewCategoryPropertyEditorTest.assertTrue((boolean)categoryProperty.isModified());
        ViewCategoryPropertyEditorTest.assertEquals((Object)"category_1", (Object)categoryProperty.getValue());
        ViewCategoryPropertyEditorTest.assertSame((Object)ViewCategoryPropertyEditor.INSTANCE, (Object)categoryProperty.getEditor());
        ViewCategoryPropertyEditorTest.assertEquals((Object)"category_1", (Object)ViewCategoryPropertyEditorTest.getPropertyText(categoryProperty));
    }

    @Test
    public void test_noAttribute() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null, "testplugin.Activator");
        AbstractPdeTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' class='test.Test'/>", "  </extension>", "</plugin>");
        Property categoryProperty = this.parseAndGetCategoryProperty();
        ViewCategoryPropertyEditorTest.assertFalse((boolean)categoryProperty.isModified());
        ViewCategoryPropertyEditorTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)categoryProperty.getValue());
        ViewCategoryPropertyEditorTest.assertSame((Object)ViewCategoryPropertyEditor.INSTANCE, (Object)categoryProperty.getEditor());
        ViewCategoryPropertyEditorTest.assertEquals(null, (Object)ViewCategoryPropertyEditorTest.getPropertyText(categoryProperty));
    }

    private Property parseAndGetCategoryProperty() throws Exception {
        ViewPartInfo part = (ViewPartInfo)this.parseJavaInfo("import org.eclipse.ui.part.*;", "public abstract class Test extends ViewPart {", "  public Test() {", "  }", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "  }", "}");
        Property extensionProperty = part.getPropertyByTitle("Extension");
        Property categoryProperty = ViewCategoryPropertyEditorTest.getSubProperties(extensionProperty)[2];
        ViewCategoryPropertyEditorTest.assertEquals((Object)"category", (Object)categoryProperty.getTitle());
        return categoryProperty;
    }
}

