/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.rcp;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.rcp.Activator;
import org.eclipse.wb.internal.rcp.model.rcp.PdeUtils;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.eclipse.wb.tests.designer.rcp.model.rcp.AbstractPdeTest;
import org.junit.Test;

public class PdeUtilsTest
extends AbstractPdeTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getProject() throws Exception {
        PdeUtilsTest.assertSame((Object)m_project, (Object)this.m_utils.getProject());
    }

    @Test
    public void test_hasPDENature() throws Exception {
        PdeUtilsTest.assertTrue((boolean)PdeUtils.hasPDENature((IProject)m_project));
        PdeUtilsTest.do_projectDispose();
        PdeUtilsTest.do_projectCreate();
        PdeUtilsTest.assertFalse((boolean)PdeUtils.hasPDENature((IProject)m_project));
    }

    @Test
    public void test_generateUniqueID() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <foo id='id'/>", "    <bar id='id_1'/>", "    <baz id='id_3'/>", "  </extension>", "</plugin>");
        PdeUtilsTest.assertEquals((Object)"id_2", (Object)this.m_utils.generateUniqueID("id"));
    }

    @Test
    public void test_getId_validPluginProject() throws Exception {
        IPluginModelBase plugin = PluginRegistry.findModel((IProject)m_project);
        PdeUtilsTest.assertNotNull((Object)plugin);
        PdeUtilsTest.assertEquals((Object)"TestProject", (Object)PdeUtils.getId((IPluginModelBase)plugin));
    }

    @Test
    public void test_getId_pluginProjectWithoutManifest() throws Exception {
        PdeUtilsTest.do_projectDispose();
        PdeUtilsTest.do_projectCreate();
        try {
            ProjectUtils.addNature((IProject)m_project, (String)"org.eclipse.pde.PluginNature");
            PdeUtilsTest.createPluginXML("<?xml version='1.0' encoding='UTF-8'?>", "<?eclipse version='3.0'?>", "<plugin/>");
            PdeUtilsTest.waitForAutoBuild();
            IPluginModelBase plugin = PluginRegistry.findModel((IProject)m_project);
            PdeUtilsTest.assertNotNull((Object)plugin);
            PdeUtilsTest.assertNull((Object)PdeUtils.getId((IPluginModelBase)plugin));
        }
        finally {
            PdeUtilsTest.do_projectDispose();
        }
    }

    @Test
    public void test_notPlugin() throws Exception {
        PdeUtilsTest.do_projectDispose();
        PdeUtilsTest.do_projectCreate();
        List elements = this.m_utils.getExtensionElements("org.eclipse.ui.views", "view");
        Assertions.assertThat((List)elements).isEmpty();
    }

    @Test
    public void test_readOnly() throws Exception {
        Object manifest = PdeUtilsTest.getFileContent("META-INF/MANIFEST.MF");
        manifest = (String)manifest + "Bundle-Localization: plugin\n";
        PdeUtilsTest.setFileContent("META-INF", "MANIFEST.MF", (String)manifest);
        PdeUtilsTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' name='name 1' class='C_1'/>", "    <view id='id_2' name='name 2' class='C_2'/>", "  </extension>", "</plugin>");
        List elements = this.m_utils.getExtensionElements("org.eclipse.ui.views", "view");
        Assertions.assertThat((List)elements).hasSize(2);
        PdeUtilsTest.assertId("id_1", (IPluginElement)elements.get(0));
        PdeUtilsTest.assertId("id_2", (IPluginElement)elements.get(1));
        PdeUtilsTest.assertId("id_1", this.m_utils.getExtensionElementById("org.eclipse.ui.views", "view", "id_1"));
        PdeUtilsTest.assertId("id_2", this.m_utils.getExtensionElementById("org.eclipse.ui.views", "view", "id_2"));
        PdeUtilsTest.assertNull((Object)this.m_utils.getExtensionElementById("org.eclipse.ui.views", "view", "noSuchID"));
        PdeUtilsTest.assertId("id_1", this.m_utils.getExtensionElementByClass("org.eclipse.ui.views", "view", "C_1"));
        PdeUtilsTest.assertId("id_2", this.m_utils.getExtensionElementByClass("org.eclipse.ui.views", "view", "C_2"));
        PdeUtilsTest.assertNull((Object)this.m_utils.getExtensionElementByClass("org.eclipse.ui.views", "view", "noSuchClass"));
        IPluginElement element = this.m_utils.getExtensionElementById("org.eclipse.ui.views", "view", "id_1");
        PdeUtilsTest.assertNull((Object)PdeUtils.getAttribute(null, (String)"nullElement"));
        PdeUtilsTest.assertNull((String)"id_1", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"noSuchAttribute"));
        PdeUtilsTest.assertEquals((Object)"id_1", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"id"));
        PdeUtilsTest.assertEquals((Object)"name 1", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"name"));
        PdeUtilsTest.assertEquals((Object)"C_1", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"class"));
    }

    @Test
    public void test_localizedAttribute() throws Exception {
        Object manifest = PdeUtilsTest.getFileContent("META-INF/MANIFEST.MF");
        manifest = (String)manifest + "Bundle-Localization: plugin\n";
        PdeUtilsTest.setFileContent("META-INF/MANIFEST.MF", (String)manifest);
        PdeUtilsTest.setFileContent(PdeUtilsTest.getFile("plugin.properties"), PdeUtilsTest.getSourceDQ("name_1 = First name", "name_2 = Second name"));
        PdeUtilsTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' name='%name_1' class='C_1'/>", "    <view id='id_2' name='%name_2' class='C_2'/>", "  </extension>", "</plugin>");
        IPluginElement element = this.m_utils.getExtensionElementById("org.eclipse.ui.views", "view", "id_1");
        PdeUtilsTest.assertEquals((Object)"First name", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"name"));
        element = this.m_utils.getExtensionElementById("org.eclipse.ui.views", "view", "id_2");
        PdeUtilsTest.assertEquals((Object)"Second name", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"name"));
    }

    @Test
    public void test_addPluginImport() throws Exception {
        PdeUtilsTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)"org.eclipse.jdt.core.IType"));
        this.m_utils.addPluginImport(new String[]{"org.eclipse.jdt.core"});
        this.m_utils.addPluginImport(new String[]{"org.eclipse.jdt.core"});
        PdeUtilsTest.waitForAutoBuild();
        PdeUtilsTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)"org.eclipse.jdt.core.IType"));
        String manifest = PdeUtilsTest.getManifest();
        Assertions.assertThat((String)manifest).contains(new CharSequence[]{",\n org.eclipse.jdt.core\n"});
    }

    @Test
    public void test_addPluginImport_useRN() throws Exception {
        String manifest = PdeUtilsTest.getManifest();
        manifest = manifest.replace("\n", "\r\n");
        PdeUtilsTest.setManifest(manifest);
        this.m_utils.addPluginImport(new String[]{"org.eclipse.jdt.core"});
        this.m_utils.addPluginImport(new String[]{"org.eclipse.jdt.ui"});
        manifest = PdeUtilsTest.getManifest();
        Assertions.assertThat((String)manifest).contains(new CharSequence[]{" org.eclipse.jdt.core,\r\n org.eclipse.jdt.ui\r\n"});
    }

    @DisposeProjectAfter
    @Test
    public void test_addLibrary() throws Exception {
        PdeUtilsTest.do_projectDispose();
        PdeUtilsTest.do_projectCreate();
        PdeProjectConversionUtils.convertToPDE(m_project, null);
        String jarPath = TestUtils.createTemporaryJar("foo.txt", "bar");
        try {
            String jarName = FilenameUtils.getName((String)jarPath);
            this.m_utils.addLibrary(jarName);
            String manifest = PdeUtilsTest.getManifest();
            Assertions.assertThat((String)manifest).contains(new CharSequence[]{jarName});
            Assertions.assertThat((String)manifest).contains(new CharSequence[]{"Bundle-ClassPath: .,\n " + jarName + "\n"});
        }
        finally {
            new File(jarPath).delete();
        }
    }

    @Test
    public void test_setAttribute_existingAttribute() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' name='name 1' class='C_1'/>", "  </extension>", "</plugin>");
        IPluginElement element = this.m_utils.getExtensionElementById("org.eclipse.ui.views", "view", "id_1");
        this.m_utils.setAttribute(element, "name", "New name");
        PdeUtilsTest.assertPluginXML(new String[]{"<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' name='New name' class='C_1'/>", "  </extension>", "</plugin>"});
        PdeUtilsTest.assertEquals((Object)"name 1", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"name"));
        element = this.m_utils.getExtensionElementById("org.eclipse.ui.views", "view", "id_1");
        PdeUtilsTest.assertEquals((Object)"New name", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"name"));
    }

    @Test
    public void test_setAttribute_newAttribute() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' name='name 1' class='C_1'/>", "  </extension>", "</plugin>");
        Assertions.assertThat((String)PdeUtilsTest.getPluginXML()).doesNotContain(new CharSequence[]{"newAttr"});
        IPluginElement element = this.m_utils.getExtensionElementById("org.eclipse.ui.views", "view", "id_1");
        this.m_utils.setAttribute(element, "newAttr", "New value");
        Assertions.assertThat((String)PdeUtilsTest.getPluginXML()).contains(new CharSequence[]{"newAttr=\"New value\""});
    }

    @Test
    public void test_setAttribute_removeAttribute() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' name='name 1' class='C_1'/>", "  </extension>", "</plugin>");
        Assertions.assertThat((String)PdeUtilsTest.getPluginXML()).contains(new CharSequence[]{"name="});
        IPluginElement element = this.m_utils.getExtensionElementById("org.eclipse.ui.views", "view", "id_1");
        this.m_utils.setAttribute(element, "name", null);
        PdeUtilsTest.assertPluginXML(new String[]{"<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' class='C_1'/>", "  </extension>", "</plugin>"});
    }

    @Test
    public void test_setAttribute_specialValue() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' name='name 1' class='C_1'/>", "  </extension>", "</plugin>");
        Assertions.assertThat((String)PdeUtilsTest.getPluginXML()).contains(new CharSequence[]{"name="});
        IPluginElement element = this.m_utils.getExtensionElementById("org.eclipse.ui.views", "view", "id_1");
        this.m_utils.setAttribute(element, "name", "a > b && !c");
        PdeUtilsTest.assertPluginXML(new String[]{"<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' name='a &gt; b &amp;&amp; !c' class='C_1'/>", "  </extension>", "</plugin>"});
        element = this.m_utils.getExtensionElementById("org.eclipse.ui.views", "view", "id_1");
        PdeUtilsTest.assertEquals((Object)"a > b && !c", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"name"));
    }

    @Test
    public void test_createExtensionElement_1() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' name='name 1' class='C_1'/>", "  </extension>", "</plugin>");
        String pointId = "org.eclipse.ui.views";
        this.m_utils.createExtensionElement(pointId, "view", Map.of("id", "id_2", "name", "name 2", "class", "C_2"));
        IPluginElement element = this.m_utils.getExtensionElementById(pointId, "view", "id_2");
        PdeUtilsTest.assertEquals((Object)"id_2", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"id"));
        PdeUtilsTest.assertEquals((Object)"name 2", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"name"));
        PdeUtilsTest.assertEquals((Object)"C_2", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"class"));
        m_getSource_ignoreSpaces = true;
        PdeUtilsTest.assertPluginXML(new String[]{"<plugin>", "\t<extension point='org.eclipse.ui.views'>", "\t\t<view id='id_1' name='name 1' class='C_1'/>", "  <view", "        class='C_2'", "        id='id_2'", "        name='name 2'>", "  </view>", "\t</extension>", "</plugin>"});
    }

    @Test
    public void test_createExtensionElement_2() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "</plugin>");
        String pointId = "org.eclipse.ui.views";
        this.m_utils.createExtensionElement(pointId, "view", Map.of("id", "id_2", "name", "name 2", "class", "C_2"));
        IPluginElement element = this.m_utils.waitExtensionElementById(pointId, "view", "id_2");
        PdeUtilsTest.assertNotNull((Object)element);
        PdeUtilsTest.assertEquals((Object)"id_2", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"id"));
        PdeUtilsTest.assertEquals((Object)"name 2", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"name"));
        PdeUtilsTest.assertEquals((Object)"C_2", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"class"));
        m_getSource_ignoreSpaces = true;
        PdeUtilsTest.assertPluginXML(new String[]{"<plugin>", "   <extension", "         point='org.eclipse.ui.views'>", "      <view", "            class='C_2'", "            id='id_2'", "            name='name 2'>", "      </view>", "   </extension>", "</plugin>"});
    }

    @Test
    public void test_createExtensionElement_3() throws Exception {
        PdeUtilsTest.assertFalse((boolean)PdeUtilsTest.getFile("plugin.xml").exists());
        String pointId = "org.eclipse.ui.views";
        this.m_utils.createExtensionElement(pointId, "view", Map.of("id", "id_2", "name", "name 2", "class", "C_2"));
        IPluginElement element = this.m_utils.waitExtensionElementById(pointId, "view", "id_2");
        PdeUtilsTest.assertEquals((Object)"id_2", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"id"));
        PdeUtilsTest.assertEquals((Object)"name 2", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"name"));
        PdeUtilsTest.assertEquals((Object)"C_2", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"class"));
        PdeUtilsTest.assertTrue((boolean)PdeUtilsTest.getFile("plugin.xml").exists());
        m_getSource_ignoreSpaces = true;
        PdeUtilsTest.assertPluginXML(new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<?eclipse version=\"3.2\"?>", "<plugin>", "   <extension", "         point='org.eclipse.ui.views'>", "      <view", "            class='C_2'", "            id='id_2'", "            name='name 2'>", "      </view>", "   </extension>", "</plugin>"});
    }

    @Test
    public void test_createExtensionElement_notInUI() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "</plugin>");
        String pointId = "org.eclipse.ui.views";
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    PdeUtilsTest.this.m_utils.createExtensionElement("org.eclipse.ui.views", "view", Map.of("id", "id_2", "name", "name 2", "class", "C_2"));
                }
                catch (Throwable e) {
                    DesignerPlugin.log((Throwable)e);
                }
            }
        };
        thread.start();
        while (thread.isAlive()) {
            PdeUtilsTest.waitEventLoop(0);
        }
        IPluginElement element = this.m_utils.waitExtensionElementById("org.eclipse.ui.views", "view", "id_2");
        PdeUtilsTest.assertNotNull((Object)element);
        PdeUtilsTest.assertEquals((Object)"id_2", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"id"));
        PdeUtilsTest.assertEquals((Object)"name 2", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"name"));
        PdeUtilsTest.assertEquals((Object)"C_2", (Object)PdeUtils.getAttribute((IPluginElement)element, (String)"class"));
        m_getSource_ignoreSpaces = true;
        PdeUtilsTest.assertPluginXML(new String[]{"<plugin>", "   <extension", "         point='org.eclipse.ui.views'>", "      <view", "            class='C_2'", "            id='id_2'", "            name='name 2'>", "      </view>", "   </extension>", "</plugin>"});
    }

    @Test
    public void test_createViewCategoryElement() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "</plugin>");
        IPluginElement category = this.m_utils.createViewCategoryElement("id_2", "name 2");
        PdeUtilsTest.assertNotNull((Object)category);
        PdeUtilsTest.assertEquals((Object)"id_2", (Object)PdeUtils.getAttribute((IPluginElement)category, (String)"id"));
        PdeUtilsTest.assertEquals((Object)"name 2", (Object)PdeUtils.getAttribute((IPluginElement)category, (String)"name"));
        m_getSource_ignoreSpaces = true;
        PdeUtilsTest.assertPluginXML(new String[]{"<plugin>", "   <extension", "         point='org.eclipse.ui.views'>", "      <category", "            id='id_2'", "            name='name 2'>", "      </category>", "   </extension>", "</plugin>"});
        category = PdeUtils.getViewCategoryInfo((String)"id_2");
        PdeUtilsTest.assertNotNull((Object)category);
        PdeUtilsTest.assertEquals((Object)"id_2", (Object)category.getId());
        PdeUtilsTest.assertEquals((Object)"name 2", (Object)category.getName());
    }

    @Test
    public void test_createViewElement() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "</plugin>");
        this.m_utils.createViewElement("id_2", "name 2", "C_2");
        this.m_utils.waitExtensionElementById("org.eclipse.ui.views", "view", "id_2");
        m_getSource_ignoreSpaces = true;
        PdeUtilsTest.assertPluginXML(new String[]{"<plugin>", "   <extension", "         point='org.eclipse.ui.views'>", "      <view", "            class='C_2'", "            id='id_2'", "            name='name 2'>", "      </view>", "   </extension>", "</plugin>"});
        PdeUtils.ViewInfo view = PdeUtils.getViewInfo((String)"id_2");
        PdeUtilsTest.assertNotNull((Object)view);
        PdeUtilsTest.assertEquals((Object)"id_2", (Object)view.getId());
        PdeUtilsTest.assertEquals((Object)"name 2", (Object)view.getName());
        PdeUtilsTest.assertEquals((Object)"C_2", (Object)view.getClassName());
    }

    @Test
    public void test_createEditorElement() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "</plugin>");
        this.m_utils.createEditorElement("id_2", "name 2", "C_2");
        m_getSource_ignoreSpaces = true;
        PdeUtilsTest.assertPluginXML(new String[]{"<plugin>", "   <extension", "         point='org.eclipse.ui.editors'>", "      <editor", "            class='C_2'", "            id='id_2'", "            name='name 2'>", "      </editor>", "   </extension>", "</plugin>"});
    }

    @Test
    public void test_createPerspectiveElement() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "</plugin>");
        this.m_utils.createPerspectiveElement("id_2", "name 2", "C_2");
        m_getSource_ignoreSpaces = true;
        PdeUtilsTest.assertPluginXML(new String[]{"<plugin>", "   <extension", "         point='org.eclipse.ui.perspectives'>", "      <perspective", "            class='C_2'", "            id='id_2'", "            name='name 2'>", "      </perspective>", "   </extension>", "</plugin>"});
    }

    @Test
    public void test_removeElement() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1'/>", "    <view id='id_2'/>", "    <view id='id_3'/>", "  </extension>", "</plugin>");
        IPluginElement element = this.m_utils.getExtensionElementById("org.eclipse.ui.views", "view", "id_2");
        PdeUtilsTest.assertNotNull((Object)element);
        this.m_utils.removeElement(element);
        PdeUtilsTest.assertPluginXML(new String[]{"<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1'/>", "    <view id='id_3'/>", "  </extension>", "</plugin>"});
    }

    @Test
    public void test_getViewInfo_noView() throws Exception {
        PdeUtilsTest.assertNull((Object)PdeUtils.getViewInfo((String)"no.such.view"));
    }

    @Test
    public void test_getViewInfoDefault() throws Exception {
        String id = "no.such.view";
        PdeUtils.ViewInfo viewInfo = PdeUtils.getViewInfoDefault((String)id);
        PdeUtilsTest.assertNotNull((Object)viewInfo);
        PdeUtilsTest.assertEquals((Object)id, (Object)viewInfo.getId());
        PdeUtilsTest.assertEquals((Object)id, (Object)viewInfo.getName());
        PdeUtilsTest.assertNotNull((Object)viewInfo.getIcon());
    }

    @Test
    public void test_getViewInfo_runtime() throws Exception {
        String viewId = "org.eclipse.jdt.ui.PackageExplorer";
        PdeUtils.ViewInfo viewInfo = PdeUtils.getViewInfo((String)viewId);
        PdeUtilsTest.assertNotNull((Object)viewInfo);
        PdeUtilsTest.assertEquals((Object)viewId, (Object)viewInfo.getId());
        PdeUtilsTest.assertEquals((Object)"org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart", (Object)viewInfo.getClassName());
        PdeUtilsTest.assertEquals((Object)"org.eclipse.jdt.ui.java", (Object)viewInfo.getCategory());
        PdeUtilsTest.assertEquals((Object)"Package Explorer", (Object)viewInfo.getName());
        PdeUtilsTest.assertNotNull((Object)viewInfo.getIcon());
        PdeUtilsTest.assertNotSame((Object)Activator.getImage((String)"info/perspective/view.gif"), (Object)viewInfo.getIcon());
        PdeUtilsTest.assertSame((Object)viewInfo, (Object)PdeUtils.getViewInfo((String)viewId));
        PdeUtilsTest.assertSame((Object)viewInfo, (Object)PdeUtils.getViewInfoDefault((String)viewId));
    }

    @Test
    public void test_getViewInfo_workspace() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' name='name 1' icon='icons/1.png' class='C_1'/>", "  </extension>", "</plugin>");
        this.ensureFolderExists("icons");
        TestUtils.createImagePNG(m_testProject, "icons/1.png", 10, 20);
        PdeUtils.ViewInfo viewInfo = PdeUtils.getViewInfo((String)"id_1");
        PdeUtilsTest.assertNotNull((Object)viewInfo);
        PdeUtilsTest.assertEquals((Object)"id_1", (Object)viewInfo.getId());
        PdeUtilsTest.assertEquals((Object)"C_1", (Object)viewInfo.getClassName());
        PdeUtilsTest.assertNull((Object)viewInfo.getCategory());
        PdeUtilsTest.assertEquals((Object)"name 1", (Object)viewInfo.getName());
        PdeUtilsTest.assertNotNull((Object)viewInfo.getIcon());
        PdeUtilsTest.assertNotSame((Object)Activator.getImage((String)"info/perspective/view.gif"), (Object)viewInfo.getIcon());
        PdeUtilsTest.assertEquals((long)10L, (long)viewInfo.getIcon().getImageData((int)100).width);
        PdeUtilsTest.assertEquals((long)20L, (long)viewInfo.getIcon().getImageData((int)100).height);
        PdeUtilsTest.assertEquals((Object)"(id_1, C_1, null, name 1)", (Object)viewInfo.toString());
    }

    @Test
    public void test_getViews() throws Exception {
        List views = PdeUtils.getViews();
        TreeMap<String, PdeUtils.ViewInfo> idToView = new TreeMap<String, PdeUtils.ViewInfo>();
        for (PdeUtils.ViewInfo viewInfo : views) {
            idToView.put(viewInfo.getId(), viewInfo);
        }
        Assertions.assertThat((List)views).isNotEmpty();
        Assertions.assertThat((int)views.size()).isGreaterThan(35);
        Set idSet = idToView.keySet();
        Assertions.assertThat(idSet).contains((Object[])new String[]{"org.eclipse.jdt.ui.PackageExplorer"});
        Assertions.assertThat(idSet).contains((Object[])new String[]{"org.eclipse.ui.navigator.ProjectExplorer"});
        Assertions.assertThat(idSet).contains((Object[])new String[]{"org.eclipse.ui.views.ContentOutline"});
        Assertions.assertThat(idSet).contains((Object[])new String[]{"org.eclipse.ui.views.BookmarkView"});
    }

    @Test
    public void test_getViewCategories() throws Exception {
        PdeUtils.ViewCategoryInfo category2;
        List categories = PdeUtils.getViewCategories();
        HashMap<String, PdeUtils.ViewCategoryInfo> idToCategory = new HashMap<String, PdeUtils.ViewCategoryInfo>();
        for (PdeUtils.ViewCategoryInfo category2 : categories) {
            idToCategory.put(category2.getId(), category2);
        }
        Assertions.assertThat((List)categories).isNotEmpty();
        Assertions.assertThat((int)categories.size()).isGreaterThan(8);
        category2 = (PdeUtils.ViewCategoryInfo)idToCategory.get(null);
        PdeUtilsTest.assertNotNull((Object)category2);
        PdeUtilsTest.assertEquals(null, (Object)category2.getId());
        PdeUtilsTest.assertEquals((Object)"Other", (Object)category2.getName());
        category2 = (PdeUtils.ViewCategoryInfo)idToCategory.get("org.eclipse.jdt.ui.java");
        PdeUtilsTest.assertNotNull((Object)category2);
        PdeUtilsTest.assertEquals((Object)"org.eclipse.jdt.ui.java", (Object)category2.getId());
        PdeUtilsTest.assertEquals((Object)"Java", (Object)category2.getName());
        PdeUtilsTest.assertEquals((Object)"(org.eclipse.jdt.ui.java, Java)", (Object)category2.toString());
        List views = category2.getViews();
        TreeMap<String, PdeUtils.ViewInfo> idToView = new TreeMap<String, PdeUtils.ViewInfo>();
        for (PdeUtils.ViewInfo viewInfo : views) {
            idToView.put(viewInfo.getId(), viewInfo);
        }
        Assertions.assertThat((List)views).isNotEmpty();
        Assertions.assertThat((int)views.size()).isGreaterThan(5);
        PdeUtilsTest.assertNotNull(idToView.get("org.eclipse.jdt.ui.PackageExplorer"));
        PdeUtilsTest.assertNull(idToView.get("org.eclipse.ui.navigator.ProjectExplorer"));
    }

    @Test
    public void test_getViewCategories_otherViews() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' name='name 1'/>", "  </extension>", "</plugin>");
        PdeUtils.ViewCategoryInfo otherCategory = (PdeUtils.ViewCategoryInfo)PdeUtils.getViewCategories().get(0);
        PdeUtilsTest.assertEquals(null, (Object)otherCategory.getId());
        boolean hasOurView = false;
        for (PdeUtils.ViewInfo view : otherCategory.getViews()) {
            if (!view.getId().equals("id_1")) continue;
            PdeUtilsTest.assertEquals((Object)"name 1", (Object)view.getName());
            PdeUtilsTest.assertEquals(null, (Object)view.getCategory());
            hasOurView = true;
            break;
        }
        PdeUtilsTest.assertTrue((boolean)hasOurView);
    }

    @Test
    public void test_getViewCategoryInfo_workspace() throws Exception {
        PdeUtilsTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <category id='id_1' name='name 1'/>", "  </extension>", "</plugin>");
        PdeUtils.ViewCategoryInfo category = PdeUtils.getViewCategoryInfo((String)"id_1");
        PdeUtilsTest.assertNotNull((Object)category);
        PdeUtilsTest.assertEquals((Object)"id_1", (Object)category.getId());
        PdeUtilsTest.assertEquals((Object)"name 1", (Object)category.getName());
        category = PdeUtils.getViewCategoryInfo((String)"noSuchCategory");
        PdeUtilsTest.assertNull((Object)category);
    }

    @Test
    public void test_getPerspectiveInfo_noPerspective() throws Exception {
        PdeUtilsTest.assertNull((Object)PdeUtils.getPerspectiveInfo((String)"no.such.perspective"));
    }

    @Test
    public void test_getPerspectiveInfoDefault() throws Exception {
        String id = "no.such.perspective";
        PdeUtils.PerspectiveInfo perspectiveInfo = PdeUtils.getPerspectiveInfoDefault((String)id);
        PdeUtilsTest.assertNotNull((Object)perspectiveInfo);
        PdeUtilsTest.assertEquals((Object)id, (Object)perspectiveInfo.getId());
        PdeUtilsTest.assertEquals((Object)id, (Object)perspectiveInfo.getName());
        PdeUtilsTest.assertNotNull((Object)perspectiveInfo.getIcon());
    }

    @Test
    public void test_getPerspectiveInfo_runtime() throws Exception {
        String id = "org.eclipse.jdt.ui.JavaPerspective";
        PdeUtils.PerspectiveInfo perspectiveInfo = PdeUtils.getPerspectiveInfo((String)id);
        PdeUtilsTest.assertNotNull((Object)perspectiveInfo);
        PdeUtilsTest.assertEquals((Object)id, (Object)perspectiveInfo.getId());
        PdeUtilsTest.assertEquals((Object)"org.eclipse.jdt.internal.ui.JavaPerspectiveFactory", (Object)perspectiveInfo.getClassName());
        PdeUtilsTest.assertEquals((Object)"Java", (Object)perspectiveInfo.getName());
        PdeUtilsTest.assertEquals((Object)"(org.eclipse.jdt.ui.JavaPerspective, org.eclipse.jdt.internal.ui.JavaPerspectiveFactory, Java)", (Object)perspectiveInfo.toString());
        PdeUtilsTest.assertNotNull((Object)perspectiveInfo.getIcon());
        PdeUtilsTest.assertNotSame((Object)Activator.getImage((String)"info/perspective/perspective.gif"), (Object)perspectiveInfo.getIcon());
        PdeUtilsTest.assertSame((Object)perspectiveInfo, (Object)PdeUtils.getPerspectiveInfo((String)id));
        PdeUtilsTest.assertSame((Object)perspectiveInfo, (Object)PdeUtils.getPerspectiveInfo((String)id));
    }

    @Test
    public void test_getPerspectives() throws Exception {
        List perspectives = PdeUtils.getPerspectives();
        TreeMap<String, PdeUtils.PerspectiveInfo> idToPerspective = new TreeMap<String, PdeUtils.PerspectiveInfo>();
        for (PdeUtils.PerspectiveInfo perspectiveInfo : perspectives) {
            idToPerspective.put(perspectiveInfo.getId(), perspectiveInfo);
        }
        Assertions.assertThat((List)perspectives).isNotEmpty();
        Assertions.assertThat((int)perspectives.size()).isGreaterThan(5);
        Set idSet = idToPerspective.keySet();
        Assertions.assertThat(idSet).contains((Object[])new String[]{"org.eclipse.ui.resourcePerspective"});
        Assertions.assertThat(idSet).contains((Object[])new String[]{"org.eclipse.jdt.ui.JavaPerspective"});
        Assertions.assertThat(idSet).contains((Object[])new String[]{"org.eclipse.pde.ui.PDEPerspective"});
    }
}

