/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.jface;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.rcp.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.jface.viewer.ViewerInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class TableViewerTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_properties() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    TableViewer tableViewer = new TableViewer(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ControlInfo table = (ControlInfo)shell.getChildrenControls().get(0);
        ViewerInfo viewer = (ViewerInfo)table.getChildren().get(0);
        TableViewerTest.assertNull((Object)viewer.getPropertyByTitle("busy"));
        Property itemCountProperty = viewer.getPropertyByTitle("itemCount");
        TableViewerTest.assertSame((Object)PropertyCategory.ADVANCED, (Object)itemCountProperty.getCategory());
        TableViewerTest.assertNotNull((Object)viewer.getPropertyByTitle("Style"));
    }

    @Test
    public void test_CheckboxTableViewer() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    TableViewer tableViewer = CheckboxTableViewer.newCheckList(this, SWT.NONE);", "  }", "}");
        TableViewerTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/ /CheckboxTableViewer.newCheckList(this, SWT.NONE)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {viewer: public org.eclipse.swt.widgets.Table org.eclipse.jface.viewers.TableViewer.getTable()} {viewer} {}", "    {static factory: org.eclipse.jface.viewers.CheckboxTableViewer newCheckList(org.eclipse.swt.widgets.Composite,int)} {local-unique: tableViewer} {/CheckboxTableViewer.newCheckList(this, SWT.NONE)/}");
        shell.refresh();
        TableViewerTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_GridLayout_andExposedViewer() throws Exception {
        TableViewerTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  private TableViewer viewer;", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    viewer = new TableViewer(this, SWT.NONE);", "  }", "  public TableViewer getViewer() {", "    return viewer;", "  }", "}"));
        TableViewerTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "  }", "}");
        shell.refresh();
        GridLayoutInfo gridLayout = (GridLayoutInfo)shell.getLayout();
        CompositeInfo myComposite = (CompositeInfo)TableViewerTest.createJavaInfo("test.MyComposite");
        gridLayout.command_CREATE((ControlInfo)myComposite, 0, false, 0, false);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "    {", "      MyComposite myComposite = new MyComposite(this, SWT.NONE);", "    }", "  }", "}");
        TableViewerTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new GridLayout())/ /new MyComposite(this, SWT.NONE)/}", "  {new: org.eclipse.swt.layout.GridLayout} {empty} {/setLayout(new GridLayout())/}", "  {new: test.MyComposite} {local-unique: myComposite} {/new MyComposite(this, SWT.NONE)/}", "    {implicit-layout: org.eclipse.swt.layout.FillLayout} {implicit-layout} {}", "    {virtual-layout_data: org.eclipse.swt.layout.GridData} {virtual-layout-data} {}", "    {viewer: public org.eclipse.swt.widgets.Table org.eclipse.jface.viewers.TableViewer.getTable()} {viewer} {}", "      {method: public org.eclipse.jface.viewers.TableViewer test.MyComposite.getViewer()} {property} {}");
    }
}

