/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.editor.DesignerEditorTestCase;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.junit.Before;

public abstract class RcpGefTest
extends DesignerEditorTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        RcpGefTest.configureDefaults(ToolkitProvider.DESCRIPTION);
        if (m_testProject == null) {
            RcpGefTest.do_projectCreate();
            BTestUtils.configure(m_testProject);
        }
    }

    protected final CompositeInfo openComposite(String ... lines) throws Exception {
        return (CompositeInfo)this.openJavaInfo(lines);
    }

    protected final <T extends JavaInfo> T openJavaInfo(String ... lines) throws Exception {
        String source = this.getTestSource2(lines);
        ICompilationUnit unit = this.createModelCompilationUnit("test", "Test.java", source);
        this.openDesign(unit);
        return (T)this.m_contentJavaInfo;
    }

    protected final void assertEditor(String ... lines) {
        AstEditor editor = EditorState.getActiveJavaInfo().getEditor();
        String expectedSource = this.getTestSource2(lines);
        RcpGefTest.assertEditor(expectedSource, editor);
    }

    protected final String getTestSource2(String ... lines) {
        lines = RcpGefTest.getDoubleQuotes(lines);
        lines = this.getTestSource_decorate(lines);
        return RcpGefTest.getSource(lines);
    }

    protected String[] getTestSource_decorate(String ... lines) {
        lines = CodeUtils.join((String[])new String[]{"package test;", "import org.eclipse.swt.SWT;", "import org.eclipse.swt.events.*;", "import org.eclipse.swt.graphics.*;", "import org.eclipse.swt.widgets.*;", "import org.eclipse.swt.layout.*;", "import org.eclipse.swt.custom.*;", "import org.eclipse.jface.viewers.*;", "import org.eclipse.jface.preference.*;", "import org.eclipse.jface.resource.*;", "import org.eclipse.ui.forms.*;", "import org.eclipse.ui.forms.widgets.*;"}, (String[])lines);
        return lines;
    }

    protected void prepareComponent() throws Exception {
        this.prepareComponent(100, 50);
    }

    protected void prepareComponent(int width, int height) throws Exception {
        RcpGefTest.setFileContentSrc("test/Button.java", this.getTestSource2("public class Button extends org.eclipse.swt.widgets.Button {", "  public Button(Composite parent, int style) {", "    super(parent, style);", "  }", "  protected void checkSubclass () {", "  }", "  public Point computeSize (int wHint, int hHint, boolean changed) {", "    return new Point(" + width + ", " + height + ");", "  }", "}"));
        RcpGefTest.waitForAutoBuild();
    }

    protected ControlInfo loadCreationButton() throws Exception {
        return (ControlInfo)this.loadCreationTool("test.Button");
    }

    protected final void loadButton() throws Exception {
        this.loadCreationTool("org.eclipse.swt.widgets.Button", "empty");
    }

    protected final void loadButtonWithText() throws Exception {
        this.loadCreationTool("org.eclipse.swt.widgets.Button");
    }
}

