/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor;

import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.eclipse.wb.tests.gef.EventSender;
import org.junit.Test;

public class SelectSupportTest
extends SwingGefTest {
    @Test
    public void test_all() throws Exception {
        ContainerInfo panel = this.openContainer("// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"Button 1\");\n\t\t\tadd(button_1);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"Button 2\");\n\t\t\tadd(button_2);\n\t\t}\n\t\t{\n\t\t\tJTextField text_1 = new JTextField(15);\n\t\t\tadd(text_1);\n\t\t}\n\t}\n}");
        Object button_1 = SelectSupportTest.getJavaInfoByName("button_1");
        Object button_2 = SelectSupportTest.getJavaInfoByName("button_2");
        Object text_1 = SelectSupportTest.getJavaInfoByName("text_1");
        this.canvas.deselectAll();
        this.sendSelectKey(262144);
        this.canvas.assertSelection(panel, button_1, button_2, text_1);
        this.canvas.deselectAll();
        this.canvas.select(button_1);
        this.sendSelectKey(393216);
        this.canvas.assertSelection(button_1, button_2);
        this.canvas.deselectAll();
        this.canvas.select(text_1);
        this.sendSelectKey(327680);
        this.canvas.assertSelection(button_1, button_2, text_1);
        IMenuManager contextMenu = SelectSupportTest.getContextMenu(new ObjectInfo[]{panel});
        IMenuManager selectMenu = SelectSupportTest.findChildMenuManager((IContributionManager)contextMenu, "Select");
        this.canvas.deselectAll();
        SelectSupportTest.findChildAction((IContributionManager)selectMenu, "All").run();
        this.canvas.assertSelection(panel, button_1, button_2, text_1);
        this.canvas.deselectAll();
        this.canvas.select(button_1);
        SelectSupportTest.findChildAction((IContributionManager)selectMenu, "All of Same Type").run();
        this.canvas.assertSelection(button_1, button_2);
        this.canvas.deselectAll();
        this.canvas.select(text_1);
        SelectSupportTest.findChildAction((IContributionManager)selectMenu, "All on Same Parent").run();
        this.canvas.assertSelection(button_1, button_2, text_1);
    }

    @Test
    public void test_disposeHierarchy() throws Exception {
        this.openContainer("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        IDesignPageSite.Helper.getSite((ObjectInfo)this.m_contentJavaInfo).reparse();
        this.fetchContentFields();
        this.canvas.deselectAll();
        this.sendSelectKey(262144);
        this.canvas.assertSelection(this.m_contentJavaInfo);
    }

    private void sendSelectKey(int stateMask) {
        FigureCanvas control = this.m_viewerCanvas.getControl();
        EventSender eventSender = new EventSender((Control)control);
        eventSender.setStateMask(stateMask);
        eventSender.keyDown(97);
    }
}

