/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.palette;

import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.EntryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ComponentEntryInfo;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.Test;

public class PaletteInfoTest
extends DesignerTestCase {
    @Test
    public void test_toString() throws Exception {
        PaletteInfo palette = new PaletteInfo();
        PaletteInfoTest.assertEquals((Object)"", (Object)palette.toString());
        palette.addCategory(new CategoryInfo("category_1"));
        PaletteInfoTest.assertEquals((Object)"Category(id='category_1', name='(unknown)', entries=[])", (Object)palette.toString());
    }

    @Test
    public void test_categories() throws Exception {
        PaletteInfo palette = new PaletteInfo();
        CategoryInfo category_1 = new CategoryInfo("category_1");
        CategoryInfo category_2 = new CategoryInfo("category_2");
        PaletteInfoTest.assertEquals((long)0L, (long)palette.getCategories().size());
        palette.addCategory(category_1);
        palette.addCategory(category_2);
        PaletteInfoTest.assertEquals((long)2L, (long)palette.getCategories().size());
        PaletteInfoTest.assertSame((Object)category_1, palette.getCategories().get(0));
        PaletteInfoTest.assertSame((Object)category_2, palette.getCategories().get(1));
        PaletteInfoTest.assertSame((Object)category_1, (Object)palette.getCategory("category_1"));
        PaletteInfoTest.assertSame((Object)category_2, (Object)palette.getCategory("category_2"));
        PaletteInfoTest.assertNull((Object)palette.getCategory("no-such-category"));
    }

    @Test
    public void test_moveCategory() throws Exception {
        PaletteInfo palette = new PaletteInfo();
        CategoryInfo category_1 = new CategoryInfo("category_1");
        CategoryInfo category_2 = new CategoryInfo("category_2");
        CategoryInfo category_3 = new CategoryInfo("category_3");
        palette.addCategory(category_1);
        palette.addCategory(category_2);
        palette.addCategory(category_3);
        palette.moveCategory("noSuchCategory", null);
        PaletteInfoTest.assertSame((Object)category_1, palette.getCategories().get(0));
        PaletteInfoTest.assertSame((Object)category_2, palette.getCategories().get(1));
        PaletteInfoTest.assertSame((Object)category_3, palette.getCategories().get(2));
        palette.moveCategory("category_1", "category_1");
        PaletteInfoTest.assertSame((Object)category_1, palette.getCategories().get(0));
        PaletteInfoTest.assertSame((Object)category_2, palette.getCategories().get(1));
        PaletteInfoTest.assertSame((Object)category_3, palette.getCategories().get(2));
        palette.moveCategory("category_1", "noSuchCategory");
        PaletteInfoTest.assertSame((Object)category_2, palette.getCategories().get(0));
        PaletteInfoTest.assertSame((Object)category_3, palette.getCategories().get(1));
        PaletteInfoTest.assertSame((Object)category_1, palette.getCategories().get(2));
        palette.moveCategory("category_1", "category_2");
        PaletteInfoTest.assertSame((Object)category_1, palette.getCategories().get(0));
        PaletteInfoTest.assertSame((Object)category_2, palette.getCategories().get(1));
        PaletteInfoTest.assertSame((Object)category_3, palette.getCategories().get(2));
    }

    @Test
    public void test_getEntry() throws Exception {
        PaletteInfo palette = new PaletteInfo();
        CategoryInfo category = new CategoryInfo("category_1");
        palette.addCategory(category);
        ComponentEntryInfo entry_1 = new ComponentEntryInfo();
        entry_1.setId("1");
        ComponentEntryInfo entry_2 = new ComponentEntryInfo();
        entry_2.setId("2");
        category.addEntry((EntryInfo)entry_1);
        category.addEntry((EntryInfo)entry_2);
        PaletteInfoTest.assertSame((Object)entry_1, (Object)palette.getEntry("1"));
        PaletteInfoTest.assertSame((Object)entry_2, (Object)palette.getEntry("2"));
        PaletteInfoTest.assertNull((Object)palette.getEntry("no-such-entry"));
    }
}

